/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DebugText
extends JTextPane {
    private SimpleAttributeSet asm;
    private SimpleAttributeSet asi;
    private SimpleAttributeSet ase;
    private SimpleAttributeSet aseem;
    private SimpleAttributeSet asest;

    public DebugText() {
        this.setEditable(false);
        this.asm = new SimpleAttributeSet();
        this.asi = new SimpleAttributeSet();
        StyleConstants.setForeground(this.asi, Color.blue);
        StyleConstants.setItalic(this.asi, true);
        StyleConstants.setBold(this.asi, true);
        this.ase = new SimpleAttributeSet();
        StyleConstants.setForeground(this.ase, Color.red);
        StyleConstants.setBold(this.ase, true);
        this.aseem = new SimpleAttributeSet();
        StyleConstants.setBold(this.aseem, true);
        this.asest = new SimpleAttributeSet();
        StyleConstants.setForeground(this.asest, new Color(64, 64, 64));
    }

    public void printMessage(String msg) {
        this.showMsg(msg, this.asm);
    }

    public void printError(String msg) {
        this.showMsg(msg, this.ase);
    }

    public void printInfo(String msg) {
        this.showMsg(msg, this.asi);
    }

    public void printException(Exception e) {
        StackTraceElement[] st = e.getStackTrace();
        this.showMsg("\n-----------Exception-----------\n", this.asm);
        this.showMsg(String.valueOf(e.getMessage()) + "\n", this.aseem);
        int i = 0;
        while (i < st.length) {
            this.showMsg(String.valueOf(st[i].toString()) + "\n", this.asest);
            ++i;
        }
        this.showMsg("-------------------------------\n", this.asm);
    }

    private void showMsg(String msg, AttributeSet as) {
        Document doc = this.getDocument();
        try {
            doc.insertString(doc.getLength(), msg, as);
            this.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }
}

