/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Vector2f;

public class Matrix2f
extends Matrix
implements Serializable {
    public float m00 = 1.0f;
    public float m01;
    public float m10;
    public float m11 = 1.0f;

    public Matrix2f() {
    }

    public Matrix2f(Matrix2f src) {
        this.load(src);
    }

    public Matrix2f load(Matrix2f src) {
        this.m00 = src.m00;
        this.m01 = src.m01;
        this.m10 = src.m10;
        this.m11 = src.m11;
        return this;
    }

    public Matrix load(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m01 = buf.get();
        this.m10 = buf.get();
        this.m11 = buf.get();
        return this;
    }

    public Matrix loadTranspose(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m10 = buf.get();
        this.m01 = buf.get();
        this.m11 = buf.get();
        return this;
    }

    public Matrix store(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m01);
        buf.put(this.m10);
        buf.put(this.m11);
        return this;
    }

    public Matrix storeTranspose(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m10);
        buf.put(this.m01);
        buf.put(this.m11);
        return this;
    }

    public static Matrix2f add(Matrix2f left, Matrix2f right, Matrix2f dest) {
        Matrix2f temp = null;
        if (dest == null) {
            dest = new Matrix2f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix2f();
        }
        dest.m00 = left.m00 + right.m00;
        dest.m01 = left.m01 + right.m01;
        dest.m10 = left.m10 + right.m10;
        dest.m11 = left.m11 + right.m11;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix2f sub(Matrix2f left, Matrix2f right, Matrix2f dest) {
        Matrix2f temp = null;
        if (dest == null) {
            dest = new Matrix2f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix2f();
        }
        dest.m00 = left.m00 - right.m00;
        dest.m01 = left.m01 - right.m01;
        dest.m10 = left.m10 - right.m10;
        dest.m11 = left.m11 - right.m11;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix2f mul(Matrix2f left, Matrix2f right, Matrix2f dest) {
        Matrix2f temp = null;
        if (dest == null) {
            dest = new Matrix2f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix2f();
        }
        dest.m00 = left.m00 * right.m00 + left.m10 * right.m01;
        dest.m01 = left.m01 * right.m00 + left.m11 * right.m01;
        dest.m10 = left.m00 * right.m10 + left.m10 * right.m11;
        dest.m11 = left.m01 * right.m10 + left.m11 * right.m11;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Vector2f transform(Matrix2f left, Vector2f right, Vector2f dest) {
        Vector2f temp = null;
        if (dest == null) {
            dest = new Vector2f();
        } else if (dest == right) {
            temp = dest;
            dest = new Vector2f();
        }
        dest.x = left.m00 * right.x + left.m10 * right.y;
        dest.y = left.m01 * right.x + left.m11 * right.y;
        if (temp != null) {
            temp.set(dest);
            return temp;
        }
        return dest;
    }

    public Matrix transpose() {
        float temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        return this;
    }

    public Matrix2f transpose(Matrix2f dest) {
        if (dest == null) {
            dest = new Matrix2f();
        }
        if (dest == this) {
            this.transpose();
        } else {
            dest.m01 = this.m10;
            dest.m10 = this.m01;
        }
        return dest;
    }

    public Matrix invert() {
        float determinant = this.determinant();
        if (determinant != 0.0f) {
            float determinant_inv = 1.0f / determinant;
            float t00 = this.m11 * determinant_inv;
            float t01 = -this.m01 * determinant_inv;
            float t11 = this.m00 * determinant_inv;
            float t10 = -this.m10 * determinant_inv;
            this.m00 = t00;
            this.m01 = t01;
            this.m10 = t10;
            this.m11 = t11;
            return this;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m00).append(' ').append(this.m10).append(' ').append('\n');
        buf.append(this.m01).append(' ').append(this.m11).append(' ').append('\n');
        return buf.toString();
    }

    public Matrix negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        return this;
    }

    public Matrix2f negate(Matrix2f dest) {
        if (dest == null) {
            dest = new Matrix2f();
        }
        dest.m00 = -this.m00;
        dest.m01 = -this.m01;
        dest.m10 = -this.m10;
        dest.m11 = -this.m11;
        return dest;
    }

    public Matrix setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        return this;
    }

    public Matrix setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        return this;
    }

    public float determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }
}

