/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import org.lwjgl.Sys;

public class Timer {
    private static long resolution = Sys.getTimerResolution();
    private static final int QUERY_INTERVAL = 1000;
    private static int queryCount = 0;
    private static int currentTime;
    private int startTime;
    private int lastTime;
    private boolean paused;

    static {
        Timer.tick();
    }

    public Timer() {
        this.reset();
        this.resume();
    }

    public float getTime() {
        if (!this.paused) {
            this.lastTime = currentTime - this.startTime;
        }
        return (float)((double)this.lastTime / (double)resolution);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
    }

    public void reset() {
        this.set(0.0f);
    }

    public void resume() {
        this.paused = false;
        this.startTime = currentTime - this.lastTime;
    }

    public void set(float newTime) {
        int newTimeInTicks = (int)((double)newTime * (double)resolution);
        this.startTime = currentTime - newTimeInTicks;
        this.lastTime = newTimeInTicks;
    }

    public static void tick() {
        currentTime = (int)Sys.getTime();
        if (++queryCount > 1000) {
            queryCount = 0;
            resolution = Sys.getTimerResolution();
        }
    }

    public String toString() {
        return "Timer[Time=" + this.getTime() + ", Paused=" + this.paused + "]";
    }
}

