/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Map;
import java.util.WeakHashMap;
import org.lwjgl.opengl.StateStack;
import org.lwjgl.opengl.Util;

class VBOTracker {
    private static VBOTracker current_tracker;
    private static final Map contextToTracker;
    private final StateStack vbo_array_stack;
    private final StateStack vbo_element_stack;
    private final StateStack attrib_stack;

    static {
        contextToTracker = new WeakHashMap(3, 1.0f);
    }

    private VBOTracker() {
        int stack_size = Math.max(1, Util.glGetInteger(3387));
        this.vbo_array_stack = new StateStack(stack_size, 0);
        this.vbo_element_stack = new StateStack(stack_size, 0);
        this.attrib_stack = new StateStack(stack_size, 0);
    }

    static StateStack getVBOArrayStack() {
        return VBOTracker.current_tracker.vbo_array_stack;
    }

    static StateStack getVBOElementStack() {
        return VBOTracker.current_tracker.vbo_element_stack;
    }

    static StateStack getClientAttribStack() {
        return VBOTracker.current_tracker.attrib_stack;
    }

    static void setCurrent(Object context) {
        if (context == null) {
            current_tracker = null;
            return;
        }
        current_tracker = (VBOTracker)contextToTracker.get(context);
        if (current_tracker == null) {
            current_tracker = new VBOTracker();
            contextToTracker.put(context, current_tracker);
        }
    }
}

