/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public final class Pbuffer {
    public static final int PBUFFER_SUPPORTED = 1;
    public static final int RENDER_TEXTURE_SUPPORTED = 2;
    public static final int RENDER_TEXTURE_RECTANGLE_SUPPORTED = 4;
    public static final int RENDER_DEPTH_TEXTURE_SUPPORTED = 8;
    public static final int MIPMAP_LEVEL = 8315;
    public static final int CUBE_MAP_FACE = 8316;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_X = 8317;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_X = 8318;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Y = 8319;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Y = 8320;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Z = 8321;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Z = 8322;
    public static final int FRONT_LEFT_BUFFER = 8323;
    public static final int FRONT_RIGHT_BUFFER = 8324;
    public static final int BACK_LEFT_BUFFER = 8325;
    public static final int BACK_RIGHT_BUFFER = 8326;
    public static final int DEPTH_BUFFER = 8359;
    private static final int HANDLE_SIZE = 24;
    private final ByteBuffer handle;
    private final int width;
    private final int height;

    static {
        Sys.initialize();
    }

    public Pbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture) throws LWJGLException {
        this.width = width;
        this.height = height;
        this.handle = Pbuffer.createPbuffer(width, height, pixel_format, renderTexture);
    }

    private static ByteBuffer createPbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture) throws LWJGLException {
        GLContext.loadOpenGLLibrary();
        try {
            ByteBuffer handle = BufferUtils.createByteBuffer(24);
            if (renderTexture == null) {
                Pbuffer.nCreate(handle, width, height, pixel_format, null, null);
            } else {
                Pbuffer.nCreate(handle, width, height, pixel_format, renderTexture.pixelFormatCaps, renderTexture.pBufferAttribs);
            }
            return handle;
        }
        catch (LWJGLException e) {
            GLContext.unloadOpenGLLibrary();
            throw e;
        }
    }

    public boolean isBufferLost() {
        return Pbuffer.nIsBufferLost(this.handle);
    }

    private static native boolean nIsBufferLost(ByteBuffer var0);

    public void makeCurrent() throws LWJGLException {
        Pbuffer.nMakeCurrent(this.handle);
        GLContext.useContext(this);
    }

    private static native void nMakeCurrent(ByteBuffer var0) throws LWJGLException;

    public static int getPbufferCaps() {
        return Display.getImplementation().getPbufferCaps();
    }

    private static native void nCreate(ByteBuffer var0, int var1, int var2, PixelFormat var3, IntBuffer var4, IntBuffer var5) throws LWJGLException;

    public void destroy() {
        try {
            this.makeCurrent();
            int error = GL11.glGetError();
            Pbuffer.nDestroy(this.handle);
            GLContext.useContext(null);
            GLContext.unloadOpenGLLibrary();
            if (error != 0) {
                throw new OpenGLException(error);
            }
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
    }

    private static native void nDestroy(ByteBuffer var0);

    public void setAttrib(int attrib, int value) {
        Pbuffer.nSetAttrib(this.handle, attrib, value);
    }

    private static native void nSetAttrib(ByteBuffer var0, int var1, int var2);

    public void bindTexImage(int buffer) {
        Pbuffer.nBindTexImage(this.handle, buffer);
    }

    private static native void nBindTexImage(ByteBuffer var0, int var1);

    public void releaseTexImage(int buffer) {
        Pbuffer.nReleaseTexImage(this.handle, buffer);
    }

    private static native void nReleaseTexImage(ByteBuffer var0, int var1);

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

