/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;

public abstract class NVProgram {
    public static final int GL_PROGRAM_TARGET_NV = 34374;
    public static final int GL_PROGRAM_LENGTH_NV = 34343;
    public static final int GL_PROGRAM_RESIDENT_NV = 34375;
    public static final int GL_PROGRAM_STRING_NV = 34344;
    public static final int GL_PROGRAM_ERROR_POSITION_NV = 34379;
    public static final int GL_PROGRAM_ERROR_STRING_NV = 34932;

    static native void initNativeStubs() throws LWJGLException;

    public static void glLoadProgramNV(int target, int programID, ByteBuffer string) {
        BufferChecks.checkDirect(string);
        NVProgram.nglLoadProgramNV(target, programID, string.remaining(), string, string.position());
    }

    private static native void nglLoadProgramNV(int var0, int var1, int var2, Buffer var3, int var4);

    public static native void glBindProgramNV(int var0, int var1);

    public static void glDeleteProgramsNV(IntBuffer programs) {
        BufferChecks.checkDirect(programs);
        NVProgram.nglDeleteProgramsNV(programs.remaining(), programs, programs.position());
    }

    private static native void nglDeleteProgramsNV(int var0, IntBuffer var1, int var2);

    public static void glGenProgramsNV(IntBuffer programs) {
        BufferChecks.checkDirect(programs);
        NVProgram.nglGenProgramsNV(programs.remaining(), programs, programs.position());
    }

    private static native void nglGenProgramsNV(int var0, IntBuffer var1, int var2);

    public static void glGetProgramNV(int programID, int parameterName, IntBuffer params) {
        BufferChecks.checkDirect(params);
        NVProgram.nglGetProgramivNV(programID, parameterName, params, params.position());
    }

    private static native void nglGetProgramivNV(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetProgramStringNV(int programID, int parameterName, ByteBuffer paramString) {
        BufferChecks.checkDirect(paramString);
        NVProgram.nglGetProgramStringNV(programID, parameterName, paramString, paramString.position());
    }

    private static native void nglGetProgramStringNV(int var0, int var1, Buffer var2, int var3);

    public static native boolean glIsProgramNV(int var0);

    public static boolean glAreProgramsResidentNV(IntBuffer programIDs, ByteBuffer programResidences) {
        BufferChecks.checkDirect(programIDs);
        BufferChecks.checkDirect(programResidences);
        if (programIDs.remaining() != programResidences.remaining()) {
            throw new IllegalArgumentException("programIDs.remaining() != programResidences.remaining()");
        }
        return NVProgram.nglAreProgramsResidentNV(programIDs.remaining(), programIDs, programIDs.position(), programResidences, programResidences.position());
    }

    private static native boolean nglAreProgramsResidentNV(int var0, IntBuffer var1, int var2, ByteBuffer var3, int var4);

    public static void glRequestResidentProgramsNV(IntBuffer programIDs) {
        BufferChecks.checkDirect(programIDs);
        NVProgram.nglRequestResidentProgramsNV(programIDs.remaining(), programIDs, programIDs.position());
    }

    private static native void nglRequestResidentProgramsNV(int var0, IntBuffer var1, int var2);
}

