/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;

public final class NVPixelDataRange {
    public static final int GL_WRITE_PIXEL_DATA_RANGE_NV = 34936;
    public static final int GL_READ_PIXEL_DATA_RANGE_NV = 34937;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 34938;
    public static final int GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 34939;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 34940;
    public static final int GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 34941;

    private NVPixelDataRange() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glPixelDataRangeNV(int target, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        NVPixelDataRange.nglPixelDataRangeNV(target, data.remaining(), data, data.position());
    }

    public static void glPixelDataRangeNV(int target, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        NVPixelDataRange.nglPixelDataRangeNV(target, data.remaining() << 1, data, data.position() << 1);
    }

    public static void glPixelDataRangeNV(int target, IntBuffer data) {
        BufferChecks.checkDirect(data);
        NVPixelDataRange.nglPixelDataRangeNV(target, data.remaining() << 2, data, data.position() << 2);
    }

    public static void glPixelDataRangeNV(int target, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        NVPixelDataRange.nglPixelDataRangeNV(target, data.remaining() << 2, data, data.position() << 2);
    }

    private static native void nglPixelDataRangeNV(int var0, int var1, Buffer var2, int var3);

    public static native void glFlushPixelDataRangeNV(int var0);
}

