/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.MacOSXGLCanvas;

final class MacOSXFrame
extends Frame
implements WindowListener,
ComponentListener {
    private final MacOSXGLCanvas canvas;
    private boolean close_requested;
    private Rectangle bounds;
    private boolean should_update;
    private boolean active;
    private boolean visible;
    private boolean minimized;

    MacOSXFrame(DisplayMode mode, java.awt.DisplayMode requested_mode, boolean fullscreen, int x, int y) throws LWJGLException {
        this.setResizable(false);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.canvas = new MacOSXGLCanvas();
        this.add((Component)this.canvas, "Center");
        boolean undecorated = Boolean.getBoolean("org.lwjgl.opengl.Window.undecorated");
        this.setUndecorated(fullscreen || undecorated);
        if (fullscreen) {
            MacOSXFrame.getDevice().setFullScreenWindow(this);
            MacOSXFrame.getDevice().setDisplayMode(requested_mode);
            java.awt.DisplayMode real_mode = MacOSXFrame.getDevice().getDisplayMode();
            if (requested_mode.getWidth() != real_mode.getWidth() || requested_mode.getHeight() != real_mode.getHeight()) {
                MacOSXFrame.getDevice().setFullScreenWindow(null);
                this.syncDispose();
                throw new LWJGLException("AWT capped mode: requested mode = " + requested_mode.getWidth() + "x" + requested_mode.getHeight() + " but got " + real_mode.getWidth() + " " + real_mode.getHeight());
            }
        }
        this.pack();
        this.syncReshape(x, y, mode.getWidth(), mode.getHeight());
        this.invokeAWT(new Runnable(){

            public void run() {
                MacOSXFrame.this.setVisible(true);
                MacOSXFrame.this.requestFocus();
                MacOSXFrame.this.canvas.requestFocus();
            }
        });
        this.canvas.waitForCanvasCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle syncGetBounds() {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            return this.bounds;
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.bounds = this.getBounds();
        }
    }

    public void componentResized(ComponentEvent e) {
        this.updateBounds();
    }

    public void componentMoved(ComponentEvent e) {
        this.updateBounds();
    }

    public static GraphicsDevice getDevice() {
        GraphicsEnvironment g_env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = g_env.getDefaultScreenDevice();
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowIconified(WindowEvent e) {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.minimized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowDeiconified(WindowEvent e) {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.minimized = false;
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosing(WindowEvent e) {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.close_requested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowDeactivated(WindowEvent e) {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowActivated(WindowEvent e) {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            this.should_update = true;
            this.active = true;
        }
    }

    public void syncDispose() {
        this.invokeAWT(new Runnable(){

            public void run() {
                if (MacOSXFrame.this.isDisplayable()) {
                    MacOSXFrame.this.dispose();
                }
            }
        });
    }

    public void syncSetTitle(String title) {
        this.invokeAWT(new TitleSetter(title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncIsCloseRequested() {
        boolean result;
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            result = this.close_requested;
            this.close_requested = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncIsVisible() {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            return !this.minimized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncIsActive() {
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            return this.active;
        }
    }

    public MacOSXGLCanvas getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncShouldUpdateContext() {
        boolean result;
        MacOSXFrame macOSXFrame = this;
        synchronized (macOSXFrame) {
            result = this.canvas.syncShouldUpdateContext() || this.should_update;
            this.should_update = false;
        }
        return result;
    }

    private void invokeAWT(Runnable r) {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void syncReshape(int x, int y, int width, int height) {
        this.invokeAWT(new Reshaper(x, y, width, height));
    }

    public void syncSetCursor(Cursor awt_cursor) {
        this.invokeAWT(new CursorSetter(awt_cursor));
    }

    private class TitleSetter
    implements Runnable {
        private final String title;

        TitleSetter(String title) {
            this.title = title;
        }

        public void run() {
            MacOSXFrame.this.setTitle(this.title);
        }
    }

    private class Reshaper
    implements Runnable {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        Reshaper(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void run() {
            Insets insets = MacOSXFrame.this.getInsets();
            MacOSXFrame.this.setBounds(this.x, this.y, this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
        }
    }

    private class CursorSetter
    implements Runnable {
        private final Cursor awt_cursor;

        CursorSetter(Cursor awt_cursor) {
            this.awt_cursor = awt_cursor;
        }

        public void run() {
            MacOSXFrame.this.canvas.setCursor(this.awt_cursor);
        }
    }
}

