/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.VBOTracker;

public final class GLContext {
    private static WeakReference currentContext;
    public static boolean GL_ARB_color_buffer_float;
    public static boolean GL_ARB_depth_texture;
    public static boolean GL_ARB_draw_buffers;
    public static boolean GL_ARB_fragment_program;
    public static boolean GL_ARB_fragment_program_shadow;
    public static boolean GL_ARB_fragment_shader;
    public static boolean GL_ARB_half_float_pixel;
    public static boolean GL_ARB_imaging;
    public static boolean GL_ARB_matrix_palette;
    public static boolean GL_ARB_multisample;
    public static boolean GL_ARB_multitexture;
    public static boolean GL_ARB_occlusion_query;
    public static boolean GL_ARB_point_parameters;
    public static boolean GL_ARB_point_sprite;
    public static boolean GL_ARB_shading_language_100;
    public static boolean GL_ARB_shader_objects;
    public static boolean GL_ARB_shadow;
    public static boolean GL_ARB_shadow_ambient;
    public static boolean GL_ARB_texture_border_clamp;
    public static boolean GL_ARB_texture_compression;
    public static boolean GL_ARB_texture_cube_map;
    public static boolean GL_ARB_texture_env_add;
    public static boolean GL_ARB_texture_env_combine;
    public static boolean GL_ARB_texture_env_crossbar;
    public static boolean GL_ARB_texture_env_dot3;
    public static boolean GL_ARB_texture_float;
    public static boolean GL_ARB_texture_mirrored_repeat;
    public static boolean GL_ARB_texture_non_power_of_two;
    public static boolean GL_ARB_texture_rectangle;
    public static boolean GL_ARB_transpose_matrix;
    public static boolean GL_ARB_vertex_blend;
    public static boolean GL_ARB_vertex_buffer_object;
    public static boolean GL_ARB_vertex_program;
    public static boolean GL_ARB_vertex_shader;
    public static boolean GL_ARB_window_pos;
    public static boolean GL_EXT_abgr;
    public static boolean GL_EXT_bgra;
    public static boolean GL_EXT_blend_equation_separate;
    public static boolean GL_EXT_blend_func_separate;
    public static boolean GL_EXT_blend_subtract;
    public static boolean GL_EXT_Cg_shader;
    public static boolean GL_EXT_compiled_vertex_array;
    public static boolean GL_EXT_depth_bounds_test;
    public static boolean GL_EXT_draw_range_elements;
    public static boolean GL_EXT_fog_coord;
    public static boolean GL_EXT_multi_draw_arrays;
    public static boolean GL_EXT_packed_pixels;
    public static boolean GL_EXT_paletted_texture;
    public static boolean GL_EXT_pixel_buffer_object;
    public static boolean GL_EXT_point_parameters;
    public static boolean GL_EXT_rescale_normal;
    public static boolean GL_EXT_secondary_color;
    public static boolean GL_EXT_separate_specular_color;
    public static boolean GL_EXT_shadow_funcs;
    public static boolean GL_EXT_shared_texture_palette;
    public static boolean GL_EXT_stencil_two_side;
    public static boolean GL_EXT_stencil_wrap;
    public static boolean GL_EXT_texture_3D;
    public static boolean GL_EXT_texture_compression_s3tc;
    public static boolean GL_EXT_texture_env_combine;
    public static boolean GL_EXT_texture_env_dot3;
    public static boolean GL_EXT_texture_filter_anisotropic;
    public static boolean GL_EXT_texture_lod_bias;
    public static boolean GL_EXT_texture_mirror_clamp;
    public static boolean GL_EXT_texture_rectangle;
    public static boolean GL_EXT_vertex_shader;
    public static boolean GL_EXT_vertex_weighting;
    public static boolean GL_ATI_draw_buffers;
    public static boolean GL_ATI_element_array;
    public static boolean GL_ATI_envmap_bumpmap;
    public static boolean GL_ATI_fragment_shader;
    public static boolean GL_ATI_map_object_buffer;
    public static boolean GL_ATI_pn_triangles;
    public static boolean GL_ATI_separate_stencil;
    public static boolean GL_ATI_texture_compression_3dc;
    public static boolean GL_ATI_texture_float;
    public static boolean GL_ATI_texture_mirror_once;
    public static boolean GL_ATI_vertex_array_object;
    public static boolean GL_ATI_vertex_streams;
    public static boolean GL_ATI_vertex_attrib_array_object;
    public static boolean GL_HP_occlusion_test;
    public static boolean GL_IBM_rasterpos_clip;
    public static boolean GL_NV_blend_square;
    public static boolean GL_NV_copy_depth_to_color;
    public static boolean GL_NV_depth_clamp;
    public static boolean GL_NV_evaluators;
    public static boolean GL_NV_fence;
    public static boolean GL_NV_float_buffer;
    public static boolean GL_NV_fog_distance;
    public static boolean GL_NV_fragment_program;
    public static boolean GL_NV_fragment_program2;
    public static boolean GL_NV_fragment_program_option;
    public static boolean GL_NV_half_float;
    public static boolean GL_NV_light_max_exponent;
    public static boolean GL_NV_multisample_filter_hint;
    public static boolean GL_NV_occlusion_query;
    public static boolean GL_NV_packed_depth_stencil;
    public static boolean GL_NV_pixel_data_range;
    public static boolean GL_NV_point_sprite;
    public static boolean GL_NV_primitive_restart;
    public static boolean GL_NV_register_combiners;
    public static boolean GL_NV_register_combiners2;
    public static boolean GL_NV_texgen_reflection;
    public static boolean GL_NV_texture_compression_vtc;
    public static boolean GL_NV_texture_env_combine4;
    public static boolean GL_NV_texture_expand_normal;
    public static boolean GL_NV_texture_rectangle;
    public static boolean GL_NV_texture_shader;
    public static boolean GL_NV_texture_shader2;
    public static boolean GL_NV_texture_shader3;
    public static boolean GL_NV_vertex_array_range;
    public static boolean GL_NV_vertex_array_range2;
    public static boolean GL_NV_vertex_program;
    public static boolean GL_NV_vertex_program1_1;
    public static boolean GL_NV_vertex_program2;
    public static boolean GL_NV_vertex_program2_option;
    public static boolean GL_NV_vertex_program3;
    public static boolean GL_SUN_slice_accum;
    public static boolean OpenGL11;
    public static boolean OpenGL12;
    public static boolean OpenGL13;
    public static boolean OpenGL14;
    public static boolean OpenGL15;
    public static boolean OpenGL20;
    private static Map exts;
    private static int gl_ref_count;
    private static boolean did_auto_load;
    private static boolean loaded_stubs;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Sys.initialize();
    }

    private static void determineAvailableExtensions(Set exts) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.opengl.GLContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isStatic(fields[i].getModifiers()) && fields[i].getType().equals(Boolean.TYPE)) {
                try {
                    Field field = fields[i];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.lwjgl.opengl.GLContext");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    field.setBoolean(clazz2, exts.contains(fields[i].getName()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
    }

    public static void useContext(Object context) throws LWJGLException {
        Object current;
        if (context == null) {
            GLContext.unloadStubs();
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            currentContext = null;
            VBOTracker.setCurrent(null);
            return;
        }
        Object v0 = current = currentContext == null ? null : currentContext.get();
        if (current == context) {
            return;
        }
        if (gl_ref_count == 0) {
            GLContext.loadOpenGLLibrary();
            did_auto_load = true;
        }
        try {
            GLContext.loadStubs();
            currentContext = new WeakReference<Object>(context);
            VBOTracker.setCurrent(context);
        }
        catch (LWJGLException e) {
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            throw e;
        }
    }

    private static void getExtensionClassesAndNames(Map exts, Set exts_names) {
        String version = GL11.glGetString(7938);
        StringTokenizer version_tokenizer = new StringTokenizer(version, ". ");
        String major_string = version_tokenizer.nextToken();
        String minor_string = version_tokenizer.nextToken();
        int majorVersion = Integer.parseInt(major_string);
        int minorVersion = Integer.parseInt(minor_string);
        if (majorVersion == 2) {
            GLContext.addExtensionClass(exts, exts_names, "GL20", "OpenGL20");
            GLContext.addExtensionClass(exts, exts_names, "GL15", "OpenGL15");
            GLContext.addExtensionClass(exts, exts_names, "GL14", "OpenGL14");
            GLContext.addExtensionClass(exts, exts_names, "GL13", "OpenGL13");
            GLContext.addExtensionClass(exts, exts_names, "GL12", "OpenGL12");
        } else {
            switch (minorVersion) {
                case 5: {
                    GLContext.addExtensionClass(exts, exts_names, "GL15", "OpenGL15");
                }
                case 4: {
                    GLContext.addExtensionClass(exts, exts_names, "GL14", "OpenGL14");
                }
                case 3: {
                    GLContext.addExtensionClass(exts, exts_names, "GL13", "OpenGL13");
                }
                case 2: {
                    GLContext.addExtensionClass(exts, exts_names, "GL12", "OpenGL12");
                }
            }
        }
        GLContext.addExtensionClass(exts, exts_names, "EXTTextureCompressionS3TC", "");
        String extensions_string = GL11.glGetString(7939);
        StringTokenizer tokenizer = new StringTokenizer(extensions_string);
        while (tokenizer.hasMoreTokens()) {
            String extension_string = tokenizer.nextToken();
            StringBuffer converted_name = new StringBuffer();
            int gl_prefix_index = extension_string.indexOf("GL_");
            if (gl_prefix_index == -1) continue;
            if ("GL_EXT_texture_compression_s3tc".equals(extension_string)) {
                GLContext.addExtensionClass(exts, exts_names, "EXTTextureCompressionS3TC", "GL_EXT_texture_compression_s3tc");
                continue;
            }
            if ("GL_EXT_texture_lod_bias".equals(extension_string)) {
                GLContext.addExtensionClass(exts, exts_names, "EXTTextureLODBias", "GL_EXT_texture_lod_bias");
                continue;
            }
            if ("GL_NV_texture_compression_vtc".equals(extension_string)) {
                GLContext.addExtensionClass(exts, exts_names, "NVTextureCompressionVTC", "GL_NV_texture_compression_vtc");
                continue;
            }
            int i = gl_prefix_index + 3;
            while (i < extension_string.length()) {
                char c = extension_string.charAt(i) == '_' ? Character.toUpperCase(extension_string.charAt(++i)) : extension_string.charAt(i);
                converted_name.append(c);
                ++i;
            }
            GLContext.addExtensionClass(exts, exts_names, converted_name.toString(), extension_string);
        }
        GLContext.addExtensionClass(exts, exts_names, "ARBBufferObject", null);
        GLContext.addExtensionClass(exts, exts_names, "ARBProgram", null);
        GLContext.addExtensionClass(exts, exts_names, "NVProgram", null);
    }

    private static void addExtensionClass(Map exts, Set exts_names, String ext_class_name, String ext_name) {
        if (ext_name != null) {
            if (exts_names.contains(ext_name)) {
                return;
            }
            exts_names.add(ext_name);
        }
        try {
            Class<?> extension_class = Class.forName("org.lwjgl.opengl." + ext_class_name);
            extension_class.getDeclaredMethod("initNativeStubs", null);
            exts.put(extension_class, ext_name);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static void loadStubs() throws LWJGLException {
        if (loaded_stubs) {
            return;
        }
        GL11.initNativeStubs();
        exts = new HashMap();
        HashSet exts_names = new HashSet();
        GLContext.getExtensionClassesAndNames(exts, exts_names);
        Iterator exts_it = exts.keySet().iterator();
        while (exts_it.hasNext()) {
            Class extension_class = (Class)exts_it.next();
            GLContext.resetNativeStubs(extension_class);
            try {
                Method init_stubs_method = extension_class.getDeclaredMethod("initNativeStubs", null);
                init_stubs_method.invoke(null, null);
            }
            catch (Exception e) {
                Sys.log("Failed to initialize extension " + extension_class);
                exts_it.remove();
                exts_names.remove(exts.get(extension_class));
            }
        }
        GLContext.determineAvailableExtensions(exts_names);
        loaded_stubs = true;
    }

    private static void unloadStubs() {
        if (!loaded_stubs) {
            return;
        }
        loaded_stubs = false;
        Iterator exts_it = exts.keySet().iterator();
        while (exts_it.hasNext()) {
            Class ext_class = (Class)exts_it.next();
            GLContext.resetNativeStubs(ext_class);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.lwjgl.opengl.GL11");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GLContext.resetNativeStubs(clazz);
    }

    public static void loadOpenGLLibrary() throws LWJGLException {
        if (gl_ref_count == 0) {
            GLContext.nLoadOpenGLLibrary();
        }
        ++gl_ref_count;
    }

    private static native void nLoadOpenGLLibrary() throws LWJGLException;

    public static void unloadOpenGLLibrary() {
        if (--gl_ref_count == 0) {
            GLContext.nUnloadOpenGLLibrary();
        }
    }

    private static native void nUnloadOpenGLLibrary();

    private static native void resetNativeStubs(Class var0);
}

