/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.VBOTracker;

class GLBufferChecks {
    private GLBufferChecks() {
    }

    static void ensureArrayVBOdisabled() {
        if (VBOTracker.getVBOArrayStack().getState() != 0) {
            throw new OpenGLException("Cannot use Buffers when VBO is enabled");
        }
    }

    static void ensureArrayVBOenabled() {
        if (VBOTracker.getVBOArrayStack().getState() == 0) {
            throw new OpenGLException("Cannot use offsets when VBO is disabled");
        }
    }

    static void ensureElementVBOdisabled() {
        if (VBOTracker.getVBOElementStack().getState() != 0) {
            throw new OpenGLException("Cannot use Buffers when VBO is enabled");
        }
    }

    static void ensureElementVBOenabled() {
        if (VBOTracker.getVBOElementStack().getState() == 0) {
            throw new OpenGLException("Cannot use offsets when VBO is disabled");
        }
    }

    static int calculateImageStorage(int format, int type, int width, int height, int depth) {
        return GLBufferChecks.calculateBytesPerPixel(type, format) * width * height * depth;
    }

    static int calculateTexImage1DStorage(int format, int type, int width, int border) {
        return GLBufferChecks.calculateBytesPerPixel(type, format) * (width + (border << 1));
    }

    static int calculateTexImage2DStorage(int format, int type, int width, int height, int border) {
        return GLBufferChecks.calculateTexImage1DStorage(type, format, width, border) * (height + (border << 1));
    }

    static int calculateTexImage3DStorage(int format, int type, int width, int height, int depth, int border) {
        return GLBufferChecks.calculateTexImage2DStorage(type, format, width, height, border) * (depth + (border << 1));
    }

    private static int calculateBytesPerPixel(int type, int format) {
        int epp;
        int bpe;
        switch (type) {
            case 5120: 
            case 5121: {
                bpe = 1;
                break;
            }
            case 5122: 
            case 5123: {
                bpe = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                bpe = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        switch (format) {
            case 6406: 
            case 6409: {
                epp = 1;
                break;
            }
            case 6410: {
                epp = 2;
                break;
            }
            case 6407: 
            case 32992: {
                epp = 3;
                break;
            }
            case 6408: 
            case 32768: 
            case 32993: {
                epp = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        return bpe * epp;
    }
}

