/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;
import org.lwjgl.opengl.VBOTracker;

public final class GL11 {
    public static final int GL_ACCUM = 256;
    public static final int GL_LOAD = 257;
    public static final int GL_RETURN = 258;
    public static final int GL_MULT = 259;
    public static final int GL_ADD = 260;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_CURRENT_BIT = 1;
    public static final int GL_POINT_BIT = 2;
    public static final int GL_LINE_BIT = 4;
    public static final int GL_POLYGON_BIT = 8;
    public static final int GL_POLYGON_STIPPLE_BIT = 16;
    public static final int GL_PIXEL_MODE_BIT = 32;
    public static final int GL_LIGHTING_BIT = 64;
    public static final int GL_FOG_BIT = 128;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_ACCUM_BUFFER_BIT = 512;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_VIEWPORT_BIT = 2048;
    public static final int GL_TRANSFORM_BIT = 4096;
    public static final int GL_ENABLE_BIT = 8192;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_HINT_BIT = 32768;
    public static final int GL_EVAL_BIT = 65536;
    public static final int GL_LIST_BIT = 131072;
    public static final int GL_TEXTURE_BIT = 262144;
    public static final int GL_SCISSOR_BIT = 524288;
    public static final int GL_ALL_ATTRIB_BITS = 1048575;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_QUADS = 7;
    public static final int GL_QUAD_STRIP = 8;
    public static final int GL_POLYGON = 9;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_TRUE = 1;
    public static final int GL_FALSE = 0;
    public static final int GL_CLIP_PLANE0 = 12288;
    public static final int GL_CLIP_PLANE1 = 12289;
    public static final int GL_CLIP_PLANE2 = 12290;
    public static final int GL_CLIP_PLANE3 = 12291;
    public static final int GL_CLIP_PLANE4 = 12292;
    public static final int GL_CLIP_PLANE5 = 12293;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_2_BYTES = 5127;
    public static final int GL_3_BYTES = 5128;
    public static final int GL_4_BYTES = 5129;
    public static final int GL_DOUBLE = 5130;
    public static final int GL_NONE = 0;
    public static final int GL_FRONT_LEFT = 1024;
    public static final int GL_FRONT_RIGHT = 1025;
    public static final int GL_BACK_LEFT = 1026;
    public static final int GL_BACK_RIGHT = 1027;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_LEFT = 1030;
    public static final int GL_RIGHT = 1031;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_AUX0 = 1033;
    public static final int GL_AUX1 = 1034;
    public static final int GL_AUX2 = 1035;
    public static final int GL_AUX3 = 1036;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_STACK_OVERFLOW = 1283;
    public static final int GL_STACK_UNDERFLOW = 1284;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_2D = 1536;
    public static final int GL_3D = 1537;
    public static final int GL_3D_COLOR = 1538;
    public static final int GL_3D_COLOR_TEXTURE = 1539;
    public static final int GL_4D_COLOR_TEXTURE = 1540;
    public static final int GL_PASS_THROUGH_TOKEN = 1792;
    public static final int GL_POINT_TOKEN = 1793;
    public static final int GL_LINE_TOKEN = 1794;
    public static final int GL_POLYGON_TOKEN = 1795;
    public static final int GL_BITMAP_TOKEN = 1796;
    public static final int GL_DRAW_PIXEL_TOKEN = 1797;
    public static final int GL_COPY_PIXEL_TOKEN = 1798;
    public static final int GL_LINE_RESET_TOKEN = 1799;
    public static final int GL_EXP = 2048;
    public static final int GL_EXP2 = 2049;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_COEFF = 2560;
    public static final int GL_ORDER = 2561;
    public static final int GL_DOMAIN = 2562;
    public static final int GL_CURRENT_COLOR = 2816;
    public static final int GL_CURRENT_INDEX = 2817;
    public static final int GL_CURRENT_NORMAL = 2818;
    public static final int GL_CURRENT_TEXTURE_COORDS = 2819;
    public static final int GL_CURRENT_RASTER_COLOR = 2820;
    public static final int GL_CURRENT_RASTER_INDEX = 2821;
    public static final int GL_CURRENT_RASTER_TEXTURE_COORDS = 2822;
    public static final int GL_CURRENT_RASTER_POSITION = 2823;
    public static final int GL_CURRENT_RASTER_POSITION_VALID = 2824;
    public static final int GL_CURRENT_RASTER_DISTANCE = 2825;
    public static final int GL_POINT_SMOOTH = 2832;
    public static final int GL_POINT_SIZE = 2833;
    public static final int GL_POINT_SIZE_RANGE = 2834;
    public static final int GL_POINT_SIZE_GRANULARITY = 2835;
    public static final int GL_LINE_SMOOTH = 2848;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_LINE_WIDTH_RANGE = 2850;
    public static final int GL_LINE_WIDTH_GRANULARITY = 2851;
    public static final int GL_LINE_STIPPLE = 2852;
    public static final int GL_LINE_STIPPLE_PATTERN = 2853;
    public static final int GL_LINE_STIPPLE_REPEAT = 2854;
    public static final int GL_LIST_MODE = 2864;
    public static final int GL_MAX_LIST_NESTING = 2865;
    public static final int GL_LIST_BASE = 2866;
    public static final int GL_LIST_INDEX = 2867;
    public static final int GL_POLYGON_MODE = 2880;
    public static final int GL_POLYGON_SMOOTH = 2881;
    public static final int GL_POLYGON_STIPPLE = 2882;
    public static final int GL_EDGE_FLAG = 2883;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_LIGHTING = 2896;
    public static final int GL_LIGHT_MODEL_LOCAL_VIEWER = 2897;
    public static final int GL_LIGHT_MODEL_TWO_SIDE = 2898;
    public static final int GL_LIGHT_MODEL_AMBIENT = 2899;
    public static final int GL_SHADE_MODEL = 2900;
    public static final int GL_COLOR_MATERIAL_FACE = 2901;
    public static final int GL_COLOR_MATERIAL_PARAMETER = 2902;
    public static final int GL_COLOR_MATERIAL = 2903;
    public static final int GL_FOG = 2912;
    public static final int GL_FOG_INDEX = 2913;
    public static final int GL_FOG_DENSITY = 2914;
    public static final int GL_FOG_START = 2915;
    public static final int GL_FOG_END = 2916;
    public static final int GL_FOG_MODE = 2917;
    public static final int GL_FOG_COLOR = 2918;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_ACCUM_CLEAR_VALUE = 2944;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_MATRIX_MODE = 2976;
    public static final int GL_NORMALIZE = 2977;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_MODELVIEW_STACK_DEPTH = 2979;
    public static final int GL_PROJECTION_STACK_DEPTH = 2980;
    public static final int GL_TEXTURE_STACK_DEPTH = 2981;
    public static final int GL_MODELVIEW_MATRIX = 2982;
    public static final int GL_PROJECTION_MATRIX = 2983;
    public static final int GL_TEXTURE_MATRIX = 2984;
    public static final int GL_ATTRIB_STACK_DEPTH = 2992;
    public static final int GL_CLIENT_ATTRIB_STACK_DEPTH = 2993;
    public static final int GL_ALPHA_TEST = 3008;
    public static final int GL_ALPHA_TEST_FUNC = 3009;
    public static final int GL_ALPHA_TEST_REF = 3010;
    public static final int GL_DITHER = 3024;
    public static final int GL_BLEND_DST = 3040;
    public static final int GL_BLEND_SRC = 3041;
    public static final int GL_BLEND = 3042;
    public static final int GL_LOGIC_OP_MODE = 3056;
    public static final int GL_INDEX_LOGIC_OP = 3057;
    public static final int GL_COLOR_LOGIC_OP = 3058;
    public static final int GL_AUX_BUFFERS = 3072;
    public static final int GL_DRAW_BUFFER = 3073;
    public static final int GL_READ_BUFFER = 3074;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_INDEX_CLEAR_VALUE = 3104;
    public static final int GL_INDEX_WRITEMASK = 3105;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_INDEX_MODE = 3120;
    public static final int GL_RGBA_MODE = 3121;
    public static final int GL_DOUBLEBUFFER = 3122;
    public static final int GL_STEREO = 3123;
    public static final int GL_RENDER_MODE = 3136;
    public static final int GL_PERSPECTIVE_CORRECTION_HINT = 3152;
    public static final int GL_POINT_SMOOTH_HINT = 3153;
    public static final int GL_LINE_SMOOTH_HINT = 3154;
    public static final int GL_POLYGON_SMOOTH_HINT = 3155;
    public static final int GL_FOG_HINT = 3156;
    public static final int GL_TEXTURE_GEN_S = 3168;
    public static final int GL_TEXTURE_GEN_T = 3169;
    public static final int GL_TEXTURE_GEN_R = 3170;
    public static final int GL_TEXTURE_GEN_Q = 3171;
    public static final int GL_PIXEL_MAP_I_TO_I = 3184;
    public static final int GL_PIXEL_MAP_S_TO_S = 3185;
    public static final int GL_PIXEL_MAP_I_TO_R = 3186;
    public static final int GL_PIXEL_MAP_I_TO_G = 3187;
    public static final int GL_PIXEL_MAP_I_TO_B = 3188;
    public static final int GL_PIXEL_MAP_I_TO_A = 3189;
    public static final int GL_PIXEL_MAP_R_TO_R = 3190;
    public static final int GL_PIXEL_MAP_G_TO_G = 3191;
    public static final int GL_PIXEL_MAP_B_TO_B = 3192;
    public static final int GL_PIXEL_MAP_A_TO_A = 3193;
    public static final int GL_PIXEL_MAP_I_TO_I_SIZE = 3248;
    public static final int GL_PIXEL_MAP_S_TO_S_SIZE = 3249;
    public static final int GL_PIXEL_MAP_I_TO_R_SIZE = 3250;
    public static final int GL_PIXEL_MAP_I_TO_G_SIZE = 3251;
    public static final int GL_PIXEL_MAP_I_TO_B_SIZE = 3252;
    public static final int GL_PIXEL_MAP_I_TO_A_SIZE = 3253;
    public static final int GL_PIXEL_MAP_R_TO_R_SIZE = 3254;
    public static final int GL_PIXEL_MAP_G_TO_G_SIZE = 3255;
    public static final int GL_PIXEL_MAP_B_TO_B_SIZE = 3256;
    public static final int GL_PIXEL_MAP_A_TO_A_SIZE = 3257;
    public static final int GL_UNPACK_SWAP_BYTES = 3312;
    public static final int GL_UNPACK_LSB_FIRST = 3313;
    public static final int GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_SWAP_BYTES = 3328;
    public static final int GL_PACK_LSB_FIRST = 3329;
    public static final int GL_PACK_ROW_LENGTH = 3330;
    public static final int GL_PACK_SKIP_ROWS = 3331;
    public static final int GL_PACK_SKIP_PIXELS = 3332;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAP_COLOR = 3344;
    public static final int GL_MAP_STENCIL = 3345;
    public static final int GL_INDEX_SHIFT = 3346;
    public static final int GL_INDEX_OFFSET = 3347;
    public static final int GL_RED_SCALE = 3348;
    public static final int GL_RED_BIAS = 3349;
    public static final int GL_ZOOM_X = 3350;
    public static final int GL_ZOOM_Y = 3351;
    public static final int GL_GREEN_SCALE = 3352;
    public static final int GL_GREEN_BIAS = 3353;
    public static final int GL_BLUE_SCALE = 3354;
    public static final int GL_BLUE_BIAS = 3355;
    public static final int GL_ALPHA_SCALE = 3356;
    public static final int GL_ALPHA_BIAS = 3357;
    public static final int GL_DEPTH_SCALE = 3358;
    public static final int GL_DEPTH_BIAS = 3359;
    public static final int GL_MAX_EVAL_ORDER = 3376;
    public static final int GL_MAX_LIGHTS = 3377;
    public static final int GL_MAX_CLIP_PLANES = 3378;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_PIXEL_MAP_TABLE = 3380;
    public static final int GL_MAX_ATTRIB_STACK_DEPTH = 3381;
    public static final int GL_MAX_MODELVIEW_STACK_DEPTH = 3382;
    public static final int GL_MAX_NAME_STACK_DEPTH = 3383;
    public static final int GL_MAX_PROJECTION_STACK_DEPTH = 3384;
    public static final int GL_MAX_TEXTURE_STACK_DEPTH = 3385;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 3387;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_INDEX_BITS = 3409;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_ACCUM_RED_BITS = 3416;
    public static final int GL_ACCUM_GREEN_BITS = 3417;
    public static final int GL_ACCUM_BLUE_BITS = 3418;
    public static final int GL_ACCUM_ALPHA_BITS = 3419;
    public static final int GL_NAME_STACK_DEPTH = 3440;
    public static final int GL_AUTO_NORMAL = 3456;
    public static final int GL_MAP1_COLOR_4 = 3472;
    public static final int GL_MAP1_INDEX = 3473;
    public static final int GL_MAP1_NORMAL = 3474;
    public static final int GL_MAP1_TEXTURE_COORD_1 = 3475;
    public static final int GL_MAP1_TEXTURE_COORD_2 = 3476;
    public static final int GL_MAP1_TEXTURE_COORD_3 = 3477;
    public static final int GL_MAP1_TEXTURE_COORD_4 = 3478;
    public static final int GL_MAP1_VERTEX_3 = 3479;
    public static final int GL_MAP1_VERTEX_4 = 3480;
    public static final int GL_MAP2_COLOR_4 = 3504;
    public static final int GL_MAP2_INDEX = 3505;
    public static final int GL_MAP2_NORMAL = 3506;
    public static final int GL_MAP2_TEXTURE_COORD_1 = 3507;
    public static final int GL_MAP2_TEXTURE_COORD_2 = 3508;
    public static final int GL_MAP2_TEXTURE_COORD_3 = 3509;
    public static final int GL_MAP2_TEXTURE_COORD_4 = 3510;
    public static final int GL_MAP2_VERTEX_3 = 3511;
    public static final int GL_MAP2_VERTEX_4 = 3512;
    public static final int GL_MAP1_GRID_DOMAIN = 3536;
    public static final int GL_MAP1_GRID_SEGMENTS = 3537;
    public static final int GL_MAP2_GRID_DOMAIN = 3538;
    public static final int GL_MAP2_GRID_SEGMENTS = 3539;
    public static final int GL_TEXTURE_1D = 3552;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_FEEDBACK_BUFFER_POINTER = 3568;
    public static final int GL_FEEDBACK_BUFFER_SIZE = 3569;
    public static final int GL_FEEDBACK_BUFFER_TYPE = 3570;
    public static final int GL_SELECTION_BUFFER_POINTER = 3571;
    public static final int GL_SELECTION_BUFFER_SIZE = 3572;
    public static final int GL_TEXTURE_WIDTH = 4096;
    public static final int GL_TEXTURE_HEIGHT = 4097;
    public static final int GL_TEXTURE_INTERNAL_FORMAT = 4099;
    public static final int GL_TEXTURE_BORDER_COLOR = 4100;
    public static final int GL_TEXTURE_BORDER = 4101;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_LIGHT0 = 16384;
    public static final int GL_LIGHT1 = 16385;
    public static final int GL_LIGHT2 = 16386;
    public static final int GL_LIGHT3 = 16387;
    public static final int GL_LIGHT4 = 16388;
    public static final int GL_LIGHT5 = 16389;
    public static final int GL_LIGHT6 = 16390;
    public static final int GL_LIGHT7 = 16391;
    public static final int GL_AMBIENT = 4608;
    public static final int GL_DIFFUSE = 4609;
    public static final int GL_SPECULAR = 4610;
    public static final int GL_POSITION = 4611;
    public static final int GL_SPOT_DIRECTION = 4612;
    public static final int GL_SPOT_EXPONENT = 4613;
    public static final int GL_SPOT_CUTOFF = 4614;
    public static final int GL_CONSTANT_ATTENUATION = 4615;
    public static final int GL_LINEAR_ATTENUATION = 4616;
    public static final int GL_QUADRATIC_ATTENUATION = 4617;
    public static final int GL_COMPILE = 4864;
    public static final int GL_COMPILE_AND_EXECUTE = 4865;
    public static final int GL_CLEAR = 5376;
    public static final int GL_AND = 5377;
    public static final int GL_AND_REVERSE = 5378;
    public static final int GL_COPY = 5379;
    public static final int GL_AND_INVERTED = 5380;
    public static final int GL_NOOP = 5381;
    public static final int GL_XOR = 5382;
    public static final int GL_OR = 5383;
    public static final int GL_NOR = 5384;
    public static final int GL_EQUIV = 5385;
    public static final int GL_INVERT = 5386;
    public static final int GL_OR_REVERSE = 5387;
    public static final int GL_COPY_INVERTED = 5388;
    public static final int GL_OR_INVERTED = 5389;
    public static final int GL_NAND = 5390;
    public static final int GL_SET = 5391;
    public static final int GL_EMISSION = 5632;
    public static final int GL_SHININESS = 5633;
    public static final int GL_AMBIENT_AND_DIFFUSE = 5634;
    public static final int GL_COLOR_INDEXES = 5635;
    public static final int GL_MODELVIEW = 5888;
    public static final int GL_PROJECTION = 5889;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_COLOR = 6144;
    public static final int GL_DEPTH = 6145;
    public static final int GL_STENCIL = 6146;
    public static final int GL_COLOR_INDEX = 6400;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_RED = 6403;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_BITMAP = 6656;
    public static final int GL_POINT = 6912;
    public static final int GL_LINE = 6913;
    public static final int GL_FILL = 6914;
    public static final int GL_RENDER = 7168;
    public static final int GL_FEEDBACK = 7169;
    public static final int GL_SELECT = 7170;
    public static final int GL_FLAT = 7424;
    public static final int GL_SMOOTH = 7425;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_S = 8192;
    public static final int GL_T = 8193;
    public static final int GL_R = 8194;
    public static final int GL_Q = 8195;
    public static final int GL_MODULATE = 8448;
    public static final int GL_DECAL = 8449;
    public static final int GL_TEXTURE_ENV_MODE = 8704;
    public static final int GL_TEXTURE_ENV_COLOR = 8705;
    public static final int GL_TEXTURE_ENV = 8960;
    public static final int GL_EYE_LINEAR = 9216;
    public static final int GL_OBJECT_LINEAR = 9217;
    public static final int GL_SPHERE_MAP = 9218;
    public static final int GL_TEXTURE_GEN_MODE = 9472;
    public static final int GL_OBJECT_PLANE = 9473;
    public static final int GL_EYE_PLANE = 9474;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_CLAMP = 10496;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLIENT_PIXEL_STORE_BIT = 1;
    public static final int GL_CLIENT_VERTEX_ARRAY_BIT = 2;
    public static final int GL_ALL_CLIENT_ATTRIB_BITS = -1;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_POINT = 10753;
    public static final int GL_POLYGON_OFFSET_LINE = 10754;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_ALPHA4 = 32827;
    public static final int GL_ALPHA8 = 32828;
    public static final int GL_ALPHA12 = 32829;
    public static final int GL_ALPHA16 = 32830;
    public static final int GL_LUMINANCE4 = 32831;
    public static final int GL_LUMINANCE8 = 32832;
    public static final int GL_LUMINANCE12 = 32833;
    public static final int GL_LUMINANCE16 = 32834;
    public static final int GL_LUMINANCE4_ALPHA4 = 32835;
    public static final int GL_LUMINANCE6_ALPHA2 = 32836;
    public static final int GL_LUMINANCE8_ALPHA8 = 32837;
    public static final int GL_LUMINANCE12_ALPHA4 = 32838;
    public static final int GL_LUMINANCE12_ALPHA12 = 32839;
    public static final int GL_LUMINANCE16_ALPHA16 = 32840;
    public static final int GL_INTENSITY = 32841;
    public static final int GL_INTENSITY4 = 32842;
    public static final int GL_INTENSITY8 = 32843;
    public static final int GL_INTENSITY12 = 32844;
    public static final int GL_INTENSITY16 = 32845;
    public static final int GL_R3_G3_B2 = 10768;
    public static final int GL_RGB4 = 32847;
    public static final int GL_RGB5 = 32848;
    public static final int GL_RGB8 = 32849;
    public static final int GL_RGB10 = 32850;
    public static final int GL_RGB12 = 32851;
    public static final int GL_RGB16 = 32852;
    public static final int GL_RGBA2 = 32853;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_RGB10_A2 = 32857;
    public static final int GL_RGBA12 = 32858;
    public static final int GL_RGBA16 = 32859;
    public static final int GL_TEXTURE_RED_SIZE = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE = 32863;
    public static final int GL_TEXTURE_LUMINANCE_SIZE = 32864;
    public static final int GL_TEXTURE_INTENSITY_SIZE = 32865;
    public static final int GL_PROXY_TEXTURE_1D = 32867;
    public static final int GL_PROXY_TEXTURE_2D = 32868;
    public static final int GL_TEXTURE_PRIORITY = 32870;
    public static final int GL_TEXTURE_RESIDENT = 32871;
    public static final int GL_TEXTURE_BINDING_1D = 32872;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_VERTEX_ARRAY = 32884;
    public static final int GL_NORMAL_ARRAY = 32885;
    public static final int GL_COLOR_ARRAY = 32886;
    public static final int GL_INDEX_ARRAY = 32887;
    public static final int GL_TEXTURE_COORD_ARRAY = 32888;
    public static final int GL_EDGE_FLAG_ARRAY = 32889;
    public static final int GL_VERTEX_ARRAY_SIZE = 32890;
    public static final int GL_VERTEX_ARRAY_TYPE = 32891;
    public static final int GL_VERTEX_ARRAY_STRIDE = 32892;
    public static final int GL_NORMAL_ARRAY_TYPE = 32894;
    public static final int GL_NORMAL_ARRAY_STRIDE = 32895;
    public static final int GL_COLOR_ARRAY_SIZE = 32897;
    public static final int GL_COLOR_ARRAY_TYPE = 32898;
    public static final int GL_COLOR_ARRAY_STRIDE = 32899;
    public static final int GL_INDEX_ARRAY_TYPE = 32901;
    public static final int GL_INDEX_ARRAY_STRIDE = 32902;
    public static final int GL_TEXTURE_COORD_ARRAY_SIZE = 32904;
    public static final int GL_TEXTURE_COORD_ARRAY_TYPE = 32905;
    public static final int GL_TEXTURE_COORD_ARRAY_STRIDE = 32906;
    public static final int GL_EDGE_FLAG_ARRAY_STRIDE = 32908;
    public static final int GL_VERTEX_ARRAY_POINTER = 32910;
    public static final int GL_NORMAL_ARRAY_POINTER = 32911;
    public static final int GL_COLOR_ARRAY_POINTER = 32912;
    public static final int GL_INDEX_ARRAY_POINTER = 32913;
    public static final int GL_TEXTURE_COORD_ARRAY_POINTER = 32914;
    public static final int GL_EDGE_FLAG_ARRAY_POINTER = 32915;
    public static final int GL_V2F = 10784;
    public static final int GL_V3F = 10785;
    public static final int GL_C4UB_V2F = 10786;
    public static final int GL_C4UB_V3F = 10787;
    public static final int GL_C3F_V3F = 10788;
    public static final int GL_N3F_V3F = 10789;
    public static final int GL_C4F_N3F_V3F = 10790;
    public static final int GL_T2F_V3F = 10791;
    public static final int GL_T4F_V4F = 10792;
    public static final int GL_T2F_C4UB_V3F = 10793;
    public static final int GL_T2F_C3F_V3F = 10794;
    public static final int GL_T2F_N3F_V3F = 10795;
    public static final int GL_T2F_C4F_N3F_V3F = 10796;
    public static final int GL_T4F_C4F_N3F_V4F = 10797;
    public static final int GL_LOGIC_OP = 3057;
    public static final int GL_TEXTURE_COMPONENTS = 4099;

    private GL11() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static native void glAccum(int var0, float var1);

    public static native void glAlphaFunc(int var0, float var1);

    public static native void glClearColor(float var0, float var1, float var2, float var3);

    public static native void glClearAccum(float var0, float var1, float var2, float var3);

    public static native void glClear(int var0);

    public static void glCallLists(ByteBuffer lists) {
        BufferChecks.checkDirect(lists);
        GL11.nglCallLists(lists.remaining(), 5121, lists, lists.position());
    }

    public static void glCallLists(ShortBuffer lists) {
        BufferChecks.checkDirect(lists);
        GL11.nglCallLists(lists.remaining(), 5123, lists, lists.position() << 1);
    }

    public static void glCallLists(IntBuffer lists) {
        BufferChecks.checkDirect(lists);
        GL11.nglCallLists(lists.remaining(), 5125, lists, lists.position() << 2);
    }

    private static native void nglCallLists(int var0, int var1, Buffer var2, int var3);

    public static native void glCallList(int var0);

    public static native void glBlendFunc(int var0, int var1);

    public static void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, ByteBuffer bitmap) {
        BufferChecks.checkBuffer(bitmap, (width + 7) / 8 * height);
        GL11.nglBitmap(width, height, xorig, yorig, xmove, ymove, bitmap, bitmap.position());
    }

    private static native void nglBitmap(int var0, int var1, float var2, float var3, float var4, float var5, ByteBuffer var6, int var7);

    public static native void glBindTexture(int var0, int var1);

    public static native void glBegin(int var0);

    public static native void glEnd();

    public static native void glArrayElement(int var0);

    public static native void glClearDepth(double var0);

    public static native void glDeleteLists(int var0, int var1);

    public static void glDeleteTextures(IntBuffer textures) {
        BufferChecks.checkDirect(textures);
        GL11.nglDeleteTextures(textures.remaining(), textures, textures.position());
    }

    private static native void nglDeleteTextures(int var0, IntBuffer var1, int var2);

    public static native void glCullFace(int var0);

    public static native void glCopyTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void glCopyTexSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void glCopyTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void glCopyTexImage1D(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native void glCopyPixels(int var0, int var1, int var2, int var3, int var4);

    public static void glColorPointer(int size, boolean unsigned, int stride, ByteBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglColorPointer(size, unsigned ? 5121 : 5120, stride, pointer, pointer.position());
    }

    public static void glColorPointer(int size, int stride, FloatBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglColorPointer(size, 5126, stride, pointer, pointer.position() << 2);
    }

    private static native void nglColorPointer(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glColorPointer(int size, int type, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglColorPointerVBO(size, type, stride, buffer_offset);
    }

    private static native void nglColorPointerVBO(int var0, int var1, int var2, int var3);

    public static native void glColorMaterial(int var0, int var1);

    public static native void glColorMask(boolean var0, boolean var1, boolean var2, boolean var3);

    public static native void glColor3b(byte var0, byte var1, byte var2);

    public static native void glColor3f(float var0, float var1, float var2);

    public static native void glColor3ub(byte var0, byte var1, byte var2);

    public static native void glColor4b(byte var0, byte var1, byte var2, byte var3);

    public static native void glColor4f(float var0, float var1, float var2, float var3);

    public static native void glColor4ub(byte var0, byte var1, byte var2, byte var3);

    public static void glClipPlane(int plane, DoubleBuffer equation) {
        BufferChecks.checkBuffer(equation, 4);
        GL11.nglClipPlane(plane, equation, equation.position() << 3);
    }

    private static native void nglClipPlane(int var0, DoubleBuffer var1, int var2);

    public static native void glClearStencil(int var0);

    public static native void glClearIndex(float var0);

    public static native void glEvalPoint1(int var0);

    public static native void glEvalPoint2(int var0, int var1);

    public static native void glEvalMesh1(int var0, int var1, int var2);

    public static native void glEvalMesh2(int var0, int var1, int var2, int var3, int var4);

    public static native void glEvalCoord1f(float var0);

    public static native void glEvalCoord2f(float var0, float var1);

    public static native void glEnableClientState(int var0);

    public static native void glDisableClientState(int var0);

    public static native void glEnable(int var0);

    public static native void glDisable(int var0);

    public static void glEdgeFlagPointer(int stride, ByteBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglEdgeFlagPointer(stride, pointer, pointer.position());
    }

    private static native void nglEdgeFlagPointer(int var0, Buffer var1, int var2);

    public static void glEdgeFlagPointer(int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglEdgeFlagPointerVBO(stride, buffer_offset);
    }

    private static native void nglEdgeFlagPointerVBO(int var0, int var1);

    public static native void glEdgeFlag(boolean var0);

    public static void glDrawPixels(int width, int height, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1));
        GL11.nglDrawPixels(width, height, format, type, pixels, pixels.position());
    }

    public static void glDrawPixels(int width, int height, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 1);
        GL11.nglDrawPixels(width, height, format, type, pixels, pixels.position() << 1);
    }

    public static void glDrawPixels(int width, int height, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 2);
        GL11.nglDrawPixels(width, height, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglDrawPixels(int var0, int var1, int var2, int var3, Buffer var4, int var5);

    public static void glDrawElements(int mode, ByteBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL11.nglDrawElements(mode, indices.remaining(), 5121, indices, indices.position());
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL11.nglDrawElements(mode, indices.remaining(), 5123, indices, indices.position() << 1);
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL11.nglDrawElements(mode, indices.remaining(), 5125, indices, indices.position() << 2);
    }

    private static native void nglDrawElements(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glDrawElements(int mode, int count, int type, int buffer_offset) {
        GLBufferChecks.ensureElementVBOenabled();
        GL11.nglDrawElementsVBO(mode, count, type, buffer_offset);
    }

    private static native void nglDrawElementsVBO(int var0, int var1, int var2, int var3);

    public static native void glDrawBuffer(int var0);

    public static native void glDrawArrays(int var0, int var1, int var2);

    public static native void glDepthRange(double var0, double var2);

    public static native void glDepthMask(boolean var0);

    public static native void glDepthFunc(int var0);

    public static void glFeedbackBuffer(int type, FloatBuffer buffer) {
        BufferChecks.checkDirect(buffer);
        GL11.nglFeedbackBuffer(buffer.remaining(), type, buffer, buffer.position());
    }

    private static native void nglFeedbackBuffer(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetPixelMap(int map, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        GL11.nglGetPixelMapfv(map, values, values.position());
    }

    private static native void nglGetPixelMapfv(int var0, FloatBuffer var1, int var2);

    public static void glGetPixelMap(int map, IntBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        GL11.nglGetPixelMapuiv(map, values, values.position());
    }

    private static native void nglGetPixelMapuiv(int var0, IntBuffer var1, int var2);

    public static void glGetPixelMap(int map, ShortBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        GL11.nglGetPixelMapusv(map, values, values.position());
    }

    private static native void nglGetPixelMapusv(int var0, ShortBuffer var1, int var2);

    public static void glGetMaterial(int face, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetMaterialfv(face, pname, params, params.position());
    }

    private static native void nglGetMaterialfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetMaterial(int face, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetMaterialiv(face, pname, params, params.position());
    }

    private static native void nglGetMaterialiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetMap(int target, int query, FloatBuffer v) {
        BufferChecks.checkBuffer(v, 256);
        GL11.nglGetMapfv(target, query, v, v.position());
    }

    public static void glGetMap(int target, int query, IntBuffer v) {
        BufferChecks.checkBuffer(v, 256);
        GL11.nglGetMapiv(target, query, v, v.position());
    }

    private static native void nglGetMapfv(int var0, int var1, FloatBuffer var2, int var3);

    private static native void nglGetMapiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetLight(int light, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetLightfv(light, pname, params, params.position());
    }

    private static native void nglGetLightfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetLight(int light, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetLightiv(light, pname, params, params.position());
    }

    private static native void nglGetLightiv(int var0, int var1, IntBuffer var2, int var3);

    public static native int glGetError();

    public static void glGetClipPlane(int plane, DoubleBuffer equation) {
        BufferChecks.checkBuffer(equation);
        GL11.nglGetClipPlane(plane, equation, equation.position());
    }

    private static native void nglGetClipPlane(int var0, DoubleBuffer var1, int var2);

    public static void glGetBoolean(int pname, ByteBuffer params) {
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetBooleanv(pname, params, params.position());
    }

    private static native void nglGetBooleanv(int var0, ByteBuffer var1, int var2);

    public static void glGetDouble(int pname, DoubleBuffer params) {
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetDoublev(pname, params, params.position());
    }

    private static native void nglGetDoublev(int var0, DoubleBuffer var1, int var2);

    public static void glGetFloat(int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetFloatv(pname, params, params.position());
    }

    private static native void nglGetFloatv(int var0, FloatBuffer var1, int var2);

    public static void glGetInteger(int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetIntegerv(pname, params, params.position());
    }

    private static native void nglGetIntegerv(int var0, IntBuffer var1, int var2);

    public static void glGenTextures(IntBuffer textures) {
        BufferChecks.checkDirect(textures);
        GL11.nglGenTextures(textures.remaining(), textures, textures.position());
    }

    private static native void nglGenTextures(int var0, IntBuffer var1, int var2);

    public static native int glGenLists(int var0);

    public static native void glFrustum(double var0, double var2, double var4, double var6, double var8, double var10);

    public static native void glFrontFace(int var0);

    public static native void glFogf(int var0, float var1);

    public static native void glFogi(int var0, int var1);

    public static void glFog(int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglFogfv(pname, params, params.position());
    }

    private static native void nglFogfv(int var0, FloatBuffer var1, int var2);

    public static void glFog(int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglFogiv(pname, params, params.position());
    }

    private static native void nglFogiv(int var0, IntBuffer var1, int var2);

    public static native void glFlush();

    public static native void glFinish();

    public static native ByteBuffer glGetPointerv(int var0, int var1);

    public static native boolean glIsEnabled(int var0);

    public static void glInterleavedArrays(int format, int stride, ByteBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglInterleavedArrays(format, stride, pointer, pointer.position());
    }

    public static void glInterleavedArrays(int format, int stride, ShortBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglInterleavedArrays(format, stride, pointer, pointer.position() << 1);
    }

    public static void glInterleavedArrays(int format, int stride, IntBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglInterleavedArrays(format, stride, pointer, pointer.position() << 2);
    }

    public static void glInterleavedArrays(int format, int stride, FloatBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglInterleavedArrays(format, stride, pointer, pointer.position() << 2);
    }

    private static native void nglInterleavedArrays(int var0, int var1, Buffer var2, int var3);

    public static void glInterleavedArrays(int format, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglInterleavedArraysVBO(format, stride, buffer_offset);
    }

    private static native void nglInterleavedArraysVBO(int var0, int var1, int var2);

    public static native void glInitNames();

    public static native void glHint(int var0, int var1);

    public static void glGetTexParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexParameterfv(target, pname, params, params.position());
    }

    private static native void nglGetTexParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetTexParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetTexParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetTexLevelParameter(int target, int level, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexLevelParameterfv(target, level, pname, params, params.position());
    }

    private static native void nglGetTexLevelParameterfv(int var0, int var1, int var2, FloatBuffer var3, int var4);

    public static void glGetTexLevelParameter(int target, int level, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexLevelParameteriv(target, level, pname, params, params.position());
    }

    private static native void nglGetTexLevelParameteriv(int var0, int var1, int var2, IntBuffer var3, int var4);

    public static void glGetTexImage(int target, int level, int format, int type, ByteBuffer pixels) {
        int width = 1;
        int height = 1;
        int depth = 1;
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth));
        GL11.nglGetTexImage(target, level, format, type, pixels, pixels.position());
    }

    public static void glGetTexImage(int target, int level, int format, int type, ShortBuffer pixels) {
        int width = 1;
        int height = 1;
        int depth = 1;
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth) >> 1);
        GL11.nglGetTexImage(target, level, format, type, pixels, pixels.position() << 1);
    }

    public static void glGetTexImage(int target, int level, int format, int type, IntBuffer pixels) {
        int width = 1;
        int height = 1;
        int depth = 1;
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth) >> 2);
        GL11.nglGetTexImage(target, level, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglGetTexImage(int var0, int var1, int var2, int var3, Buffer var4, int var5);

    public static void glGetTexGen(int coord, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexGeniv(coord, pname, params, params.position());
    }

    private static native void nglGetTexGeniv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetTexGen(int coord, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexGenfv(coord, pname, params, params.position());
    }

    private static native void nglGetTexGenfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetTexEnv(int coord, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexEnviv(coord, pname, params, params.position());
    }

    private static native void nglGetTexEnviv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetTexEnv(int coord, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglGetTexEnvfv(coord, pname, params, params.position());
    }

    private static native void nglGetTexEnvfv(int var0, int var1, FloatBuffer var2, int var3);

    public static native String glGetString(int var0);

    public static void glGetPolygonStipple(ByteBuffer mask) {
        BufferChecks.checkBuffer(mask, 1024);
        GL11.nglGetPolygonStipple(mask, mask.position());
    }

    private static native void nglGetPolygonStipple(ByteBuffer var0, int var1);

    public static native boolean glIsList(int var0);

    public static native void glMaterialf(int var0, int var1, float var2);

    public static native void glMateriali(int var0, int var1, int var2);

    public static void glMaterial(int face, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglMaterialfv(face, pname, params, params.position());
    }

    private static native void nglMaterialfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glMaterial(int face, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglMaterialiv(face, pname, params, params.position());
    }

    private static native void nglMaterialiv(int var0, int var1, IntBuffer var2, int var3);

    public static native void glMapGrid1f(int var0, float var1, float var2);

    public static native void glMapGrid2f(int var0, float var1, float var2, int var3, float var4, float var5);

    public static void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, FloatBuffer points) {
        BufferChecks.checkDirect(points);
        GL11.nglMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points, points.position());
    }

    private static native void nglMap2f(int var0, float var1, float var2, int var3, int var4, float var5, float var6, int var7, int var8, FloatBuffer var9, int var10);

    public static void glMap1f(int target, float u1, float u2, int stride, int order, FloatBuffer points) {
        BufferChecks.checkDirect(points);
        GL11.nglMap1f(target, u1, u2, stride, order, points, points.position());
    }

    private static native void nglMap1f(int var0, float var1, float var2, int var3, int var4, FloatBuffer var5, int var6);

    public static native void glLogicOp(int var0);

    public static native void glLoadName(int var0);

    public static void glLoadMatrix(FloatBuffer m) {
        BufferChecks.checkBuffer(m, 16);
        GL11.nglLoadMatrixf(m, m.position());
    }

    private static native void nglLoadMatrixf(FloatBuffer var0, int var1);

    public static native void glLoadIdentity();

    public static native void glListBase(int var0);

    public static native void glLineWidth(float var0);

    public static native void glLineStipple(int var0, short var1);

    public static native void glLightModelf(int var0, float var1);

    public static native void glLightModeli(int var0, int var1);

    public static void glLightModel(int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglLightModelfv(pname, params, params.position());
    }

    private static native void nglLightModelfv(int var0, FloatBuffer var1, int var2);

    public static void glLightModel(int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglLightModeliv(pname, params, params.position());
    }

    private static native void nglLightModeliv(int var0, IntBuffer var1, int var2);

    public static native void glLightf(int var0, int var1, float var2);

    public static native void glLighti(int var0, int var1, int var2);

    public static void glLight(int light, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglLightfv(light, pname, params, params.position());
    }

    private static native void nglLightfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glLight(int light, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglLightiv(light, pname, params, params.position());
    }

    private static native void nglLightiv(int var0, int var1, IntBuffer var2, int var3);

    public static native boolean glIsTexture(int var0);

    public static native void glMatrixMode(int var0);

    public static void glPolygonStipple(ByteBuffer mask) {
        BufferChecks.checkBuffer(mask, 1024);
        GL11.nglPolygonStipple(mask, mask.position());
    }

    private static native void nglPolygonStipple(ByteBuffer var0, int var1);

    public static native void glPolygonOffset(float var0, float var1);

    public static native void glPolygonMode(int var0, int var1);

    public static native void glPointSize(float var0);

    public static native void glPixelZoom(float var0, float var1);

    public static native void glPixelTransferf(int var0, float var1);

    public static native void glPixelTransferi(int var0, int var1);

    public static native void glPixelStoref(int var0, float var1);

    public static native void glPixelStorei(int var0, int var1);

    public static void glPixelMap(int map, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        GL11.nglPixelMapfv(map, values.remaining(), values, values.position());
    }

    private static native void nglPixelMapfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glPixelMap(int map, IntBuffer values) {
        BufferChecks.checkDirect(values);
        GL11.nglPixelMapuiv(map, values.remaining(), values, values.position());
    }

    private static native void nglPixelMapuiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glPixelMap(int map, ShortBuffer values) {
        BufferChecks.checkDirect(values);
        GL11.nglPixelMapusv(map, values.remaining(), values, values.position());
    }

    private static native void nglPixelMapusv(int var0, int var1, ShortBuffer var2, int var3);

    public static native void glPassThrough(float var0);

    public static native void glOrtho(double var0, double var2, double var4, double var6, double var8, double var10);

    public static void glNormalPointer(int stride, ByteBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglNormalPointer(5120, stride, pointer, pointer.position());
    }

    public static void glNormalPointer(int stride, IntBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglNormalPointer(5124, stride, pointer, pointer.position() << 2);
    }

    public static void glNormalPointer(int stride, FloatBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglNormalPointer(5126, stride, pointer, pointer.position() << 2);
    }

    private static native void nglNormalPointer(int var0, int var1, Buffer var2, int var3);

    public static void glNormalPointer(int type, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglNormalPointerVBO(type, stride, buffer_offset);
    }

    private static native void nglNormalPointerVBO(int var0, int var1, int var2);

    public static native void glNormal3b(byte var0, byte var1, byte var2);

    public static native void glNormal3f(float var0, float var1, float var2);

    public static native void glNormal3i(int var0, int var1, int var2);

    public static native void glNewList(int var0, int var1);

    public static native void glEndList();

    public static void glMultMatrix(FloatBuffer m) {
        BufferChecks.checkBuffer(m, 16);
        GL11.nglMultMatrixf(m, m.position());
    }

    private static native void nglMultMatrixf(FloatBuffer var0, int var1);

    public static native void glShadeModel(int var0);

    public static void glSelectBuffer(IntBuffer buffer) {
        BufferChecks.checkDirect(buffer);
        GL11.nglSelectBuffer(buffer.remaining(), buffer, buffer.position());
    }

    private static native void nglSelectBuffer(int var0, IntBuffer var1, int var2);

    public static native void glScissor(int var0, int var1, int var2, int var3);

    public static native void glScalef(float var0, float var1, float var2);

    public static native void glRotatef(float var0, float var1, float var2, float var3);

    public static native int glRenderMode(int var0);

    public static native void glRectf(float var0, float var1, float var2, float var3);

    public static native void glRecti(int var0, int var1, int var2, int var3);

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1));
        GL11.nglReadPixels(x, y, width, height, format, type, pixels, pixels.position());
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 1);
        GL11.nglReadPixels(x, y, width, height, format, type, pixels, pixels.position() << 1);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 2);
        GL11.nglReadPixels(x, y, width, height, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglReadPixels(int var0, int var1, int var2, int var3, int var4, int var5, Buffer var6, int var7);

    public static native void glReadBuffer(int var0);

    public static native void glRasterPos2f(float var0, float var1);

    public static native void glRasterPos2i(int var0, int var1);

    public static native void glRasterPos3f(float var0, float var1, float var2);

    public static native void glRasterPos3i(int var0, int var1, int var2);

    public static native void glRasterPos4f(float var0, float var1, float var2, float var3);

    public static native void glRasterPos4i(int var0, int var1, int var2, int var3);

    public static native void glPushName(int var0);

    public static native void glPopName();

    public static native void glPushMatrix();

    public static native void glPopMatrix();

    public static void glPushClientAttrib(int mask) {
        VBOTracker.getClientAttribStack().pushState();
        VBOTracker.getClientAttribStack().setState(mask);
        if ((mask & 2) != 0) {
            VBOTracker.getVBOArrayStack().pushState();
            VBOTracker.getVBOElementStack().pushState();
        }
        GL11.nglPushClientAttrib(mask);
    }

    private static native void nglPushClientAttrib(int var0);

    public static void glPopClientAttrib() {
        if ((VBOTracker.getClientAttribStack().popState() & 2) != 0) {
            VBOTracker.getVBOArrayStack().popState();
            VBOTracker.getVBOElementStack().popState();
        }
        GL11.nglPopClientAttrib();
    }

    private static native void nglPopClientAttrib();

    public static native void glPushAttrib(int var0);

    public static native void glPopAttrib();

    public static native void glStencilFunc(int var0, int var1, int var2);

    public static void glVertexPointer(int size, int stride, FloatBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglVertexPointer(size, 5126, stride, pointer, pointer.position() << 2);
    }

    public static void glVertexPointer(int size, int stride, IntBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglVertexPointer(size, 5124, stride, pointer, pointer.position() << 2);
    }

    private static native void nglVertexPointer(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glVertexPointer(int size, int type, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglVertexPointerVBO(size, type, stride, buffer_offset);
    }

    private static native void nglVertexPointerVBO(int var0, int var1, int var2, int var3);

    public static native void glVertex2f(float var0, float var1);

    public static native void glVertex2i(int var0, int var1);

    public static native void glVertex3f(float var0, float var1, float var2);

    public static native void glVertex3i(int var0, int var1, int var2);

    public static native void glVertex4f(float var0, float var1, float var2, float var3);

    public static native void glVertex4i(int var0, int var1, int var2, int var3);

    public static native void glTranslatef(float var0, float var1, float var2);

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, ByteBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage1DStorage(format, type, width, border));
        }
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, pixels, pixels != null ? pixels.position() : 0);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, ShortBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage1DStorage(format, type, width, border) >> 1);
        }
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, pixels, pixels != null ? pixels.position() << 1 : 0);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, IntBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage1DStorage(format, type, width, border) >> 2);
        }
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    public static void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, FloatBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage1DStorage(format, type, width, border) >> 2);
        }
        GL11.nglTexImage1D(target, level, internalformat, width, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    private static native void nglTexImage1D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7, int var8);

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage2DStorage(format, type, width, height, border));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels, pixels != null ? pixels.position() : 0);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage2DStorage(format, type, width, height, border) >> 1);
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels, pixels != null ? pixels.position() << 1 : 0);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage2DStorage(format, type, width, height, border) >> 2);
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage2DStorage(format, type, width, height, border) >> 2);
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    private static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8, int var9);

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1));
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, pixels, pixels.position());
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 1);
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, pixels, pixels.position() << 1);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 2);
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, pixels, pixels.position() << 2);
    }

    public static void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 2);
        GL11.nglTexSubImage1D(target, level, xoffset, width, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglTexSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, Buffer var6, int var7);

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1));
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels, pixels.position());
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 1);
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels, pixels.position() << 1);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 2);
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels, pixels.position() << 2);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 2);
        GL11.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8, int var9);

    public static native void glTexParameterf(int var0, int var1, float var2);

    public static native void glTexParameteri(int var0, int var1, int var2);

    public static void glTexParameter(int target, int pname, FloatBuffer param) {
        BufferChecks.checkBuffer(param);
        GL11.nglTexParameterfv(target, pname, param, param.position());
    }

    private static native void nglTexParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glTexParameter(int target, int pname, IntBuffer param) {
        BufferChecks.checkBuffer(param);
        GL11.nglTexParameteriv(target, pname, param, param.position());
    }

    private static native void nglTexParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static native void glTexGenf(int var0, int var1, float var2);

    public static void glTexGen(int coord, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglTexGenfv(coord, pname, params, params.position());
    }

    private static native void nglTexGenfv(int var0, int var1, FloatBuffer var2, int var3);

    public static native void glTexGeni(int var0, int var1, int var2);

    public static void glTexGen(int coord, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglTexGeniv(coord, pname, params, params.position());
    }

    private static native void nglTexGeniv(int var0, int var1, IntBuffer var2, int var3);

    public static native void glTexEnvf(int var0, int var1, float var2);

    public static native void glTexEnvi(int var0, int var1, int var2);

    public static void glTexEnv(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglTexEnvfv(target, pname, params, params.position());
    }

    private static native void nglTexEnvfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glTexEnv(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL11.nglTexEnviv(target, pname, params, params.position());
    }

    private static native void nglTexEnviv(int var0, int var1, IntBuffer var2, int var3);

    public static void glTexCoordPointer(int size, int stride, FloatBuffer pointer) {
        BufferChecks.checkDirect(pointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        GL11.nglTexCoordPointer(size, 5126, stride, pointer, pointer.position() << 2);
    }

    private static native void nglTexCoordPointer(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glTexCoordPointer(int size, int type, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        GL11.nglTexCoordPointerVBO(size, type, stride, buffer_offset);
    }

    private static native void nglTexCoordPointerVBO(int var0, int var1, int var2, int var3);

    public static native void glTexCoord1f(float var0);

    public static native void glTexCoord2f(float var0, float var1);

    public static native void glTexCoord3f(float var0, float var1, float var2);

    public static native void glTexCoord4f(float var0, float var1, float var2, float var3);

    public static native void glStencilOp(int var0, int var1, int var2);

    public static native void glStencilMask(int var0);

    public static native void glViewport(int var0, int var1, int var2, int var3);
}

