/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;

public final class ATIVertexArrayObject {
    public static final int GL_STATIC_ATI = 34656;
    public static final int GL_DYNAMIC_ATI = 34657;
    public static final int GL_PRESERVE_ATI = 34658;
    public static final int GL_DISCARD_ATI = 34659;
    public static final int GL_OBJECT_BUFFER_SIZE_ATI = 34660;
    public static final int GL_OBJECT_BUFFER_USAGE_ATI = 34661;
    public static final int GL_ARRAY_OBJECT_BUFFER_ATI = 34662;
    public static final int GL_ARRAY_OBJECT_OFFSET_ATI = 34663;

    private ATIVertexArrayObject() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static int glNewObjectBufferATI(int size, ByteBuffer pPointer, int usage) {
        BufferChecks.checkDirectOrNull(pPointer);
        return ATIVertexArrayObject.nglNewObjectBufferATI(pPointer != null ? pPointer.remaining() : size, pPointer, pPointer != null ? pPointer.position() : 0, usage);
    }

    public static int glNewObjectBufferATI(int size, ShortBuffer pPointer, int usage) {
        BufferChecks.checkDirectOrNull(pPointer);
        return ATIVertexArrayObject.nglNewObjectBufferATI(pPointer != null ? pPointer.remaining() << 1 : size, pPointer, pPointer != null ? pPointer.position() << 1 : 0, usage);
    }

    public static int glNewObjectBufferATI(int size, FloatBuffer pPointer, int usage) {
        BufferChecks.checkDirectOrNull(pPointer);
        return ATIVertexArrayObject.nglNewObjectBufferATI(pPointer != null ? pPointer.remaining() << 2 : size, pPointer, pPointer != null ? pPointer.position() << 2 : 0, usage);
    }

    public static int glNewObjectBufferATI(int size, IntBuffer pPointer, int usage) {
        BufferChecks.checkDirectOrNull(pPointer);
        return ATIVertexArrayObject.nglNewObjectBufferATI(pPointer != null ? pPointer.remaining() << 2 : size, pPointer, pPointer != null ? pPointer.position() << 2 : 0, usage);
    }

    private static native int nglNewObjectBufferATI(int var0, Buffer var1, int var2, int var3);

    public static native boolean glIsObjectBufferATI(int var0);

    public static void glUpdateObjectBufferATI(int buffer, int offset, ByteBuffer pPointer, int preserve) {
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining(), pPointer, pPointer.position(), preserve);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, ShortBuffer pPointer, int preserve) {
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 1, pPointer, pPointer.position() << 1, preserve);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, FloatBuffer pPointer, int preserve) {
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 2, pPointer, pPointer.position() << 2, preserve);
    }

    public static void glUpdateObjectBufferATI(int buffer, int offset, IntBuffer pPointer, int preserve) {
        BufferChecks.checkDirect(pPointer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(buffer, offset, pPointer.remaining() << 2, pPointer, pPointer.position() << 2, preserve);
    }

    private static native void nglUpdateObjectBufferATI(int var0, int var1, int var2, Buffer var3, int var4, int var5);

    public static void glGetObjectBufferATI(int buffer, int pname, FloatBuffer pfParams) {
        BufferChecks.checkDirect(pfParams);
        ATIVertexArrayObject.nglGetObjectBufferfvATI(buffer, pname, pfParams, pfParams.position());
    }

    private static native void nglGetObjectBufferfvATI(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetObjectBufferATI(int buffer, int pname, IntBuffer piParams) {
        BufferChecks.checkDirect(piParams);
        ATIVertexArrayObject.nglGetObjectBufferivATI(buffer, pname, piParams, piParams.position());
    }

    private static native void nglGetObjectBufferivATI(int var0, int var1, IntBuffer var2, int var3);

    public static native void glFreeObjectBufferATI(int var0);

    public static native void glArrayObjectATI(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glGetArrayObjectATI(int array, int pname, FloatBuffer pfParams) {
        BufferChecks.checkBuffer(pfParams);
        ATIVertexArrayObject.nglGetArrayObjectfvATI(array, pname, pfParams, pfParams.position());
    }

    private static native void nglGetArrayObjectfvATI(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetArrayObjectATI(int array, int pname, IntBuffer piParams) {
        BufferChecks.checkBuffer(piParams);
        ATIVertexArrayObject.nglGetArrayObjectivATI(array, pname, piParams, piParams.position());
    }

    private static native void nglGetArrayObjectivATI(int var0, int var1, IntBuffer var2, int var3);

    public static native void glVariantArrayObjectATI(int var0, int var1, int var2, int var3, int var4);

    public static void glGetVariantArrayObjectATI(int id, int pname, FloatBuffer pfParams) {
        BufferChecks.checkBuffer(pfParams);
        ATIVertexArrayObject.nglGetVariantArrayObjectfvATI(id, pname, pfParams, pfParams.position());
    }

    private static native void nglGetVariantArrayObjectfvATI(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetVariantArrayObjectATI(int id, int pname, IntBuffer piParams) {
        BufferChecks.checkBuffer(piParams);
        ATIVertexArrayObject.nglGetVariantArrayObjectivATI(id, pname, piParams, piParams.position());
    }

    private static native void nglGetVariantArrayObjectivATI(int var0, int var1, IntBuffer var2, int var3);
}

