/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;

public final class ARBMatrixPalette {
    public static final int GL_MATRIX_PALETTE_ARB = 34880;
    public static final int GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 34881;
    public static final int GL_MAX_PALETTE_MATRICES_ARB = 34882;
    public static final int GL_CURRENT_PALETTE_MATRIX_ARB = 34883;
    public static final int GL_MATRIX_INDEX_ARRAY_ARB = 34884;
    public static final int GL_CURRENT_MATRIX_INDEX_ARB = 34885;
    public static final int GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 34886;
    public static final int GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 34887;
    public static final int GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 34888;
    public static final int GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 34889;

    private ARBMatrixPalette() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static native void glCurrentPaletteMatrixARB(int var0);

    public static void glMatrixIndexPointerARB(int size, int stride, ByteBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5121, stride, pPointer, pPointer.position());
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ShortBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5123, stride, pPointer, pPointer.position() << 1);
    }

    public static void glMatrixIndexPointerARB(int size, int stride, IntBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5125, stride, pPointer, pPointer.position() << 2);
    }

    private static native void nglMatrixIndexPointerARB(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glMatrixIndexPointerARB(int size, int type, int stride, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        ARBMatrixPalette.nglMatrixIndexPointerARBVBO(size, type, stride, buffer_offset);
    }

    private static native void nglMatrixIndexPointerARBVBO(int var0, int var1, int var2, int var3);

    public static void glMatrixIndexuARB(ByteBuffer pIndices) {
        BufferChecks.checkDirect(pIndices);
        ARBMatrixPalette.nglMatrixIndexubvARB(pIndices.remaining(), pIndices, pIndices.position());
    }

    private static native void nglMatrixIndexubvARB(int var0, ByteBuffer var1, int var2);

    public static void glMatrixIndexuARB(IntBuffer piIndices) {
        BufferChecks.checkDirect(piIndices);
        ARBMatrixPalette.nglMatrixIndexuivARB(piIndices.remaining(), piIndices, piIndices.position());
    }

    private static native void nglMatrixIndexuivARB(int var0, IntBuffer var1, int var2);

    public static void glMatrixIndexuARB(ShortBuffer psIndices) {
        BufferChecks.checkDirect(psIndices);
        ARBMatrixPalette.nglMatrixIndexusvARB(psIndices.remaining(), psIndices, psIndices.position());
    }

    private static native void nglMatrixIndexusvARB(int var0, ShortBuffer var1, int var2);
}

