/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;

public final class ARBImaging {
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_COLOR_MATRIX = 32945;
    public static final int GL_COLOR_MATRIX_STACK_DEPTH = 32946;
    public static final int GL_MAX_COLOR_MATRIX_STACK_DEPTH = 32947;
    public static final int GL_POST_COLOR_MATRIX_RED_SCALE = 32948;
    public static final int GL_POST_COLOR_MATRIX_GREEN_SCALE = 32949;
    public static final int GL_POST_COLOR_MATRIX_BLUE_SCALE = 32950;
    public static final int GL_POST_COLOR_MATRIX_ALPHA_SCALE = 32951;
    public static final int GL_POST_COLOR_MATRIX_RED_BIAS = 32952;
    public static final int GL_POST_COLOR_MATRIX_GREEN_BIAS = 32953;
    public static final int GL_POST_COLOR_MATRIX_BLUE_BIAS = 32954;
    public static final int GL_POST_COLOR_MATRIX_ALPHA_BIAS = 32955;
    public static final int GL_COLOR_TABLE = 32976;
    public static final int GL_POST_CONVOLUTION_COLOR_TABLE = 32977;
    public static final int GL_POST_COLOR_MATRIX_COLOR_TABLE = 32978;
    public static final int GL_PROXY_COLOR_TABLE = 32979;
    public static final int GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 32980;
    public static final int GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 32981;
    public static final int GL_COLOR_TABLE_SCALE = 32982;
    public static final int GL_COLOR_TABLE_BIAS = 32983;
    public static final int GL_COLOR_TABLE_FORMAT = 32984;
    public static final int GL_COLOR_TABLE_WIDTH = 32985;
    public static final int GL_COLOR_TABLE_RED_SIZE = 32986;
    public static final int GL_COLOR_TABLE_GREEN_SIZE = 32987;
    public static final int GL_COLOR_TABLE_BLUE_SIZE = 32988;
    public static final int GL_COLOR_TABLE_ALPHA_SIZE = 32989;
    public static final int GL_COLOR_TABLE_LUMINANCE_SIZE = 32990;
    public static final int GL_COLOR_TABLE_INTENSITY_SIZE = 32991;
    public static final int GL_CONVOLUTION_1D = 32784;
    public static final int GL_CONVOLUTION_2D = 32785;
    public static final int GL_SEPARABLE_2D = 32786;
    public static final int GL_CONVOLUTION_BORDER_MODE = 32787;
    public static final int GL_CONVOLUTION_FILTER_SCALE = 32788;
    public static final int GL_CONVOLUTION_FILTER_BIAS = 32789;
    public static final int GL_REDUCE = 32790;
    public static final int GL_CONVOLUTION_FORMAT = 32791;
    public static final int GL_CONVOLUTION_WIDTH = 32792;
    public static final int GL_CONVOLUTION_HEIGHT = 32793;
    public static final int GL_MAX_CONVOLUTION_WIDTH = 32794;
    public static final int GL_MAX_CONVOLUTION_HEIGHT = 32795;
    public static final int GL_POST_CONVOLUTION_RED_SCALE = 32796;
    public static final int GL_POST_CONVOLUTION_GREEN_SCALE = 32797;
    public static final int GL_POST_CONVOLUTION_BLUE_SCALE = 32798;
    public static final int GL_POST_CONVOLUTION_ALPHA_SCALE = 32799;
    public static final int GL_POST_CONVOLUTION_RED_BIAS = 32800;
    public static final int GL_POST_CONVOLUTION_GREEN_BIAS = 32801;
    public static final int GL_POST_CONVOLUTION_BLUE_BIAS = 32802;
    public static final int GL_POST_CONVOLUTION_ALPHA_BIAS = 32803;
    public static final int GL_IGNORE_BORDER = 33104;
    public static final int GL_CONSTANT_BORDER = 33105;
    public static final int GL_REPLICATE_BORDER = 33107;
    public static final int GL_CONVOLUTION_BORDER_COLOR = 33108;
    public static final int GL_HISTOGRAM = 32804;
    public static final int GL_PROXY_HISTOGRAM = 32805;
    public static final int GL_HISTOGRAM_WIDTH = 32806;
    public static final int GL_HISTOGRAM_FORMAT = 32807;
    public static final int GL_HISTOGRAM_RED_SIZE = 32808;
    public static final int GL_HISTOGRAM_GREEN_SIZE = 32809;
    public static final int GL_HISTOGRAM_BLUE_SIZE = 32810;
    public static final int GL_HISTOGRAM_ALPHA_SIZE = 32811;
    public static final int GL_HISTOGRAM_LUMINANCE_SIZE = 32812;
    public static final int GL_HISTOGRAM_SINK = 32813;
    public static final int GL_MINMAX = 32814;
    public static final int GL_MINMAX_FORMAT = 32815;
    public static final int GL_MINMAX_SINK = 32816;

    private ARBImaging() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glColorTable(int target, int internalFormat, int width, int format, int type, ByteBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglColorTable(target, internalFormat, width, format, type, data, data.position());
    }

    public static void glColorTable(int target, int internalFormat, int width, int format, int type, FloatBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglColorTable(target, internalFormat, width, format, type, data, data.position() << 2);
    }

    private static native void nglColorTable(int var0, int var1, int var2, int var3, int var4, Buffer var5, int var6);

    public static void glColorSubTable(int target, int start, int count, int format, int type, ByteBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglColorSubTable(target, start, count, format, type, data, data.position());
    }

    public static void glColorSubTable(int target, int start, int count, int format, int type, FloatBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglColorSubTable(target, start, count, format, type, data, data.position() << 2);
    }

    private static native void nglColorSubTable(int var0, int var1, int var2, int var3, int var4, Buffer var5, int var6);

    public static void glColorTableParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglColorTableParameteriv(target, pname, params, params.position());
    }

    private static native void nglColorTableParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static void glColorTableParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglColorTableParameterfv(target, pname, params, params.position());
    }

    private static native void nglColorTableParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static native void glCopyColorSubTable(int var0, int var1, int var2, int var3, int var4);

    public static native void glCopyColorTable(int var0, int var1, int var2, int var3, int var4);

    public static void glGetColorTable(int target, int format, int type, ByteBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglGetColorTable(target, format, type, data, data.position());
    }

    public static void glGetColorTable(int target, int format, int type, FloatBuffer data) {
        BufferChecks.checkBuffer(data, 256);
        ARBImaging.nglGetColorTable(target, format, type, data, data.position());
    }

    private static native void nglGetColorTable(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glGetColorTableParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetColorTableParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetColorTableParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetColorTableParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetColorTableParameterfv(target, pname, params, params.position());
    }

    private static native void nglGetColorTableParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static native void glBlendEquation(int var0);

    public static native void glBlendColor(float var0, float var1, float var2, float var3);

    public static native void glHistogram(int var0, int var1, int var2, boolean var3);

    public static native void glResetHistogram(int var0);

    public static void glGetHistogram(int target, boolean reset, int format, int type, ByteBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        ARBImaging.nglGetHistogram(target, reset, format, type, values, values.position());
    }

    public static void glGetHistogram(int target, boolean reset, int format, int type, ShortBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        ARBImaging.nglGetHistogram(target, reset, format, type, values, values.position() << 1);
    }

    public static void glGetHistogram(int target, boolean reset, int format, int type, IntBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        ARBImaging.nglGetHistogram(target, reset, format, type, values, values.position() << 2);
    }

    public static void glGetHistogram(int target, boolean reset, int format, int type, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 256);
        ARBImaging.nglGetHistogram(target, reset, format, type, values, values.position() << 2);
    }

    private static native void nglGetHistogram(int var0, boolean var1, int var2, int var3, Buffer var4, int var5);

    public static void glGetHistogramParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 256);
        ARBImaging.nglGetHistogramParameterfv(target, pname, params, params.position());
    }

    private static native void nglGetHistogramParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetHistogramParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetHistogramParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetHistogramParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static native void glMinmax(int var0, int var1, boolean var2);

    public static native void glResetMinmax(int var0);

    public static void glGetMinmax(int target, boolean reset, int format, int types, ByteBuffer values) {
        BufferChecks.checkBuffer(values);
        ARBImaging.nglGetMinmax(target, reset, format, types, values, values.position());
    }

    public static void glGetMinmax(int target, boolean reset, int format, int types, ShortBuffer values) {
        BufferChecks.checkBuffer(values);
        ARBImaging.nglGetMinmax(target, reset, format, types, values, values.position() << 1);
    }

    public static void glGetMinmax(int target, boolean reset, int format, int types, IntBuffer values) {
        BufferChecks.checkBuffer(values);
        ARBImaging.nglGetMinmax(target, reset, format, types, values, values.position() << 2);
    }

    public static void glGetMinmax(int target, boolean reset, int format, int types, FloatBuffer values) {
        BufferChecks.checkBuffer(values);
        ARBImaging.nglGetMinmax(target, reset, format, types, values, values.position() << 2);
    }

    private static native void nglGetMinmax(int var0, boolean var1, int var2, int var3, Buffer var4, int var5);

    public static void glGetMinmaxParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetMinmaxParameterfv(target, pname, params, params.position());
    }

    private static native void nglGetMinmaxParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetMinmaxParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetMinmaxParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetMinmaxParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, ByteBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1));
        ARBImaging.nglConvolutionFilter1D(target, internalformat, width, format, type, image, image.position());
    }

    public static void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, ShortBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 1);
        ARBImaging.nglConvolutionFilter1D(target, internalformat, width, format, type, image, image.position());
    }

    public static void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, IntBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 2);
        ARBImaging.nglConvolutionFilter1D(target, internalformat, width, format, type, image, image.position());
    }

    public static void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, FloatBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, 1, 1) >> 2);
        ARBImaging.nglConvolutionFilter1D(target, internalformat, width, format, type, image, image.position());
    }

    private static native void nglConvolutionFilter1D(int var0, int var1, int var2, int var3, int var4, Buffer var5, int var6);

    public static void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, ByteBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, height, 1));
        ARBImaging.nglConvolutionFilter2D(target, internalformat, width, height, format, type, image, image.position());
    }

    public static void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, ShortBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 1);
        ARBImaging.nglConvolutionFilter2D(target, internalformat, width, height, format, type, image, image.position() << 1);
    }

    public static void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, IntBuffer image) {
        BufferChecks.checkBuffer(image, GLBufferChecks.calculateImageStorage(format, type, width, height, 1) >> 2);
        ARBImaging.nglConvolutionFilter2D(target, internalformat, width, height, format, type, image, image.position() << 2);
    }

    private static native void nglConvolutionFilter2D(int var0, int var1, int var2, int var3, int var4, int var5, Buffer var6, int var7);

    public static native void glConvolutionParameterf(int var0, int var1, float var2);

    public static void glConvolutionParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglConvolutionParameterfv(target, pname, params, params.position());
    }

    private static native void nglConvolutionParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static native void glConvolutionParameteri(int var0, int var1, int var2);

    public static void glConvolutionParameteriv(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglConvolutionParameteriv(target, pname, params, params.position());
    }

    private static native void nglConvolutionParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static native void glCopyConvolutionFilter1D(int var0, int var1, int var2, int var3, int var4);

    public static native void glCopyConvolutionFilter2D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glGetConvolutionFilter(int target, int format, int type, ByteBuffer image) {
        BufferChecks.checkDirect(image);
        ARBImaging.nglGetConvolutionFilter(target, format, type, image, image.position());
    }

    public static void glGetConvolutionFilter(int target, int format, int type, ShortBuffer image) {
        BufferChecks.checkDirect(image);
        ARBImaging.nglGetConvolutionFilter(target, format, type, image, image.position() << 1);
    }

    public static void glGetConvolutionFilter(int target, int format, int type, IntBuffer image) {
        BufferChecks.checkDirect(image);
        ARBImaging.nglGetConvolutionFilter(target, format, type, image, image.position() << 2);
    }

    public static void glGetConvolutionFilter(int target, int format, int type, FloatBuffer image) {
        BufferChecks.checkDirect(image);
        ARBImaging.nglGetConvolutionFilter(target, format, type, image, image.position() << 2);
    }

    private static native void nglGetConvolutionFilter(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glGetConvolutionParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetConvolutionParameterfv(target, pname, params, params.position());
    }

    private static native void nglGetConvolutionParameterfv(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetConvolutionParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBImaging.nglGetConvolutionParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetConvolutionParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, Buffer row, Buffer column) {
        BufferChecks.checkDirectBuffer(row);
        BufferChecks.checkDirectBuffer(column);
        ARBImaging.nglSeparableFilter2D(target, internalformat, width, height, format, type, row, BufferUtils.getOffset(row), column, BufferUtils.getOffset(column));
    }

    private static native void nglSeparableFilter2D(int var0, int var1, int var2, int var3, int var4, int var5, Buffer var6, int var7, Buffer var8, int var9);

    public static void glGetSeparableFilter(int target, int format, int type, Buffer row, Buffer column, Buffer span) {
        BufferChecks.checkDirectBuffer(row);
        BufferChecks.checkDirectBuffer(column);
        BufferChecks.checkDirectBuffer(span);
        ARBImaging.nglGetSeparableFilter(target, format, type, row, BufferUtils.getOffset(row), column, BufferUtils.getOffset(column), span, BufferUtils.getOffset(span));
    }

    private static native void nglGetSeparableFilter(int var0, int var1, int var2, Buffer var3, int var4, Buffer var5, int var6, Buffer var7, int var8);
}

