/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.VBOTracker;

public abstract class ARBBufferObject {
    public static final int GL_STREAM_DRAW_ARB = 35040;
    public static final int GL_STREAM_READ_ARB = 35041;
    public static final int GL_STREAM_COPY_ARB = 35042;
    public static final int GL_STATIC_DRAW_ARB = 35044;
    public static final int GL_STATIC_READ_ARB = 35045;
    public static final int GL_STATIC_COPY_ARB = 35046;
    public static final int GL_DYNAMIC_DRAW_ARB = 35048;
    public static final int GL_DYNAMIC_READ_ARB = 35049;
    public static final int GL_DYNAMIC_COPY_ARB = 35050;
    public static final int GL_READ_ONLY_ARB = 35000;
    public static final int GL_WRITE_ONLY_ARB = 35001;
    public static final int GL_READ_WRITE_ARB = 35002;
    public static final int GL_BUFFER_SIZE_ARB = 34660;
    public static final int GL_BUFFER_USAGE_ARB = 34661;
    public static final int GL_BUFFER_ACCESS_ARB = 35003;
    public static final int GL_BUFFER_MAPPED_ARB = 35004;
    public static final int GL_BUFFER_MAP_POINTER_ARB = 35005;

    static native void initNativeStubs() throws LWJGLException;

    public static void glBindBufferARB(int target, int buffer) {
        switch (target) {
            case 34963: {
                VBOTracker.getVBOElementStack().setState(buffer);
                break;
            }
            case 34962: {
                VBOTracker.getVBOArrayStack().setState(buffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported VBO target " + target);
            }
        }
        ARBBufferObject.nglBindBufferARB(target, buffer);
    }

    private static native void nglBindBufferARB(int var0, int var1);

    public static void glDeleteBuffersARB(IntBuffer buffers) {
        int i = buffers.position();
        while (i < buffers.limit()) {
            int buffer_handle = buffers.get(i);
            if (VBOTracker.getVBOElementStack().getState() == buffer_handle) {
                VBOTracker.getVBOElementStack().setState(0);
            }
            if (VBOTracker.getVBOArrayStack().getState() == buffer_handle) {
                VBOTracker.getVBOArrayStack().setState(0);
            }
            ++i;
        }
        BufferChecks.checkDirect(buffers);
        ARBBufferObject.nglDeleteBuffersARB(buffers.remaining(), buffers, buffers.position());
    }

    private static native void nglDeleteBuffersARB(int var0, IntBuffer var1, int var2);

    public static void glGenBuffersARB(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        ARBBufferObject.nglGenBuffersARB(buffers.remaining(), buffers, buffers.position());
    }

    private static native void nglGenBuffersARB(int var0, IntBuffer var1, int var2);

    public static native boolean glIsBufferARB(int var0);

    public static void glBufferDataARB(int target, int size, ByteBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        ARBBufferObject.nglBufferDataARB(target, data != null ? data.remaining() : size, data, data != null ? data.position() : 0, usage);
    }

    public static void glBufferDataARB(int target, int size, ShortBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        ARBBufferObject.nglBufferDataARB(target, data != null ? data.remaining() << 1 : size, data, data != null ? data.position() << 1 : 0, usage);
    }

    public static void glBufferDataARB(int target, int size, FloatBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        ARBBufferObject.nglBufferDataARB(target, data != null ? data.remaining() << 2 : size, data, data != null ? data.position() << 2 : 0, usage);
    }

    public static void glBufferDataARB(int target, int size, IntBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        ARBBufferObject.nglBufferDataARB(target, data != null ? data.remaining() << 2 : size, data, data != null ? data.position() << 2 : 0, usage);
    }

    private static native void nglBufferDataARB(int var0, int var1, Buffer var2, int var3, int var4);

    public static void glBufferSubDataARB(int target, int offset, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining(), data, data.position());
    }

    public static void glBufferSubDataARB(int target, int offset, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 1, data, data.position() << 1);
    }

    public static void glBufferSubDataARB(int target, int offset, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    public static void glBufferSubDataARB(int target, int offset, IntBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    private static native void nglBufferSubDataARB(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glGetBufferSubDataARB(int target, int offset, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining(), data, data.position());
    }

    public static void glGetBufferSubDataARB(int target, int offset, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 1, data, data.position() << 1);
    }

    public static void glGetBufferSubDataARB(int target, int offset, IntBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    public static void glGetBufferSubDataARB(int target, int offset, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    private static native void nglGetBufferSubDataARB(int var0, int var1, int var2, Buffer var3, int var4);

    public static native ByteBuffer glMapBufferARB(int var0, int var1, int var2, ByteBuffer var3);

    public static native boolean glUnmapBufferARB(int var0);

    public static void glGetBufferParameterARB(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        ARBBufferObject.nglGetBufferParameterivARB(target, pname, params, params.position());
    }

    private static native void nglGetBufferParameterivARB(int var0, int var1, IntBuffer var2, int var3);

    public static native ByteBuffer glGetBufferPointerARB(int var0, int var1, int var2);
}

