/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal.eax;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.Sys;
import org.lwjgl.openal.eax.EAX20;

public class EAXListenerProperties {
    private boolean autoCommit = true;
    protected ByteBuffer eaxListenerProperties = ByteBuffer.allocateDirect(EAXLISTENERPROPERTIES_SIZE);
    protected static int EAXLISTENERPROPERTIES_SIZE;
    protected static int room_offset;
    protected static int roomHF_offset;
    protected static int roomRolloffFactor_offset;
    protected static int decayTime_offset;
    protected static int decayHFRatio_offset;
    protected static int reflections_offset;
    protected static int reflectionsDelay_offset;
    protected static int reverb_offset;
    protected static int reverbDelay_offset;
    protected static int environment_offset;
    protected static int environmentSize_offset;
    protected static int environmentDiffusion_offset;
    protected static int airAbsorptionHF_offset;
    protected static int flags_offset;
    public static final int EAXLISTENER_NONE = 0;
    public static final int EAXLISTENER_ALLPARAMETERS = 1;
    public static final int EAXLISTENER_ROOM = 2;
    public static final int EAXLISTENER_ROOMHF = 3;
    public static final int EAXLISTENER_ROOMROLLOFFFACTOR = 4;
    public static final int EAXLISTENER_DECAYTIME = 5;
    public static final int EAXLISTENER_DECAYHFRATIO = 6;
    public static final int EAXLISTENER_REFLECTIONS = 7;
    public static final int EAXLISTENER_REFLECTIONSDELAY = 8;
    public static final int EAXLISTENER_REVERB = 9;
    public static final int EAXLISTENER_REVERBDELAY = 10;
    public static final int EAXLISTENER_ENVIRONMENT = 11;
    public static final int EAXLISTENER_ENVIRONMENTSIZE = 12;
    public static final int EAXLISTENER_ENVIRONMENTDIFFUSION = 13;
    public static final int EAXLISTENER_AIRABSORPTIONHF = 14;
    public static final int EAXLISTENER_FLAGS = 15;
    public static final int EAXLISTENER_IMMEDIATE = 0;
    public static final int EAXLISTENER_DEFERRED = Integer.MIN_VALUE;
    public static final int EAXLISTENER_COMMITDEFERREDSETTINGS = 0;
    public static final int EAXLISTENERFLAGS_DECAYTIMESCALE = 1;
    public static final int EAXLISTENERFLAGS_REFLECTIONSSCALE = 2;
    public static final int EAXLISTENERFLAGS_REFLECTIONSDELAYSCALE = 4;
    public static final int EAXLISTENERFLAGS_REVERBSCALE = 8;
    public static final int EAXLISTENERFLAGS_REVERBDELAYSCALE = 16;
    public static final int EAXLISTENERFLAGS_DECAYHFLIMIT = 32;
    public static final int EAXLISTENERFLAGS_RESERVED = -64;
    public static final int EAXLISTENER_MINROOM = -10000;
    public static final int EAXLISTENER_MAXROOM = 0;
    public static final int EAXLISTENER_DEFAULTROOM = -1000;
    public static final int EAXLISTENER_MINROOMHF = -10000;
    public static final int EAXLISTENER_MAXROOMHF = 0;
    public static final int EAXLISTENER_DEFAULTROOMHF = -100;
    public static final float EAXLISTENER_MINROOMROLLOFFFACTOR = 0.0f;
    public static final float EAXLISTENER_MAXROOMROLLOFFFACTOR = 10.0f;
    public static final float EAXLISTENER_DEFAULTROOMROLLOFFFACTOR = 0.0f;
    public static final float EAXLISTENER_MINDECAYTIME = 0.1f;
    public static final float EAXLISTENER_MAXDECAYTIME = 20.0f;
    public static final float EAXLISTENER_DEFAULTDECAYTIME = 1.49f;
    public static final float EAXLISTENER_MINDECAYHFRATIO = 0.1f;
    public static final float EAXLISTENER_MAXDECAYHFRATIO = 2.0f;
    public static final float EAXLISTENER_DEFAULTDECAYHFRATIO = 0.83f;
    public static final int EAXLISTENER_MINREFLECTIONS = -10000;
    public static final int EAXLISTENER_MAXREFLECTIONS = 1000;
    public static final int EAXLISTENER_DEFAULTREFLECTIONS = -2602;
    public static final float EAXLISTENER_MINREFLECTIONSDELAY = 0.0f;
    public static final float EAXLISTENER_MAXREFLECTIONSDELAY = 0.3f;
    public static final float EAXLISTENER_DEFAULTREFLECTIONSDELAY = 0.007f;
    public static final int EAXLISTENER_MINREVERB = -10000;
    public static final int EAXLISTENER_MAXREVERB = 2000;
    public static final int EAXLISTENER_DEFAULTREVERB = 200;
    public static final float EAXLISTENER_MINREVERBDELAY = 0.0f;
    public static final float EAXLISTENER_MAXREVERBDELAY = 0.1f;
    public static final float EAXLISTENER_DEFAULTREVERBDELAY = 0.011f;
    public static final int EAXLISTENER_MINENVIRONMENT = 0;
    public static final int EAXLISTENER_MAXENVIRONMENT = 25;
    public static final int EAXLISTENER_DEFAULTENVIRONMENT = 0;
    public static final float EAXLISTENER_MINENVIRONMENTSIZE = 1.0f;
    public static final float EAXLISTENER_MAXENVIRONMENTSIZE = 100.0f;
    public static final float EAXLISTENER_DEFAULTENVIRONMENTSIZE = 7.5f;
    public static final float EAXLISTENER_MINENVIRONMENTDIFFUSION = 0.0f;
    public static final float EAXLISTENER_MAXENVIRONMENTDIFFUSION = 1.0f;
    public static final float EAXLISTENER_DEFAULTENVIRONMENTDIFFUSION = 1.0f;
    public static final float EAXLISTENER_MINAIRABSORPTIONHF = -100.0f;
    public static final float EAXLISTENER_MAXAIRABSORPTIONHF = 0.0f;
    public static final float EAXLISTENER_DEFAULTAIRABSORPTIONHF = -5.0f;
    public static final int EAXLISTENER_DEFAULTFLAGS = 63;

    static {
        Sys.initialize();
        EAXLISTENERPROPERTIES_SIZE = EAXListenerProperties.sizeOfEaxListenerProperties();
        EAXListenerProperties.assignOffsets();
    }

    public EAXListenerProperties() {
        this.eaxListenerProperties.order(ByteOrder.nativeOrder());
    }

    public void loadEAXValues() {
        EAX20.eaxGet(2, 1, 0, this.eaxListenerProperties, EAXLISTENERPROPERTIES_SIZE);
    }

    public void reset() {
        boolean commitValue = this.autoCommit;
        this.autoCommit = false;
        this.setRoom(-1000);
        this.setRoomHF(-100);
        this.setRoomRolloffFactor(0.0f);
        this.setDecayTime(1.49f);
        this.setDecayTimeHFRatio(0.83f);
        this.setReflections(-2602);
        this.setReflectionsDelay(0.007f);
        this.setReverb(200);
        this.setReverbDelay(0.011f);
        this.setEnvironment(0);
        this.setEnvironmentSize(7.5f);
        this.setEnvironmentDiffusion(1.0f);
        this.setAirAbsorptionFactor(-5.0f);
        this.setFlags(63);
        this.autoCommit = commitValue;
    }

    public void commit() {
        EAX20.eaxSet(2, 1, 0, this.eaxListenerProperties, EAXLISTENERPROPERTIES_SIZE);
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean enabled) {
        this.autoCommit = enabled;
    }

    private final void autoCommit() {
        if (this.autoCommit) {
            this.commit();
        }
    }

    public int getSize() {
        return EAXLISTENERPROPERTIES_SIZE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EAXListenerProperties [");
        sb.append("lRoom = ");
        sb.append(this.getRoom());
        sb.append(", ");
        sb.append("lRoomHF = ");
        sb.append(this.getRoomHF());
        sb.append(", ");
        sb.append("flRoomRolloffFactor = ");
        sb.append(this.getRoomRolloffFactor());
        sb.append(", ");
        sb.append("flDecayTime = ");
        sb.append(this.getDecayTime());
        sb.append(", ");
        sb.append("flDecayHFRatio = ");
        sb.append(this.getDecayTimeHFRatio());
        sb.append(", ");
        sb.append("lReflections = ");
        sb.append(this.getReflections());
        sb.append(", ");
        sb.append("flReflectionsDelay = ");
        sb.append(this.getReflectionsDelay());
        sb.append(", ");
        sb.append("lReverb = ");
        sb.append(this.getReverb());
        sb.append(", ");
        sb.append("flReverbDelay = ");
        sb.append(this.getReverbDelay());
        sb.append(", ");
        sb.append("dwEnvironment = ");
        sb.append(this.getEnvironment());
        sb.append(", ");
        sb.append("flEnvironmentSize = ");
        sb.append(this.getEnvironmentSize());
        sb.append(", ");
        sb.append("flEnvironmentDiffusion = ");
        sb.append(this.getEnvironmentDiffusion());
        sb.append(", ");
        sb.append("flAirAbsorptionHF = ");
        sb.append(this.getAirAbsorptionHF());
        sb.append(", ");
        sb.append("dwFlags = ");
        sb.append(this.getFlags());
        sb.append("]");
        return sb.toString();
    }

    public int getRoom() {
        return this.eaxListenerProperties.getInt(room_offset);
    }

    public void setRoom(int room) {
        this.eaxListenerProperties.putInt(room_offset, room);
        this.autoCommit();
    }

    public int getRoomHF() {
        return this.eaxListenerProperties.getInt(roomHF_offset);
    }

    public void setRoomHF(int roomHF) {
        this.eaxListenerProperties.putInt(roomHF_offset, roomHF);
        this.autoCommit();
    }

    public float getRoomRolloffFactor() {
        return this.eaxListenerProperties.getFloat(roomRolloffFactor_offset);
    }

    public void setRoomRolloffFactor(float roomRolloffFactor) {
        this.eaxListenerProperties.putFloat(roomRolloffFactor_offset, roomRolloffFactor);
        this.autoCommit();
    }

    public float getDecayTime() {
        return this.eaxListenerProperties.getFloat(decayTime_offset);
    }

    public void setDecayTime(float decayTime) {
        this.eaxListenerProperties.putFloat(decayTime_offset, decayTime);
        this.autoCommit();
    }

    public float getDecayTimeHFRatio() {
        return this.eaxListenerProperties.getFloat(decayHFRatio_offset);
    }

    public void setDecayTimeHFRatio(float decayTimeHFRatio) {
        this.eaxListenerProperties.putFloat(decayHFRatio_offset, decayTimeHFRatio);
        this.autoCommit();
    }

    public int getReflections() {
        return this.eaxListenerProperties.getInt(reflections_offset);
    }

    public void setReflections(int reflections) {
        this.eaxListenerProperties.putInt(reflections_offset, reflections);
        this.autoCommit();
    }

    public float getReflectionsDelay() {
        return this.eaxListenerProperties.getFloat(reflectionsDelay_offset);
    }

    public void setReflectionsDelay(float reflectionsDelay) {
        this.eaxListenerProperties.putFloat(reflectionsDelay_offset, reflectionsDelay);
        this.autoCommit();
    }

    public int getReverb() {
        return this.eaxListenerProperties.getInt(reverb_offset);
    }

    public void setReverb(int reverb) {
        this.eaxListenerProperties.putInt(reverb_offset, reverb);
        this.autoCommit();
    }

    public float getReverbDelay() {
        return this.eaxListenerProperties.getFloat(reverbDelay_offset);
    }

    public void setReverbDelay(float reverbDelay) {
        this.eaxListenerProperties.putFloat(reverbDelay_offset, reverbDelay);
        this.autoCommit();
    }

    public int getEnvironment() {
        return this.eaxListenerProperties.getInt(environment_offset);
    }

    public void setEnvironment(int environment) {
        this.eaxListenerProperties.putInt(environment_offset, environment);
        if (this.autoCommit) {
            EAX20.eaxSet(2, 11, 0, this.eaxListenerProperties.position(environment_offset), 4);
            this.eaxListenerProperties.rewind();
        }
    }

    public float getEnvironmentSize() {
        return this.eaxListenerProperties.getFloat(environmentSize_offset);
    }

    public void setEnvironmentSize(float environmentSize) {
        this.eaxListenerProperties.putFloat(environmentSize_offset, environmentSize);
        if (this.autoCommit) {
            EAX20.eaxSet(2, 12, 0, this.eaxListenerProperties.position(environmentSize_offset), 4);
            this.eaxListenerProperties.rewind();
        }
    }

    public float getEnvironmentDiffusion() {
        return this.eaxListenerProperties.getFloat(environmentDiffusion_offset);
    }

    public void setEnvironmentDiffusion(float environmentDiffusion) {
        this.eaxListenerProperties.putFloat(environmentDiffusion_offset, environmentDiffusion);
        this.autoCommit();
    }

    public float getAirAbsorptionHF() {
        return this.eaxListenerProperties.getFloat(airAbsorptionHF_offset);
    }

    public void setAirAbsorptionFactor(float airAbsorptionHF) {
        this.eaxListenerProperties.putFloat(airAbsorptionHF_offset, airAbsorptionHF);
        this.autoCommit();
    }

    public int getFlags() {
        return this.eaxListenerProperties.getInt(flags_offset);
    }

    public void setFlags(int flags) {
        this.eaxListenerProperties.putInt(flags_offset, flags);
        this.autoCommit();
    }

    protected static native int sizeOfEaxListenerProperties();

    protected static native void assignOffsets();
}

