/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal.eax;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.openal.eax.EAX20;

public class EAXBufferProperties {
    private boolean autoCommit = true;
    private int currentSource = -1;
    protected ByteBuffer eaxBufferProperties = BufferUtils.createByteBuffer(EAXBUFFERPROPERTIES_SIZE);
    protected static int EAXBUFFERPROPERTIES_SIZE;
    protected static int direct_offset;
    protected static int directHF_offset;
    protected static int room_offset;
    protected static int roomHF_offset;
    protected static int roomRolloffFactor_offset;
    protected static int obstruction_offset;
    protected static int obstructionLFRatio_offset;
    protected static int occlusion_offset;
    protected static int occlusionLFRatio_offset;
    protected static int occlusionRoomRatio_offset;
    protected static int outsideVolumeHF_offset;
    protected static int airAbsorptionFactor_offset;
    protected static int flags_offset;
    public static final int EAXBUFFER_NONE = 0;
    public static final int EAXBUFFER_ALLPARAMETERS = 1;
    public static final int EAXBUFFER_DIRECT = 2;
    public static final int EAXBUFFER_DIRECTHF = 3;
    public static final int EAXBUFFER_ROOM = 4;
    public static final int EAXBUFFER_ROOMHF = 5;
    public static final int EAXBUFFER_ROOMROLLOFFFACTOR = 6;
    public static final int EAXBUFFER_OBSTRUCTION = 7;
    public static final int EAXBUFFER_OBSTRUCTIONLFRATIO = 8;
    public static final int EAXBUFFER_OCCLUSION = 9;
    public static final int EAXBUFFER_OCCLUSIONLFRATIO = 10;
    public static final int EAXBUFFER_OCCLUSIONROOMRATIO = 11;
    public static final int EAXBUFFER_OUTSIDEVOLUMEHF = 12;
    public static final int EAXBUFFER_AIRABSORPTIONFACTOR = 13;
    public static final int EAXBUFFER_FLAGS = 14;
    public static final int EAXBUFFER_IMMEDIATE = 0;
    public static final int EAXBUFFER_DEFERRED = Integer.MIN_VALUE;
    public static final int EAXBUFFER_COMMITDEFERREDSETTINGS = 0;
    public static final int EAXBUFFER_FLAGS_DIRECTHFAUTO = 1;
    public static final int EAXBUFFER_FLAGS_ROOMAUTO = 2;
    public static final int EAXBUFFER_FLAGS_ROOMHFAUTO = 4;
    public static final int EAXBUFFER_FLAGS_RESERVED = -8;
    public static final int EAXBUFFER_MINDIRECT = -10000;
    public static final int EAXBUFFER_MAXDIRECT = 1000;
    public static final int EAXBUFFER_DEFAULTDIRECT = 0;
    public static final int EAXBUFFER_MINDIRECTHF = -10000;
    public static final int EAXBUFFER_MAXDIRECTHF = 0;
    public static final int EAXBUFFER_DEFAULTDIRECTHF = 0;
    public static final int EAXBUFFER_MINROOM = -10000;
    public static final int EAXBUFFER_MAXROOM = 1000;
    public static final int EAXBUFFER_DEFAULTROOM = 0;
    public static final int EAXBUFFER_MINROOMHF = -10000;
    public static final int EAXBUFFER_MAXROOMHF = 0;
    public static final int EAXBUFFER_DEFAULTROOMHF = 0;
    public static final float EAXBUFFER_MINROOMROLLOFFFACTOR = 0.0f;
    public static final float EAXBUFFER_MAXROOMROLLOFFFACTOR = 10.0f;
    public static final float EAXBUFFER_DEFAULTROOMROLLOFFFACTOR = 0.0f;
    public static final int EAXBUFFER_MINOBSTRUCTION = -10000;
    public static final int EAXBUFFER_MAXOBSTRUCTION = 0;
    public static final int EAXBUFFER_DEFAULTOBSTRUCTION = 0;
    public static final float EAXBUFFER_MINOBSTRUCTIONLFRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOBSTRUCTIONLFRATIO = 1.0f;
    public static final float EAXBUFFER_DEFAULTOBSTRUCTIONLFRATIO = 0.0f;
    public static final int EAXBUFFER_MINOCCLUSION = -10000;
    public static final int EAXBUFFER_MAXOCCLUSION = 0;
    public static final int EAXBUFFER_DEFAULTOCCLUSION = 0;
    public static final float EAXBUFFER_MINOCCLUSIONLFRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOCCLUSIONLFRATIO = 1.0f;
    public static final float EAXBUFFER_DEFAULTOCCLUSIONLFRATIO = 0.25f;
    public static final float EAXBUFFER_MINOCCLUSIONROOMRATIO = 0.0f;
    public static final float EAXBUFFER_MAXOCCLUSIONROOMRATIO = 10.0f;
    public static final float EAXBUFFER_DEFAULTOCCLUSIONROOMRATIO = 0.5f;
    public static final int EAXBUFFER_MINOUTSIDEVOLUMEHF = -10000;
    public static final int EAXBUFFER_MAXOUTSIDEVOLUMEHF = 0;
    public static final int EAXBUFFER_DEFAULTOUTSIDEVOLUMEHF = 0;
    public static final float EAXBUFFER_MINAIRABSORPTIONFACTOR = 0.0f;
    public static final float EAXBUFFER_MAXAIRABSORPTIONFACTOR = 10.0f;
    public static final float EAXBUFFER_DEFAULTAIRABSORPTIONFACTOR = 1.0f;
    public static final int EAXBUFFER_DEFAULTFLAGS = 7;

    static {
        Sys.initialize();
        EAXBUFFERPROPERTIES_SIZE = EAXBufferProperties.sizeOfEaxBufferProperties();
        EAXBufferProperties.assignOffsets();
    }

    public EAXBufferProperties() {
        this.eaxBufferProperties.order(ByteOrder.nativeOrder());
    }

    public void setCurrentSource(int source) {
        this.currentSource = source;
    }

    public int getCurrentSource() {
        return this.currentSource;
    }

    public void loadEAXValues() {
        EAX20.eaxGet(1, 1, this.currentSource, this.eaxBufferProperties, EAXBUFFERPROPERTIES_SIZE);
    }

    public void reset() {
        boolean commitValue = this.autoCommit;
        this.autoCommit = false;
        this.setDirect(0);
        this.setDirectHF(0);
        this.setRoom(0);
        this.setRoomHF(0);
        this.setRoomRolloffFactor(0.0f);
        this.setObstruction(0);
        this.setObstructionLFRatio(0.0f);
        this.setOcclusion(0);
        this.setOcclusionLFRatio(0.25f);
        this.setOcclusionRoomRatio(0.5f);
        this.setOutsideVolumeHF(0);
        this.setAirAbsorptionFactor(1.0f);
        this.setFlags(7);
        this.autoCommit = commitValue;
    }

    public void commit() {
        EAX20.eaxSet(1, 1, this.currentSource, this.eaxBufferProperties, EAXBUFFERPROPERTIES_SIZE);
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean enabled) {
        this.autoCommit = enabled;
    }

    private final void autoCommit() {
        if (this.autoCommit) {
            this.commit();
        }
    }

    public static int getSize() {
        return EAXBUFFERPROPERTIES_SIZE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EAXBufferProperties [");
        sb.append("lDirect = ");
        sb.append(this.getDirect());
        sb.append(", ");
        sb.append("lDirectHF = ");
        sb.append(this.getDirectHF());
        sb.append(", ");
        sb.append("lRoom = ");
        sb.append(this.getRoom());
        sb.append(", ");
        sb.append("lRoomHF = ");
        sb.append(this.getRoomHF());
        sb.append(", ");
        sb.append("flRoomRolloffFactor = ");
        sb.append(this.getRoomRolloffFactor());
        sb.append(", ");
        sb.append("lObstruction = ");
        sb.append(this.getObstruction());
        sb.append(", ");
        sb.append("flObstructionLFRatio = ");
        sb.append(this.getObstructionLFRatio());
        sb.append(", ");
        sb.append("lOcclusion = ");
        sb.append(this.getOcclusion());
        sb.append(", ");
        sb.append("flOcclusionLFRatio = ");
        sb.append(this.getOcclusionLFRatio());
        sb.append(", ");
        sb.append("flOcclusionRoomRatio = ");
        sb.append(this.getOcclusionRoomRatio());
        sb.append(", ");
        sb.append("lOutsideVolumeHF = ");
        sb.append(this.getOutsideVolumeHF());
        sb.append(", ");
        sb.append("flAirAbsorptionFactor = ");
        sb.append(this.getAirAbsorptionFactor());
        sb.append(", ");
        sb.append("dwFlags = ");
        sb.append(this.getFlags());
        sb.append("]");
        return sb.toString();
    }

    public int getDirect() {
        return this.eaxBufferProperties.getInt(direct_offset);
    }

    public void setDirect(int direct) {
        this.eaxBufferProperties.putInt(direct_offset, direct);
        this.autoCommit();
    }

    public int getDirectHF() {
        return this.eaxBufferProperties.getInt(directHF_offset);
    }

    public void setDirectHF(int directHF) {
        this.eaxBufferProperties.putInt(directHF_offset, directHF);
        this.autoCommit();
    }

    public int getRoom() {
        return this.eaxBufferProperties.getInt(room_offset);
    }

    public void setRoom(int room) {
        this.eaxBufferProperties.putInt(room_offset, room);
        this.autoCommit();
    }

    public int getRoomHF() {
        return this.eaxBufferProperties.getInt(roomHF_offset);
    }

    public void setRoomHF(int roomHF) {
        this.eaxBufferProperties.putInt(roomHF_offset, roomHF);
        this.autoCommit();
    }

    public float getRoomRolloffFactor() {
        return this.eaxBufferProperties.getFloat(roomRolloffFactor_offset);
    }

    public void setRoomRolloffFactor(float roomRolloffFactor) {
        this.eaxBufferProperties.putFloat(roomRolloffFactor_offset, roomRolloffFactor);
        this.autoCommit();
    }

    public int getObstruction() {
        return this.eaxBufferProperties.getInt(obstruction_offset);
    }

    public void setObstruction(int obstruction) {
        this.eaxBufferProperties.putInt(obstruction_offset, obstruction);
        this.autoCommit();
    }

    public float getObstructionLFRatio() {
        return this.eaxBufferProperties.getFloat(obstructionLFRatio_offset);
    }

    public void setObstructionLFRatio(float obstructionLFRatio) {
        this.eaxBufferProperties.putFloat(obstructionLFRatio_offset, obstructionLFRatio);
        this.autoCommit();
    }

    public int getOcclusion() {
        return this.eaxBufferProperties.getInt(occlusion_offset);
    }

    public void setOcclusion(int occlusion) {
        this.eaxBufferProperties.putInt(occlusion_offset, occlusion);
        this.autoCommit();
    }

    public float getOcclusionLFRatio() {
        return this.eaxBufferProperties.getFloat(occlusionLFRatio_offset);
    }

    public void setOcclusionLFRatio(float occlusionLFRatio) {
        this.eaxBufferProperties.putFloat(occlusionLFRatio_offset, occlusionLFRatio);
        this.autoCommit();
    }

    public float getOcclusionRoomRatio() {
        return this.eaxBufferProperties.getFloat(occlusionRoomRatio_offset);
    }

    public void setOcclusionRoomRatio(float occlusionRoomRatio) {
        this.eaxBufferProperties.putFloat(occlusionRoomRatio_offset, occlusionRoomRatio);
        this.autoCommit();
    }

    public int getOutsideVolumeHF() {
        return this.eaxBufferProperties.getInt(outsideVolumeHF_offset);
    }

    public void setOutsideVolumeHF(int outsideVolumeHF) {
        this.eaxBufferProperties.putInt(outsideVolumeHF_offset, outsideVolumeHF);
        this.autoCommit();
    }

    public float getAirAbsorptionFactor() {
        return this.eaxBufferProperties.getFloat(airAbsorptionFactor_offset);
    }

    public void setAirAbsorptionFactor(float airAbsorptionFactor) {
        this.eaxBufferProperties.putFloat(airAbsorptionFactor_offset, airAbsorptionFactor);
        this.autoCommit();
    }

    public int getFlags() {
        return this.eaxBufferProperties.getInt(flags_offset);
    }

    public void setFlags(int flags) {
        this.eaxBufferProperties.putInt(flags_offset, flags);
        this.autoCommit();
    }

    protected static native int sizeOfEaxBufferProperties();

    protected static native void assignOffsets();
}

