/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;

public class Controller {
    private static boolean created;
    private static boolean[] buttons;
    private static int x;
    private static int rx;
    private static int y;
    private static int ry;
    private static int z;
    private static int rz;
    private static int pov;
    private static int slider;
    public static final int POV_CENTER = -1;
    public static final int POV_NORTH = 0;
    public static final int POV_SOUTH = 18000;
    public static final int POV_EAST = 27000;
    public static final int POV_WEST = 9000;
    private static int buttonCount;
    private static boolean hasXAxis;
    private static boolean hasRXAxis;
    private static boolean hasYAxis;
    private static boolean hasRYAxis;
    private static boolean hasZAxis;
    private static boolean hasRZAxis;
    private static boolean hasPOV;
    private static boolean hasSlider;
    private static String[] buttonName;
    private static final Map buttonMap;
    private static boolean initialized;

    static {
        x = 0;
        rx = 0;
        y = 0;
        ry = 0;
        z = 0;
        rz = 0;
        slider = 0;
        buttonCount = -1;
        hasXAxis = false;
        hasRXAxis = false;
        hasYAxis = false;
        hasRYAxis = false;
        hasZAxis = false;
        hasRZAxis = false;
        hasPOV = false;
        hasSlider = false;
        buttonMap = new HashMap(8);
    }

    private Controller() {
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        Sys.initialize();
        Controller.initIDs();
        initialized = true;
    }

    public static void create() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display must be created before you can create Controller");
        }
        Controller.initialize();
        if (created) {
            return;
        }
        Controller.nCreate();
        buttonName = new String[buttons.length];
        int i = 0;
        while (i < buttons.length) {
            Controller.buttonName[i] = "BUTTON" + i;
            buttonMap.put(buttonName[i], new Integer(i));
            ++i;
        }
        created = true;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
        if (!created) {
            return;
        }
        created = false;
        Controller.nDestroy();
    }

    public static void poll() {
        if (!created) {
            throw new IllegalStateException("Controller must be created before you can poll the device");
        }
        Controller.nPoll();
    }

    public static boolean isButtonDown(int button) {
        if (!created) {
            throw new IllegalStateException("Controller must be created before you can query button state");
        }
        return buttons[button];
    }

    public static boolean isBuffered() {
        return false;
    }

    public static String getButtonName(int button) {
        if (button < 0 || button >= buttonName.length) {
            return null;
        }
        return buttonName[button];
    }

    public static int getButtonIndex(String buttonName) {
        Integer ret = (Integer)buttonMap.get(buttonName);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    private static native void nPoll();

    private static native void nCreate() throws LWJGLException;

    private static native void nDestroy();

    private static native void initIDs();

    public static int getButtonCount() {
        return buttonCount;
    }

    public static boolean hasPOV() {
        return hasPOV;
    }

    public static boolean hasRXAxis() {
        return hasRXAxis;
    }

    public static boolean hasRYAxis() {
        return hasRYAxis;
    }

    public static boolean hasRZAxis() {
        return hasRZAxis;
    }

    public static boolean hasSlider() {
        return hasSlider;
    }

    public static boolean hasXAxis() {
        return hasXAxis;
    }

    public static boolean hasYAxis() {
        return hasYAxis;
    }

    public static boolean hasZAxis() {
        return hasZAxis;
    }

    public static int getPov() {
        return pov;
    }

    public static int getRx() {
        return rx;
    }

    public static int getRy() {
        return ry;
    }

    public static int getRz() {
        return rz;
    }

    public static int getSlider() {
        return slider;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getZ() {
        return z;
    }
}

