/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.devil;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;

public class IL {
    private static final int BUFFER_LENGTH = 1000;
    protected static boolean created;
    public static final int IL_FALSE = 0;
    public static final int IL_TRUE = 1;
    public static final int IL_COLOUR_INDEX = 6400;
    public static final int IL_COLOR_INDEX = 6400;
    public static final int IL_RGB = 6407;
    public static final int IL_RGBA = 6408;
    public static final int IL_BGR = 32992;
    public static final int IL_BGRA = 32993;
    public static final int IL_LUMINANCE = 6409;
    public static final int IL_BYTE = 5120;
    public static final int IL_SHORT = 5122;
    public static final int IL_INT = 5124;
    public static final int IL_FLOAT = 5126;
    public static final int IL_DOUBLE = 5130;
    public static final int IL_VENDOR = 7936;
    public static final int IL_VERSION_1_6_0 = 1;
    public static final int IL_VERSION = 160;
    public static final int IL_LOAD_EXT = 7937;
    public static final int IL_SAVE_EXT = 7938;
    public static final int IL_ORIGIN_BIT = 1;
    public static final int IL_FILE_BIT = 2;
    public static final int IL_PAL_BIT = 4;
    public static final int IL_FORMAT_BIT = 8;
    public static final int IL_TYPE_BIT = 16;
    public static final int IL_COMPRESS_BIT = 32;
    public static final int IL_LOADFAIL_BIT = 64;
    public static final int IL_FORMAT_SPECIFIC_BIT = 128;
    public static final int IL_ALL_ATTRIB_BITS = 1048575;
    public static final int IL_PAL_NONE = 1024;
    public static final int IL_PAL_RGB24 = 1025;
    public static final int IL_PAL_RGB32 = 1026;
    public static final int IL_PAL_RGBA32 = 1027;
    public static final int IL_PAL_BGR24 = 1028;
    public static final int IL_PAL_BGR32 = 1029;
    public static final int IL_PAL_BGRA32 = 1030;
    public static final int IL_TYPE_UNKNOWN = 0;
    public static final int IL_BMP = 1056;
    public static final int IL_CUT = 1057;
    public static final int IL_DOOM = 1058;
    public static final int IL_DOOM_FLAT = 1059;
    public static final int IL_ICO = 1060;
    public static final int IL_JPG = 1061;
    public static final int IL_LBM = 1062;
    public static final int IL_PCD = 1063;
    public static final int IL_PCX = 1064;
    public static final int IL_PIC = 1065;
    public static final int IL_PNG = 1066;
    public static final int IL_PNM = 1067;
    public static final int IL_SGI = 1068;
    public static final int IL_TGA = 1069;
    public static final int IL_TIF = 1070;
    public static final int IL_CHEAD = 1071;
    public static final int IL_RAW = 1072;
    public static final int IL_MDL = 1073;
    public static final int IL_WAL = 1074;
    public static final int IL_OIL = 1075;
    public static final int IL_LIF = 1076;
    public static final int IL_MNG = 1077;
    public static final int IL_JNG = 1077;
    public static final int IL_GIF = 1078;
    public static final int IL_DDS = 1079;
    public static final int IL_DCX = 1080;
    public static final int IL_PSD = 1081;
    public static final int IL_EXIF = 1082;
    public static final int IL_PSP = 1083;
    public static final int IL_PIX = 1084;
    public static final int IL_PXR = 1085;
    public static final int IL_XPM = 1086;
    public static final int IL_JASC_PAL = 1141;
    public static final int IL_NO_ERROR = 0;
    public static final int IL_INVALID_ENUM = 1281;
    public static final int IL_OUT_OF_MEMORY = 1282;
    public static final int IL_FORMAT_NOT_SUPPORTED = 1283;
    public static final int IL_INTERNAL_ERROR = 1284;
    public static final int IL_INVALID_VALUE = 1285;
    public static final int IL_ILLEGAL_OPERATION = 1286;
    public static final int IL_ILLEGAL_FILE_VALUE = 1287;
    public static final int IL_INVALID_FILE_HEADER = 1288;
    public static final int IL_INVALID_PARAM = 1289;
    public static final int IL_COULD_NOT_OPEN_FILE = 1290;
    public static final int IL_INVALID_EXTENSION = 1291;
    public static final int IL_FILE_ALREADY_EXISTS = 1292;
    public static final int IL_OUT_FORMAT_SAME = 1293;
    public static final int IL_STACK_OVERFLOW = 1294;
    public static final int IL_STACK_UNDERFLOW = 1295;
    public static final int IL_INVALID_CONVERSION = 1296;
    public static final int IL_BAD_DIMENSIONS = 1297;
    public static final int IL_FILE_READ_ERROR = 1298;
    public static final int IL_LIB_GIF_ERROR = 1505;
    public static final int IL_LIB_JPEG_ERROR = 1506;
    public static final int IL_LIB_PNG_ERROR = 1507;
    public static final int IL_LIB_TIFF_ERROR = 1508;
    public static final int IL_LIB_MNG_ERROR = 1509;
    public static final int IL_UNKNOWN_ERROR = 1535;
    public static final int IL_ORIGIN_SET = 1536;
    public static final int IL_ORIGIN_LOWER_LEFT = 1537;
    public static final int IL_ORIGIN_UPPER_LEFT = 1538;
    public static final int IL_ORIGIN_MODE = 1539;
    public static final int IL_FORMAT_SET = 1552;
    public static final int IL_FORMAT_MODE = 1553;
    public static final int IL_TYPE_SET = 1554;
    public static final int IL_TYPE_MODE = 1555;
    public static final int IL_FILE_OVERWRITE = 1568;
    public static final int IL_FILE_MODE = 1569;
    public static final int IL_CONV_PAL = 1584;
    public static final int IL_DEFAULT_ON_FAIL = 1586;
    public static final int IL_USE_KEY_COLOUR = 1589;
    public static final int IL_USE_KEY_COLOR = 1589;
    public static final int IL_SAVE_INTERLACED = 1593;
    public static final int IL_INTERLACE_MODE = 1594;
    public static final int IL_QUANTIZATION_MODE = 1600;
    public static final int IL_WU_QUANT = 1601;
    public static final int IL_NEU_QUANT = 1602;
    public static final int IL_NEU_QUANT_SAMPLE = 1603;
    public static final int IL_FASTEST = 1632;
    public static final int IL_LESS_MEM = 1633;
    public static final int IL_DONT_CARE = 1634;
    public static final int IL_MEM_SPEED_HINT = 1637;
    public static final int IL_USE_COMPRESSION = 1638;
    public static final int IL_NO_COMPRESSION = 1639;
    public static final int IL_COMPRESSION_HINT = 1640;
    public static final int IL_SUB_NEXT = 1664;
    public static final int IL_SUB_MIPMAP = 1665;
    public static final int IL_SUB_LAYER = 1666;
    public static final int IL_COMPRESS_MODE = 1792;
    public static final int IL_COMPRESS_NONE = 1793;
    public static final int IL_COMPRESS_RLE = 1794;
    public static final int IL_COMPRESS_LZO = 1795;
    public static final int IL_COMPRESS_ZLIB = 1796;
    public static final int IL_TGA_CREATE_STAMP = 1808;
    public static final int IL_JPG_QUALITY = 1809;
    public static final int IL_PNG_INTERLACE = 1810;
    public static final int IL_TGA_RLE = 1811;
    public static final int IL_BMP_RLE = 1812;
    public static final int IL_SGI_RLE = 1813;
    public static final int IL_TGA_ID_STRING = 1815;
    public static final int IL_TGA_AUTHNAME_STRING = 1816;
    public static final int IL_TGA_AUTHCOMMENT_STRING = 1817;
    public static final int IL_PNG_AUTHNAME_STRING = 1818;
    public static final int IL_PNG_TITLE_STRING = 1819;
    public static final int IL_PNG_DESCRIPTION_STRING = 1820;
    public static final int IL_TIF_DESCRIPTION_STRING = 1821;
    public static final int IL_TIF_HOSTCOMPUTER_STRING = 1822;
    public static final int IL_TIF_DOCUMENTNAME_STRING = 1823;
    public static final int IL_TIF_AUTHNAME_STRING = 1824;
    public static final int IL_JPG_SAVE_FORMAT = 1825;
    public static final int IL_CHEAD_HEADER_STRING = 1826;
    public static final int IL_PCD_PICNUM = 1827;
    public static final int IL_DXTC_FORMAT = 1797;
    public static final int IL_DXT1 = 1798;
    public static final int IL_DXT2 = 1799;
    public static final int IL_DXT3 = 1800;
    public static final int IL_DXT4 = 1801;
    public static final int IL_DXT5 = 1802;
    public static final int IL_DXT_NO_COMP = 1803;
    public static final int IL_KEEP_DXTC_DATA = 1804;
    public static final int IL_DXTC_DATA_FORMAT = 1805;
    public static final int IL_CUBEMAP_POSITIVEX = 1024;
    public static final int IL_CUBEMAP_NEGATIVEX = 2048;
    public static final int IL_CUBEMAP_POSITIVEY = 4096;
    public static final int IL_CUBEMAP_NEGATIVEY = 8192;
    public static final int IL_CUBEMAP_POSITIVEZ = 16384;
    public static final int IL_CUBEMAP_NEGATIVEZ = 32768;
    public static final int IL_VERSION_NUM = 3554;
    public static final int IL_IMAGE_WIDTH = 3556;
    public static final int IL_IMAGE_HEIGHT = 3557;
    public static final int IL_IMAGE_DEPTH = 3558;
    public static final int IL_IMAGE_SIZE_OF_DATA = 3559;
    public static final int IL_IMAGE_BPP = 3560;
    public static final int IL_IMAGE_BYTES_PER_PIXEL = 3560;
    public static final int IL_IMAGE_BITS_PER_PIXEL = 3561;
    public static final int IL_IMAGE_FORMAT = 3562;
    public static final int IL_IMAGE_TYPE = 3563;
    public static final int IL_PALETTE_TYPE = 3564;
    public static final int IL_PALETTE_SIZE = 3565;
    public static final int IL_PALETTE_BPP = 3566;
    public static final int IL_PALETTE_NUM_COLS = 3567;
    public static final int IL_PALETTE_BASE_TYPE = 3568;
    public static final int IL_NUM_IMAGES = 3569;
    public static final int IL_NUM_MIPMAPS = 3570;
    public static final int IL_NUM_LAYERS = 3571;
    public static final int IL_ACTIVE_IMAGE = 3572;
    public static final int IL_ACTIVE_MIPMAP = 3573;
    public static final int IL_ACTIVE_LAYER = 3574;
    public static final int IL_CUR_IMAGE = 3575;
    public static final int IL_IMAGE_DURATION = 3576;
    public static final int IL_IMAGE_PLANESIZE = 3577;
    public static final int IL_IMAGE_BPC = 3578;
    public static final int IL_IMAGE_OFFX = 3579;
    public static final int IL_IMAGE_OFFY = 3580;
    public static final int IL_IMAGE_CUBEFLAGS = 3581;
    public static final int IL_SEEK_SET = 0;
    public static final int IL_SEEK_CUR = 1;
    public static final int IL_SEEK_END = 2;
    public static final int IL_EOF = -1;

    static {
        System.loadLibrary("DevIL");
        System.loadLibrary("lwjgl-devil");
    }

    public static boolean isCreated() {
        return created;
    }

    public static native void initNativeStubs() throws LWJGLException;

    public static native boolean ilActiveImage(int var0);

    public static native boolean ilActiveLayer(int var0);

    public static native boolean ilActiveMipmap(int var0);

    public static native boolean ilApplyPal(String var0);

    public static native boolean ilApplyProfile(String var0, String var1);

    public static native void ilBindImage(int var0);

    public static native boolean ilBlit(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static native void ilClearColour(float var0, float var1, float var2, float var3);

    public static native boolean ilClearImage();

    public static native int ilCloneCurImage();

    public static native boolean ilCompressFunc(int var0);

    public static native boolean ilConvertImage(int var0, int var1);

    public static native boolean ilConvertPal(int var0);

    public static native boolean ilCopyImage(int var0);

    public static int ilCopyPixels(int XOff, int YOff, int ZOff, int Width, int Height, int Depth, int Format, int Type2, ByteBuffer Data) {
        BufferChecks.checkDirect(Data);
        return IL.nilCopyPixels(XOff, YOff, ZOff, Width, Height, Depth, Format, Type2, Data, Data.position());
    }

    public static native int nilCopyPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, ByteBuffer var8, int var9);

    public static native int ilCreateSubImage(int var0, int var1);

    public static native boolean ilDefaultImage();

    public static void ilDeleteImages(int num, IntBuffer images) {
        BufferChecks.checkDirect(images);
        IL.nilDeleteImages(num, images, images.position());
    }

    public static native void nilDeleteImages(int var0, IntBuffer var1, int var2);

    public static native boolean ilDisable(int var0);

    public static native boolean ilEnable(int var0);

    public static native boolean ilFormatFunc(int var0);

    public static void ilGenImages(int num, IntBuffer images) {
        BufferChecks.checkDirect(images);
        IL.nilGenImages(num, images, images.position());
    }

    public static native void nilGenImages(int var0, IntBuffer var1, int var2);

    public static native ByteBuffer ilGetAlpha(int var0);

    public static native void ilModAlpha(int var0);

    public static native void ilSetAlpha(int var0);

    public static native boolean ilGetBoolean(int var0);

    public static native ByteBuffer ilGetData();

    public static native int ilGetError();

    public static native int ilGetInteger(int var0);

    public static native int ilGetLumpPos();

    public static native ByteBuffer ilGetPalette();

    public static native String ilGetString(int var0);

    public static native void ilHint(int var0, int var1);

    public static native void ilInit();

    public static native boolean ilIsDisabled(int var0);

    public static native boolean ilIsEnabled(int var0);

    public static native boolean ilIsImage(int var0);

    public static native boolean ilIsValid(int var0, String var1);

    public static boolean ilIsValidL(int Type2, ByteBuffer Lump, int Size) {
        BufferChecks.checkDirect(Lump);
        return IL.nilIsValidL(Type2, Lump, Lump.position(), Size);
    }

    public static native boolean nilIsValidL(int var0, ByteBuffer var1, int var2, int var3);

    public static native void ilKeyColour(float var0, float var1, float var2, float var3);

    public static native boolean ilLoad(int var0, String var1);

    public static native boolean ilLoadImage(String var0);

    public static boolean ilLoadFromURL(URL url) {
        boolean result = false;
        int type = 0;
        String file = url.toString();
        int index = file.lastIndexOf(46);
        if (index != -1) {
            String extension = file.substring(index + 1);
            if (extension.equalsIgnoreCase("bmp")) {
                type = 1056;
            } else if (extension.equalsIgnoreCase("cut")) {
                type = 1057;
            } else if (extension.equalsIgnoreCase("gif")) {
                type = 1078;
            } else if (extension.equalsIgnoreCase("ico")) {
                type = 1060;
            } else if (extension.equalsIgnoreCase("jpg")) {
                type = 1061;
            } else if (extension.equalsIgnoreCase("lif")) {
                type = 1076;
            } else if (extension.equalsIgnoreCase("mng")) {
                type = 1077;
            } else if (extension.equalsIgnoreCase("pcd")) {
                type = 1063;
            } else if (extension.equalsIgnoreCase("pcx")) {
                type = 1064;
            } else if (extension.equalsIgnoreCase("pic")) {
                type = 1065;
            } else if (extension.equalsIgnoreCase("png")) {
                type = 1066;
            } else if (extension.equalsIgnoreCase("pbm") || extension.equalsIgnoreCase("pgm") || extension.equalsIgnoreCase("ppm")) {
                type = 1067;
            } else if (extension.equalsIgnoreCase("psd")) {
                type = 1081;
            } else if (extension.equalsIgnoreCase("psp")) {
                type = 1083;
            } else if (extension.equalsIgnoreCase("bw") || extension.equalsIgnoreCase("rgb") || extension.equalsIgnoreCase("rgba") || extension.equalsIgnoreCase("sgi")) {
                type = 1068;
            } else if (extension.equalsIgnoreCase("tga")) {
                type = 1069;
            } else if (extension.equalsIgnoreCase("tif") || extension.equalsIgnoreCase("tiff")) {
                type = 1070;
            }
        }
        try {
            result = IL.ilLoadFromStream(url.openStream(), type);
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static boolean ilLoadFromStream(InputStream stream, int type) {
        boolean result = false;
        int bufferLength = 1000;
        int lastRead = 0;
        byte[] read = new byte[bufferLength];
        byte[] block = new byte[]{};
        BufferedInputStream buf = new BufferedInputStream(stream);
        try {
            do {
                if ((lastRead = buf.read(read)) == -1) continue;
                block = IL.appendByteArray(block, read, lastRead);
            } while (lastRead != -1);
            ByteBuffer lump = ByteBuffer.allocateDirect(block.length);
            lump.put(block);
            lump.flip();
            result = IL.ilLoadL(type, lump, block.length);
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private static byte[] appendByteArray(byte[] oldArray, byte[] copyArray, int length) {
        int oldLength = oldArray.length;
        byte[] newArray = new byte[oldLength + length];
        int i = 0;
        while (i < oldLength) {
            newArray[i] = oldArray[i];
            ++i;
        }
        i = 0;
        while (i < length) {
            newArray[i + oldLength] = copyArray[i];
            ++i;
        }
        return newArray;
    }

    public static boolean ilLoadL(int Type2, ByteBuffer Lump, int Size) {
        BufferChecks.checkDirect(Lump);
        return IL.nilLoadL(Type2, Lump, Lump.position(), Size);
    }

    public static native boolean nilLoadL(int var0, ByteBuffer var1, int var2, int var3);

    public static native boolean ilLoadPal(String var0);

    public static native boolean ilOriginFunc(int var0);

    public static native boolean ilOverlayImage(int var0, int var1, int var2, int var3);

    public static native void ilPopAttrib();

    public static native void ilPushAttrib(int var0);

    public static native boolean ilRemoveLoad(String var0);

    public static native boolean ilRemoveSave(String var0);

    public static native void ilResetMemory();

    public static native void ilResetRead();

    public static native void ilResetWrite();

    public static native boolean ilSave(int var0, String var1);

    public static native boolean ilSaveImage(String var0);

    public static int ilSaveL(int Type2, ByteBuffer Lump, int Size) {
        BufferChecks.checkDirect(Lump);
        return IL.nilSaveL(Type2, Lump, Lump.position(), Size);
    }

    public static native int nilSaveL(int var0, ByteBuffer var1, int var2, int var3);

    public static native boolean ilSavePal(String var0);

    public static boolean ilSetData(ByteBuffer Data) {
        BufferChecks.checkDirect(Data);
        return IL.nilSetData(Data, Data.position());
    }

    public static native boolean nilSetData(ByteBuffer var0, int var1);

    public static native boolean ilSetDuration(int var0);

    public static native void ilSetInteger(int var0, int var1);

    public static void ilSetPixels(int XOff, int YOff, int ZOff, int Width, int Height, int Depth, int Format, int Type2, ByteBuffer Data) {
        BufferChecks.checkDirect(Data);
        IL.nilSetPixels(XOff, YOff, ZOff, Width, Height, Depth, Format, Type2, Data, Data.position());
    }

    public static native void nilSetPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, ByteBuffer var8, int var9);

    public static native void ilSetString(int var0, String var1);

    public static native void ilShutDown();

    public static boolean ilTexImage(int Width, int Height, int Depth, byte Bpp, int Format, int Type2, ByteBuffer Data) {
        BufferChecks.checkDirect(Data);
        return IL.nilTexImage(Width, Height, Depth, Bpp, Format, Type2, Data, Data.position());
    }

    public static native boolean nilTexImage(int var0, int var1, int var2, byte var3, int var4, int var5, ByteBuffer var6, int var7);

    public static native boolean ilTypeFunc(int var0);

    public static native boolean ilLoadData(String var0, int var1, int var2, int var3, byte var4);

    public static boolean ilLoadDataL(ByteBuffer Lump, int Size, int Width, int Height, int Depth, byte Bpp) {
        BufferChecks.checkDirect(Lump);
        return IL.nilLoadDataL(Lump, Lump.position(), Size, Width, Height, Depth, Bpp);
    }

    public static native boolean nilLoadDataL(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5, byte var6);

    public static native boolean ilSaveData(String var0);

    public static void create() throws LWJGLException {
        if (!created) {
            IL.nCreate();
            IL.initNativeStubs();
            IL.ilInit();
            created = true;
        }
    }

    public static native void nCreate();
}

