/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.lwjgl.PlatformAdapter;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public final class Sys {
    public static final String VERSION = "0.94";
    public static final int LOW_PRIORITY = -1;
    public static final int NORMAL_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    public static final int REALTIME_PRIORITY = 2;
    private static String LIBRARY_NAME = "lwjgl";
    private static String PLATFORM;
    public static final boolean DEBUG;
    private static boolean initialized;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        DEBUG = Boolean.getBoolean("org.lwjgl.Sys.debug");
        Sys.initialize();
    }

    public static String getLibraryName() {
        return LIBRARY_NAME;
    }

    private Sys() {
    }

    public static void log(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        System.loadLibrary(LIBRARY_NAME);
        String native_version = Sys.getNativeLibraryVersion();
        if (!native_version.equals(VERSION)) {
            throw new LinkageError("Version mismatch: jar version is '0.94', native libary version is '" + native_version + "'");
        }
        Sys.setDebug(DEBUG);
        PLATFORM = System.getProperty("org.lwjgl.Sys.platform", "org.lwjgl.SwingAdapter");
    }

    private static native String getNativeLibraryVersion();

    private static native void setDebug(boolean var0);

    public static native long getTimerResolution();

    public static long getTime() {
        return Sys.ngetTime() & Long.MAX_VALUE;
    }

    private static native long ngetTime();

    public static native void setProcessPriority(int var0);

    public static void alert(String title, String message) {
        String osName;
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed(false);
        }
        if ((osName = System.getProperty("os.name")).startsWith("Windows")) {
            Sys.nAlert(title, message);
        } else {
            try {
                PlatformAdapter adapter = (PlatformAdapter)Class.forName(PLATFORM).newInstance();
                adapter.alert(title, message);
            }
            catch (Exception e) {
                Sys.log("Unable to display alert using: " + PLATFORM);
            }
        }
        if (grabbed) {
            Mouse.setGrabbed(true);
        }
    }

    private static native void nAlert(String var0, String var1);

    public static boolean openURL(String url) {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method lookupMethod = serviceManagerClass.getMethod("lookup", classArray);
            Object basicService = lookupMethod.invoke(serviceManagerClass, "javax.jnlp.BasicService");
            Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Class[] classArray2 = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            Method showDocumentMethod = basicServiceClass.getMethod("showDocument", classArray2);
            try {
                Boolean ret = (Boolean)showDocumentMethod.invoke(basicService, new URL(url));
                return ret;
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception ue) {
            return Display.getImplementation().openURL(url);
        }
    }

    public static String getClipboard() {
        try {
            PlatformAdapter adapter = (PlatformAdapter)Class.forName(PLATFORM).newInstance();
            return adapter.getClipboard();
        }
        catch (Throwable e) {
            Sys.log("Unable to get clipboard contents: " + e);
            return Sys.nGetClipboard();
        }
    }

    private static native String nGetClipboard();
}

