import objc
from Foundation import *
from AppKit import *
from PyObjCTools.KeyValueCoding import *
from PyObjCTools import NibClassBuilder, AppHelper
import math,random,time


#class CoreGraphics(object):
#	_module = None
#	def __getattr__(self, name):
#		cls = type(self)
#		if cls._module is None:
#			import CoreGraphics
#			cls._module = CoreGraphics
#			self.__dict__.update(CoreGraphics.__dict__)
#			del cls.__getattr__
#			return getattr(self, name)
#
#CoreGraphics = CoreGraphics()

def makeJigsawPoint(fx,fy,tx,ty,sx,sy,factor,ortofactor):
	return NSMakePoint(((tx-fx)*factor+fx)+ortofactor*sx,((ty-fy)*factor+fy)+ortofactor*sy)

def makeJigsawBezier(fx,fy,tx,ty):
	side = random.choice([-1,1])
	wall1move = random.random()*0.05-0.025
	wall2move = random.random()*0.05-0.025
	bumpmove = random.random()*0.1-0.05
	bumpskew = random.random()*0.1-0.05
	bumpin = random.random()*0.1+0.95
	bumpwidth = random.random()*0.05
	startbump = 0.375+bumpwidth+bumpmove
	endbump = 0.625-bumpwidth+bumpmove
	sx = side*(ty-fy)
	sy = side*(fx-tx)
	bp = []
	bp.append(NSMakePoint(fx,fy))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,0.2+wall1move,-0.035))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,0.3+wall1move,-0.035))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump,0))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump+0.1000,0.0833*bumpin))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump-0.2200+bumpskew,0.2083*bumpin))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump+0.1000+bumpskew,0.2500*bumpin))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump+0.4666+bumpskew,0.2083*bumpin))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,startbump+0.1000,0.0833*bumpin))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,endbump,0))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,endbump+0.2+wall2move,-0.035))
	bp.append(makeJigsawPoint(fx,fy,tx,ty,sx,sy,endbump+0.3+wall2move,-0.035))
	bp.append(NSMakePoint(tx,ty))
	return bp

def makeLineBezier(fx,fy,tx,ty):
	bp = []
	bp.append(NSMakePoint(fx,fy))
	bp.append(NSMakePoint(tx,ty))
	return bp

def appendSideToBezier(bp,side,reverse,num):
	if len(side)==2:
		if reverse==0:
			if num==1:
				bp.moveToPoint_(side[0])
			bp.lineToPoint_(side[1])
		else:
			if num==1:
				bp.moveToPoint_(side[1])
			bp.lineToPoint_(side[0])
		if num==2:
			bp.closePath()
	elif len(side)==13:
		if reverse==0:
			if num==1:
				bp.moveToPoint_(side[0])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[3],side[1],side[2])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[6],side[4],side[5])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[9],side[7],side[8])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[12],side[10],side[11])
		else:
			if num==1:
				bp.moveToPoint_(side[12])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[9],side[11],side[10])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[6],side[8],side[7])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[3],side[5],side[4])
			bp.curveToPoint_controlPoint1_controlPoint2_(side[0],side[2],side[1])
		if num==2:
			bp.closePath()

def makeJigsawShape(left,down,right,up):
	bp = NSBezierPath.bezierPath()
	appendSideToBezier(bp,left,0,1)
	appendSideToBezier(bp,down,0,0)
	appendSideToBezier(bp,right,1,0)
	appendSideToBezier(bp,up,1,2)
	return bp


NibClassBuilder.extractClasses("MainMenu")

class KeyWindow(NSWindow):
	def canBecomeKeyWindow(self):
		return True

class MiniImageWindow(NSWindow):
	def animationResizeTime_(self,rect):
		return 0.2

class MiniImageView(NSView):
	def drawRect_(self,rect):
		if self.image:
			imw,imh = self.image.size()
			self.image.drawInRect_fromRect_operation_fraction_(self.bounds(),NSMakeRect(0,0,imw,imh),NSCompositeSourceOver,1.0)
			(bw,bh) = self.bounds()[1]
			if self.climage:
				self.climage.compositeToPoint_operation_(NSMakePoint(5,bh-16),NSCompositeSourceOver)
				if self.closeispressed:
					bp = NSBezierPath.bezierPathWithOvalInRect_(NSMakeRect(5,bh-16,11,11))
					#NSColor.colorWithDeviceRed_green_blue_alpha_(0.3,0.3,0.3,0.4).set()
					NSColor.colorWithDeviceWhite_alpha_(0.2,0.3).set()
					bp.fill()
			gc = NSGraphicsContext.currentContext()
		#gc.setImageInterpolation_(NSImageInterpolationNone)
			gc.setShouldAntialias_(False)
			NSColor.colorWithDeviceWhite_alpha_(1.0,0.4).set()
			bp = NSBezierPath.bezierPath()
			bp.moveToPoint_(NSMakePoint(bw-2,1))
			bp.lineToPoint_(NSMakePoint(bw-2,1))
			bp.moveToPoint_(NSMakePoint(bw-6,1))
			bp.lineToPoint_(NSMakePoint(bw-2,5))
			bp.moveToPoint_(NSMakePoint(bw-10,1))
			bp.lineToPoint_(NSMakePoint(bw-2,9))
			bp.stroke()
			NSColor.colorWithDeviceWhite_alpha_(0.0,0.4).set()
			bp = NSBezierPath.bezierPath()
			bp.moveToPoint_(NSMakePoint(bw-3,1))
			bp.lineToPoint_(NSMakePoint(bw-2,2))
			bp.moveToPoint_(NSMakePoint(bw-7,1))
			bp.lineToPoint_(NSMakePoint(bw-2,6))
			bp.moveToPoint_(NSMakePoint(bw-11,1))
			bp.lineToPoint_(NSMakePoint(bw-2,10))
			bp.stroke()
			NSColor.colorWithDeviceWhite_alpha_(0.0,0.2).set()
			bp = NSBezierPath.bezierPath()
			bp.moveToPoint_(NSMakePoint(bw-4,1))
			bp.lineToPoint_(NSMakePoint(bw-2,3))
			bp.moveToPoint_(NSMakePoint(bw-8,1))
			bp.lineToPoint_(NSMakePoint(bw-2,7))
			bp.moveToPoint_(NSMakePoint(bw-12,1))
			bp.lineToPoint_(NSMakePoint(bw-2,11))
			bp.stroke()

	def setCloseImage(self,climage):
		self.climage = climage
		self.closeispressed = 0

	def setImage(self,image):
		self.image = image

	def setController(self,controller):
		self.controller = controller

	def acceptsFirstMouse_(self,event):
		return True

	def shouldDelayWindowOrderingForEvent_(self,event):
		return True

	def mouseDown_(self,event):
		AppHelper.NSApp().preventWindowOrdering()
		self.controller.hidePrefs_(self)
		self.controller.hideAbout_(self)
		(x,y) = event.locationInWindow()
		(w,h) = self.bounds()[1]
		if x>w-12 and y<12:
			self.resizing = 1
			self.dragging = 0
			(self.mvx,self.mvy) = (w-x,y)
		elif x>5 and x<16 and y>h-16 and y<h-5:
			self.resizing = 0
			self.dragging = 0
			self.closeispressed = 1
			self.setNeedsDisplayInRect_(NSMakeRect(5,h-16,11,11))
		else:
			self.resizing = 0
			self.dragging = 1
			(self.mvx,self.mvy) = (x,y)

	def mouseDragged_(self,event):
		(x,y) = event.locationInWindow()
		(w,h) = self.bounds()[1]
		window = self.window()
		parent = window.parentWindow()
		if parent and self.image:
			(imw,imh) = self.image.size()
			((fx,fy),(fw,fh)) = window.frame()
			((pfrx,pfry),(pfrw,pfrh)) = parent.frame()
			if self.dragging==1:
				(fx,fy) = (fx + x - self.mvx,fy + y - self.mvy)
				if fx<pfrx:
					fx=pfrx
				if fy<pfry:
					fy=pfry
				if fx+fw>pfrx+pfrw:
					fx = pfrx+pfrw-fw
				if fy+fh>pfry+pfrh:
					fy = pfry+pfrh-fh
				window.setFrameOrigin_(NSMakePoint(fx,fy))
			elif self.resizing==1:
				nfw = x + self.mvx
				nfh = fh + self.mvy - y
				if fy + fh - nfh < pfry:
					nfh = fy + fh - pfry
				if fx + nfw > pfrx + pfrw:
					nfw = pfrx + pfrw -fx
				if nfw>0:
					factorx = float(imw)/float(nfw)
				else:
					factorx = 5
				if nfh>0:
					factory = float(imh)/float(nfh)
				else:
					factory = 5
				factor = max(factorx,factory)
				if factor>5:
					factor=5
				if factor<2:
					factor=2
				nfw = int(imw/factor)
				nfh = int(imh/factor)
				fy = fy + fh - nfh
				window.setFrame_display_(NSMakeRect(fx,fy,nfw,nfh),True)
			else:
				if x>5 and x<16 and y>h-16 and y<h-5:
					if self.closeispressed == 0:
						self.closeispressed=1
						self.setNeedsDisplayInRect_(NSMakeRect(5,h-16,11,11))
				else:
					if self.closeispressed == 1:
						self.closeispressed=0
						self.setNeedsDisplayInRect_(NSMakeRect(5,h-16,11,11))

	def mouseUp_(self,event):
		if self.closeispressed==1:
			self.closeispressed = 0
			(w,h) = self.bounds()[1]
			self.setNeedsDisplayInRect_(NSMakeRect(5,h-16,11,11))
			self.controller.showMiniImage_(self)


class ImgView(NSView):
	def drawRect_(self,rect):
		if self.image:
			imw,imh = self.image.size()
			self.image.drawInRect_fromRect_operation_fraction_(self.bounds(),NSMakeRect(0,0,imw,imh),NSCompositeSourceOver,1.0)
	def setImage(self,image):
		self.image = image

class TimerView(NSView):
	def drawRect_(self,rect):
		if self.timermode>0:
			defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
			timerWithInfo = getKey(defaults, u'timerWithInfo')
			if timerWithInfo and self.descstr!="":
				descstr = self.descstr + '\n'
			else:
				descstr = ''
			if self.timermode==1:
				tc = int(self.timercnt)
				hr = self.timercnt/3600
				mi = (self.timercnt%3600)/60
				se = self.timercnt%60
				s = NSString.stringWithString_('%s%d:%02d:%02d (%d s)' % (descstr,hr,mi,se,tc))
			elif self.timermode==2:
				tc = int(self.timercnt)
				hr = tc/3600
				mi = (tc%3600)/60
				se = tc%60
				de = int(10*(self.timercnt - tc))
				s = NSString.stringWithString_('%s%d:%02d:%02d.%1d (%d.%1d s)' % (descstr,hr,mi,se,de,tc,de))
			elif self.timermode==3:
				s = NSString.stringWithString_('%s0:00:00 (0 s)' % (descstr))
			f = NSFont.systemFontOfSize_(16)
			p = NSMutableParagraphStyle.alloc().init()
			p.setParagraphStyle_(NSParagraphStyle.defaultParagraphStyle())
			p.setAlignment_(NSCenterTextAlignment)
			ssize = s.sizeWithAttributes_({NSFontAttributeName:f,NSParagraphStyleAttributeName:p})
			newfw = int(ssize[0])+1
			newfh = int(ssize[1])+1
			window = self.window()
			((fx,fy),(fw,fh)) = window.frame()
			if newfw!=fw or newfh!=fh:
				fx-=int((newfw-fw)/2)
				fy-=int((newfh-fh)/2)
				((pfrx,pfry),(pfrw,pfrh)) = self.parentframe
				if fx<pfrx:
					fx=pfrx
				if fy<pfry:
					fy=pfry
				if fx+newfw>pfrx+pfrw:
					fx = pfrx+pfrw-newfw
				if fy+newfh>pfry+pfrh:
					fy = pfry+pfrh-newfh
				window.setFrame_display_(NSMakeRect(fx,fy,newfw,newfh),True)
			else:
				timerColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'timerColor'))
				timerBgColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'timerBgColor'))
				timerBgColor.set()
				NSBezierPath.fillRect_(self.bounds())
				s.drawAtPoint_withAttributes_(NSMakePoint(0,0),{NSFontAttributeName:f,NSParagraphStyleAttributeName:p,NSForegroundColorAttributeName:timerColor})

	def myinit(self,parentframe):
		self.descstr = ""
		self.timerstart = time.time()
		self.timercnt = 0
		self.timermode = 3
		self.checkpos = 0
		self.parentframe = parentframe
		self.lock = NSLock.alloc().init()
		NSThread.detachNewThreadSelector_toTarget_withObject_(self.thread_,self,None)

#	def forcecheckpos(self):
#		self.checkpos = 1
#		self.setNeedsDisplay_(True)
#		self.displayIfNeeded()

	def setdescstr(self,descstr):
		self.descstr = descstr
		self.setNeedsDisplay_(True)
		self.displayIfNeeded()

	def thread_(self,userparam):
#		mypool = NSAutoreleasePool.alloc().init()
#		draincnt = 0
		while 1:
			self.lock.lock()
		        if self.timermode==1:
				tc = int(time.time() - self.timerstart)
				if tc>self.timercnt:
					self.timercnt=tc
					self.setNeedsDisplay_(True)
#					draincnt+=1
#					if draincnt>50:
#						draincnt = 0
#						mypool.drain()
			self.lock.unlock()
			time.sleep(0.1)
#		mypool.drain()

	def startTimer(self,timeroffset):
		self.lock.lock()
		self.timerstart = time.time()-timeroffset
		self.timercnt = -1
		self.timermode=1
		self.lock.unlock()
		#if self.timer:
		#	self.timer.invalidate()
		#self.timer = NSTimer.scheduledTimerWithTimeInterval_target_selector_userInfo_repeats_(1.0,self,self.tick_,None,1)

	def stopTimer(self):
		self.lock.lock()
		self.timermode=2
		self.timercnt = time.time() - self.timerstart
		self.setNeedsDisplay_(True)
		self.lock.unlock()
		#self.timer.invalidate()

	def resetTimer(self):
		self.lock.lock()
		self.timermode=3
		self.timercnt = 0
		self.setNeedsDisplay_(True)
		self.lock.unlock()
		self.displayIfNeeded()

	def getTimer(self):
		return time.time() - self.timerstart

	def setController(self,controller):
		self.controller = controller

	def mouseDown_(self,event):
		self.controller.hidePrefs_(self)
		self.controller.hideAbout_(self)
		(x,y) = event.locationInWindow()
		(w,h) = self.bounds()[1]
		(self.mvx,self.mvy) = (x,y)

	def mouseDragged_(self,event):
		(x,y) = event.locationInWindow()
		(w,h) = self.bounds()[1]
		window = self.window()
		parent = window.parentWindow()
		if parent:
			((fx,fy),(fw,fh)) = window.frame()
			((pfrx,pfry),(pfrw,pfrh)) = parent.frame()
			(fx,fy) = (fx + x - self.mvx,fy + y - self.mvy)
			if fx<pfrx:
				fx=pfrx
			if fy<pfry:
				fy=pfry
			if fx+fw>pfrx+pfrw:
				fx = pfrx+pfrw-fw
			if fy+fh>pfry+pfrh:
				fy = pfry+pfrh-fh
			window.setFrameOrigin_(NSMakePoint(fx,fy))


class BGView(NSView):
	def drawRect_(self,rect):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		backgroundColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'backgroundColor'))
		backgroundPicColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'backgroundPicColor'))
		frameColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'frameColor'))
		if self.puzzleframe:
			backgroundColor.set()
			bp = NSBezierPath.bezierPathWithRect_(self.bounds())
			gp = bp.bezierPathByReversingPath()
			gp.appendBezierPathWithRect_(self.puzzleframe)
			gp.fill()
			backgroundPicColor.set()
			NSBezierPath.fillRect_(self.puzzleframe)
			frameColor.set()
			NSBezierPath.strokeRect_(self.puzzleframe)
		else:
			backgroundColor.set()
			NSBezierPath.fillRect_(self.bounds())

	def setPuzzleFrame(self,frame):
		self.puzzleframe = frame

	def setController(self,controller):
		self.controller = controller


	def acceptsFirstMouse_(self,event):
		return True

	def shouldDelayWindowOrderingForEvent_(self,event):
		return True

	def mouseDown_(self,event):
		AppHelper.NSApp().preventWindowOrdering()
		self.controller.hidePrefs_(self)
		self.controller.hideAbout_(self)
#		NSCursor.closedHandCursor().set()
#		(self.dsx,self.dsy) = event.locationInWindow()
		#super(BGView, self).mouseDown_(event)
		#self.window().orderBack_(self)

#	def mouseDragged_(self,event):
#		window = self.window()
#		parent = window.parentWindow()
#		if parent:
#			(x,y) = window.convertBaseToScreen_(event.locationInWindow())
#			((pfrx,pfry),(pfrw,pfrh)) = parent.frame()
#			(fx,fy) = (x - self.dsx,y - self.dsy)
#			if fx>0:
#				fx=0
#			if fy>0:
#				fy=0
#			if fx<-200:
#				fx=-200
#			if fy<-200:
#				fy=-200
#			parent.setFrameOrigin_(NSMakePoint(fx,fy))

#	def mouseUp_(self,event):
#		NSCursor.arrowCursor().set()

#	def scrollWheel_(self,event):
#		dx = event.deltaX()
#		dy = event.deltaY()
#		window = self.window()
#		parent = window.parentWindow()
#		if parent:
#			((pfrx,pfry),(pfrw,pfrh)) = parent.frame()
#			fx = pfrx+dx
#			fy = pfry+dy
#			if fx>0:
#				fx=0
#			if fy>0:
#				fy=0
#			if fx<-200:
#				fx=-200
#			if fy<-200:
#				fy=-200
#			parent.setFrameOrigin_(NSMakePoint(fx,fy))
			

#class ProgressView(NSView):
#	def initWithFrame_(self, frame):
#		super(ProgressView, self).initWithFrame_(frame)
#		self.value = 0
#		return self

#	def drawRect_(self,rect):
#		NSColor.whiteColor().set()
#		bounds = self.bounds()
#		NSBezierPath.strokeRect_(bounds)
#		((x,y),(w,h)) = bounds
#		bar = NSMakeRect(x+2,y+2,(w-4)*self.value,h-4)
#		NSBezierPath.fillRect_(bar)
	
#	def setValue_(self,value):
#		self.value = value
#		self.setNeedsDisplay_(True)

#	def isOpaque(self):
#		return True

#
#  puzzle image:
#  +-------------------------+
#  |    |<-----sx------->|   |
#  |    |                |   |
#  |    +-----    -----+ --- |
#  |    |     \__/     | | ^ |
#  |    |              | | | |
#  |     \              \| | |
#  |      |     +        | sy|
#  |     /              /  | |
#  |    |      __      |   | |
#  |    |     /  \     |   | |
#  |    +-----    -----+ --- |
#  |    ^                    |
#  |    spx,spy (px,py rel.) |
#  +-------------------------+
#  ^
#  px,py (right pos <-> dx==px and dy==py)
#

class Puzzel:
	# shape
	# cachedimage
	# puzzelposition (x,y)
	# position (px,py)
	# size (sx,sy)
	# dstposition (dx,dy)
	# shapeposition (spx,spy) - relative to (px,py)
	# shapesize (ssx,ssy)
	# rottab 4*(shape,cachedimage,bevcachedimage,spx,spy,ssx,ssy)
	# angle (0-3) 0 - norm , 1 - 90 , 2 - 180 , 3 - 270
	def __init__(self,mainimage,x,y,shape,shmidx,shmidy,cimgsizex,cimgsizey):
		((bpx,bpy),(bpw,bph)) = NSIntegralRect(shape.bounds())
		movx,movy = shmidx-cimgsizex/2,shmidy-cimgsizey/2
		trans = NSAffineTransform.transform()
		trans.translateXBy_yBy_(-movx,-movy)
		shape.transformUsingAffineTransform_(trans)
		self.x = x
		self.y = y
		self.px = 0
		self.py = 0
		self.sx = cimgsizex
		self.sy = cimgsizey
		self.dx = movx
		self.dy = movy
		self.rottab = []
		self.angle = 0
		bevmoves=[(-1,-1),(-1,1),(1,1),(1,-1)]
		for i in xrange(1):
#			trans = NSAffineTransform.transform()
#			trans.translateXBy_yBy_(cimgsizex/2.0,cimgsizey/2.0)
#			trans.rotateByDegrees_(i*90)
#			trans.translateXBy_yBy_(-cimgsizex/2.0,-cimgsizey/2.0)
			rotshape = shape #trans.transformBezierPath_(shape)
			((spx,spy),(ssx,ssy)) = NSIntegralRect(rotshape.bounds())
			rpx = int(spx+ssx)
			rpy = int(spy+ssy)
			spx=int(spx)
			spy=int(spy)
			ssx=rpx - spx
			ssy=rpy - spy
			cachedimage = NSImage.alloc().initWithSize_(NSMakeSize(cimgsizex,cimgsizey))
			cachedimage.lockFocus()
#			trans.concat()
			shape.addClip()
			mainimage.compositeToPoint_fromRect_operation_(NSMakePoint(0,0),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver)
# for rotation - use slower function:
#			mainimage.drawInRect_fromRect_operation_fraction_(NSMakeRect(0,0,cimgsizex,cimgsizey),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver,1.0)
			NSColor.blackColor().set()
			shape.stroke()
			cachedimage.unlockFocus()
			cachedimage.setCacheMode_(NSImageCacheAlways)
			bevcachedimage = cachedimage.copyWithZone_(None)
#			bevcachedimage = NSImage.alloc().initWithSize_(NSMakeSize(cimgsizex,cimgsizey))
			bevcachedimage.lockFocus()
#			trans.concat()
			shape.addClip()
#			mainimage.compositeToPoint_fromRect_operation_(NSMakePoint(0,0),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver)
# for rotation - use slower function:
#			mainimage.drawInRect_fromRect_operation_fraction_(NSMakeRect(0,0,cimgsizex,cimgsizey),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver,1.0)
#			NSColor.blackColor().set()
#			shape.stroke()
			btrans = NSAffineTransform.transform()
			btrans.translateXBy_yBy_(bevmoves[i][0],bevmoves[i][1])
			shape_light1 = btrans.transformBezierPath_(shape)
			btrans.invert()
			shape_dark1 = btrans.transformBezierPath_(shape)
			btrans.invert()
			btrans.translateXBy_yBy_(bevmoves[i][0],bevmoves[i][1])
			shape_light2 = btrans.transformBezierPath_(shape)
			btrans.invert()
			shape_dark2 = btrans.transformBezierPath_(shape)
			NSColor.colorWithDeviceWhite_alpha_(1.0,0.25).set()
			shape_light2.stroke()
			NSColor.colorWithDeviceWhite_alpha_(1.0,0.5).set()
			shape_light1.stroke()
			NSColor.colorWithDeviceWhite_alpha_(0.0,0.25).set()
			shape_dark2.stroke()
			NSColor.colorWithDeviceWhite_alpha_(0.0,0.5).set()
			shape_dark1.stroke()
#			bevcachedbitmapimage = NSBitmapImageRep.alloc().initWithFocusedViewRect_(NSMakeRect(0,0,cimgsizex,cimgsizey))
			bevcachedimage.unlockFocus()
			bevcachedimage.setCacheMode_(NSImageCacheAlways)
#			if i==0 or i==2:
#			    ssx,ssy = bpw,bph
#			else:
#			    ssx,ssy = bph,bpw
#			spx,spy = bpx-movx,bpy-movy
#			print cachedbitmapimage
#			print bevcachedbitmapimage
#			print cachedimage
#			print bevcachedimage
			self.rottab.append((rotshape,cachedimage,bevcachedimage,spx,spy,ssx,ssy))
		self.shape,self.cachedimage,self.bevcachedimage,self.spx,self.spy,self.ssx,self.ssy = self.rottab[self.angle]

#		self.shape = shape
#		self.ssx = bpw
#		self.ssy = bph
#		self.spx = bpx-movx
#		self.spy = bpy-movy
#		self.cachedimage = NSImage.alloc().initWithSize_(NSMakeSize(cimgsizex,cimgsizey))
#		self.cachedimage.lockFocus()
#		shape.addClip()
#		mainimage.drawInRect_fromRect_operation_fraction_(NSMakeRect(0,0,cimgsizex,cimgsizey),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver,1.0)
#		NSColor.blackColor().set()
#		shape.stroke()
#		self.cachedimage.unlockFocus()
#		self.bevcachedimage = NSImage.alloc().initWithSize_(NSMakeSize(cimgsizex,cimgsizey))
#		self.bevcachedimage.lockFocus()
#		shape.addClip()
#		mainimage.drawInRect_fromRect_operation_fraction_(NSMakeRect(0,0,cimgsizex,cimgsizey),NSMakeRect(movx,movy,cimgsizex,cimgsizey),NSCompositeSourceOver,1.0)
#		NSColor.blackColor().set()
#		shape.stroke()
#		trans = NSAffineTransform.transform()
#		trans.translateXBy_yBy_(-1,-1)
#		shape_light1 = trans.transformBezierPath_(shape)
#		trans.invert()
#		shape_dark1 = trans.transformBezierPath_(shape)
#		trans.invert()
#		trans.translateXBy_yBy_(-1,-1)
#		shape_light2 = trans.transformBezierPath_(shape)
#		trans.invert()
#		shape_dark2 = trans.transformBezierPath_(shape)
#		NSColor.colorWithDeviceWhite_alpha_(1.0,0.25).set()
#		shape_light2.stroke()
#		NSColor.colorWithDeviceWhite_alpha_(1.0,0.5).set()
#		shape_light1.stroke()
#		NSColor.colorWithDeviceWhite_alpha_(0.0,0.25).set()
#		shape_dark2.stroke()
#		NSColor.colorWithDeviceWhite_alpha_(0.0,0.5).set()
#		shape_dark1.stroke()
#		self.bevcachedimage.unlockFocus()

#	def rotate(self,byangle):
#		self.angle += byangle
#		self.angle &= 3
#		self.shape,self.cachedimage,self.bevcachedimage,self.spx,self.spy,self.ssx,self.ssy = self.rottab[self.angle]

#	def intersect(self,rx,ry,rw,rh):
#		if rx+rw>=self.px and rx<=self.px+self.sx and ry+rh>=self.py and ry<=self.py+self.sy:
#			return True
#		else:
#			return False

#	def draw(self,rx,ry,rw,rh,bev):
#		if self.intersect(rx,ry,rw,rh):
#			print "draw %dx%d" % (self.x,self.y)
#			if bev:
#				self.bevcachedimage.dissolveToPoint_fraction_(NSMakePoint(self.px,self.py),1.0)
#				self.bevcachedimage.compositeToPoint_operation_(NSMakePoint(self.px,self.py),NSCompositeSourceOver)
#			else:
#				self.cachedimage.dissolveToPoint_fraction_(NSMakePoint(self.px,self.py),1.0)
#				self.cachedimage.compositeToPoint_operation_(NSMakePoint(self.px,self.py),NSCompositeSourceOver)

	def draw(self,bev):
		if bev:
#			self.bevcachedimage.drawAtPoint_(NSMakePoint(self.px,self.py))
#			self.bevcachedimage.dissolveToPoint_fraction_(NSMakePoint(self.px,self.py),1.0)
			self.bevcachedimage.compositeToPoint_operation_(NSMakePoint(self.px,self.py),NSCompositeSourceOver)
		else:
#			self.cachedimage.drawAtPoint_(NSMakePoint(self.px,self.py))
#			self.cachedimage.dissolveToPoint_fraction_(NSMakePoint(self.px,self.py),1.0)
			self.cachedimage.compositeToPoint_operation_(NSMakePoint(self.px,self.py),NSCompositeSourceOver)

	def drawmoved(self,bev,movpt):
		if bev:
			self.bevcachedimage.compositeToPoint_operation_(NSMakePoint(self.px-movpt[0],self.py-movpt[1]),NSCompositeSourceOver)
		else:
			self.cachedimage.compositeToPoint_operation_(NSMakePoint(self.px-movpt[0],self.py-movpt[1]),NSCompositeSourceOver)

#	def shadow(self,rx,ry,rw,rh):
#		if self.intersect(rx,ry,rw+10,rh+10):
#			NSColor.blackColor().set()
#			trans = NSAffineTransform.transform()
#			trans.translateXBy_yBy_(self.px,self.py)
#			shadowshape = trans.transformBezierPath_(self.shape)
#			shadowshape.fill()

	def hittest(self,x,y):
		self.hx,self.hy = x-self.px,y-self.py
		if self.hx>=0 and self.hx<self.sx and self.hy>=0 and self.hy<self.sy:
			if self.shape.containsPoint_(NSMakePoint(self.hx,self.hy)):
				return True
		return False

	def checkpoint(self,vx,vy,x,y):
		rx = x
		ry = y
		px,py = x-self.hx,y-self.hy
		if px<-self.spx:
			rx = self.hx-self.spx
		if py<-self.spy:
			ry = self.hy-self.spy
		if px>=vx-self.spx-self.ssx:
			rx = vx-self.spx-self.ssx+self.hx
		if py>=vy-self.spy-self.ssy:
			ry = vy-self.spy-self.ssy+self.hy
		return rx,ry

	def moveby(self,dx,dy):
		self.px,self.py = self.px+dx,self.py+dy

	def move(self,x,y):
		self.px,self.py = x-self.hx,y-self.hy

	def midpoint(self):
		return NSMakePoint(self.px+self.spx+self.ssx/2,self.py+self.spy+self.ssy/2)

	def setmidpointto(self,x,y):
		self.px = x-(self.spx+self.ssx/2)
		self.py = y-(self.spy+self.ssy/2)

	def rect(self):
		return NSMakeRect(self.px,self.py,self.sx,self.sy)

	def addrect(self,rect):
		if rect:
			return NSUnionRect(rect,self.rect())
		else:
			return self.rect()

	def getangle(self):
		return self.angle

	def aboutrightpos(self,ox,oy,r):
		ix,iy = self.px - ox,self.py - oy
		dx,dy = ix - self.dx,iy - self.dy
		return math.sqrt(dx*dx+dy*dy)<r

	def movevector(self,ox,oy):
		ix,iy = self.px - ox,self.py - oy
		dx,dy = ix - self.dx,iy - self.dy
		return (dx,dy)

	def setposmovedby(self,ox,oy,dx,dy):
		self.px = ox + dx + self.dx
		self.py = oy + dy + self.dy

	def positionindex(self):
		return (self.x,self.y)

	def setrightpos(self,ox,oy):
		self.px,self.py = int(self.dx + ox),int(self.dy + oy)

	def isonborder(self,vx,vy,ox,oy):
		(midpx,midpy) = self.midpoint()
		if midpx>=ox and midpx<=vx-ox and midpy>=oy and midpy<=vy-oy:
			return 0
		else:
			return 1

	def toborder(self,vx,vy,ox,oy):
		(midpx,midpy) = self.midpoint()
		rx = vx-ox
		ry = vy-oy
		if not (midpx>=ox and midpx<=rx and midpy>=oy and midpy<=ry):
			mvx=0
			mvy=0
			xmin = self.px+self.spx
			ymin = self.py+self.spy
			xmax = xmin + self.ssx
			ymax = ymin + self.ssy
			if xmax>ox and xmin<rx and ymax>oy and ymin<ry:
				onboard=1
			else:
				onboard=0
			if onboard:
				if midpx<ox:
					mvx = ox - xmax
				if midpx>rx:
					mvx = rx - xmin
				if midpy<oy:
					mvy = oy - ymax
				if midpy>ry:
					mvy = ry - ymin
			if abs(mvx)>abs(mvy):
				self.px+=mvx
			elif abs(mvy)>abs(mvx):
				self.py+=mvy
			else:
				self.px+=mvx
				self.py+=mvy



# bmode - 1 (random on border)
# bmode - 0 (just random)
	def randomposition(self,vx,vy,ox,oy,bmode):
		if bmode==0:
			mx = vx-self.ssx
			my = vy-self.ssy
			self.px = random.randint(0,mx)-self.spx
			self.py = random.randint(0,my)-self.spy
		else:
			if ox<=self.ssx:
				sizex=1
				movex=vx-self.ssx-1
			else:
				sizex=ox-self.ssx
				movex=vx-ox-1
			if oy<=self.ssy:
				sizey=1
				movey=vy-self.ssy-1
			else:
				sizey=oy-self.ssy
				movey=vy-oy-1
			corners = 4*sizex*sizey
			horizontal = 2*sizey*(movex-sizex)
			vertical = 2*sizex*(movey-sizey)
			all = corners + horizontal + vertical
			place = random.randint(0,all-1)
			if place<corners:
				place,corner = divmod(place,4)
				if (corner&1)==1:
					addx=movex
				else:
					addx=0
				if (corner&2)==2:
					addy=movey
				else:
					addy=0
				self.px,self.py = divmod(place,sizey)
				self.px += addx-self.spx
				self.py += addy-self.spy
			else:
				place-=corners
				if place<horizontal:
					place,half = divmod(place,2)
					addx=sizex
					addy=half*movey
					self.px,self.py = divmod(place,sizey)
					self.px+=addx-self.spx
					self.py+=addy-self.spy
				else:
					place-=horizontal
					place,half = divmod(place,2)
					addx=half*movex
					addy=sizey
					self.py,self.px = divmod(place,sizex)
					self.px+=addx-self.spx
					self.py+=addy-self.spy



class MainView(NibClassBuilder.AutoBaseClass):
	def createPuzzle(self,newpuzzle,lparr,lfarr):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		if newpuzzle==None:
			self.pieceSize = getKey(defaults, u'pieceSize')
		shuffleAlgorithm = getKey(defaults, u'shuffleAlgorithm')
		sensitivity = getKey(defaults, u'sensitivity')
		(w,h) = self.image.size()
		xc = int(round(w/self.pieceSize))
		yc = int(round(h/self.pieceSize))
		if xc<=0:
			xc=1
		if yc<=0:
			yc=1
		infostr = NSBundle.mainBundle().localizedStringForKey_value_table_("Info","image resolution: %d x %d\npuzzle matrix: %d x %d (%d)","")
		self.timerview.setdescstr(infostr % (w,h,xc,yc,xc*yc))
		tw = w/xc
		th = h/yc
		if newpuzzle==None:
			self.seed = int(random.random()*1000000000)
		random.seed(self.seed)
		# make grid
		grid = []
		for x in xrange(xc+1):
			grid.append([])
			for y in xrange(yc+1):
				alpha = (x*1.2)*math.pi+(y/6.0)*math.pi
				beta = (x/7.0)*math.pi+(y*1.3)*math.pi
				mvx = math.sin(alpha)*tw*0.05
				mvy = math.sin(beta)*th*0.05
				if x==0 or x==xc:
					mvx=0
				if y==0 or y==yc:
					mvy=0
				posx = x*tw+mvx
				posy = y*th+mvy
				grid[x].append((posx,posy))
		#make curves
		hcurves = []
		for x in xrange(xc):
			hcurves.append([])
			hcurves[x].append(makeLineBezier(grid[x][0][0],grid[x][0][1],grid[x+1][0][0],grid[x+1][0][1]))
			for y in xrange(yc-1):
				hcurves[x].append(makeJigsawBezier(grid[x][y+1][0],grid[x][y+1][1],grid[x+1][y+1][0],grid[x+1][y+1][1]))
			hcurves[x].append(makeLineBezier(grid[x][yc][0],grid[x][yc][1],grid[x+1][yc][0],grid[x+1][yc][1]))
		vcurves = []
		vcurves.append([])
		for y in xrange(yc):
			vcurves[0].append(makeLineBezier(grid[0][y][0],grid[0][y][1],grid[0][y+1][0],grid[0][y+1][1]))
		for x in xrange(xc-1):
			vcurves.append([])
			for y in xrange(yc):
				vcurves[x+1].append(makeJigsawBezier(grid[x+1][y][0],grid[x+1][y][1],grid[x+1][y+1][0],grid[x+1][y+1][1]))
		vcurves.append([])
		for y in xrange(yc):
			vcurves[xc].append(makeLineBezier(grid[xc][y][0],grid[xc][y][1],grid[xc][y+1][0],grid[xc][y+1][1]))
		# create shapes and calc cached image size
		puzzles_data=[]
		cimgsize = 0
		for y in xrange(yc):
			for x in xrange(xc):
				jshape = makeJigsawShape(vcurves[x][y],hcurves[x][y+1],vcurves[x+1][y],hcurves[x][y])
				shape = jshape.bezierPathByFlatteningPath()
				shmidx = int((grid[x][y][0]+grid[x][y+1][0]+grid[x+1][y+1][0]+grid[x+1][y][0])/4)
				shmidy = int((grid[x][y][1]+grid[x][y+1][1]+grid[x+1][y+1][1]+grid[x+1][y][1])/4)
#				shape.setCachesBezierPath_(True)
				puzzles_data.append((x,y,shape,shmidx,shmidy))
				((bpx,bpy),(bpw,bph)) = shape.bounds()
				half1 = (shmidx-bpx)+10
				half2 = (shmidy-bpy)+10
				half3 = (bpx+bpw-shmidx)+10
				half4 = (bpy+bph-shmidy)+10
				half = int(max(half1,half2,half3,half4))
				if half>cimgsize:
					cimgsize = half
		cimgsize*=2
		random.shuffle(puzzles_data)
		# create puzzles objects
		self.puzzles = xc*yc
		self.xc = xc
		self.yc = yc
		self.freepuzzles = []
		self.placedpuzzles = []
		self.draggedpuzzles = []
		self.radius = sensitivity*self.pieceSize/100
		viewx,viewy = self.frame()[1]
#		lt=time.time()
		if newpuzzle==None:
			self.newpuzzle = 1
			self.display()
			refreshcnt=0
			for x,y,shape,shmidx,shmidy in puzzles_data:
				puzzel = Puzzel(self.image,x,y,shape,shmidx,shmidy,cimgsize,cimgsize)
				puzzel.setrightpos(self.offx,self.offy)
				self.freepuzzles.append([puzzel])
				self.setNeedsDisplayInRect_(puzzel.rect())
				refreshcnt+=1
				if refreshcnt%20==0:
					self.displayIfNeeded()
				self.mainwindow.discardEventsMatchingMask_beforeEvent_(NSAnyEventMask,None)
		else:
			self.newpuzzle = newpuzzle
			self.display()
			pfarr = {}
			i=0
			for l in lfarr:
				for pi,mv in l:
					x = int(pi[0])
					y = int(pi[1])
					pfarr[(x,y)]=(i,mv)
				i+=1
				self.freepuzzles.append([])
			for x,y,shape,shmidx,shmidy in puzzles_data:
				puzzel = Puzzel(self.image,x,y,shape,shmidx,shmidy,cimgsize,cimgsize)
				if lparr.containsObject_((x,y)):
					puzzel.setrightpos(self.offx,self.offy)
					self.placedpuzzles.append(puzzel)
				else:
					if pfarr.has_key((x,y)):
						i,mv = pfarr[(x,y)]
						#print i,mv
						puzzel.setposmovedby(self.offx,self.offy,int(mv[0]),int(mv[1]))
						self.freepuzzles[i].append(puzzel)
					else:
						puzzel.setrightpos(self.offx,self.offy)
						#print (x,y)
						#print pfarr
						#print pfarr[(x,y)]
						#if shuffleAlgorithm==0 or shuffleAlgorithm==3:
						#    puzzel.randomposition(viewx,viewy,self.offx,self.offy,0)
						#else:
						#    puzzel.randomposition(viewx,viewy,self.offx,self.offy,1)
						self.freepuzzles.append([puzzel])
				self.setNeedsDisplayInRect_(puzzel.rect())
				self.displayIfNeeded()
			self.checkPuzzlePositions()
		self.display()

	def destroyPuzzle(self):
		self.placedpuzzles=[]
		self.freepuzzles=[]
		self.draggedpuzzles=[]
		self.showfullimage=0
		self.newpuzzle = 0
		self.display()

	def checkPuzzlePositions(self):
		(w,h) = self.bounds()[1]
		if self.newpuzzle:
			for l in self.freepuzzles:
				for p in l:
					p.setrightpos(self.offx,self.offy)
		else:
			for l in self.freepuzzles:
				for p in l:
					p.hittest(0,0)
				x,y = 0,0
				for p in l:
					x,y = p.checkpoint(w,h,x,y)
				for p in l:
					p.move(x,y)
		for p in self.placedpuzzles:
			p.setrightpos(self.offx,self.offy)

	def randomPuzzlePositions(self,mode):
		if mode<0 or mode>5:
			defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
			shuffleAlgorithm = getKey(defaults, u'shuffleAlgorithm')
		else:
			shuffleAlgorithm = int(mode)
		viewx,viewy = self.frame()[1]
		random.shuffle(self.freepuzzles)
		if shuffleAlgorithm>2:
			regular=1
			shuffleAlgorithm-=3
		else:
			regular=0
		if self.newpuzzle and shuffleAlgorithm==2:
			shuffleAlgorithm=1
		tomove = []
		for l in self.freepuzzles:
			if len(l)==1:
				if shuffleAlgorithm<2 or l[0].isonborder(viewx,viewy,self.offx,self.offy):
					tomove.append(l[0])
		if regular:
			num = len(tomove)
			if num==0:
				return
			if shuffleAlgorithm==0:
				area = viewx*viewy
				psiz = math.ceil(math.sqrt(area/num))	# start from square root
				notfound=1
				while notfound:				# and find best psiz
					rows = math.floor(viewy / psiz)
					cols = math.floor(viewx / psiz)
					if rows*cols>=num:
						notfound=0
					else:
						psiz-=1
				#rows = math.floor(viewy / psiz)
				ppr = num/rows
				sum = 0.0
				n = 0
				offy = (psiz+viewy - (rows*psiz)) / 2
				for i in xrange(int(rows)):
					sum+=ppr
					cols = round(sum-n)
					offx = (psiz+viewx - (cols*psiz)) / 2
					for j in xrange(int(cols)):
						tomove[n].setmidpointto(offx+psiz*j,offy+psiz*i)
						n+=1
			else:
				area = 2*(viewx*self.offy+viewy*self.offx)-4*(self.offx*self.offy)
				psiz = math.ceil(math.sqrt(area/num))	# start from square root
				if psiz<10: # too many pieces for given area - back to random mode
					for l in tomove:
						l.randomposition(viewx,viewy,self.offx,self.offy,1)
					return
				notfound=1
				while notfound:				# and find best psiz
					rows = math.floor(viewy / psiz)
					lrows = math.floor(self.offy / psiz)*2
					srows = rows - lrows
					lcols = math.floor(viewx / psiz)
					scols = math.floor(self.offx / psiz)*2
					#print psiz,lrows,lcols,srows,scols
					if psiz==1 or lrows*lcols+srows*scols>=num:
						notfound=0
					else:
						psiz-=1
				#rows = math.floor(viewy / psiz)
				hlrows = int(round(lrows/2))
				lnum = int(num * (lrows*lcols) / (lrows*lcols+srows*scols))
				snum = num - lnum
				#print lnum,snum
				lpsiz = psiz
				spsiz = psiz
				if lrows>0:
					lppr = (lnum/lrows)
					if lppr>0:
						lpsiz = math.floor(viewx/math.ceil(lppr))
				else:
					lppr = 0
				if srows>0:
					sppr = (snum/srows)/2.0
					if sppr>0:
						spsiz = math.floor(self.offx/math.ceil(sppr))
				else:
					sppr = 0
				sum = 0.0
				n = 0
				offy = (psiz+viewy - (rows*psiz)) / 2
				# upper rows
				for i in xrange(hlrows):
					#print i,"long up"
					sum+=lppr
					cols = round(sum-n)
					offx = (lpsiz+viewx - (cols*lpsiz)) / 2
					for j in xrange(int(cols)):
						tomove[n].setmidpointto(offx+lpsiz*j,offy+psiz*i)
						tomove[n].toborder(viewx,viewy,self.offx,self.offy)
						n+=1
				# bottom rows
				for i in xrange(int(rows)-hlrows,int(rows)):
					#print i,"long down"
					sum+=lppr
					cols = round(sum-n)
					offx = (lpsiz+viewx - (cols*lpsiz)) / 2
					for j in xrange(int(cols)):
						tomove[n].setmidpointto(offx+lpsiz*j,offy+psiz*i)
						tomove[n].toborder(viewx,viewy,self.offx,self.offy)
						n+=1
				# left side
				for i in xrange(hlrows,int(rows)-hlrows):
					#print i,"short left"
					sum+=sppr
					cols = round(sum-n)
					offx = (spsiz+self.offx - (cols*spsiz)) / 2
					for j in xrange(int(cols)):
						tomove[n].setmidpointto(offx+spsiz*j,offy+psiz*i)
						tomove[n].toborder(viewx,viewy,self.offx,self.offy)
						n+=1
				# right side
				for i in xrange(hlrows,int(rows)-hlrows):
					#print i,"short right"
					sum+=sppr
					cols = round(sum-n)
					offx = (spsiz+self.offx - (cols*spsiz)) / 2
					for j in xrange(int(cols)):
						tomove[n].setmidpointto(viewx-(offx+spsiz*j),offy+psiz*i)
						tomove[n].toborder(viewx,viewy,self.offx,self.offy)
						n+=1
			for l in tomove:
				l.hittest(0,0)
				x,y = l.checkpoint(viewx,viewy,0,0)
				if x!=0 or y!=0:
					l.move(x,y)
			random.shuffle(self.freepuzzles)
		else:
			for l in tomove:
				if shuffleAlgorithm==0:
					l.randomposition(viewx,viewy,self.offx,self.offy,0)
				else:
					l.randomposition(viewx,viewy,self.offx,self.offy,1)


#	def wantsDefaultClipping(self):
#		return 0

	def drawRect_(self,rect):
		#gc = NSGraphicsContext.currentContext()
		#gc.setImageInterpolation_(NSImageInterpolationNone)
#		gc.setShouldAntialias_(False)
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
# draw background
#		backgroundColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'backgroundColor'))
#		backgroundPicColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'backgroundPicColor'))
#		frameColor = NSUnarchiver.unarchiveObjectWithData_(getKey(defaults, u'frameColor'))
#		if self.image:
#			(imw,imh) = self.image.size()
#			puzzleframe = NSMakeRect(self.offx,self.offy,imw,imh)
#			backgroundColor.set()
#			bp = NSBezierPath.bezierPathWithRect_(self.bounds())
#			gp = bp.bezierPathByReversingPath()
#			gp.appendBezierPathWithRect_(puzzleframe)
#			gp.fill()
#			backgroundPicColor.set()
#			NSBezierPath.fillRect_(puzzleframe)
#			frameColor.set()
#			NSBezierPath.strokeRect_(puzzleframe)
#		else:
#			backgroundColor.set()
#			NSBezierPath.fillRect_(self.bounds())
# draw puzzles
		viewx,viewy = self.bounds()[1]
		beveledPieces = getKey(defaults, u'beveledPieces')
		shadowedPieces = getKey(defaults, u'shadowedPieces')
		if self.image:
			(imw,imh) = self.image.size()
			if self.showfullimage:
				self.image.dissolveToPoint_fraction_(NSMakePoint(self.offx,self.offy),1.0)
			if self.newpuzzle:
				f = NSFont.systemFontOfSize_(40)
				ls = NSBundle.mainBundle().localizedStringForKey_value_table_("Pieces","%d","")
				s = NSString.stringWithString_(ls % self.puzzles)
				siz = s.sizeWithAttributes_({NSFontAttributeName:f})
				if (siz[1]<self.offy+10):
				    s.drawAtPoint_withAttributes_(NSMakePoint(self.offx+(imw/2)-(siz[0]/2),self.offy+imh+4),{NSFontAttributeName:f})
				else:
				    s.drawAtPoint_withAttributes_(NSMakePoint(self.offx+(imw/2)-(siz[0]/2),self.offy+imh-siz[1]-4),{NSFontAttributeName:f})
#		NSColor.blackColor().set()
#		NSBezierPath.strokeRect_(NSMakeRect(0,0,viewx,viewy))

		for p in self.placedpuzzles:
			if NSIntersectsRect(rect,p.rect()):
				p.draw(beveledPieces)
		for l in self.freepuzzles:
			i=0
			for p in l:
				if NSIntersectsRect(rect,p.rect()):
					i=1
			if i:
				if shadowedPieces and self.newpuzzle==0:
					self.sho.set()
					for p in l:
						p.draw(beveledPieces)
					self.shn.set()
				for p in l:
					p.draw(beveledPieces)



#		sumrect = None
#		for p in self.draggedpuzzles:
#			sumrect = p.addrect(sumrect)
#		if sumrect:
#			self.cachedbitmapimage = NSBitmapImageRep.alloc().initWithFocusedViewRect_(self.bounds())
#			self.draggedcachedimage = NSImage.alloc().initWithSize_(sumrect[1])
#			self.draggedcachedimage.lockFocus()
#			if shadowedPieces and self.newpuzzle==0:
#				self.shs.set()
#				for p in self.draggedpuzzles:
#					p.drawmoved(beveledPieces,sumrect[0])
#				self.shn.set()
#			for p in self.draggedpuzzles:
#				p.drawmoved(beveledPieces,sumrect[0])
#			self.draggedcachedimage.unlockFocus()
#			self.draggedcachedimage.setCacheMode_(NSImageCacheAlways)
#			self.draggedcachedimage.compositeToPoint_operation_(NSMakePoint(sumrect[0][0],sumrect[0][1]),NSCompositeSourceOver)
#			self.draggedlastrect = sumrect


			#self.mywindow.cacheImageInRect_(sumrect)
			#if shadowedPieces and self.newpuzzle==0:
			#	self.shs.set()
			#	for p in self.draggedpuzzles:
			#		p.draw(beveledPieces)
			#	self.shn.set()
			#for p in self.draggedpuzzles:
			#	p.draw(beveledPieces)


	def redisplay_(self,sender):
		self.bgview.setNeedsDisplay_(True)
		self.setNeedsDisplay_(True)

	def redisplayPuzzles_(self,sender):
		self.setNeedsDisplay_(True)

	def redisplayBackground_(self,sender):
		self.bgview.setNeedsDisplay_(True)

	def redisplayTimer_(self,sender):
		self.timerview.setNeedsDisplay_(True)

#	def showImage_(self, sender):
#		self.showimage = 1-self.showimage
#		sender.setState_(self.showimage)
#		self.setNeedsDisplay_(True)

	def windowDidResize_(self,sender):
		(w,h)=self.frame()[1]
		if self.image:
			(imw,imh) = self.image.size()
			self.offx = int(round((w-imw)/2))
			self.offy = int(round((h-imh)/2))
		self.checkPuzzlePositions()
		self.setNeedsDisplay_(True)

	def rightMouseDown_(self, event):
		self.hidePrefs_(self)
		self.hideAbout_(self)
		pass
#		(x,y) = event.locationInWindow()
#		(w,h) = self.bounds()[1]
#		indx = range(len(self.freepuzzles))
#		indx.reverse()
#		for i in indx:
#			test=0
#			for p in self.freepuzzles[i]:
#				if p.hittest(x,y):
#					test=1
#			if test:
#				l = self.freepuzzles[i]
#				if len(l)==1:
#					del self.freepuzzles[i]
#					self.freepuzzles.append(l)
#					for p in l:
#						p.rotate(1)
#					for p in l:
#						p.hittest(0,0)
#					x,y = 0,0
#					for p in l:
#						x,y = p.checkpoint(w,h,x,y)
#					if x!=0 or y!=0:
#						for p in l:
#							self.setNeedsDisplayInRect_(p.rect())
#							p.move(x,y)
#					for p in l:
#						self.setNeedsDisplayInRect_(p.rect())
#				return

	def tryJoinFreeToDragged(self):
		joined=0
		tojoin = {}
		for p in self.draggedpuzzles:
			angle = p.getangle()
			pmvx,pmvy = p.movevector(self.offx,self.offy)
			pidx,pidy = p.positionindex()
			indx = range(len(self.freepuzzles))
			for i in indx:
				test=0
				for fp in self.freepuzzles[i]:
					if fp.getangle()==angle:
						fpmvx,fpmvy = fp.movevector(self.offx,self.offy)
						fpidx,fpidy = fp.positionindex()
						if (pidx==fpidx and (pidy-fpidy==1 or fpidy-pidy==1)) or (pidy==fpidy and (pidx-fpidx==1 or fpidx-pidx==1)):
							diffx,diffy = pmvx-fpmvx,pmvy-fpmvy
							if math.sqrt(diffx*diffx+diffy*diffy)<self.radius:
								test=1
				if test:
					tojoin[i]=(diffx,diffy);
		tojoinlist = tojoin.keys()
		tojoinlist.sort()
		tojoinlist.reverse()
		for i in tojoinlist:
			joined = 1
			for p in self.freepuzzles[i]:
				self.setNeedsDisplayInRect_(p.rect())
				p.moveby(tojoin[i][0],tojoin[i][1])
				self.draggedpuzzles.append(p)
			del self.freepuzzles[i]
		return joined

	def tryMatchDragged(self,restricted):
		placed=0
		for p in self.draggedpuzzles:
			if p.getangle()==0 and p.aboutrightpos(self.offx,self.offy,self.radius):
				if restricted==0:
					placed=1
				else:
					pidx,pidy = p.positionindex()
					if (pidx==0 or pidx==self.xc-1) and (pidy==0 or pidy==self.yc-1):	# corners could match instantly
						placed=1
					else:
						for fp in self.placedpuzzles:
							fpidx,fpidy = fp.positionindex()
							if (pidx==fpidx and (pidy-fpidy==1 or fpidy-pidy==1)) or (pidy==fpidy and (pidx-fpidx==1 or fpidx-pidx==1)):
								placed=1
		if placed:
			for p in self.draggedpuzzles:
				self.setNeedsDisplayInRect_(p.rect())
				p.setrightpos(self.offx,self.offy)
				self.setNeedsDisplayInRect_(p.rect())
				self.placedpuzzles.append(p)
		return placed

	def fixDraggedPosition(self):
		(w,h) = self.bounds()[1]
		for p in self.draggedpuzzles:
			p.hittest(0,0)
		x,y = 0,0
		for p in self.draggedpuzzles:
			x,y = p.checkpoint(w,h,x,y)
		if x!=0 or y!=0:
			for p in self.draggedpuzzles:
				self.setNeedsDisplayInRect_(p.rect())
				p.move(x,y)
		for p in self.draggedpuzzles:
			self.setNeedsDisplayInRect_(p.rect())

	def afterDraggingTest(self):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		matchType = getKey(defaults, u'matchType')
		joined = self.tryJoinFreeToDragged()
		placed = self.tryMatchDragged(matchType)
		if placed==0:
			self.freepuzzles.append(self.draggedpuzzles)
			self.fixDraggedPosition()
		self.draggedpuzzles=[]
		self.displayIfNeeded()
		self.dragview.setImage(None)
		#self.dragwin.setFrame_display_(NSMakeRect(0,0,0,0),False)
		self.dragwindow.orderOut_(self)
		if placed==1 and len(self.freepuzzles)==0:
			self.gameover()
		elif placed==1 or joined==1:
			self.click()

	def myEventLoop(self,i):
		(w,h) = self.bounds()[1]
		l = self.freepuzzles[i]
		self.draggedpuzzles = l
		del self.freepuzzles[i]
		#create dragged image
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		beveledPieces = getKey(defaults, u'beveledPieces')
		shadowedPieces = getKey(defaults, u'shadowedPieces')
		sumrect = None
		for p in self.draggedpuzzles:
			sumrect = p.addrect(sumrect)
		draggedimage = NSImage.alloc().initWithSize_(sumrect[1])
		draggedimage.lockFocus()
		if shadowedPieces:
			self.shs.set()
			for p in self.draggedpuzzles:
				p.drawmoved(beveledPieces,sumrect[0])
			self.shn.set()
		for p in self.draggedpuzzles:
			p.drawmoved(beveledPieces,sumrect[0])
		draggedimage.unlockFocus()
		#print "1"
		self.dragview.setImage(draggedimage)
		(winx,winy) = self.mainwindow.convertBaseToScreen_(sumrect[0])
		(winw,winh) = sumrect[1]
		self.dragwindow.setFrame_display_(NSMakeRect(winx,winy,winw,winh),True)
		self.dragview.display()
		#print "3"
		self.dragwindow.orderFront_(self)
		#self.dragwin.setHasShadow_(False)
		#print "4"
		#self.dragwin.makeKeyAndOrderFront_(self)
		#print "5"
		# redraw anything under draggedpuzzles
		#for p in l:
		#	self.setNeedsDisplayInRect_(p.rect())
		self.setNeedsDisplayInRect_(sumrect)
		self.displayIfNeeded()
		# event loop
		while True:
			event = self.mainwindow.nextEventMatchingMask_(NSLeftMouseUpMask|NSLeftMouseDraggedMask|NSLeftMouseDownMask)
			(x,y) = event.locationInWindow()
			type = event.type()
			if type==NSLeftMouseDragged:
				#self.miniimage.setFrame_display_(NSMakeRect(x+40,y+40,800,600),False)
				#print "step1 %f" % (time.time())
				for p in self.draggedpuzzles:
					x,y = p.checkpoint(w,h,x,y)
				for p in self.draggedpuzzles:
					p.move(x,y)
				sumrect = None
				for p in self.draggedpuzzles:
					sumrect = p.addrect(sumrect)
				#print sumrect
				origin = self.mainwindow.convertBaseToScreen_(sumrect[0])
				self.dragwindow.setFrameOrigin_(origin)
				#print "step2 %f" % (time.time())
				#self.lockFocus()
				#print "step3 %f" % (time.time())
				#NSBezierPath.bezierPathWithRect_(self.draggedlastrect).setClip()
				#self.draggedlastrect = sumrect
				#self.cachedbitmapimage.draw()
				#self.mywindow.restoreCachedImage()
				#self.mywindow.cacheImageInRect_(sumrect)
				#cachedbitmapimage = NSBitmapImageRep.alloc().initWithFocusedViewRect_(sumrect)
				#cachedbitmappoint = sumrect[0]
				#print "step4 %f" % (time.time())
				#NSBezierPath.bezierPathWithRect_(sumrect).setClip()
				#print "step5 %f" % (time.time())
				#self.draggedcachedimage.compositeToPoint_operation_(NSMakePoint(sumrect[0][0],sumrect[0][1]),NSCompositeSourceOver)
				#print "step6 %f" % (time.time())
				#self.unlockFocus()
				#print "step7 %f" % (time.time())
				#self.mywindow.flushWindow() #IfNeeded()
				#print "step8 %f" % (time.time())
			elif type==NSLeftMouseDown:
				pass
			elif type==NSLeftMouseUp:
				#self.draggedcachedimage = None
				#self.draggedlastrect = None
				#self.mywindow.discardCachedImage()
				self.afterDraggingTest()
				return

#virtual 
#	def bgEventLoop(self,event):
#		NSCursor.closedHandCursor().set()
#		dsx,dsy = event.locationInWindow()
#		while True:
#			event = self.mainwindow.nextEventMatchingMask_(NSLeftMouseUpMask|NSLeftMouseDraggedMask|NSLeftMouseDownMask)
#			type = event.type()
#			if type==NSLeftMouseDragged:
#				(x,y) = self.mainwindow.convertBaseToScreen_(event.locationInWindow())
#				((pfrx,pfry),(pfrw,pfrh)) = self.mainwindow.frame()
#				(fx,fy) = (x - dsx,y - dsy)
#				if fx>0:
#					fx=0
#				if fy>0:
#					fy=0
#				if fx<-200:
#					fx=-200
#				if fy<-200:
#					fy=-200
#				self.mainwindow.setFrameOrigin_(NSMakePoint(fx,fy))
#			elif type==NSLeftMouseDown:
#				pass
#			elif type==NSLeftMouseUp:
#				NSCursor.arrowCursor().set()
#				return
# ^^^ virtual

	def acceptsFirstMouse_(self,event):
		return True

#	def shouldDelayWindowOrderingForEvent_(self,event):
#		return True

	def mouseDown_(self, event):
		AppHelper.NSApp().preventWindowOrdering()
		if event.modifierFlags()&NSControlKeyMask:
			return self.rightMouseDown_(event)
		self.hidePrefs_(self)
		self.hideAbout_(self)
		(x,y) = event.locationInWindow()
		(sx,sy) = self.mainwindow.convertBaseToScreen_(NSMakePoint(x,y))
		(w,h) = self.bounds()[1]
		# on fullscreen mode - check if have to show or hide menu
		#if self.fullscreen:
		#	if (y>h-1 or y<2 or x>w-2 or x<1):
		#		if self.menuIsShown==0:
		#			NSMenu.setMenuBarVisible_(1)
		#			self.menuIsShown=1
		#			return
		#	else:
		#		if self.menuIsShown==1:
		#			NSMenu.setMenuBarVisible_(0)
		#			self.menuIsShown=0
		#			return
		# on 'newpuzzle' mode reshuffle puzzles (first click)
		if self.newpuzzle:
			self.randomPuzzlePositions(-1)
			self.newpuzzle=0
			self.setNeedsDisplay_(True)
			self.timerview.startTimer(0)
			self.ingameplay=1
			self.setUIModeProperly()
		# else try to drag puzzles
		else:
			# try to find puzzle to drag
			found=0
			i=len(self.freepuzzles)
			while i>0 and found==0:
				i-=1
				for p in self.freepuzzles[i]:
					if p.hittest(x,y):
						found=1
			if found:
				self.ingameplay=2	# something moved - ask for save
				self.myEventLoop(i)
# virtual screen:
#			else:
#				self.bgEventLoop(event)

# virtual screen:
#	def scrollWheel_(self,event):
#		dx = event.deltaX()
#		dy = event.deltaY()
#		((pfrx,pfry),(pfrw,pfrh)) = self.mainwindow.frame()
#		fx = pfrx+5*dx
#		fy = pfry-5*dy
#		if fx>0:
#			fx=0
#		if fy>0:
#			fy=0
#		if fx<-200:
#			fx=-200
#		if fy<-200:
#			fy=-200
#		self.mainwindow.setFrameOrigin_(NSMakePoint(fx,fy))

#	def keyDown_(self,event):
#		cc = event.keyCode()
#		if cc==123:
#			dx=-100
#			dy=0
#		elif cc==124:
#			dx=100
#			dy=0
#		elif cc==125:
#			dx=0
#			dy=-100
#		elif cc==126:
#			dx=0
#			dy=100
#		else:
#			return
#		(fx,fy) = self.mainwindow.frame()[0]
#		fx+=dx
#		fy+=dy
#		self.mainwindow.setFrameOrigin_(NSMakePoint(fx,fy))

#^^^ virtual


#	def keyUp_(self,event):
#		print "ala"

#	def flagsChanged_(self,event):
#		print event.modifierFlags()&NSControlKeyMask

#	def acceptsFirstMouse_(self,event):
#		return True

	def acceptsFirstResponder(self):
		return True

#	def isOpaque(self):
#		return True

#	def performKeyEquivalent_(self,event):
#		print event
#		return True


	def gameover(self):
		self.timerview.stopTimer()
		self.ingameplay=0
		self.setUIModeProperly()
		self.snd_jupi.play()
		self.freepuzzles=[]
		self.placedpuzzles=[]
		self.showfullimage=1
		self.setNeedsDisplay_(True)

	def click(self):
		self.snd_tuk.play()

	def setSensitivity_(self,sender):
		self.radius = sender.intValue()*self.pieceSize/100

	def setBackgroundTransparency_(self,sender):
		self.bgwindow.setAlphaValue_(sender.floatValue())

	def setPuzzlesTransparency_(self,sender):
		self.mainwindow.setAlphaValue_(sender.floatValue())

	def setDraggedPuzzleTransparency_(self,sender):
		self.dragwindow.setAlphaValue_(sender.floatValue())

	def setMiniImageTransparency_(self,sender):
		self.miniimagewindow.setAlphaValue_(sender.floatValue())

	def setUIModeProperly(self):
		if self.fullscreen:
			if self.ingameplay:
				defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
				menuAlwaysHidden = getKey(defaults, u'menuAlwaysHidden')
				if menuAlwaysHidden:
					SetSystemUIMode(kUIModeAllHidden,0)
				else:
					SetSystemUIMode(kUIModeAllHidden,kUIOptionAutoShowMenuBar)
			else:
				SetSystemUIMode(kUIModeAllHidden,kUIOptionAutoShowMenuBar)
		else:
			SetSystemUIMode(kUIModeNormal,0)


	def alwaysHiddenChanged_(self,sender):
		self.setUIModeProperly()

	def createWindows(self):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		bgTransparency = getKey(defaults, u'bgTransparency')
		piecesTransparency = getKey(defaults, u'piecesTransparency')
		draggedTransparency = getKey(defaults, u'draggedTransparency')
		miniimageTransparency = getKey(defaults, u'miniimageTransparency')
		self.miniimageIsShown = getKey(defaults, u'bgImage')
		self.timerIsShown = getKey(defaults, u'timer')
		self.setUIModeProperly()
		screen = NSScreen.mainScreen()
		if self.fullscreen:
			winframe = screen.frame()
		else:
			self.alwaysHiddenButton.setEnabled_(False)
			winframe = screen.visibleFrame()
		# for virtual screen :
		#((fx,fy),(fw,fh)) = winframe
		#winframe = NSMakeRect(fx-100,fy-100,fw+200,fh+200)

		self.mainwindow = KeyWindow.alloc().initWithContentRect_styleMask_backing_defer_(winframe,NSBorderlessWindowMask,NSBackingStoreBuffered,False)
		self.mainwindow.setBackgroundColor_(NSColor.clearColor())
		self.mainwindow.setAlphaValue_(piecesTransparency)
		self.mainwindow.setOpaque_(False)
		self.mainwindow.setHasShadow_(False)
		self.mainwindow.setMovableByWindowBackground_(False)
		self.mainwindow.setContentView_(self)
		self.mainwindow.useOptimizedDrawing_(True)
		self.mainwindow.setInitialFirstResponder_(self)
		self.mainwindow.setTitle_(u'Pacek')
		self.mainwindow.makeKeyAndOrderFront_(self)
		# background
		self.bgwindow = NSWindow.alloc().initWithContentRect_styleMask_backing_defer_(winframe,NSBorderlessWindowMask,NSBackingStoreBuffered,False)
		self.bgwindow.setBackgroundColor_(NSColor.clearColor())
		self.bgwindow.setAlphaValue_(bgTransparency)
		self.bgwindow.setOpaque_(False)
		self.bgwindow.setHasShadow_(False)
		self.bgwindow.setMovableByWindowBackground_(False)
		self.bgview = BGView.alloc().initWithFrame_(winframe)
		self.bgview.setPuzzleFrame(None)
		self.bgview.setController(self)
		self.bgwindow.setContentView_(self.bgview)
		self.bgwindow.useOptimizedDrawing_(True)
		self.bgwindow.makeKeyAndOrderFront_(self)
		self.mainwindow.addChildWindow_ordered_(self.bgwindow,NSWindowBelow)
		# self.bgwindow.setExcludedFromWindowsMenu_(True)
		# drag window
		frame = NSMakeRect(0,0,1,1)
		self.dragwindow = NSWindow.alloc().initWithContentRect_styleMask_backing_defer_(frame,NSBorderlessWindowMask,NSBackingStoreBuffered,False)
		self.dragwindow.setLevel_(NSFloatingWindowLevel)
		self.dragwindow.setBackgroundColor_(NSColor.clearColor())
		self.dragwindow.setAlphaValue_(draggedTransparency)
		self.dragwindow.setOpaque_(False)
		self.dragwindow.setHasShadow_(False)
		self.dragwindow.setMovableByWindowBackground_(False)
		self.dragview = ImgView.alloc().initWithFrame_(frame)
		self.dragview.setImage(None)
		self.dragwindow.setContentView_(self.dragview)
		self.dragwindow.useOptimizedDrawing_(True)
		self.dragwindow.setIgnoresMouseEvents_(True)
		self.dragwindow.orderOut_(self)
		#self.dragwindow.makeKeyAndOrderFront_(self)
		# mini image window
		((wfx,wfy),(wfw,wfh)) = winframe
		frame = NSMakeRect(wfx+wfw/2,wfy+wfh/2,1,1)
		self.miniimagewindow = MiniImageWindow.alloc().initWithContentRect_styleMask_backing_defer_(frame,NSBorderlessWindowMask,NSBackingStoreBuffered,False)
		self.miniimagewindow.setBackgroundColor_(NSColor.clearColor())
		self.miniimagewindow.setOpaque_(False)
		self.miniimagewindow.setAlphaValue_(miniimageTransparency)
		self.miniimagewindow.setHasShadow_(True)
		#self.miniimagewindow.setIgnoresMouseEvents_(True)
		#self.miniimagewindow.setMovableByWindowBackground_(False)
		self.miniimageview = MiniImageView.alloc().initWithFrame_(frame)
		self.miniimageview.setImage(None)
		self.miniimageview.setCloseImage(self.img_button)
		self.miniimageview.setController(self)
		self.miniimagewindow.setContentView_(self.miniimageview)
		self.miniimagewindow.useOptimizedDrawing_(True)
		if self.miniimageIsShown:
			self.miniimagewindow.orderFront_(self)
			#self.miniimagewindow.orderWindow_relativeTo_(self.mainwindow.windowNumber(),NSWindowAbove)
			self.mainwindow.addChildWindow_ordered_(self.miniimagewindow,NSWindowAbove)
			hideminiimagestr = NSBundle.mainBundle().localizedStringForKey_value_table_("HideMiniImage","Hide mini image","")
			self.miniimageMenuItem.setTitle_(hideminiimagestr)
		else:
			self.miniimagewindow.orderOut_(self)
			showminiimagestr = NSBundle.mainBundle().localizedStringForKey_value_table_("ShowMiniImage","Show mini image","")
			self.miniimageMenuItem.setTitle_(showminiimagestr)
		((wfx,wfy),(wfw,wfh)) = winframe
		frame = NSMakeRect(wfx+wfw/2,wfy+wfh,1,1)
		self.timerwindow = NSWindow.alloc().initWithContentRect_styleMask_backing_defer_(frame,NSBorderlessWindowMask,NSBackingStoreBuffered,False)
		self.timerwindow.setBackgroundColor_(NSColor.clearColor())
		self.timerwindow.setOpaque_(False)
		self.timerwindow.setAlphaValue_(1.0)	# setting transparency by timerColor
		self.timerwindow.setHasShadow_(False)
		#self.timerwindow.setMovableByWindowBackground_(True)
		self.timerview = TimerView.alloc().initWithFrame_(frame)
		self.timerview.myinit(winframe)
		self.timerview.setController(self)
		self.timerwindow.setContentView_(self.timerview)
		self.timerwindow.useOptimizedDrawing_(True)
		if self.timerIsShown:
			self.timerwindow.orderFront_(self)
			#self.miniimagewindow.orderWindow_relativeTo_(self.mainwindow.windowNumber(),NSWindowAbove)
			self.mainwindow.addChildWindow_ordered_(self.timerwindow,NSWindowAbove)
			#self.timerview.forcecheckpos()
			self.timerview.setNeedsDisplay_(True)
			hidetimerstr = NSBundle.mainBundle().localizedStringForKey_value_table_("HideTimer","Hide timer","")
			self.timerMenuItem.setTitle_(hidetimerstr)
		else:
			self.timerwindow.orderOut_(self)
			showtimerstr = NSBundle.mainBundle().localizedStringForKey_value_table_("ShowTimer","Show timer","")
			self.timerMenuItem.setTitle_(showtimerstr)

	def reshuffle_(self,sender):
		self.randomPuzzlePositions(sender.tag())
		self.setNeedsDisplay_(True)

	def hidePrefs_(self,sender):
		self.prefs.close()

	def showPrefs_(self,sender):
		self.prefs.makeKeyAndOrderFront_(self)

	def hideAbout_(self,sender):
		self.about.close()

	def showAbout_(self,sender):
		self.about.makeKeyAndOrderFront_(self)

	def showMainSite_(self,sender):
		main_site = NSBundle.mainBundle().localizedStringForKey_value_table_("MainSiteURL","http://pacek.gucio.pl","")
		guciourl = NSURL.URLWithString_(main_site)
		NSWorkspace.sharedWorkspace().openURL_(guciourl)	

	def setSizeFields_(self,type):
		if type==0:
			self.sizeXField.setEditable_(0)
			self.sizeXField.setEnabled_(0)
			self.sizeYField.setEditable_(0)
			self.sizeYField.setEnabled_(0)
			self.percentField.setEditable_(1)
			self.percentField.setEnabled_(1)
		else:
			self.sizeXField.setEditable_(1)
			self.sizeXField.setEnabled_(1)
			self.sizeYField.setEditable_(1)
			self.sizeYField.setEnabled_(1)
			self.percentField.setEditable_(0)
			self.percentField.setEnabled_(0)

	def checkimgsizes(self,imageSizeX,imageSizeY,imageSizePercent,w,h):
		try:
			imageSizePercent = int(imageSizePercent)
		except Exception:
			imageSizePercent = 100
		imagePercentSizeX = int((imageSizePercent*w)/100)
		imagePercentSizeY = int((imageSizePercent*h)/100)
		try:
			imageSizeX = int(imageSizeX)
		except Exception:
			imageSizeX = 0
		try:
			imageSizeY = int(imageSizeY)
		except Exception:
			imageSizeY = 0
		if imageSizeX<320:
			imageSizeX=320
		if imageSizeY<200:
			imageSizeY=200
		if imageSizeX>w:
			imageSizeX=w
		if imageSizeY>h:
			imageSizeY=h
		return (imageSizeX,imageSizeY,imagePercentSizeX,imagePercentSizeY)

	def calcimagesize(self,imageSizeX,imageSizeY,imageSizePercent,imageSizeType,limitType,resizeUp,w,h,imw,imh):
		isx,isy,ipsx,ipsy = self.checkimgsizes(imageSizeX,imageSizeY,imageSizePercent,w,h)
		if imageSizeType==0:
			lx = ipsx
			ly = ipsy
		elif imageSizeType==1:
			lx = isx
			ly = isy
		else:
			imw = 0
			imh = 0
		if imw>0 and imh>0:
			if limitType==1:
				maxarea = float(lx*ly)
				imgarea = float(imh*imw)
				limfactor = math.sqrt(maxarea/imgarea)
			else:
				xfactor = float(lx)/float(imw)
				yfactor = float(ly)/float(imh)
				if limitType==0:
					limfactor = min(xfactor,yfactor)
				else:
					limfactor = max(xfactor,yfactor)
			xmaxfactor = float(w)/float(imw)
			ymaxfactor = float(h)/float(imh)
			maxfactor = min(xmaxfactor,ymaxfactor)
			factor = min(maxfactor,limfactor)
			if resizeUp==0 and factor>1:
				factor=1
			imw *= factor
			imh *= factor
			imw = int(imw)
			imh = int(imh)
		else:
			imw = 0
			imh = 0
		return (imw,imh,lx,ly)

	def refreshScreenPreview_(self,sender):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		imageSizeX = getKey(defaults, u'imageSizeX')
		imageSizeY = getKey(defaults, u'imageSizeY')
		imageSizePercent = getKey(defaults, u'imageSizePercent')
		imageSizeType = getKey(defaults, u'imageSizeType')
		limitType = getKey(defaults, u'limitType')
		resizeUp = getKey(defaults, u'resizeUp')
		pSize = getKey(defaults, u'pieceSize')
		self.setSizeFields_(int(imageSizeType))
		(iw,ih) = self.screenPreview.bounds()[1]
		(sw,sh)=self.bounds()[1]
		wfactor = float(iw)/float(sw)
		hfactor = float(ih)/float(sh)
		factor = min(wfactor,hfactor)
		w = int(sw*factor)
		h = int(sh*factor)
		previmage = NSImage.alloc().initWithSize_(NSMakeSize(w,h))
		previmage.lockFocus()
		#isx,isy,ipsx,ipsy,isp = self.checkimgsizes(imageSizeX,imageSizeY,imageSizePercent,w,h)
		if self.newimage:
			imw = self.newimage.bestRepresentationForDevice_(None).pixelsWide()
			imh = self.newimage.bestRepresentationForDevice_(None).pixelsHigh()
		else:
			imw = 0
			imh = 0
		(imw,imh,lx,ly) = self.calcimagesize(imageSizeX,imageSizeY,imageSizePercent,imageSizeType,limitType,resizeUp,sw,sh,imw,imh)
		if self.newimage:
			xc = int(round(float(imw)/pSize))
			yc = int(round(float(imh)/pSize))
			if xc<=0:
				xc=1
			if yc<=0:
				yc=1
			infostr = NSBundle.mainBundle().localizedStringForKey_value_table_("Info","image resolution: %d x %d\npuzzle matrix: %d x %d (%d)","")
			self.screenDescription.setStringValue_(infostr % (imw,imh,xc,yc,xc*yc))
		else:
			noimgstr = NSBundle.mainBundle().localizedStringForKey_value_table_("NoImage","no image","")
			self.screenDescription.setStringValue_(noimgstr)
		imoffx = (sw - imw)/2
		imoffy = (sh - imh)/2
		loffx = (sw - lx)/2
		loffy = (sh - ly)/2
		imw *= factor
		imh *= factor
		lx *= factor
		ly *= factor
		imoffx *= factor
		imoffy *= factor
		loffx *= factor
		loffy *= factor
		if limitType==0:
			lbp = NSBezierPath.bezierPathWithRect_(NSMakeRect(loffx,loffy,lx,ly))
		elif limitType==1:
			larea = lx*ly
			kx = larea/h
			ky = larea/w
			koffx = (w-kx)/2
			koffy = (h-ky)/2
			curve = []
			for x in xrange(1,int(koffx)):
				y = (h-larea/(w-2*x))/2
				curve.append((x,y))
			lbp = NSBezierPath.bezierPath()
			lbp.moveToPoint_(NSMakePoint(0,koffy))
			lbp.lineToPoint_(NSMakePoint(0,h-koffy))
			for x,y in curve:
				lbp.lineToPoint_(NSMakePoint(x,h-y))
			lbp.lineToPoint_(NSMakePoint(koffx,h))
			lbp.lineToPoint_(NSMakePoint(w-koffx,h))
			curve.reverse()
			for x,y in curve:
				lbp.lineToPoint_(NSMakePoint(w-x,h-y))
			lbp.lineToPoint_(NSMakePoint(w,h-koffy))
			lbp.lineToPoint_(NSMakePoint(w,koffy))
			curve.reverse()
			for x,y in curve:
				lbp.lineToPoint_(NSMakePoint(w-x,y))
			lbp.lineToPoint_(NSMakePoint(w-koffx,0))
			lbp.lineToPoint_(NSMakePoint(koffx,0))
			curve.reverse()
			for x,y in curve:
				lbp.lineToPoint_(NSMakePoint(x,y))
			lbp.closePath()
		else:
			lbp = NSBezierPath.bezierPath()
			lbp.moveToPoint_(NSMakePoint(0,loffy))
			lbp.lineToPoint_(NSMakePoint(0,loffy+ly))
			lbp.lineToPoint_(NSMakePoint(loffx,loffy+ly))
			lbp.lineToPoint_(NSMakePoint(loffx,h))
			lbp.lineToPoint_(NSMakePoint(loffx+lx,h))
			lbp.lineToPoint_(NSMakePoint(loffx+lx,loffy+ly))
			lbp.lineToPoint_(NSMakePoint(w,loffy+ly))
			lbp.lineToPoint_(NSMakePoint(w,loffy))
			lbp.lineToPoint_(NSMakePoint(loffx+lx,loffy))
			lbp.lineToPoint_(NSMakePoint(loffx+lx,0))
			lbp.lineToPoint_(NSMakePoint(loffx,0))
			lbp.lineToPoint_(NSMakePoint(loffx,loffy))
			lbp.closePath()
		NSColor.colorWithDeviceRed_green_blue_alpha_(1.0,0.0,0.0,1.0).set()
		lbp.stroke()
		NSColor.colorWithDeviceRed_green_blue_alpha_(1.0,0.0,0.0,0.2).set()
		lbp.fill()
		ibp = NSBezierPath.bezierPathWithRect_(NSMakeRect(imoffx,imoffy,imw,imh))
		NSColor.colorWithDeviceRed_green_blue_alpha_(0.0,0.0,1.0,1.0).set()
		ibp.stroke()
		NSColor.colorWithDeviceRed_green_blue_alpha_(0.0,0.0,1.0,0.2).set()
		ibp.fill()
		gc = NSGraphicsContext.currentContext()
		#gc.setImageInterpolation_(NSImageInterpolationNone)
		gc.setShouldAntialias_(False)
		fr = NSBezierPath.bezierPathWithRect_(NSMakeRect(0,0,w-1,h-1))
		NSColor.colorWithDeviceWhite_alpha_(0.0,1.0).set()
		fr.stroke()
		previmage.unlockFocus()
		self.screenPreview.setImage_(previmage)

#	def sizeTypeChanged_(self,sender):
#		self.setSizeFields_(sender.selectedTag())

	def showMiniImage_(self,sender):
		if self.miniimageIsShown:
			self.mainwindow.removeChildWindow_(self.miniimagewindow)
			self.miniimagewindow.orderOut_(self)
			self.miniimageIsShown=0
			showminiimagestr = NSBundle.mainBundle().localizedStringForKey_value_table_("ShowMiniImage","Show mini image","")
			self.miniimageMenuItem.setTitle_(showminiimagestr)
		else:
			self.miniimagewindow.orderFront_(self)
			self.mainwindow.addChildWindow_ordered_(self.miniimagewindow,NSWindowAbove)
			self.miniimageIsShown=1
			hideminiimagestr = NSBundle.mainBundle().localizedStringForKey_value_table_("HideMiniImage","Hide mini image","")
			self.miniimageMenuItem.setTitle_(hideminiimagestr)
		pass

	def showTimer_(self,sender):
		if self.timerIsShown:
			self.mainwindow.removeChildWindow_(self.timerwindow)
			self.timerwindow.orderOut_(self)
			self.timerIsShown=0
			showtimerstr = NSBundle.mainBundle().localizedStringForKey_value_table_("ShowTimer","Show timer","")
			self.timerMenuItem.setTitle_(showtimerstr)
		else:
			self.timerwindow.orderFront_(self)
			self.mainwindow.addChildWindow_ordered_(self.timerwindow,NSWindowAbove)
			self.timerview.setNeedsDisplay_(True)
			#self.timerview.forcecheckpos()
			self.timerIsShown=1
			hidetimerstr = NSBundle.mainBundle().localizedStringForKey_value_table_("HideTimer","Hide timer","")
			self.timerMenuItem.setTitle_(hidetimerstr)

#	def windowWillClose_(self,sender):
#		self.mywindow.removeChildWindow_(self.miniimage)

	def saveStateWithCoder_(self,coder):
		coder.encodeObject_forKey_(self.newimage,u'Image')
		(imw,imh) = self.image.size()
		coder.encodeInt32_forKey_(imw,u'SizeX')
		coder.encodeInt32_forKey_(imh,u'SizeY')
		coder.encodeInt32_forKey_(self.pieceSize,u'PieceSize')
		coder.encodeInt32_forKey_(self.seed,u'Seed')
		coder.encodeDouble_forKey_(self.timerview.getTimer(),u'TimerValue')
		coder.encodeInt_forKey_(self.newpuzzle,u'NewPuzzle')
		parr = NSMutableArray.arrayWithCapacity_(len(self.placedpuzzles))
		for p in self.placedpuzzles:
			pi = p.positionindex()
			parr.addObject_(pi)
		coder.encodeObject_forKey_(parr,u'PlacedPuzzles')
		farr = NSMutableArray.arrayWithCapacity_(len(self.freepuzzles))
		for l in self.freepuzzles:
			parr = NSMutableArray.arrayWithCapacity_(len(l))
			for p in l:
				pi = p.positionindex()
				mv = p.movevector(self.offx,self.offy)
				parr.addObject_((pi,mv))
			farr.addObject_(parr)
		coder.encodeObject_forKey_(farr,u'FreePuzzles')

	def loadStateWithCoder_(self,coder):
		self.timerview.resetTimer()
		self.newimage = coder.decodeObjectForKey_(u'Image')
		imw = coder.decodeInt32ForKey_(u'SizeX')
		imh = coder.decodeInt32ForKey_(u'SizeY')
		self.pieceSize = coder.decodeInt32ForKey_(u'PieceSize')
		self.seed = coder.decodeInt32ForKey_(u'Seed')
		timervalue = coder.decodeDoubleForKey_(u'TimerValue')
		newpuzzle = coder.decodeIntForKey_(u'NewPuzzle')
		parr = coder.decodeObjectForKey_(u'PlacedPuzzles')
		farr = coder.decodeObjectForKey_(u'FreePuzzles')
		if len(parr)>0 or len(farr)>0:
			self.initNewPuzzle(imw,imh,newpuzzle,parr,farr)
			self.timerview.startTimer(timervalue)
			self.ingameplay=1
			self.setUIModeProperly()
		else:
			self.initNewPuzzle(imw,imh,1,parr,farr)

	def initNewPuzzle(self,limw,limh,newpuzzle,lparr,lfarr):
		self.ingameplay=0
		self.setUIModeProperly()
		self.refreshScreenPreview_(None)
		(w,h)=self.frame()[1]
		if limw!=None and limh!=None:
			imw=limw
			imh=limh
		else:
			defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
			imageSizeX = getKey(defaults, u'imageSizeX')
			imageSizeY = getKey(defaults, u'imageSizeY')
			imageSizeType = getKey(defaults, u'imageSizeType')
			imageSizePercent = getKey(defaults, u'imageSizePercent')
			limitType = getKey(defaults, u'limitType')
			resizeUp = getKey(defaults, u'resizeUp')
			imh = self.newimage.bestRepresentationForDevice_(None).pixelsHigh()
			imw = self.newimage.bestRepresentationForDevice_(None).pixelsWide()
			(imw,imh,lx,ly) = self.calcimagesize(imageSizeX,imageSizeY,imageSizePercent,imageSizeType,limitType,resizeUp,w,h,imw,imh)
#		print imw,imh
		self.offx = int((w-imw)/2)
		self.offy = int((h-imh)/2)
		self.image = self.newimage.copyWithZone_(None)
		self.image.setScalesWhenResized_(True)
		self.image.setSize_(NSMakeSize(imw,imh))
#		print self.image
#		print self.image.size()
		self.image.setCacheMode_(NSImageCacheAlways)
		self.destroyPuzzle()
		self.bgview.setPuzzleFrame(NSMakeRect(self.offx,self.offy,imw,imh))
		self.bgview.display()
		((origx,origy),(origw,origh)) = self.miniimagewindow.frame()
		((mwx,mwy),(mww,mwh)) = self.mainwindow.frame()
		#self.miniimagewindow.setMinSize_(NSMakeSize(imw/5,imh/5))
		#self.miniimagewindow.setMaxSize_(NSMakeSize(imw/2,imh/2))
		neww = imw/3
		newh = imh/3
		newx = int (origx - ((neww - origw) / 2))
		newy = int (origy - ((newh - origh) / 2))
		if newx<mwx:
			newx=mwx
		if newx+neww>mwx+mww:
			newx = mwx+mww - neww
		if newy<mwy:
			newy=mwy
		if newy+newh>mwy+mwh:
			newy = mwy+mwh - newh
		self.miniimagewindow.setFrame_display_(NSMakeRect(newx,newy,neww,newh),True)
		#self.miniimagewindow.setAspectRatio_(NSMakeSize(imw/20,imh/20))
#		self.miniimagewindow.setViewsNeedDisplay_(True)
		self.miniimageview.setImage(self.image)
		self.miniimageview.display()
		self.miniimagewindow.invalidateShadow()
		self.miniimagewindow.orderFront_(self)
		self.createPuzzle(newpuzzle,lparr,lfarr)
		self.setNeedsDisplay_(True)

	def showMessage(self,msg):
		a = NSAlert.alertWithMessageText_defaultButton_alternateButton_otherButton_informativeTextWithFormat_(msg,None,None,None,"")
		a.runModal()

	def trysave(self):
		if self.ingameplay==2:
			doyouwanttosavestr = NSBundle.mainBundle().localizedStringForKey_value_table_("DoYouWantToSave","Do you want to save current game ?","")
			cancelstr = NSBundle.mainBundle().localizedStringForKey_value_table_("Cancel","Cancel","")
			donotsavestr = NSBundle.mainBundle().localizedStringForKey_value_table_("DoNotSave","Don't Save","")
			savestr = NSBundle.mainBundle().localizedStringForKey_value_table_("Save","Save","")
			a = NSAlert.alertWithMessageText_defaultButton_alternateButton_otherButton_informativeTextWithFormat_(doyouwanttosavestr,savestr,donotsavestr,cancelstr,"")
			button = a.runModal()
			if button==NSAlertDefaultReturn:
				self.savePuzzle_(None)
				return 1
			if button==NSAlertAlternateReturn:
				return 1
			return 0
		else:
			return 1

	def newPuzzle_(self,sender):
		if self.newimage:
			if self.trysave():
				self.timerview.resetTimer()
				self.initNewPuzzle(None,None,None,None,None)
		else:
			noimageloadedstr = NSBundle.mainBundle().localizedStringForKey_value_table_("NoImageLoaded","No image loaded !","")
			self.showMessage(noimageloadedstr)

	def pasteImage_(self,sender):
		pboard = NSPasteboard.generalPasteboard()
#		types = pboard.types()
#		if types.containsObject_(NSTIFFPboardType):
		newimage = NSImage.alloc().initWithPasteboard_(pboard)  #.dataForType_(NSTIFFPboardType))
		if newimage and newimage.isValid():
			if self.trysave():
				self.timerview.resetTimer()
				self.newimage = newimage
				self.initNewPuzzle(None,None,None,None,None)
				self.filename = NSString.stringWithString_(u'new.puzz')
		else:
			badimagestr = NSBundle.mainBundle().localizedStringForKey_value_table_("BadImage","Unrecognised image type !","")
			self.showMessage(badimagestr)

	def loadPuzzle_(self,sender):
		if self.trysave():
			panel = NSOpenPanel.openPanel()
			panel.setCanChooseFiles_(True)
			panel.setCanChooseDirectories_(False)
			panel.setAllowsMultipleSelection_(False)
			types = NSArray.arrayWithObjects_(u'gif',u'png',u'jpg',u'jpeg',u'tif',u'tiff',u'pict',u'puzz',None)
			ret = panel.runModalForTypes_(types)
			if ret==NSOKButton:
				self.application_openFiles_(None,panel.filenames())

	def savePuzzle_(self,sender):
		if self.newimage and self.ingameplay:
			self.ingameplay=1;
			panel = NSSavePanel.savePanel()
			types = NSArray.arrayWithObjects_(u'puzz',None)
			panel.setAllowedFileTypes_(types)
			panel.setCanSelectHiddenExtension_(True)
			ret = panel.runModalForDirectory_file_(self.filename.stringByDeletingLastPathComponent(),self.filename.lastPathComponent().stringByDeletingPathExtension().stringByAppendingString_(u'.puzz'))
			if ret==NSFileHandlingPanelOKButton:
				file = panel.filename()
				data = NSMutableData.data()
				archiver = NSKeyedArchiver.alloc().initForWritingWithMutableData_(data)
				self.saveStateWithCoder_(archiver)
				archiver.finishEncoding()
				result = data.writeToFile_atomically_(file,True)
		else:
			nothingtosavestr = NSBundle.mainBundle().localizedStringForKey_value_table_("NothingToSave","Nothing to save !","")
			self.showMessage(nothingtosavestr)

	def applicationWillFinishLaunching_(self,noti):
		NSColor.setIgnoresAlpha_(False)
		NSColorPanel.sharedColorPanel().setShowsAlpha_(True)
		self.shn = NSShadow.alloc().init()
		self.sho = NSShadow.alloc().init()
		self.sho.setShadowBlurRadius_(3.0)
		self.sho.setShadowOffset_(NSMakeSize(-4.0,-4.0))
		self.shs = NSShadow.alloc().init()
		self.shs.setShadowBlurRadius_(4.0)
		self.shs.setShadowOffset_(NSMakeSize(-6.0,-6.0))
		self.ingameplay = 0
		self.pieceSize = 1
		self.placedpuzzles = []
		self.freepuzzles = []
		self.draggedpuzzles = []
#		self.showimage = 0
		self.newimage = None
		self.image = None
		self.puzzles = 0
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
#		self.showImageMenuItem.setState_(self.showimage)
		self.fullscreen = getKey(defaults, u'fullscreen')
		self.setSizeFields_(getKey(defaults, u'imageSizeType'))
		#self.fullscreenMenuItem.setState_(self.fullscreen)
		self.showfullimage = 0
		self.newpuzzle = 0
		path = NSBundle.mainBundle().pathForResource_ofType_(u'tuk',u'aiff')
		self.snd_tuk = NSSound.alloc().initWithContentsOfFile_byReference_(path,False)
		path = NSBundle.mainBundle().pathForResource_ofType_(u'jupi',u'aiff')
		self.snd_jupi = NSSound.alloc().initWithContentsOfFile_byReference_(path,False)
		path = NSBundle.mainBundle().pathForResource_ofType_(u'aquabutton',u'png')
		self.img_button = NSImage.alloc().initWithContentsOfFile_(path)
		self.createWindows()
		self.refreshScreenPreview_(None)
		#self.createDragWindow()
		#self.createMainWindow()
		#self.createBackgroundWindow()
		#self.createMiniImageWindow()
		#self.setmywindow()
		#self.myapp.preventWindowOrdering()

	def application_openFiles_(self,app,strings):
		file = strings[0]
		if file.hasSuffix_(u'.puzz'):
			data = NSData.dataWithContentsOfFile_(file)
			unarchiver = NSKeyedUnarchiver.alloc().initForReadingWithData_(data)
			self.loadStateWithCoder_(unarchiver)
			unarchiver.finishDecoding()
			self.filename = file #.lastPathComponent()
		else:
			newimage = NSImage.alloc().initWithContentsOfFile_(file)
			if newimage and newimage.isValid():
				self.newimage = newimage
				self.initNewPuzzle(None,None,None,None,None)
				self.filename = file #.lastPathComponent()

	def applicationDidFinishLaunching_(self,noti):
		defaults = NSUserDefaultsController.sharedUserDefaultsController().values()
		openFile = getKey(defaults, u'openFile')
		if openFile and self.newimage==None:
			self.loadPuzzle_(None)

	def applicationShouldTerminate_(self,sender):
		if self.newimage:
			if self.trysave():
				return NSTerminateNow
			else:
				return NSTerminateCancel
		else:
			return NSTerminateNow

# constants for SetSystemUIMode
kUIModeNormal = 0
kUIModeContentSuppressed = 1
kUIModeContentHidden = 2
kUIModeAllSuppressed = 4
kUIModeAllHidden = 3
kUIOptionAutoShowMenuBar = 1 << 0
kUIOptionDisableAppleMenu = 1 << 2
kUIOptionDisableProcessSwitch = 1 << 3
kUIOptionDisableForceQuit = 1 << 4
kUIOptionDisableSessionTerminate = 1 << 5
kUIOptionDisableHide = 1 << 6

# wrapped function
bundle = NSBundle.bundleWithPath_('/System/Library/Frameworks/Carbon.framework')
objc.loadBundleFunctions(bundle, globals(), (('SetSystemUIMode', 'III', "Sets the presentation mode for system-provided user interface elements."),))

dictionary = {}
dictionary[u'pieceSize']=50
dictionary[u'sensitivity']=15
dictionary[u'imageSizeType']=0
dictionary[u'imageSizePercent']=70
dictionary[u'imageSizeX']=800
dictionary[u'imageSizeY']=600
dictionary[u'limitType']=1
dictionary[u'matchType']=0
dictionary[u'resizeUp']=1
dictionary[u'bgTransparency']=1.0
dictionary[u'piecesTransparency']=1.0
dictionary[u'draggedTransparency']=1.0
dictionary[u'miniimageTransparency']=1.0
archivedBackgroundColor = NSArchiver.archivedDataWithRootObject_(NSColor.colorWithCalibratedWhite_alpha_(0.5,1.0))
dictionary[u'backgroundColor']=archivedBackgroundColor
archivedBackgroundPicColor = NSArchiver.archivedDataWithRootObject_(NSColor.colorWithCalibratedWhite_alpha_(0.7,1.0))
dictionary[u'backgroundPicColor']=archivedBackgroundPicColor
archivedFrameColor = NSArchiver.archivedDataWithRootObject_(NSColor.blackColor())
dictionary[u'frameColor']=archivedFrameColor
archivedTimerColor = NSArchiver.archivedDataWithRootObject_(NSColor.colorWithCalibratedWhite_alpha_(0.0,0.5))
dictionary[u'timerColor']=archivedTimerColor
archivedTimerColor = NSArchiver.archivedDataWithRootObject_(NSColor.colorWithCalibratedWhite_alpha_(1.0,0.3))
dictionary[u'timerBgColor']=archivedTimerColor
dictionary[u'menuAlwaysHidden']=0
dictionary[u'bgImage']=1
dictionary[u'timer']=1
dictionary[u'timerWithInfo']=0
dictionary[u'fullscreen']=1
dictionary[u'openFile']=1
dictionary[u'beveledPieces']=1
dictionary[u'shadowedPieces']=1
dictionary[u'shuffleAlgorithm']=5
NSUserDefaultsController.sharedUserDefaultsController().setInitialValues_(dictionary)

if __name__ == "__main__":
    AppHelper.runEventLoop()
