/*
	Oni.r
	October 03, 2000   10:09 pm
	Stefan
*/

/*---------- carb  Carbon on OS X launch information */

type 'carb' {
};

resource 'carb'(0) {
};

/*---------- DeRez'ed from Oni.rsrc */

data 'BNDL' (128) {
	$"4F6E 6921 0000 0001 4652 4546 0001 0000"            /* Oni!....FREF.... */
	$"0080 0001 0081 4943 4E23 0001 0000 0080"            /* ....ICN#..... */
	$"0001 0081"                                          /* ... */
};

data 'Oni!' (0, "Owner resource") {
	$"38A9 2032 3030 3020 5461 6B65 2032 2049"            /* 8 2000 Take 2 I */
	$"6E74 6572 6163 7469 7665 20A5 CA44 6576"            /* nteractive Dev */
	$"656C 6F70 6564 2062 7920 4275 6E67 6965"            /* eloped by Bungie */
	$"2053 6F66 7477 6172 65"                             /*  Software */
};

data 'FREF' (128) {
	$"4150 504C 0000 00"                                  /* APPL... */
};

data 'FREF' (129) {
	$"494E 5354 0001 00"                                  /* INST... */
};

data 'ICN#' (128) {
	$"FFFF FFFF E0FF FFE1 E07F FFE1 F0FF FF81"            /* . */
	$"F3CF FF83 FFC3 FEC7 FF83 FFFF FFBB FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF 81FF FFFF 81FF"            /*  */
	$"FFFF 01FF FFF7 04FF EFE7 00FF FFE7 003F"            /* ....? */
	$"DFC7 001F CFC2 03FF DFC2 078F CFE2 0FFF"            /* ..... */
	$"EFFA 1FD5 EFDE 358F EFC6 400F A720 001F"            /* .5@. .. */
	$"F700 000F F300 001F F300 001F B980 001D"            /* ........... */
	$"F800 003F FC22 003F EC03 C067 FFFF FFFF"            /* ..?".?.g */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};

data 'ICN#' (129) {
	$"1FFF FC00 1000 0600 1000 0500 1000 0480"            /* ............. */
	$"1000 0440 1000 0420 1000 07F0 1000 0010"            /* ...@... ....... */
	$"1000 0010 1000 6010 1000 4010 100F F010"            /* ......`...@.... */
	$"101E 7810 103E 1810 1070 1810 1060 0810"            /* ..x..>...p...`.. */
	$"1060 0810 1040 1810 1040 1010 1020 0010"            /* .`...@...@... .. */
	$"1000 4010 100F 0010 1000 0010 1000 0010"            /* ..@............. */
	$"1000 0010 1000 0010 1000 0010 1000 0010"            /* ................ */
	$"1000 0010 1000 0010 1000 0010 1FFF FFF0"            /* ............. */
	$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80"            /* ....... */
	$"1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
};

data 'icl8' (128) {
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FF87 DE5B 0C37 3731 B2F4 FFF4 F4F4 F4F4"            /* [.771 */
	$"F4F4 FFF4 F4F4 F4FF F4FF B20C 1231 37FF"            /* ..17 */
	$"FFFF AB13 3731 1237 37FD F4FF FEE0 FEE0"            /* .71.77 */
	$"EAF3 FEE0 FEE0 F3FE F4FE B237 3112 37EA"            /* 71.7 */
	$"FFFF E05C 3736 0D5B B2FF B287 FFF4 F4FE"            /* \76[ */
	$"F3DF F3F4 FFEA B2F4 FD12 3731 3737 5BFF"            /* .7177[ */
	$"FFFF FFFF 0D37 62FF FFF4 1331 86B2 FFF3"            /* 7b.1 */
	$"B287 FDFF FFFF FD62 8737 3112 3731 DFFF"            /* b71.71 */
	$"FFEA FFFF 62F3 FFFF EA62 0C37 1231 6262"            /* bb.7.1bb */
	$"FC62 FFFF FFF4 E05B 8E87 1231 0C8D FFFF"            /* b[.1. */
	$"FFFF EAFF FFEA FFFF B231 1231 370C 5CFF"            /* 1.17.\ */
	$"87FF FFEA FFFF FFFF F3B2 E062 5CFE FFFF"            /* b\ */
	$"FFFF FFEA FFFF FFFF 8013 86E0 8737 FFFF"            /* .7 */
	$"87EA FFFF FFEA FFF4 EAFE EAFF F3F3 FFFF"            /*  */
	$"FFFF FFFF EAFF FFFF 63FF EAFF 8EF3 FFFF"            /* c */
	$"FFFF FFFF EAFF FFEA FFF3 F3F3 E0EA FFFF"            /*  */
	$"FFFF EAFF FFFF EAFF FFFF FFFF EAFF EAFF"            /*  */
	$"FFB3 8982 655E B3FF FFFF E0FF EAFF FFFF"            /* e^ */
	$"FFEA FFFF FFFF FFEA FFEA FFFF FFEA FFFF"            /*  */
	$"B309 0F0F 330F 34FF FFEA FFFF FFFF EAFF"            /* ..3.4 */
	$"FFFF FFEA FFEA FFFF FFFF FFEA F489 FFF4"            /*  */
	$"830F 3934 0F34 0FE0 FFFF FFEA FFEA FFFF"            /* .94.4. */
	$"FFFF FFFF FFFF EAFF FFEA FFFF 5E5E FFFF"            /* ^^ */
	$"3910 0208 340F 335E FFFF FFFF FFFF FFEA"            /* 9...4.3^ */
	$"FFEA FFFF EAFF FFEA FFFF EADF 0F3A FFE0"            /* .: */
	$"3402 0802 0F3A 3310 E0FF EAFF FFEA FFFF"            /* 4....:3. */
	$"FFFF B334 F4FF FFFF FFFF FF34 0F5E FFE0"            /* 44.^ */
	$"0808 0208 0834 1533 3AEA FFFF EAFF FFFF"            /* .....4.3: */
	$"FFFF 5E5E FFEA FFFF EAFF 8933 0F5E EA89"            /* ^^3.^ */
	$"0802 0802 020F 3334 0F34 B3E0 FFFF FFFF"            /* ......34.4 */
	$"FFEA 343A FFFF FFFF FFFF 3310 333A FF5E"            /* 4:3.3:^ */
	$"0202 0208 0208 0909 3934 333A FFFF EAFF"            /* ......943: */
	$"FFFF 3339 FFFF FFEA E0FD 1033 0F0F FF33"            /* 39.3..3 */
	$"0802 0802 0802 5E8E 8364 653A ADFF FFFF"            /* ......^de: */
	$"FFFF 105E FFEA FFFF EA89 0F0F 020F DE33"            /* .^....3 */
	$"0808 0202 08AD E089 3A34 330F 65EA FFFF"            /* .....:43.e */
	$"FFFF 3333 FFFF EAFF FFF4 DF34 0809 5E34"            /* 334.^4 */
	$"0F08 020F FFFF FFEA F4AC DF5E 5EF4 89FF"            /* ....^^ */
	$"FFFF 3A10 FFFF FFFF EAFF EAF4 5E0F 3A33"            /* :.^.:3 */
	$"0908 33FF FFE9 FCD1 ACC2 2C3A 33DF 33FF"            /* .3Ѭ,:33 */
	$"EAB3 5E0F 89FF FFEA FEA0 F6AB E0FE 890F"            /* ^.. */
	$"3333 E0FD 00C2 2582 C2F5 3333 5E89 3AFF"            /* 33.%33^: */
	$"FFB3 830F 5EEA FFFF 88FA 2B09 3365 8802"            /* .^+3e. */
	$"0F65 3302 F532 322C 0F33 100F 895E 89EA"            /* .e3.22,.3..^ */
	$"FF58 8E34 0FE0 FFFF 3434 5E39 1033 0F0F"            /* X4.44^9.3.. */
	$"0202 0802 0802 0208 0208 093A 5E5E F4FF"            /* ..........:^^ */
	$"FF5E 3A5E 0F88 E0EA 0F0F 0908 0933 3409"            /* ^:^....34 */
	$"0802 0208 0208 0202 0802 0E34 DFFF EAFF"            /* ...........4 */
	$"FFFF F483 0F10 EAFF 340F 0802 020F 340E"            /* ..4.....4. */
	$"0202 0802 0802 0208 0202 095E FFFF FFFF"            /* ..........^ */
	$"FFE0 C8AA 3433 89F4 0F34 0802 080F 3909"            /* Ȫ43.4....9 */
	$"0208 0202 0802 0802 0802 0FFB D6F3 C0EA"            /* ........... */
	$"FF96 C0D0 5E0F 0FAD 3A0F 0F08 0F33 3409"            /* ^..:....34 */
	$"0802 0208 0208 0208 0208 33AD C1C9 96FF"            /* ..........3ɖ */
	$"FF80 82FB 880F 3433 3334 0F34 3910 0F08"            /* .4334.49... */
	$"0208 0201 0802 0202 0808 5EAC 8881 9DFF"            /* ..........^ */
	$"FF82 FAFA AD5E 0F15 340F 3A0F 3439 5E08"            /* ^..4.:.49^. */
	$"012C 0F08 0202 0808 0210 8888 FAFA FCFF"            /* .,........ */
	$"FFFA 5D7B 88B3 0F34 0F39 3334 0F34 AD65"            /* ]{.4.934.4e */
	$"5E65 0902 0802 0201 0F5E 82F6 F5C3 C8EA"            /* ^e......^ */
	$"EAFF FFFF F4EA EAFF FFEA FFFF FFFF FFF4"            /*  */
	$"FFF4 FFFF FFFF FFFF FFFF FFFF FFFF EAFF"            /*  */
};

data 'icl8' (129) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF FF00 0000 0000 0000 0000"            /* ......... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF 2BFF 0000 0000 0000 0000"            /* +........ */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF 2B2B FF00 0000 0000 0000"            /* ++....... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF 2B2B 2BFF 0000 0000 0000"            /* +++...... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF 2B2B 2B2B FF00 0000 0000"            /* ++++..... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5FF FFFF FFFF FFFF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F52B 2B2B F5F5 F5F5 F5F5 F5FF 0000 0000"            /* +++.... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F9FF FFF5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F52B F92B"            /* ...++ */
	$"F9FF F9F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 FFFF FFFF"            /* ... */
	$"FFFF FFFF F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 2BFF FFFF FFF9"            /* ...+ */
	$"F9FF FFFF FFF5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F52B FFFF FFFF FFF9"            /* ...+ */
	$"F5F5 F9FF FF2B F5F5 F5F5 F5FF 0000 0000"            /* +.... */
	$"0000 00FF F5F5 F5F5 F5FF FFFF F5F5 F9F9"            /* ... */
	$"F5F5 F5FF FFF9 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 2BFF FFF5 F5F5 F5F5"            /* ...+ */
	$"F5F5 F5F9 FFF9 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F9FF FFF5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F9 FFF9 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F9FF F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5FF FFF9 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F9FF F9F5 F5F5 F5F5"            /* ... */
	$"F5F5 F9FF F92B F5F5 F5F5 F5FF 0000 0000"            /* +.... */
	$"0000 00FF F5F5 F5F5 F9F9 ECF9 F5F5 F5F5"            /* ... */
	$"F5F9 F9F9 F9F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 2BF9 F9F9 F9F9 F9F9"            /* ...+ */
	$"F9EC F9F9 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F9 F9F9 ECEC ECEC"            /* ... */
	$"F9F9 F9F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 2BF9 F9F9 F9F9"            /* ...+ */
	$"F92B F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* +.... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 2B2B 2BF5"            /* ...+++ */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"            /* ... */
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"            /* .... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
};

data 'icl4' (128) {
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FEAD 0CCC FFFF FFFF FFFF FFFF FFF0 0CCF"            /* .. */
	$"FFEC CC0C CAFF FFFF FFFF FFFF FFFC C0CF"            /* . */
	$"FFFD CCCD FFFE FFFF FFFF FFFF A0CC CCDF"            /*  */
	$"FFFF CCDF FFCC 5FFF FEAF FFAD ECC0 CCFF"            /* _ */
	$"FFFF DFFF FD0C 0CDD EDFF FFFD AE0C 05FF"            /* .... */
	$"FFFF FFFF FC0C C0DF EFFF FFFF FFFD DFFF"            /* . */
	$"FFFF FFFF DC5F ECFF EFFF FFFF FFFF FFFF"            /* _ */
	$"FFFF FFFF BFFF AFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFAB ABFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF F122 D2BF FFFF FFFF"            /* "ҿ */
	$"FFFF FFFF FFFF FAFF A2BB 2B2F FFFF FFFF"            /* +/ */
	$"FFFF FFFF FFFF BBFF B20C B2DB FFFF FFFF"            /* . */
	$"FFFF FFFF FFFF 2BFF B0C0 2BD2 FFFF FFFF"            /* ++ */
	$"FFFB FFFF FFFB 2BFF CC0C CB2D BFFF FFFF"            /* +.- */
	$"FFBB FFFF FFAD 2BFA C0C0 02DB 2BFF FFFF"            /* +.+ */
	$"FFBB FFFF FFD2 DBFB 000C 0C11 BBDB FFFF"            /* .... */
	$"FFDB FFFF FA2D 22FD C0C0 C0BA ABAB AFFF"            /* -" */
	$"FF2B FFFF FA22 02AD CC00 CAFA BBD2 AFFF"            /* +"..ү */
	$"FFDD FFFF FFFB C1BB 2C02 FFFF FEFB BFAF"            /* ,. */
	$"FFB2 FFFF FFFF B2BD 1CDF FFEF E7CB DFDF"            /* . */
	$"FFB2 AFFF F8CE FFA2 DDFA 07CB 70DD BABF"            /* .pݺ */
	$"FFA2 BFFF EDC1 DAE0 2AD0 0CCC 2D22 ABAF"            /* *.-" */
	$"FBAB 2FFF BBBB 2D22 00C0 C00C 0C1B BBFF"            /* /-".... */
	$"FBBB 2EFF 221C 1DB1 C00C 0C00 C0CB FFFF"            /* ."..... */
	$"FFFA 22FF B2C0 02BC 00C0 C00C 001B FFFF"            /* "..... */
	$"FF95 BDAF 2BC0 C2B1 0C00 C0C0 C02E FF7F"            /* +±.... */
	$"F779 B22A B22C 2DB1 C00C 0C0C 0CDA 797F"            /* y*,-....y. */
	$"FDBE E2BD DB2B B22C 0C00 C000 CCBE ED7F"            /* +,...̾. */
	$"FBDD AB22 B2B2 BBBC 0C2C 00CC 02EE DDEF"            /* ݫ".,.. */
	$"FDBD EF2B 2BDB 2BAA BA10 C000 2BBC 089F"            /* +++..+. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};

data 'icl4' (129) {
	$"000F FFFF FFFF FFFF FFFF FF00 0000 0000"            /* ....... */
	$"000F 0000 0000 0000 0000 0FF0 0000 0000"            /* ............... */
	$"000F 0000 0000 0000 0000 0FCF 0000 0000"            /* ............... */
	$"000F 0000 0000 0000 0000 0FCC F000 0000"            /* .............. */
	$"000F 0000 0000 0000 0000 0FCC CF00 0000"            /* .............. */
	$"000F 0000 0000 0000 0000 0FCC CCF0 0000"            /* ............. */
	$"000F 0000 0000 0000 0000 0FFF FFFF 0000"            /* ............. */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0CCC 0000 000F 0000"            /* ............... */
	$"000F 0000 0000 0000 DFF0 0000 000F 0000"            /* .............. */
	$"000F 0000 0000 0CDC DFD0 0000 000F 0000"            /* ............. */
	$"000F 0000 0000 FFFF FFFF 0000 000F 0000"            /* ............ */
	$"000F 0000 00CF FFFD DFFF F000 000F 0000"            /* .......... */
	$"000F 0000 0CFF FFFD 00DF FC00 000F 0000"            /* ........... */
	$"000F 0000 0FFF 00DD 000F FD00 000F 0000"            /* ............. */
	$"000F 0000 CFF0 0000 000D FD00 000F 0000"            /* ............ */
	$"000F 0000 DFF0 0000 000D FD00 000F 0000"            /* ............ */
	$"000F 0000 DF00 0000 000F FD00 000F 0000"            /* .............. */
	$"000F 0000 DFD0 0000 00DF DC00 000F 0000"            /* ............ */
	$"000F 0000 DD6D 0000 0DDD D000 000F 0000"            /* ....m....... */
	$"000F 0000 CDDD DDDD D6DD 0000 000F 0000"            /* .......... */
	$"000F 0000 0DDD 6666 DDD0 0000 000F 0000"            /* ....ff...... */
	$"000F 0000 00CD DDDD DC00 0000 000F 0000"            /* ............ */
	$"000F 0000 0000 CCC0 0000 0000 000F 0000"            /* .............. */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F 0000 0000 0000 0000 0000 000F 0000"            /* ................ */
	$"000F FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* .... */
};

data 'ics#' (128) {
	$"FFFF CFFD FBFB FFFF FFFF FF9F FF3F FF0F"            /* ?. */
	$"FB1F FD3F FB77 FF87 F007 F807 E507 FFFF"            /* .?w... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};

data 'ics#' (129) {
	$"7FF0 4038 402C 403C 40C4 43C4 47E4 4C64"            /* .@8@,@<@CGLd */
	$"4C64 4C44 4384 4004 4004 4004 4004 7FFC"            /* LdLDC@.@.@.@.. */
	$"7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
	$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
};

data 'ics4' (128) {
	$"FFFF FFFF FFFF FFFF FFCD FFFF FFFF FFCF"            /*  */
	$"FFFF FCFF EFFA AC5F FFFF FFEF FFFF FFFF"            /* _ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FBBF FFFF"            /*  */
	$"FFFF FFBF BCBB FFFF FFFF FFBF CCBB FFFF"            /* ̻ */
	$"FBFF FDBF CCCA AAFF FBFF FF2A 22FF FFFF"            /* ʪ*" */
	$"FBFF FCFA DFFE 0BFF FAFF DBAE AD0C DBAF"            /* .ۮ.ۯ */
	$"FFEF B1DB CCCC CBFF F9BF B2DB CCCC CEFF"            /*  */
	$"FEAB BBBB C2CC 2EDF FFFF FFFF FFFF FFFF"            /* . */
};

data 'ics4' (129) {
	$"0FFF FFFF FFFF 0000 0F00 0000 00FF F000"            /* ......... */
	$"0F00 0000 00FC FF00 0F00 0000 00FF FF00"            /* ............ */
	$"0F00 0000 FF00 0F00 0F00 00FF FF00 0F00"            /* ............. */
	$"0F00 0FFF FFF0 0F00 0F00 FF0D 0FF0 0F00"            /* .......... */
	$"0F00 FF00 0FF0 0F00 0F00 FD00 DFD0 0F00"            /* ........... */
	$"0F00 DDDD DD00 0F00 0F00 0DDD D000 0F00"            /* .......... */
	$"0F00 0000 0000 0F00 0F00 0000 0000 0F00"            /* ................ */
	$"0F00 0000 0000 0F00 0FFF FFFF FFFF FF00"            /* .......... */
};

data 'ics8' (128) {
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFE0 375B FFFF FFFE F3FE FFFE FEB2 37FF"            /* 7[7 */
	$"FFFF F3FF FF37 B2FF FCFF FFFD 8E31 8DFF"            /* 71 */
	$"FFFF FFFF B2E0 87FF FFFF FFFF FEFF FEFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF B339 34FF FFFF FFFF"            /* 94 */
	$"FFFF FFFF FFFF 5EFF 3908 3A5E FFFF FFFF"            /* ^9.:^ */
	$"FFB3 FFFF FFFF 5EFF 0808 3434 EAFF FFFF"            /* ^..44 */
	$"FF3A FFFF FF33 3AFF 0808 088E 8365 FFFF"            /* :3:...e */
	$"FF5E FFFF FFDF 0FDE 0F0F FFFF F4DF F4FF"            /* ^... */
	$"FF5E FFFF FFF6 FE89 33FF FFFC F53A DFFF"            /* ^3: */
	$"FF8E EAFF FA5E 6588 6533 F532 333A 89FF"            /* ^ee323: */
	$"FFF4 88FF 3409 3334 0808 0808 085E FFFF"            /* 434.....^ */
	$"FFD0 5EF4 3A0F 3339 0808 0808 08FB F3FF"            /* ^:.39..... */
	$"FFFB AD34 343A 395E 2C0F 0808 10AC FAFF"            /* 44:9^,.... */
	$"FFFF F4FF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};

data 'ics8' (129) {
	$"00FF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* ..... */
	$"00FF F5F5 F5F5 F5F5 F5F5 FFFF FF00 0000"            /* .... */
	$"00FF F5F5 F5F5 F5F5 F5F5 FF2B FFFF 0000"            /* .+.. */
	$"00FF F5F5 F5F5 F5F5 F5F5 FFFF FFFF 0000"            /* ... */
	$"00FF F5F5 F5F5 F5F5 FFFF F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5F5 FFFF FFFF F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5FF FFFF FFFF FFF5 F5FF 0000"            /* ... */
	$"00FF F5F5 FFFF F5F9 F5FF FFF5 F5FF 0000"            /* ... */
	$"00FF F5F5 FFFF F5F5 F5FF FFF5 F5FF 0000"            /* ... */
	$"00FF F5F5 FFF9 F5F5 F9FF F9F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F9F9 F9F9 F9F9 F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5F9 F9F9 F9F5 F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"            /* ... */
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000"            /* ... */
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* ... */
};

data 'STR ' (1001, "balloon") {
	$"6449 6E20 6120 6461 726B 2066 7574 7572"            /* dIn a dark futur */
	$"652E 2E2E 2077 6974 6820 616E 2075 6E63"            /* e... with an unc */
	$"6572 7461 696E 2070 6173 742E 2E2E 2074"            /* ertain past... t */
	$"6865 7265 2773 206E 6F20 6F6E 6520 6C65"            /* here's no one le */
	$"6674 2074 6F20 7472 7573 742E 2041 6E64"            /* ft to trust. And */
	$"206D 7920 6D6F 6465 6D20 6973 206F 6E20"            /*  my modem is on  */
	$"6669 7265 21"                                       /* fire! */
};

data 'STR ' (1000, "key config file") {
	$"0E6B 6579 5F63 6F6E 6669 672E 7478 74"              /* .key_config.txt */
};

data 'STR ' (1002, "Command line args") {
	$"00"                                                 /* . */
};

data 'hfdr' (-5696) {
	$"0002 0000 0000 0000 0000 0001 0006 0007"            /* ................ */
	$"03E9"                                               /* . */
};

data 'ALRT' (128, "OK for resolution to change") {
	$"0028 0028 00B4 0154 0080 5555 A80A"                 /* .(.(..T.UU. */
};

data 'ALRT' (129, "Abort-Retry-Ignore") {
	$"0028 0028 00F0 0118 0081 5555 A80A"                 /* .(.(....UU. */
};

data 'ALRT' (130, "OK") {
	$"0028 0028 00F0 0118 0082 5555 A80A"                 /* .(.(....UU. */
};

data 'ALRT' (131, "OK-Cancel") {
	$"0028 0028 00F0 0118 0083 5555 A80A"                 /* .(.(....UU. */
};

data 'ALRT' (132, "Retry-Cancel") {
	$"0028 0028 00F0 0118 0084 5555 A80A"                 /* .(.(....UU. */
};

data 'ALRT' (133, "Yes-No") {
	$"0028 0028 00F0 0118 0085 5555 A80A"                 /* .(.(....UU. */
};

data 'ALRT' (134, "Yes-No-Cancel") {
	$"0028 0028 00F0 0118 0086 5555 A80A"                 /* .(.(....UU. */
};

data 'DITL' (128, "OK for resolution to change") {
	$"0002 0000 0000 0064 003C 0078 0078 0402"            /* .......d.<.x.x.. */
	$"4F4B 0000 0000 0064 00B4 0078 00F0 0406"            /* OK.....d..x... */
	$"4361 6E63 656C 0000 0000 000A 0028 005A"            /* Cancel.......(.Z */
	$"0104 889A 5468 6520 7365 7474 696E 6720"            /* ..The setting  */
	$"666F 7220 796F 7572 206D 6F6E 6974 6F72"            /* for your monitor */
	$"2068 6173 2063 6861 6E67 6564 2E20 436C"            /*  has changed. Cl */
	$"6963 6B20 4F4B 2074 6F20 636F 6E66 6972"            /* ick OK to confir */
	$"6D20 7468 6174 2074 6865 206D 6F6E 6974"            /* m that the monit */
	$"6F72 2069 7320 6469 7370 6C61 7965 6420"            /* or is displayed  */
	$"636F 7272 6563 746C 792C 206F 7220 636C"            /* correctly, or cl */
	$"6963 6B20 4361 6E63 656C 2074 6F20 7265"            /* ick Cancel to re */
	$"7665 7274 2074 6F20 7468 6520 7072 6576"            /* vert to the prev */
	$"696F 7573 2073 6574 7469 6E67 2E0D"                 /* ious setting. */
};

data 'DITL' (129, "Abort-Retry-Ignore") {
	$"0003 0000 0000 00A0 0014 00B4 0050 0405"            /* ...........P.. */
	$"4162 6F72 7400 0000 0000 00A0 005A 00B4"            /* Abort.......Z. */
	$"0096 0405 5265 7472 7900 0000 0000 00A0"            /* ...Retry...... */
	$"00A0 00B4 00DC 0406 4967 6E6F 7265 0000"            /* .....Ignore.. */
	$"0000 0006 0007 0092 00E3 8802 5E30"                 /* .........^0 */
};

data 'DITL' (130, "OK") {
	$"0001 0000 0000 00A0 0058 00B4 0094 0402"            /* ........X.... */
	$"4F4B 0000 0000 0006 0007 0092 00E3 8802"            /* OK........... */
	$"5E30"                                               /* ^0 */
};

data 'DITL' (131, "OK-Cancel") {
	$"0002 0000 0000 00A0 0014 00B4 0050 0402"            /* ...........P.. */
	$"4F4B 0000 0000 00A0 00A0 00B4 00DC 0406"            /* OK.......... */
	$"4361 6E63 656C 0000 0000 0006 0007 0092"            /* Cancel......... */
	$"00E3 8802 5E30"                                     /* ..^0 */
};

data 'DITL' (132, "Retry-Cancel") {
	$"0002 0000 0000 00A0 0014 00B4 0050 0405"            /* ...........P.. */
	$"5265 7472 7900 0000 0000 00A0 00A0 00B4"            /* Retry........ */
	$"00DC 0406 4361 6E63 656C 0000 0000 0006"            /* ...Cancel...... */
	$"0007 0092 00E3 8802 5E30"                           /* .....^0 */
};

data 'DITL' (133, "Yes-No") {
	$"0002 0000 0000 00A0 0014 00B4 0050 0403"            /* ...........P.. */
	$"5965 7300 0000 0000 00A0 00A0 00B4 00DC"            /* Yes......... */
	$"0402 4E6F 0000 0000 0006 0007 0092 00E3"            /* ..No.......... */
	$"8802 5E30"                                          /* .^0 */
};

data 'DITL' (134, "Yes-No-Cancel") {
	$"0003 0000 0000 00A0 0014 00B4 0050 0403"            /* ...........P.. */
	$"5965 7300 0000 0000 00A0 005A 00B4 0096"            /* Yes.......Z.. */
	$"0402 4E6F 0000 0000 00A0 00A0 00B4 00DC"            /* ..No........ */
	$"0406 4361 6E63 656C 0000 0000 0006 0007"            /* ..Cancel........ */
	$"0092 00E3 8802 5E30"                                /* ...^0 */
};

data 'DITL' (135, "Options") {
	$"0022 0000 0000 00DC 006E 00F0 00E6 040F"            /* ."......n.... */
	$"5361 7665 2026 2043 6F6E 7469 6E75 6500"            /* Save & Continue. */
	$"0000 0000 00DC 0104 00F0 017C 040A 446F"            /* .........|..Do */
	$"6E27 7420 5361 7665 0000 0000 00DC 0014"            /* n't Save....... */
	$"00F0 0060 040B 5248 2044 6566 6175 6C74"            /* ..`..RH Default */
	$"7300 0000 0000 00FA 0014 010E 0060 040B"            /* s...........`.. */
	$"4C48 2044 6566 6175 6C74 7300 0000 0000"            /* LH Defaults..... */
	$"00BE 0050 00CE 017C 1000 0000 0000 0010"            /* ..P..|........ */
	$"0003 0020 0017 0702 0080 0000 0000 0028"            /* ... ..........( */
	$"0003 0038 0017 0702 0080 0000 0000 0040"            /* ...8..........@ */
	$"0003 0050 0017 0702 0080 0000 0000 0058"            /* ...P..........X */
	$"0003 0068 0017 0702 0080 0000 0000 0070"            /* ...h..........p */
	$"0003 0080 0017 0702 0080 0000 0000 0088"            /* ............. */
	$"0003 0098 0017 0702 0080 0000 0000 00A0"            /* ............. */
	$"0003 00B0 0017 0702 0080 0000 0000 0010"            /* .............. */
	$"00CB 0020 00DF 0702 0080 0000 0000 0028"            /* .. .........( */
	$"00CB 0038 00DF 0702 0080 0000 0000 0040"            /* ..8.........@ */
	$"00CB 0050 00DF 0702 0080 0000 0000 0058"            /* ..P.........X */
	$"00CB 0068 00DF 0702 0080 0000 0000 0070"            /* ..h.........p */
	$"00CB 0080 00DF 0702 0080 0000 0000 0088"            /* ........... */
	$"00CB 0098 00DF 0702 0080 0000 0000 00A0"            /* ........... */
	$"00CB 00B0 00DF 0702 0080 0000 0000 0010"            /* ............ */
	$"001B 0020 00C5 8807 466F 7277 6172 6400"            /* ... .ň.Forward. */
	$"0000 0000 0028 001B 0038 00C5 8804 4C65"            /* .....(...8.ň.Le */
	$"6674 0000 0000 0040 001B 0050 00C5 8808"            /* ft.....@...P.ň. */
	$"4261 636B 7761 7264 0000 0000 0058 001B"            /* Backward.....X.. */
	$"0068 00C5 8805 5269 6768 7400 0000 0000"            /* .h.ň.Right..... */
	$"0070 001B 0080 00C5 8807 5069 636B 2075"            /* .p....ň.Pick u */
	$"7000 0000 0000 0088 001B 0098 00C5 8804"            /* p..........ň. */
	$"4472 6F70 0000 0000 00A0 001B 00B0 00C5"            /* Drop......... */
	$"8804 4A75 6D70 0000 0000 0010 00E3 0020"            /* .Jump........  */
	$"018D 8805 5075 6E63 6869 0000 0000 0028"            /* ..Punchi.....( */
	$"00E3 0038 018D 8804 4B69 636B 0000 0000"            /* ..8..Kick.... */
	$"0040 00E3 0050 018D 8806 4372 6F75 6368"            /* .@..P..Crouch */
	$"0000 0000 0058 00E3 0068 018D 8804 5761"            /* .....X..h..Wa */
	$"6C6B 0000 0000 0070 00E3 0080 018D 8806"            /* lk.....p.... */
	$"4163 7469 6F6E 0000 0000 0088 00E3 0098"            /* Action....... */
	$"018D 8804 4879 706F 0000 0000 00A0 00E3"            /* ..Hypo...... */
	$"00B0 018D 8806 5265 6C6F 6164 0000 0000"            /* ...Reload.... */
	$"00BE 0014 00CE 0046 8805 4172 6773 3A81"            /* .....F.Args: */
	$"0000 0000 00FA 00D7 010E 0113 0404 5175"            /* ............Qu */
	$"6974"                                               /* it */
};

data 'DITL' (136, "Options OSX") {
	$"0002 0000 0000 003C 0050 0050 008C 0402"            /* .......<.P.P... */
	$"4F4B 0000 0000 003C 00C8 0050 0104 0404"            /* OK.....<..P.... */
	$"5175 6974 0000 0000 0010 0019 0020 0145"            /* Quit......... .E */
	$"1000"                                               /* .. */
};

data 'DITL' (137, "Display Select") {
	$"0004 0000 0000 00E6 0096 00FA 00D2 0402"            /* ............ */
	$"4F4B 0000 0000 00E6 0046 00FA 0082 0406"            /* OK......F.... */
	$"4361 6E63 656C 0000 0000 000A 000A 009A"            /* Cancel......... */
	$"00D2 8000 0000 0000 00A0 000A 00B2 00D2"            /* .Ҁ.......... */
	$"0517 416C 7761 7973 2075 7365 2074 6869"            /* ..Always use thi */
	$"7320 6469 7370 6C61 7900 0000 0000 00B4"            /* s display...... */
	$"0014 00D8 00D2 0833 2868 6F6C 6420 646F"            /* .....3(hold do */
	$"776E 2074 6865 206F 7074 696F 6E20 6B65"            /* wn the option ke */
	$"790D 746F 2073 6565 2074 6869 7320 6469"            /* yto see this di */
	$"616C 6F67 2061 6761 696E 2900"                      /* alog again). */
};

data 'DLOG' (135, "Options") {
	$"003C 0028 0154 01B8 0004 0100 0000 0000"            /* .<.(.T......... */
	$"0000 0087 0B4F 6E69 204F 7074 696F 6E73"            /* ....Oni Options */
	$"280A"                                               /* (. */
};

data 'DLOG' (136, "Options OSX") {
	$"0028 0028 008C 0186 0000 0100 0000 0000"            /* .(.(.......... */
	$"0000 0088 184F 6E69 2043 6F6D 6D61 6E64"            /* ....Oni Command */
	$"204C 696E 6520 4F70 7469 6F6E 73A4 280A"            /*  Line Options(. */
};

data 'DLOG' (137, "Display Select") {
	$"003C 0016 014A 00FC 0005 0000 0000 0000"            /* .<...J......... */
	$"0000 0089 0E53 656C 6563 7420 4469 7370"            /* ....Select Disp */
	$"6C61 79A0 280A"                                     /* lay(. */
};

data 'MENU' (128, "keys") {
	$"0080 0000 0000 0000 0000 FFFF FFFF 034B"            /* ..........K */
	$"6579 0962 6163 6B73 7061 6365 0000 0000"            /* eybackspace.... */
	$"0374 6162 0000 0000 0963 6170 7320 6C6F"            /* .tab....caps lo */
	$"636B 0000 0000 0565 6E74 6572 0000 0000"            /* ck.....enter.... */
	$"0573 6869 6674 0000 0000 0763 6F6E 7472"            /* .shift.....contr */
	$"6F6C 0000 0000 066F 7074 696F 6E00 0000"            /* ol.....option... */
	$"000B F020 2863 6F6D 6D61 6E64 2900 0000"            /* .. (command)... */
	$"0005 7370 6163 6500 0000 0004 686F 6D65"            /* ..space.....home */
	$"0000 0000 0770 6167 6520 7570 0000 0000"            /* .....page up.... */
	$"0664 656C 6574 6500 0000 0003 656E 6400"            /* .delete.....end. */
	$"0000 0009 7061 6765 2064 6F77 6E00 0000"            /* ...page down... */
	$"0008 7570 2061 7272 6F77 0000 0000 0A6C"            /* ..up arrow.....l */
	$"6566 7420 6172 726F 7700 0000 000A 646F"            /* eft arrow.....do */
	$"776E 2061 7272 6F77 0000 0000 0B72 6967"            /* wn arrow.....rig */
	$"6874 2061 7272 6F77 0000 0000 086E 756D"            /* ht arrow.....num */
	$"206C 6F63 6B00 0000 0006 6469 7669 6465"            /*  lock.....divide */
	$"0000 0000 086D 756C 7469 706C 7900 0000"            /* .....multiply... */
	$"0008 7375 6274 7261 6374 0000 0000 0361"            /* ..subtract.....a */
	$"6464 0000 0000 086E 756D 7061 6420 3D00"            /* dd.....numpad =. */
	$"0000 0005 656E 7465 7200 0000 0007 6465"            /* ....enter.....de */
	$"6369 6D61 6C00 0000 0008 6E75 6D70 6164"            /* cimal.....numpad */
	$"2030 0000 0000 086E 756D 7061 6420 3100"            /*  0.....numpad 1. */
	$"0000 0008 6E75 6D70 6164 2032 0000 0000"            /* ....numpad 2.... */
	$"086E 756D 7061 6420 3300 0000 0008 6E75"            /* .numpad 3.....nu */
	$"6D70 6164 2034 0000 0000 086E 756D 7061"            /* mpad 4.....numpa */
	$"6420 3500 0000 0008 6E75 6D70 6164 2036"            /* d 5.....numpad 6 */
	$"0000 0000 086E 756D 7061 6420 3700 0000"            /* .....numpad 7... */
	$"0008 6E75 6D70 6164 2038 0000 0000 086E"            /* ..numpad 8.....n */
	$"756D 7061 6420 3900 0000 0001 5C00 0000"            /* umpad 9.....\... */
	$"0001 3B00 0000 000A 2E20 2870 6572 696F"            /* ..;...... (perio */
	$"6429 0000 0000 0E27 2028 6170 6F73 7472"            /* d).....' (apostr */
	$"6F70 6865 2900 0000 0001 2F00 0000 0001"            /* ophe)...../..... */
	$"5B00 0000 0001 5D00 0000 0009 2C20 2863"            /* [.....]...., (c */
	$"6F6D 6D61 2900 0000 0001 3100 0000 0001"            /* omma).....1..... */
	$"3200 0000 0001 3300 0000 0001 3400 0000"            /* 2.....3.....4... */
	$"0001 3500 0000 0001 3600 0000 0001 3700"            /* ..5.....6.....7. */
	$"0000 0001 3800 0000 0001 3900 0000 0001"            /* ....8.....9..... */
	$"3000 0000 0001 5100 0000 0001 5700 0000"            /* 0.....Q.....W... */
	$"0001 4500 0000 0001 5200 0000 0001 5400"            /* ..E.....R.....T. */
	$"0000 0001 5900 0000 0001 5500 0000 0001"            /* ....Y.....U..... */
	$"4900 0000 0001 4F00 0000 0001 5000 0000"            /* I.....O.....P... */
	$"0001 4100 0000 0001 5300 0000 0001 4400"            /* ..A.....S.....D. */
	$"0000 0001 4600 0000 0001 4700 0000 0001"            /* ....F.....G..... */
	$"4800 0000 0001 4A00 0000 0001 4B00 0000"            /* H.....J.....K... */
	$"0001 4C00 0000 0001 5A00 0000 0001 5800"            /* ..L.....Z.....X. */
	$"0000 0001 4300 0000 0001 5600 0000 0001"            /* ....C.....V..... */
	$"4200 0000 0001 4E00 0000 0001 4D00 0000"            /* B.....N.....M... */
	$"0000"                                               /* .. */
};

data 'MENU' (129, "Mac shortcuts") {
	$"0081 0000 0000 0000 0000 FFFF FFFF 0446"            /* ..........F */
	$"696C 6504 5175 6974 0051 0000 00"                   /* ile.Quit.Q... */
};

data 'CNTL' (128, "Keys Menu", purgeable) {
	$"0000 0000 0010 0014 0000 0100 0000 0080"            /* ............... */
	$"03F8 0000 0000 00"                                  /* ...... */
};

data 'vers' (1) {
	$"0100 8000 0000 0642 554E 4749 4503 312E"            /* ......BUNGIE.1. */
	$"31"                                                 /* 1 */
};

data 'vers' (2) {
	$"0100 8000 0000 0642 554E 4749 4503 312E"            /* ......BUNGIE.1. */
	$"31"                                                 /* 1 */
};

data 'MBAR' (128, "Mac Menu Bar") {
	$"0001 0081"                                          /* ... */
};

data 'CURS' (128, "Magical Invisible Cursor of Doom") {
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000"                                          /* .... */
};

data 'pref' (128, "MacOS prefs") {
	$"0000 0000"                                          /* .... */
};



