// ======================================================================
// WM_Box.h
// ======================================================================
#ifndef WM_BOX_H
#define WM_BOX_H

#pragma once

// ======================================================================
// includes
// ======================================================================
#include "BFW.h"
#include "BFW_WindowManager.h"

// ======================================================================
// enums
// ======================================================================
enum
{
	WMcBoxStyle_None			= (0x0000 << 16),
	WMcBoxStyle_HasOutline		= (0x0001 << 16),
	WMcBoxStyle_HasBackground	= (0x0002 << 16),
	WMcBoxStyle_HasTitle		= (0x0004 << 16),
	
	WMcBoxStyle_PlainBox		= (WMcBoxStyle_HasOutline),
	WMcBoxStyle_GroupBox		= (WMcBoxStyle_HasOutline | WMcBoxStyle_HasTitle | WMcBoxStyle_HasBackground)
	
};

// ======================================================================
// typedefs
// ======================================================================
typedef WMtWindow				WMtBox;

// ======================================================================
// prototypes
// ======================================================================
UUtError
WMrBox_Initialize(
	void);

// ======================================================================
#endif /* WM_BOX_H */