/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.deque;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.deque.Deque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDequeV6<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int numElements) {
        int initialCapacity = 8;
        if (numElements >= initialCapacity) {
            initialCapacity = numElements;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new Object[initialCapacity];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    private <T> T[] copyElements(T[] a) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, a, 0, this.size());
        } else if (this.head > this.tail) {
            int headPortionLen = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, a, 0, headPortionLen);
            System.arraycopy(this.elements, 0, a, headPortionLen, this.tail);
        }
        return a;
    }

    public ArrayDequeV6() {
        this.elements = new Object[16];
    }

    public ArrayDequeV6(int numElements) {
        this.allocateElements(numElements);
    }

    public ArrayDequeV6(Collection<? extends E> c) {
        this.allocateElements(c.size());
        this.addAll(c);
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        int h = this.head;
        E result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.elements.length - 1;
        return result;
    }

    @Override
    public E pollLast() {
        int t = this.tail - 1 & this.elements.length - 1;
        E result = this.elements[t];
        if (result == null) {
            return null;
        }
        this.elements[t] = null;
        this.tail = t;
        return result;
    }

    @Override
    public E getFirst() {
        E x = this.elements[this.head];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        E x = this.elements[this.tail - 1 & this.elements.length - 1];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E peekFirst() {
        return this.elements[this.head];
    }

    @Override
    public E peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        E x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        E x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.tail - 1 & mask;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i - 1 & mask;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        assert (this.elements[this.tail] == null);
        assert (this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == null);
    }

    private boolean delete(int i) {
        this.checkInvariants();
        E[] elements = this.elements;
        int mask = elements.length - 1;
        int h = this.head;
        int t = this.tail;
        int front = i - h & mask;
        int back = t - i & mask;
        if (front >= (t - h & mask)) {
            throw new ConcurrentModificationException();
        }
        if (front < back) {
            if (h <= i) {
                System.arraycopy(elements, h, elements, h + 1, front);
            } else {
                System.arraycopy(elements, 0, elements, 1, i);
                elements[0] = elements[mask];
                System.arraycopy(elements, h, elements, h + 1, mask - h);
            }
            elements[h] = null;
            this.head = h + 1 & mask;
            return false;
        }
        if (i < t) {
            System.arraycopy(elements, i + 1, elements, i, back);
            this.tail = t - 1;
        } else {
            System.arraycopy(elements, i + 1, elements, i, mask - i);
            elements[mask] = elements[0];
            System.arraycopy(elements, 1, elements, 0, t);
            this.tail = t - 1 & mask;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public boolean contains(Object o) {
        E x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != t);
        }
    }

    @Override
    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        this.copyElements(a);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public ArrayDequeV6<E> clone() {
        try {
            ArrayDequeV6 result = (ArrayDequeV6)super.clone();
            result.elements = PlatformDependent.arrayCopyOf(this.elements, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            s.writeObject(this.elements[i]);
            i = i + 1 & mask;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.allocateElements(size);
        this.head = 0;
        this.tail = size;
        for (int i = 0; i < size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendingIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;

        private DescendingIterator() {
            this.cursor = ArrayDequeV6.this.tail;
            this.fence = ArrayDequeV6.this.head;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            this.cursor = this.cursor - 1 & ArrayDequeV6.this.elements.length - 1;
            Object result = ArrayDequeV6.this.elements[this.cursor];
            if (ArrayDequeV6.this.head != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (!ArrayDequeV6.this.delete(this.lastRet)) {
                this.cursor = this.cursor + 1 & ArrayDequeV6.this.elements.length - 1;
                this.fence = ArrayDequeV6.this.head;
            }
            this.lastRet = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeqIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayDequeV6.this.head;
            this.fence = ArrayDequeV6.this.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public E next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            Object result = ArrayDequeV6.this.elements[this.cursor];
            if (ArrayDequeV6.this.tail != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDequeV6.this.elements.length - 1;
            return result;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDequeV6.this.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & ArrayDequeV6.this.elements.length - 1;
                this.fence = ArrayDequeV6.this.tail;
            }
            this.lastRet = -1;
        }
    }
}

