/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.IdentityHashMap;
import java.util.Map;

public class NaturalProperties {
    public int rotation = 1;
    public boolean flip = false;
    private Map[] quadMaps = new Map[8];

    public NaturalProperties(String type) {
        if (type.equals("4")) {
            this.rotation = 4;
        } else if (type.equals("2")) {
            this.rotation = 2;
        } else if (type.equals("F")) {
            this.flip = true;
        } else if (type.equals("4F")) {
            this.rotation = 4;
            this.flip = true;
        } else if (type.equals("2F")) {
            this.rotation = 2;
            this.flip = true;
        } else {
            Config.warn("NaturalTextures: Unknown type: " + type);
        }
    }

    public boolean isValid() {
        return this.rotation != 2 && this.rotation != 4 ? this.flip : true;
    }

    public synchronized bgg getQuad(bgg quadIn, int rotate, boolean flipU) {
        int i2 = rotate;
        if (flipU) {
            i2 = rotate | 4;
        }
        if (i2 > 0 && i2 < this.quadMaps.length) {
            bgg bakedquad;
            IdentityHashMap<bgg, bgg> map = this.quadMaps[i2];
            if (map == null) {
                this.quadMaps[i2] = map = new IdentityHashMap<bgg, bgg>(1);
            }
            if ((bakedquad = (bgg)map.get(quadIn)) == null) {
                bakedquad = this.makeQuad(quadIn, rotate, flipU);
                map.put(quadIn, bakedquad);
            }
            return bakedquad;
        }
        return quadIn;
    }

    private bgg makeQuad(bgg quad, int rotate, boolean flipU) {
        int[] aint = quad.a();
        int i2 = quad.c();
        cq enumfacing = quad.d();
        bmi textureatlassprite = quad.getSprite();
        if (!this.isFullSprite(quad)) {
            rotate = 0;
        }
        aint = this.transformVertexData(aint, rotate, flipU);
        bgg bakedquad = new bgg(aint, i2, enumfacing, textureatlassprite);
        return bakedquad;
    }

    private int[] transformVertexData(int[] vertexData, int rotate, boolean flipU) {
        int[] aint = (int[])vertexData.clone();
        int i2 = 4 - rotate;
        if (flipU) {
            i2 += 3;
        }
        i2 %= 4;
        int j2 = aint.length / 4;
        for (int k2 = 0; k2 < 4; ++k2) {
            int l2 = k2 * j2;
            int i1 = i2 * j2;
            aint[i1 + 4] = vertexData[l2 + 4];
            aint[i1 + 4 + 1] = vertexData[l2 + 4 + 1];
            if (flipU) {
                if (--i2 >= 0) continue;
                i2 = 3;
                continue;
            }
            if (++i2 <= 3) continue;
            i2 = 0;
        }
        return aint;
    }

    private boolean isFullSprite(bgg quad) {
        bmi textureatlassprite = quad.getSprite();
        float f2 = textureatlassprite.e();
        float f1 = textureatlassprite.f();
        float f22 = f1 - f2;
        float f3 = f22 / 256.0f;
        float f4 = textureatlassprite.g();
        float f5 = textureatlassprite.h();
        float f6 = f5 - f4;
        float f7 = f6 / 256.0f;
        int[] aint = quad.a();
        int i2 = aint.length / 4;
        for (int j2 = 0; j2 < 4; ++j2) {
            int k2 = j2 * i2;
            float f8 = Float.intBitsToFloat(aint[k2 + 4]);
            float f9 = Float.intBitsToFloat(aint[k2 + 4 + 1]);
            if (!this.equalsDelta(f8, f2, f3) && !this.equalsDelta(f8, f1, f3)) {
                return false;
            }
            if (this.equalsDelta(f9, f4, f7) || this.equalsDelta(f9, f5, f7)) continue;
            return false;
        }
        return true;
    }

    private boolean equalsDelta(float x1, float x2, float deltaMax) {
        float f2 = ns.e(x1 - x2);
        return f2 < deltaMax;
    }
}

