/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsServerAddress;
import net.minecraft.realms.RealmsServerPing;
import net.minecraft.realms.RealmsSharedConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsServerStatusPinger {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ek> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final String p_pingServer_1_, final RealmsServerPing p_pingServer_2_) throws UnknownHostException {
        if (p_pingServer_1_ != null && !p_pingServer_1_.startsWith("0.0.0.0") && p_pingServer_1_.length() != 0) {
            RealmsServerAddress realmsserveraddress = RealmsServerAddress.parseString(p_pingServer_1_);
            final ek networkmanager = ek.a(InetAddress.getByName(realmsserveraddress.getHost()), realmsserveraddress.getPort(), false);
            this.connections.add(networkmanager);
            networkmanager.a(new jp(){
                private boolean e = false;

                public void a(jr packetIn) {
                    js serverstatusresponse = packetIn.a();
                    if (serverstatusresponse.b() != null) {
                        p_pingServer_2_.nrOfPlayers = String.valueOf(serverstatusresponse.b().b());
                        if (ArrayUtils.isNotEmpty((Object[])serverstatusresponse.b().c())) {
                            StringBuilder stringbuilder = new StringBuilder();
                            for (GameProfile gameprofile : serverstatusresponse.b().c()) {
                                if (stringbuilder.length() > 0) {
                                    stringbuilder.append("\n");
                                }
                                stringbuilder.append(gameprofile.getName());
                            }
                            if (serverstatusresponse.b().c().length < serverstatusresponse.b().b()) {
                                if (stringbuilder.length() > 0) {
                                    stringbuilder.append("\n");
                                }
                                stringbuilder.append("... and ").append(serverstatusresponse.b().b() - serverstatusresponse.b().c().length).append(" more ...");
                            }
                            p_pingServer_2_.playerList = stringbuilder.toString();
                        }
                    } else {
                        p_pingServer_2_.playerList = "";
                    }
                    networkmanager.a(new ju(Realms.currentTimeMillis()));
                    this.e = true;
                }

                public void a(jq packetIn) {
                    networkmanager.a(new fa("Finished"));
                }

                public void a(eu reason) {
                    if (!this.e) {
                        LOGGER.error("Can't ping " + p_pingServer_1_ + ": " + reason.c());
                    }
                }
            });
            try {
                networkmanager.a(new jc(RealmsSharedConstants.NETWORK_PROTOCOL_VERSION, realmsserveraddress.getHost(), realmsserveraddress.getPort(), el.c));
                networkmanager.a(new jv());
            }
            catch (Throwable throwable) {
                LOGGER.error((Object)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<ek> list = this.connections;
        synchronized (list) {
            Iterator<ek> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ek networkmanager = iterator.next();
                if (networkmanager.g()) {
                    networkmanager.a();
                    continue;
                }
                iterator.remove();
                networkmanager.l();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<ek> list = this.connections;
        synchronized (list) {
            Iterator<ek> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ek networkmanager = iterator.next();
                if (!networkmanager.g()) continue;
                iterator.remove();
                networkmanager.a(new fa("Cancelled"));
            }
        }
    }
}

