/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.List;
import net.optifine.model.ModelUtils;
import org.lwjgl.util.vector.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static boq makeModelCube(String spriteName, int tintIndex) {
        bmi sprite = Config.getMinecraft().T().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static boq makeModelCube(bmi sprite, int tintIndex) {
        ArrayList<bgg> generalQuads = new ArrayList<bgg>();
        cq[] facings = cq.n;
        ArrayList<List<bgg>> faceQuads = new ArrayList<List<bgg>>();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            cq facing = facings[i2];
            ArrayList<bgg> quads = new ArrayList<bgg>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.add(quads);
        }
        bow bakedModel = new bow(generalQuads, faceQuads, true, true, sprite, bgr.a);
        return bakedModel;
    }

    public static boq joinModelsCube(boq modelBase, boq modelAdd) {
        ArrayList<bgg> generalQuads = new ArrayList<bgg>();
        generalQuads.addAll(modelBase.a());
        generalQuads.addAll(modelAdd.a());
        cq[] facings = cq.n;
        ArrayList<List<bgg>> faceQuads = new ArrayList<List<bgg>>();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            cq facing = facings[i2];
            ArrayList<bgg> quads = new ArrayList<bgg>();
            quads.addAll(modelBase.a(facing));
            quads.addAll(modelAdd.a(facing));
            faceQuads.add(quads);
        }
        boolean ao2 = modelBase.b();
        boolean builtIn = modelBase.d();
        bmi sprite = modelBase.e();
        bgr transforms = modelBase.f();
        bow bakedModel = new bow(generalQuads, faceQuads, ao2, builtIn, sprite, transforms);
        return bakedModel;
    }

    public static bgg makeBakedQuad(cq facing, bmi sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        bgk uv2 = new bgk(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        bgi face = new bgi(facing, tintIndex, "#" + facing.l(), uv2);
        bor modelRotation = bor.a;
        bgj partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        bgo faceBakery = new bgo();
        bgg quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static boq makeModel(String modelName, String spriteOldName, String spriteNewName) {
        bmh textureMap = Config.getMinecraft().T();
        bmi spriteOld = textureMap.getSpriteSafe(spriteOldName);
        bmi spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static boq makeModel(String modelName, bmi spriteOld, bmi spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        bou modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        bov mrl = new bov(modelName, "normal");
        boq model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        boq modelNew = ModelUtils.duplicateModel(model);
        cq[] faces = cq.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            cq face = faces[i2];
            List<bgg> quads = modelNew.a(face);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List<bgg> quadsGeneral = modelNew.a();
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<bgg> quads, bmi spriteOld, bmi spriteNew) {
        ArrayList<bgg> quadsNew = new ArrayList<bgg>();
        for (bgg quad : quads) {
            if (quad.getSprite() == spriteOld) {
                quad = new bgn(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x2) {
        if (x2 > -1.0E-6f && x2 < 1.0E-6f) {
            return 0.0f;
        }
        if (x2 > 0.999999f && x2 < 1.000001f) {
            return 1.0f;
        }
        return x2;
    }

    public static aug getOffsetBoundingBox(aug aabb, afh.a offsetType, cj pos) {
        int x2 = pos.n();
        int z2 = pos.p();
        long k2 = (long)(x2 * 3129871) ^ (long)z2 * 116129781L;
        k2 = k2 * k2 * 42317861L + k2 * 11L;
        double dx2 = ((double)((float)(k2 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz2 = ((double)((float)(k2 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy2 = 0.0;
        if (offsetType == afh.a.c) {
            dy2 = ((double)((float)(k2 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.c(dx2, dy2, dz2);
    }
}

