/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.IntegratedServerUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static bfr renderGlobal;
    private static RandomEntity randomEntity;
    private static bhc tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_MCPATCHER_MOB = "mcpatcher/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(pk entity, adm world) {
        if (world == null) {
            return;
        }
        pz edm = entity.H();
        edm.spawnPosition = entity.c();
        edm.spawnBiome = world.b(edm.spawnPosition);
        UUID uuid = entity.aK();
        if (entity instanceof wi) {
            RandomEntities.updateEntityVillager(uuid, (wi)entity);
        }
    }

    public static void entityUnloaded(pk entity, adm world) {
    }

    private static void updateEntityVillager(UUID uuid, wi ev2) {
        pk se2 = IntegratedServerUtils.getEntity(uuid);
        if (!(se2 instanceof wi)) {
            return;
        }
        wi sev = (wi)se2;
        int profSev = sev.cl();
        ev2.r(profSev);
        int careerId = Reflector.getFieldValueInt(sev, Reflector.EntityVillager_careerId, 0);
        Reflector.setFieldValueInt(ev2, Reflector.EntityVillager_careerId, careerId);
        int careerLevel = Reflector.getFieldValueInt(sev, Reflector.EntityVillager_careerLevel, 0);
        Reflector.setFieldValueInt(ev2, Reflector.EntityVillager_careerLevel, careerLevel);
    }

    public static void worldChanged(adm oldWorld, adm newWorld) {
        if (newWorld != null) {
            List<pk> entityList = newWorld.E();
            for (int e2 = 0; e2 < entityList.size(); ++e2) {
                pk entity = entityList.get(e2);
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static jy getTextureLocation(jy loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re2 = RandomEntities.getRandomEntityRendered();
            if (re2 == null) {
                jy jy2 = loc;
                return jy2;
            }
            String name = loc.a();
            if (name.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                name = RandomEntities.getHorseTexturePath(name, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
            }
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY) && !name.startsWith(PREFIX_TEXTURES_PAINTING)) {
                jy jy3 = loc;
                return jy3;
            }
            RandomEntityProperties props = mapProperties.get(name);
            if (props == null) {
                jy jy4 = loc;
                return jy4;
            }
            jy jy5 = props.getTextureLocation(loc, re2);
            return jy5;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
            String abbr = HORSE_TEXTURES_ABBR[i2];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i2];
        }
        return path;
    }

    private static IRandomEntity getRandomEntityRendered() {
        akw te2;
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (RandomEntities.tileEntityRendererDispatcher.tileEntityRendered != null && (te2 = RandomEntities.tileEntityRendererDispatcher.tileEntityRendered).z() != null) {
            randomTileEntity.setTileEntity(te2);
            return randomTileEntity;
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(jy loc, boolean mcpatcher) {
        RandomEntityProperties props;
        String path = loc.a();
        jy locProps = RandomEntities.getLocationProperties(loc, mcpatcher);
        if (locProps != null && (props = RandomEntities.parseProperties(locProps, loc)) != null) {
            return props;
        }
        jy[] variants = RandomEntities.getLocationsVariants(loc, mcpatcher);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(jy propLoc, jy resLoc) {
        try {
            String path = propLoc.a();
            RandomEntities.dbg(resLoc.a() + ", properties: " + path);
            InputStream in2 = Config.getResourceStream(propLoc);
            if (in2 == null) {
                RandomEntities.warn("Properties not found: " + path);
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in2);
            in2.close();
            RandomEntityProperties rmp = new RandomEntityProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e2) {
            RandomEntities.warn("File not found: " + resLoc.a());
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private static jy getLocationProperties(jy loc, boolean mcpatcher) {
        String path;
        String pathBase;
        String pathProps;
        jy locMcp = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        jy locProps = new jy(domain, pathProps = (pathBase = StrUtils.removeSuffix(path = locMcp.a(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath(pathBase);
        if (pathParent == null) {
            return null;
        }
        jy locParentProps = new jy(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static jy getLocationRandom(jy loc, boolean mcpatcher) {
        String domain = loc.b();
        String path = loc.a();
        String prefixTextures = PREFIX_TEXTURES;
        String prefixRandom = PREFIX_OPTIFINE_RANDOM;
        if (mcpatcher) {
            prefixTextures = PREFIX_TEXTURES_ENTITY;
            prefixRandom = PREFIX_MCPATCHER_MOB;
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix(path, prefixTextures, prefixRandom);
        return new jy(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        if (pathRandom.startsWith(PREFIX_MCPATCHER_MOB)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_MCPATCHER_MOB, PREFIX_TEXTURES_ENTITY);
        }
        return null;
    }

    protected static jy getLocationIndexed(jy loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        jy locNew = new jy(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String suffix = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix(path, suffix);
            return pathParent;
        }
        return null;
    }

    private static jy[] getLocationsVariants(jy loc, boolean mcpatcher) {
        ArrayList<jy> list = new ArrayList<jy>();
        list.add(loc);
        jy locRandom = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (locRandom == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int index = i2 + 1;
            jy locIndex = RandomEntities.getLocationIndexed(locRandom, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        jy[] locs = list.toArray(new jy[list.size()]);
        RandomEntities.dbg(loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = bhc.a;
        String[] prefixes = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_MCPATCHER_MOB};
        String[] suffixes = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] pathsRandom = ResUtils.collectFiles(prefixes, suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i2 = 0; i2 < pathsRandom.length; ++i2) {
            RandomEntityProperties props;
            String path = pathsRandom[i2];
            path = StrUtils.removeSuffix(path, suffixes);
            path = StrUtils.trimTrailing(path, "0123456789");
            String pathBase = RandomEntities.getPathBase(path = path + SUFFIX_PNG);
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            jy locBase = new jy(pathBase);
            if (!Config.hasResource(locBase) || (props = mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties(locBase, false);
            if (props == null) {
                props = RandomEntities.makeProperties(locBase, true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, tp.class, String[].class, 2);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, tp.class, String[].class, 3);
    }
}

