#!/bin/bash

MC_MAIN_PATH="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )/game"
cd "$MC_MAIN_PATH"

JAVA_PATH="/System/Library/Frameworks/JavaVM.framework/Versions/1.5.0/Home/bin"

JVM_ARGS='-Xmx784M -Xms784M -Dsun.rmi.dgc.server.gcInterval=2147483646 -XX:+UnlockExperimentalVMOptions -XX:MaxGCPauseMillis=25 -XX:+Aggressiveopts -XX:SurvivorRatio=16 -Xnoclassgc'

echo "Minecraft 1.8.9 for PowerPC OSX, version 0.1.6."
echo "Made by mueller_minki in 2022."
echo "Contributors: velleda, Camotoy, z970, Griffin, akamadman203"
echo "Custom libraries included in this project:"
echo "CodecJOrbis big endian - https://github.com/Camotoy/codecjorbis"
echo "lwjgl powerpchack - https://github.com/Camotoy/lwjgl/tree/powerpchack"
echo ""
read -p "Please enter your user name (no spaces and backslashes): " MCUSER
echo "Launching the game..."

"$JAVA_PATH"/java -cp "$MC_MAIN_PATH"/minecraft.jar:"$MC_MAIN_PATH"/libraries/guava-jdk5-17.0.jar:"$MC_MAIN_PATH"/libraries/jinput.jar:"$MC_MAIN_PATH"/libraries/lwjgl.jar:"$MC_MAIN_PATH"/libraries/lwjgl_util.jar:"$MC_MAIN_PATH"/libraries/netty-buffer-4.0.10.Final.jar:"$MC_MAIN_PATH"/libraries/netty-codec-4.0.10.Final.jar:"$MC_MAIN_PATH"/libraries/netty-common-4.0.10.Final.jar:"$MC_MAIN_PATH"/libraries/netty-handler-4.0.10.Final.jar:"$MC_MAIN_PATH"/libraries/netty-transport-4.0.10.Final.jar:"$MC_MAIN_PATH"/libraries/codecjorbis-1.0-SNAPSHOT.jar:"$MC_MAIN_PATH"/libraries/codecwav-20101023.jar:"$MC_MAIN_PATH"/libraries/commons-codec-1.6.jar:"$MC_MAIN_PATH"/libraries/commons-io-2.2.jar:"$MC_MAIN_PATH"/libraries/commons-logging-1.1.3.jar:"$MC_MAIN_PATH"/libraries/jutils-1.0.0.jar:"$MC_MAIN_PATH"/libraries/soundsystem-20120107.jar:"$MC_MAIN_PATH"/libraries/vecmath-1.3.1.jar:"$MC_MAIN_PATH"/libraries/authlib-1.5.21.jar:"$MC_MAIN_PATH"/libraries/log4j-api-2.3.jar:"$MC_MAIN_PATH"/libraries/log4j-to-slf4j-2.3.jar:"$MC_MAIN_PATH"/libraries/jopt-simple-4.6.jar:"$MC_MAIN_PATH"/libraries/gson-2.2.4.jar:"$MC_MAIN_PATH"/libraries/commons-lang3-3.1.jar:"$MC_MAIN_PATH"/libraries/librarylwjglopenal-20100824.jar:"$MC_MAIN_PATH"/libraries/icu4j-core-mojang-51.2.jar:"$MC_MAIN_PATH"/libraries/trove4j-3.0.3.jar:"$MC_MAIN_PATH"/libraries/slf4j-api-1.7.21.jar:"$MC_MAIN_PATH"/libraries/slf4j-simple-1.7.21.jar: -Djava.library.path="$MC_MAIN_PATH"/natives/ "$JVM_ARGS" net.minecraft.client.main.Main --version mcp --assetsDir "$MC_MAIN_PATH"/assets/ --gameDir . --assetIndex 1.8 --accessToken empty --userProperties {} --username $MCUSER
