/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLogger
implements ExtendedLogger,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final Marker FLOW_MARKER = MarkerManager.getMarker("FLOW");
    public static final Marker ENTRY_MARKER = MarkerManager.getMarker("ENTRY").setParents(FLOW_MARKER);
    public static final Marker EXIT_MARKER = MarkerManager.getMarker("EXIT").setParents(FLOW_MARKER);
    public static final Marker EXCEPTION_MARKER = MarkerManager.getMarker("EXCEPTION");
    public static final Marker THROWING_MARKER = MarkerManager.getMarker("THROWING").setParents(EXCEPTION_MARKER);
    public static final Marker CATCHING_MARKER = MarkerManager.getMarker("CATCHING").setParents(EXCEPTION_MARKER);
    public static final Class<? extends MessageFactory> DEFAULT_MESSAGE_FACTORY_CLASS = ParameterizedMessageFactory.class;
    private static final String FQCN = AbstractLogger.class.getName();
    private static final String THROWING = "throwing";
    private static final String CATCHING = "catching";
    private final String name;
    private final MessageFactory messageFactory;

    public static void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        String name = logger.getName();
        MessageFactory loggerMessageFactory = logger.getMessageFactory();
        if (messageFactory != null && !loggerMessageFactory.equals(messageFactory)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with the message factory {}, which may create log events with unexpected formatting.", name, loggerMessageFactory, messageFactory);
        } else if (messageFactory == null && !loggerMessageFactory.getClass().equals(DEFAULT_MESSAGE_FACTORY_CLASS)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with a null message factory (defaults to {}), which may create log events with unexpected formatting.", name, loggerMessageFactory, DEFAULT_MESSAGE_FACTORY_CLASS.getName());
        }
    }

    public AbstractLogger() {
        this.name = this.getClass().getName();
        this.messageFactory = this.createDefaultMessageFactory();
    }

    public AbstractLogger(String name) {
        this.name = name;
        this.messageFactory = this.createDefaultMessageFactory();
    }

    public AbstractLogger(String name, MessageFactory messageFactory) {
        this.name = name;
        this.messageFactory = messageFactory == null ? this.createDefaultMessageFactory() : messageFactory;
    }

    @Override
    public void catching(Level level, Throwable t) {
        this.catching(FQCN, level, t);
    }

    protected void catching(String fqcn, Level level, Throwable t) {
        if (this.isEnabled(level, CATCHING_MARKER, (Object)null, null)) {
            this.logMessage(fqcn, level, CATCHING_MARKER, this.catchingMsg(t), t);
        }
    }

    @Override
    public void catching(Throwable t) {
        if (this.isEnabled(Level.ERROR, CATCHING_MARKER, (Object)null, null)) {
            this.logMessage(FQCN, Level.ERROR, CATCHING_MARKER, this.catchingMsg(t), t);
        }
    }

    protected Message catchingMsg(Throwable t) {
        return this.messageFactory.newMessage(CATCHING);
    }

    private MessageFactory createDefaultMessageFactory() {
        try {
            return DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void debug(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, msg, null);
    }

    @Override
    public void debug(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, msg, t);
    }

    @Override
    public void debug(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, null);
    }

    @Override
    public void debug(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, t);
    }

    @Override
    public void debug(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, (Throwable)null);
    }

    @Override
    public void debug(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, params);
    }

    @Override
    public void debug(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, t);
    }

    @Override
    public void debug(Message msg) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, msg, null);
    }

    @Override
    public void debug(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, msg, t);
    }

    @Override
    public void debug(Object message) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, t);
    }

    @Override
    public void debug(String message) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, params);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, t);
    }

    @Override
    public void entry() {
        this.entry(FQCN, new Object[0]);
    }

    @Override
    public void entry(Object ... params) {
        this.entry(FQCN, params);
    }

    protected void entry(String fqcn, Object ... params) {
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            this.logIfEnabled(fqcn, Level.TRACE, ENTRY_MARKER, this.entryMsg(params.length, params), null);
        }
    }

    protected Message entryMsg(int count, Object ... params) {
        if (count == 0) {
            return this.messageFactory.newMessage("entry");
        }
        StringBuilder sb = new StringBuilder("entry params(");
        int i = 0;
        for (Object parm : params) {
            if (parm != null) {
                sb.append(parm.toString());
            } else {
                sb.append("null");
            }
            if (++i >= params.length) continue;
            sb.append(", ");
        }
        sb.append(')');
        return this.messageFactory.newMessage(sb.toString());
    }

    @Override
    public void error(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, msg, null);
    }

    @Override
    public void error(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, msg, t);
    }

    @Override
    public void error(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, null);
    }

    @Override
    public void error(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, t);
    }

    @Override
    public void error(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, (Throwable)null);
    }

    @Override
    public void error(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, params);
    }

    @Override
    public void error(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, t);
    }

    @Override
    public void error(Message msg) {
        this.logIfEnabled(FQCN, Level.ERROR, null, msg, null);
    }

    @Override
    public void error(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, null, msg, t);
    }

    @Override
    public void error(Object message) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, t);
    }

    @Override
    public void error(String message) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void error(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, params);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, t);
    }

    @Override
    public void exit() {
        this.exit(FQCN, null);
    }

    @Override
    public <R> R exit(R result) {
        return this.exit(FQCN, result);
    }

    protected <R> R exit(String fqcn, R result) {
        if (this.isEnabled(Level.TRACE, EXIT_MARKER, (Object)null, null)) {
            this.logIfEnabled(fqcn, Level.TRACE, EXIT_MARKER, this.exitMsg(result), null);
        }
        return result;
    }

    protected Message exitMsg(Object result) {
        if (result == null) {
            return this.messageFactory.newMessage("exit");
        }
        return this.messageFactory.newMessage("exit with(" + result + ')');
    }

    @Override
    public void fatal(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, msg, null);
    }

    @Override
    public void fatal(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, msg, t);
    }

    @Override
    public void fatal(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, null);
    }

    @Override
    public void fatal(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, t);
    }

    @Override
    public void fatal(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, (Throwable)null);
    }

    @Override
    public void fatal(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, params);
    }

    @Override
    public void fatal(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, t);
    }

    @Override
    public void fatal(Message msg) {
        this.logIfEnabled(FQCN, Level.FATAL, null, msg, null);
    }

    @Override
    public void fatal(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, null, msg, t);
    }

    @Override
    public void fatal(Object message) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, null);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, t);
    }

    @Override
    public void fatal(String message) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void fatal(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, params);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, t);
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void info(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.INFO, marker, msg, null);
    }

    @Override
    public void info(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, marker, msg, t);
    }

    @Override
    public void info(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, null);
    }

    @Override
    public void info(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, t);
    }

    @Override
    public void info(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void info(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, params);
    }

    @Override
    public void info(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, t);
    }

    @Override
    public void info(Message msg) {
        this.logIfEnabled(FQCN, Level.INFO, null, msg, null);
    }

    @Override
    public void info(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, null, msg, t);
    }

    @Override
    public void info(Object message) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, t);
    }

    @Override
    public void info(String message) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void info(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, params);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG, null, null);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isEnabled(Level.DEBUG, marker, (Object)null, null);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.isEnabled(level, null, (Object)null, null);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker) {
        return this.isEnabled(level, marker, (Object)null, null);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR, null, (Object)null, null);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isEnabled(Level.ERROR, marker, (Object)null, null);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL, null, (Object)null, null);
    }

    @Override
    public boolean isFatalEnabled(Marker marker) {
        return this.isEnabled(Level.FATAL, marker, (Object)null, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO, null, (Object)null, null);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isEnabled(Level.INFO, marker, (Object)null, null);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE, null, (Object)null, null);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isEnabled(Level.TRACE, marker, (Object)null, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN, null, (Object)null, null);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isEnabled(Level.WARN, marker, (Object)null, null);
    }

    @Override
    public void log(Level level, Marker marker, Message msg) {
        this.logIfEnabled(FQCN, level, marker, msg, (Throwable)null);
    }

    @Override
    public void log(Level level, Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, level, marker, msg, t);
    }

    @Override
    public void log(Level level, Marker marker, Object message) {
        this.logIfEnabled(FQCN, level, marker, message, (Throwable)null);
    }

    @Override
    public void log(Level level, Marker marker, Object message, Throwable t) {
        if (this.isEnabled(level, marker, message, t)) {
            this.logMessage(FQCN, level, marker, message, t);
        }
    }

    @Override
    public void log(Level level, Marker marker, String message) {
        this.logIfEnabled(FQCN, level, marker, message, (Throwable)null);
    }

    @Override
    public void log(Level level, Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, level, marker, message, params);
    }

    @Override
    public void log(Level level, Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, level, marker, message, t);
    }

    @Override
    public void log(Level level, Message msg) {
        this.logIfEnabled(FQCN, level, null, msg, null);
    }

    @Override
    public void log(Level level, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, level, null, msg, t);
    }

    @Override
    public void log(Level level, Object message) {
        this.logIfEnabled(FQCN, level, null, message, null);
    }

    @Override
    public void log(Level level, Object message, Throwable t) {
        this.logIfEnabled(FQCN, level, null, message, t);
    }

    @Override
    public void log(Level level, String message) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void log(Level level, String message, Object ... params) {
        this.logIfEnabled(FQCN, level, null, message, params);
    }

    @Override
    public void log(Level level, String message, Throwable t) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, t);
    }

    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(level, marker, msg, t)) {
            this.logMessage(fqcn, level, marker, msg, t);
        }
    }

    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, Object message, Throwable t) {
        if (this.isEnabled(level, marker, message, t)) {
            this.logMessage(fqcn, level, marker, message, t);
        }
    }

    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message) {
        if (this.isEnabled(level, marker, message)) {
            this.logMessage(fqcn, level, marker, message);
        }
    }

    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object ... params) {
        if (this.isEnabled(level, marker, message, params)) {
            this.logMessage(fqcn, level, marker, message, params);
        }
    }

    @Override
    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable t) {
        if (this.isEnabled(level, marker, message, t)) {
            this.logMessage(fqcn, level, marker, message, t);
        }
    }

    protected void logMessage(String fqcn, Level level, Marker marker, Object message, Throwable t) {
        this.logMessage(fqcn, level, marker, this.messageFactory.newMessage(message), t);
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Throwable t) {
        this.logMessage(fqcn, level, marker, this.messageFactory.newMessage(message), t);
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message) {
        Message msg = this.messageFactory.newMessage(message);
        this.logMessage(fqcn, level, marker, msg, msg.getThrowable());
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object ... params) {
        Message msg = this.messageFactory.newMessage(message, params);
        this.logMessage(fqcn, level, marker, msg, msg.getThrowable());
    }

    @Override
    public void printf(Level level, Marker marker, String format, Object ... params) {
        if (this.isEnabled(level, marker, format, params)) {
            StringFormattedMessage msg = new StringFormattedMessage(format, params);
            this.logMessage(FQCN, level, marker, msg, msg.getThrowable());
        }
    }

    @Override
    public void printf(Level level, String format, Object ... params) {
        if (this.isEnabled(level, null, format, params)) {
            StringFormattedMessage msg = new StringFormattedMessage(format, params);
            this.logMessage(FQCN, level, null, msg, msg.getThrowable());
        }
    }

    @Override
    public <T extends Throwable> T throwing(T t) {
        return this.throwing(FQCN, Level.ERROR, t);
    }

    @Override
    public <T extends Throwable> T throwing(Level level, T t) {
        return this.throwing(FQCN, level, t);
    }

    protected <T extends Throwable> T throwing(String fqcn, Level level, T t) {
        if (this.isEnabled(level, THROWING_MARKER, (Object)null, null)) {
            this.logMessage(fqcn, level, THROWING_MARKER, this.throwingMsg(t), t);
        }
        return t;
    }

    protected Message throwingMsg(Throwable t) {
        return this.messageFactory.newMessage(THROWING);
    }

    @Override
    public void trace(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, msg, null);
    }

    @Override
    public void trace(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, msg, t);
    }

    @Override
    public void trace(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, null);
    }

    @Override
    public void trace(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, t);
    }

    @Override
    public void trace(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void trace(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, params);
    }

    @Override
    public void trace(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, t);
    }

    @Override
    public void trace(Message msg) {
        this.logIfEnabled(FQCN, Level.TRACE, null, msg, null);
    }

    @Override
    public void trace(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, null, msg, t);
    }

    @Override
    public void trace(Object message) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, t);
    }

    @Override
    public void trace(String message) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, params);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, t);
    }

    @Override
    public void warn(Marker marker, Message msg) {
        this.logIfEnabled(FQCN, Level.WARN, marker, msg, null);
    }

    @Override
    public void warn(Marker marker, Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, marker, msg, t);
    }

    @Override
    public void warn(Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, null);
    }

    @Override
    public void warn(Marker marker, Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, t);
    }

    @Override
    public void warn(Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, (Throwable)null);
    }

    @Override
    public void warn(Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, params);
    }

    @Override
    public void warn(Marker marker, String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, t);
    }

    @Override
    public void warn(Message msg) {
        this.logIfEnabled(FQCN, Level.WARN, null, msg, null);
    }

    @Override
    public void warn(Message msg, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, null, msg, t);
    }

    @Override
    public void warn(Object message) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, t);
    }

    @Override
    public void warn(String message) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, params);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, t);
    }
}

