/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import net.optifine.Lang;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProviderShaderOptions;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionScreen;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.shaders.gui.GuiSliderShaderOption;

public class GuiShaderOptions
extends GuiScreenOF {
    private axu prevScreen;
    protected String title = "Shader Options";
    private avh settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderShaderOptions());
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(axu guiscreen, avh gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(axu guiscreen, avh gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    @Override
    public void b() {
        this.title = bnq.a("of.options.shaderOptionsTitle", new Object[0]);
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = Shaders.getShaderPackColumns(this.screenName, 2);
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            int colsMin = ns.f((double)ops.length / 9.0);
            if (columns < colsMin) {
                columns = colsMin;
            }
            for (int i2 = 0; i2 < ops.length; ++i2) {
                ShaderOption so2 = ops[i2];
                if (so2 == null || !so2.isVisible()) continue;
                int col = i2 % columns;
                int row = i2 / columns;
                int colWidth = Math.min(this.l / columns, 200);
                baseX = (this.l - colWidth * columns) / 2;
                int x2 = col * colWidth + 5 + baseX;
                int y2 = baseY + row * stepY;
                int w2 = colWidth - 10;
                int h2 = btnHeight;
                String text = GuiShaderOptions.getButtonText(so2, w2);
                GuiButtonShaderOption btn = Shaders.isShaderPackOptionSlider(so2.getName()) ? new GuiSliderShaderOption(baseId + i2, x2, y2, w2, h2, so2, text) : new GuiButtonShaderOption(baseId + i2, x2, y2, w2, h2, so2, text);
                btn.l = so2.isEnabled();
                this.n.add(btn);
            }
        }
        this.n.add(new avs(201, this.l / 2 - btnWidth - 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, bnq.a("controls.reset", new Object[0])));
        this.n.add(new avs(200, this.l / 2 + 20, this.m / 6 + 168 + 11, btnWidth, btnHeight, bnq.a("gui.done", new Object[0])));
    }

    public static String getButtonText(ShaderOption so2, int btnWidth) {
        String labelName = so2.getNameText();
        if (so2 instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so2;
            return labelName + "...";
        }
        avn fr2 = Config.getMinecraft().k;
        int lenSuffix = fr2.a(": " + Lang.getOff()) + 5;
        while (fr2.a(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so2.isChanged() ? so2.getValueColor(so2.getValue()) : "";
        String labelValue = so2.getValueText(so2.getValue());
        return labelName + ": " + col + labelValue;
    }

    @Override
    protected void a(avs guibutton) {
        if (!guibutton.l) {
            return;
        }
        if (guibutton.k < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so2 = btnSo.getShaderOption();
            if (so2 instanceof ShaderOptionScreen) {
                String screenName = so2.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.j.a(scr);
                return;
            }
            if (GuiShaderOptions.r()) {
                so2.resetValue();
            } else if (btnSo.isSwitchable()) {
                so2.nextValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.k == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i2 = 0; i2 < opts.length; ++i2) {
                ShaderOption opt = opts[i2];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.k == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                this.changed = false;
                Shaders.uninit();
            }
            this.j.a(this.prevScreen);
        }
    }

    @Override
    protected void actionPerformedRightClick(avs btn) {
        if (btn instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
            ShaderOption so2 = btnSo.getShaderOption();
            if (GuiShaderOptions.r()) {
                so2.resetValue();
            } else if (btnSo.isSwitchable()) {
                so2.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    @Override
    public void m() {
        super.m();
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
    }

    private void updateAllButtons() {
        for (avs btn : this.n) {
            if (!(btn instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)btn;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.j = GuiShaderOptions.getButtonText(opt, gbso.b());
            gbso.valueChanged();
        }
    }

    @Override
    public void a(int x2, int y2, float f2) {
        this.c();
        if (this.screenText != null) {
            this.a(this.q, this.screenText, this.l / 2, 15, 0xFFFFFF);
        } else {
            this.a(this.q, this.title, this.l / 2, 15, 0xFFFFFF);
        }
        super.a(x2, y2, f2);
        this.tooltipManager.drawTooltips(x2, y2, this.n);
    }
}

