/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import net.optifine.util.MemoryMonitor;
import org.lwjgl.opengl.GL11;

public class Lagometer {
    private static ave mc;
    private static avh gameSettings;
    private static nt profiler;
    public static boolean active;
    public static TimerNano timerTick;
    public static TimerNano timerScheduledExecutables;
    public static TimerNano timerChunkUpload;
    public static TimerNano timerChunkUpdate;
    public static TimerNano timerVisibility;
    public static TimerNano timerTerrain;
    public static TimerNano timerServer;
    private static long[] timesFrame;
    private static long[] timesTick;
    private static long[] timesScheduledExecutables;
    private static long[] timesChunkUpload;
    private static long[] timesChunkUpdate;
    private static long[] timesVisibility;
    private static long[] timesTerrain;
    private static long[] timesServer;
    private static boolean[] gcs;
    private static int numRecordedFrameTimes;
    private static long prevFrameTimeNano;
    private static long renderTimeNano;

    public static void updateLagometer() {
        if (mc == null) {
            mc = ave.A();
            gameSettings = Lagometer.mc.t;
            profiler = Lagometer.mc.A;
        }
        if (Lagometer.gameSettings.aC && (Lagometer.gameSettings.ofLagometer || Lagometer.gameSettings.aE)) {
            active = true;
            long timeNowNano = System.nanoTime();
            if (prevFrameTimeNano == -1L) {
                prevFrameTimeNano = timeNowNano;
            } else {
                int j2 = numRecordedFrameTimes & timesFrame.length - 1;
                ++numRecordedFrameTimes;
                boolean flag = MemoryMonitor.isGcEvent();
                Lagometer.timesFrame[j2] = timeNowNano - prevFrameTimeNano - renderTimeNano;
                Lagometer.timesTick[j2] = Lagometer.timerTick.timeNano;
                Lagometer.timesScheduledExecutables[j2] = Lagometer.timerScheduledExecutables.timeNano;
                Lagometer.timesChunkUpload[j2] = Lagometer.timerChunkUpload.timeNano;
                Lagometer.timesChunkUpdate[j2] = Lagometer.timerChunkUpdate.timeNano;
                Lagometer.timesVisibility[j2] = Lagometer.timerVisibility.timeNano;
                Lagometer.timesTerrain[j2] = Lagometer.timerTerrain.timeNano;
                Lagometer.timesServer[j2] = Lagometer.timerServer.timeNano;
                Lagometer.gcs[j2] = flag;
                Lagometer.timerTick.reset();
                Lagometer.timerScheduledExecutables.reset();
                Lagometer.timerVisibility.reset();
                Lagometer.timerChunkUpdate.reset();
                Lagometer.timerChunkUpload.reset();
                Lagometer.timerTerrain.reset();
                Lagometer.timerServer.reset();
                prevFrameTimeNano = System.nanoTime();
            }
        } else {
            active = false;
            prevFrameTimeNano = -1L;
        }
    }

    public static void showLagometer(avr scaledResolution) {
        if (gameSettings != null && (Lagometer.gameSettings.ofLagometer || Lagometer.gameSettings.aE)) {
            long i2 = System.nanoTime();
            bfl.m(256);
            bfl.n(5889);
            bfl.E();
            bfl.g();
            bfl.D();
            bfl.a(0.0, Lagometer.mc.d, Lagometer.mc.e, 0.0, 1000.0, 3000.0);
            bfl.n(5888);
            bfl.E();
            bfl.D();
            bfl.b(0.0f, 0.0f, -2000.0f);
            GL11.glLineWidth((float)1.0f);
            bfl.x();
            bfx tessellator = bfx.a();
            bfd worldrenderer = tessellator.c();
            worldrenderer.a(1, bms.f);
            for (int j2 = 0; j2 < timesFrame.length; ++j2) {
                int k2 = (j2 - numRecordedFrameTimes & timesFrame.length - 1) * 100 / timesFrame.length;
                k2 += 155;
                float f2 = Lagometer.mc.e;
                long l2 = 0L;
                if (gcs[j2]) {
                    Lagometer.renderTime(j2, timesFrame[j2], k2, k2 / 2, 0, f2, worldrenderer);
                    continue;
                }
                Lagometer.renderTime(j2, timesFrame[j2], k2, k2, k2, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesServer[j2], k2 / 2, k2 / 2, k2 / 2, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesTerrain[j2], 0, k2, 0, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesVisibility[j2], k2, k2, 0, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesChunkUpdate[j2], k2, 0, 0, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesChunkUpload[j2], k2, 0, k2, f2, worldrenderer);
                f2 -= (float)Lagometer.renderTime(j2, timesScheduledExecutables[j2], 0, 0, k2, f2, worldrenderer);
                float f3 = f2 - (float)Lagometer.renderTime(j2, timesTick[j2], 0, k2, k2, f2, worldrenderer);
            }
            Lagometer.renderTimeDivider(0, timesFrame.length, 33333333L, 196, 196, 196, Lagometer.mc.e, worldrenderer);
            Lagometer.renderTimeDivider(0, timesFrame.length, 16666666L, 196, 196, 196, Lagometer.mc.e, worldrenderer);
            tessellator.b();
            bfl.w();
            int j2 = Lagometer.mc.e - 80;
            int k2 = Lagometer.mc.e - 160;
            Lagometer.mc.k.a("30", 2, k2 + 1, -8947849);
            Lagometer.mc.k.a("30", 1, k2, -3881788);
            Lagometer.mc.k.a("60", 2, j2 + 1, -8947849);
            Lagometer.mc.k.a("60", 1, j2, -3881788);
            bfl.n(5889);
            bfl.F();
            bfl.n(5888);
            bfl.F();
            bfl.w();
            float f1 = 1.0f - (float)((double)(System.currentTimeMillis() - MemoryMonitor.getStartTimeMs()) / 1000.0);
            f1 = Config.limit(f1, 0.0f, 1.0f);
            int l2 = (int)(170.0f + f1 * 85.0f);
            int i1 = (int)(100.0f + f1 * 55.0f);
            int j1 = (int)(10.0f + f1 * 10.0f);
            int k1 = l2 << 16 | i1 << 8 | j1;
            int l1 = 512 / scaledResolution.e() + 2;
            int i22 = Lagometer.mc.e / scaledResolution.e() - 8;
            avo guiingame = Lagometer.mc.q;
            avo.a(l1 - 1, i22 - 1, l1 + 50, i22 + 10, -1605349296);
            Lagometer.mc.k.a(" " + MemoryMonitor.getAllocationRateMb() + " MB/s", l1, i22, k1);
            renderTimeNano = System.nanoTime() - i2;
        }
    }

    private static long renderTime(int frameNum, long time, int r2, int g2, int b2, float baseHeight, bfd tessellator) {
        long i2 = time / 200000L;
        if (i2 < 3L) {
            return 0L;
        }
        tessellator.b((double)((float)frameNum + 0.5f), (double)(baseHeight - (float)i2 + 0.5f), 0.0).b(r2, g2, b2, 255).d();
        tessellator.b((double)((float)frameNum + 0.5f), (double)(baseHeight + 0.5f), 0.0).b(r2, g2, b2, 255).d();
        return i2;
    }

    private static long renderTimeDivider(int frameStart, int frameEnd, long time, int r2, int g2, int b2, float baseHeight, bfd tessellator) {
        long i2 = time / 200000L;
        if (i2 < 3L) {
            return 0L;
        }
        tessellator.b((double)((float)frameStart + 0.5f), (double)(baseHeight - (float)i2 + 0.5f), 0.0).b(r2, g2, b2, 255).d();
        tessellator.b((double)((float)frameEnd + 0.5f), (double)(baseHeight - (float)i2 + 0.5f), 0.0).b(r2, g2, b2, 255).d();
        return i2;
    }

    public static boolean isActive() {
        return active;
    }

    static {
        active = false;
        timerTick = new TimerNano();
        timerScheduledExecutables = new TimerNano();
        timerChunkUpload = new TimerNano();
        timerChunkUpdate = new TimerNano();
        timerVisibility = new TimerNano();
        timerTerrain = new TimerNano();
        timerServer = new TimerNano();
        timesFrame = new long[512];
        timesTick = new long[512];
        timesScheduledExecutables = new long[512];
        timesChunkUpload = new long[512];
        timesChunkUpdate = new long[512];
        timesVisibility = new long[512];
        timesTerrain = new long[512];
        timesServer = new long[512];
        gcs = new boolean[512];
        numRecordedFrameTimes = 0;
        prevFrameTimeNano = -1L;
        renderTimeNano = 0L;
    }

    public static class TimerNano {
        public long timeStartNano = 0L;
        public long timeNano = 0L;

        public void start() {
            if (active && this.timeStartNano == 0L) {
                this.timeStartNano = System.nanoTime();
            }
        }

        public void end() {
            if (active && this.timeStartNano != 0L) {
                this.timeNano += System.nanoTime() - this.timeStartNano;
                this.timeStartNano = 0L;
            }
        }

        private void reset() {
            this.timeNano = 0L;
            this.timeStartNano = 0L;
        }
    }
}

