/*
 * Decompiled with CFR 0.152.
 */
package optifine.xdelta;

import java.io.IOException;
import optifine.xdelta.SeekableSource;

public class ByteArraySeekableSource
implements SeekableSource {
    byte[] source;
    long lastPos = 0L;

    public ByteArraySeekableSource(byte[] source) {
        this.source = source;
    }

    public void seek(long pos) throws IOException {
        this.lastPos = pos;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int i2 = this.source.length - (int)this.lastPos;
        if (i2 <= 0) {
            return -1;
        }
        if (i2 < len) {
            len = i2;
        }
        System.arraycopy(this.source, (int)this.lastPos, b2, off, len);
        this.lastPos += (long)len;
        return len;
    }

    public long length() throws IOException {
        return this.source.length;
    }

    public void close() throws IOException {
        this.source = null;
    }
}

