/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.optifine.shaders.BlockAliases;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.GL20;

public class SVertexBuilder {
    int vertexSize;
    int offsetNormal;
    int offsetUV;
    int offsetUVCenter;
    boolean hasNormal;
    boolean hasTangent;
    boolean hasUV;
    boolean hasUVCenter;
    long[] entityData = new long[10];
    int entityDataIndex = 0;

    public SVertexBuilder() {
        this.entityData[this.entityDataIndex] = 0L;
    }

    public static void initVertexBuilder(bfd wrr) {
        wrr.sVertexBuilder = new SVertexBuilder();
    }

    public void pushEntity(long data) {
        ++this.entityDataIndex;
        this.entityData[this.entityDataIndex] = data;
    }

    public void popEntity() {
        this.entityData[this.entityDataIndex] = 0L;
        --this.entityDataIndex;
    }

    public static void pushEntity(alz blockState, cj blockPos, adq blockAccess, bfd wrr) {
        int j2;
        int i2;
        afh block = blockState.c();
        if (blockState instanceof aly) {
            aly blockstatebase = (aly)blockState;
            i2 = blockstatebase.getBlockId();
            j2 = blockstatebase.getMetadata();
        } else {
            i2 = afh.a(block);
            j2 = block.c(blockState);
        }
        int j1 = BlockAliases.getBlockAliasId(i2, j2);
        if (j1 >= 0) {
            i2 = j1;
        }
        int k2 = block.b();
        int l2 = ((k2 & 0xFFFF) << 16) + (i2 & 0xFFFF);
        int i1 = j2 & 0xFFFF;
        wrr.sVertexBuilder.pushEntity(((long)i1 << 32) + (long)l2);
    }

    public static void popEntity(bfd wrr) {
        wrr.sVertexBuilder.popEntity();
    }

    public static boolean popEntity(boolean value, bfd wrr) {
        wrr.sVertexBuilder.popEntity();
        return value;
    }

    public static void endSetVertexFormat(bfd wrr) {
        SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
        bmu vertexformat = wrr.g();
        svertexbuilder.vertexSize = vertexformat.g() / 4;
        svertexbuilder.hasTangent = svertexbuilder.hasNormal = vertexformat.b();
        svertexbuilder.hasUV = vertexformat.a(0);
        svertexbuilder.offsetNormal = svertexbuilder.hasNormal ? vertexformat.c() / 4 : 0;
        svertexbuilder.offsetUV = svertexbuilder.hasUV ? vertexformat.b(0) / 4 : 0;
        svertexbuilder.offsetUVCenter = 8;
    }

    public static void beginAddVertex(bfd wrr) {
        if (wrr.e == 0) {
            SVertexBuilder.endSetVertexFormat(wrr);
        }
    }

    public static void endAddVertex(bfd wrr) {
        SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
        if (svertexbuilder.vertexSize == 14) {
            if (wrr.i == 7 && wrr.e % 4 == 0) {
                svertexbuilder.calcNormal(wrr, wrr.j() - 4 * svertexbuilder.vertexSize);
            }
            long i2 = svertexbuilder.entityData[svertexbuilder.entityDataIndex];
            int j2 = wrr.j() - 14 + 12;
            wrr.b.put(j2, (int)i2);
            wrr.b.put(j2 + 1, (int)(i2 >> 32));
        }
    }

    public static void beginAddVertexData(bfd wrr, int[] data) {
        if (wrr.e == 0) {
            SVertexBuilder.endSetVertexFormat(wrr);
        }
        SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
        if (svertexbuilder.vertexSize == 14) {
            long i2 = svertexbuilder.entityData[svertexbuilder.entityDataIndex];
            int j2 = 12;
            while (j2 + 1 < data.length) {
                data[j2] = (int)i2;
                data[j2 + 1] = (int)(i2 >> 32);
                j2 += 14;
            }
        }
    }

    public static void beginAddVertexData(bfd wrr, ByteBuffer byteBuffer) {
        if (wrr.e == 0) {
            SVertexBuilder.endSetVertexFormat(wrr);
        }
        SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
        if (svertexbuilder.vertexSize == 14) {
            long i2 = svertexbuilder.entityData[svertexbuilder.entityDataIndex];
            int j2 = byteBuffer.limit() / 4;
            int k2 = 12;
            while (k2 + 1 < j2) {
                int l2 = (int)i2;
                int i1 = (int)(i2 >> 32);
                byteBuffer.putInt(k2 * 4, l2);
                byteBuffer.putInt((k2 + 1) * 4, i1);
                k2 += 14;
            }
        }
    }

    public static void endAddVertexData(bfd wrr) {
        SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
        if (svertexbuilder.vertexSize == 14 && wrr.i == 7 && wrr.e % 4 == 0) {
            svertexbuilder.calcNormal(wrr, wrr.j() - 4 * svertexbuilder.vertexSize);
        }
    }

    public void calcNormal(bfd wrr, int baseIndex) {
        FloatBuffer floatbuffer = wrr.d;
        IntBuffer intbuffer = wrr.b;
        int i2 = wrr.j();
        float f2 = floatbuffer.get(baseIndex + 0 * this.vertexSize);
        float f1 = floatbuffer.get(baseIndex + 0 * this.vertexSize + 1);
        float f22 = floatbuffer.get(baseIndex + 0 * this.vertexSize + 2);
        float f3 = floatbuffer.get(baseIndex + 0 * this.vertexSize + this.offsetUV);
        float f4 = floatbuffer.get(baseIndex + 0 * this.vertexSize + this.offsetUV + 1);
        float f5 = floatbuffer.get(baseIndex + 1 * this.vertexSize);
        float f6 = floatbuffer.get(baseIndex + 1 * this.vertexSize + 1);
        float f7 = floatbuffer.get(baseIndex + 1 * this.vertexSize + 2);
        float f8 = floatbuffer.get(baseIndex + 1 * this.vertexSize + this.offsetUV);
        float f9 = floatbuffer.get(baseIndex + 1 * this.vertexSize + this.offsetUV + 1);
        float f10 = floatbuffer.get(baseIndex + 2 * this.vertexSize);
        float f11 = floatbuffer.get(baseIndex + 2 * this.vertexSize + 1);
        float f12 = floatbuffer.get(baseIndex + 2 * this.vertexSize + 2);
        float f13 = floatbuffer.get(baseIndex + 2 * this.vertexSize + this.offsetUV);
        float f14 = floatbuffer.get(baseIndex + 2 * this.vertexSize + this.offsetUV + 1);
        float f15 = floatbuffer.get(baseIndex + 3 * this.vertexSize);
        float f16 = floatbuffer.get(baseIndex + 3 * this.vertexSize + 1);
        float f17 = floatbuffer.get(baseIndex + 3 * this.vertexSize + 2);
        float f18 = floatbuffer.get(baseIndex + 3 * this.vertexSize + this.offsetUV);
        float f19 = floatbuffer.get(baseIndex + 3 * this.vertexSize + this.offsetUV + 1);
        float f21 = f11 - f1;
        float f25 = f17 - f7;
        float f24 = f16 - f6;
        float f222 = f12 - f22;
        float f30 = f21 * f25 - f24 * f222;
        float f23 = f15 - f5;
        float f20 = f10 - f2;
        float f31 = f222 * f23 - f25 * f20;
        float f32 = f20 * f24 - f23 * f21;
        float f33 = f30 * f30 + f31 * f31 + f32 * f32;
        float f34 = (double)f33 != 0.0 ? (float)(1.0 / Math.sqrt(f33)) : 1.0f;
        f30 *= f34;
        f31 *= f34;
        f32 *= f34;
        f20 = f5 - f2;
        f21 = f6 - f1;
        f222 = f7 - f22;
        float f26 = f8 - f3;
        float f27 = f9 - f4;
        f23 = f10 - f2;
        f24 = f11 - f1;
        f25 = f12 - f22;
        float f28 = f13 - f3;
        float f29 = f14 - f4;
        float f35 = f26 * f29 - f28 * f27;
        float f36 = f35 != 0.0f ? 1.0f / f35 : 1.0f;
        float f37 = (f29 * f20 - f27 * f23) * f36;
        float f38 = (f29 * f21 - f27 * f24) * f36;
        float f39 = (f29 * f222 - f27 * f25) * f36;
        float f40 = (f26 * f23 - f28 * f20) * f36;
        float f41 = (f26 * f24 - f28 * f21) * f36;
        float f42 = (f26 * f25 - f28 * f222) * f36;
        f33 = f37 * f37 + f38 * f38 + f39 * f39;
        f34 = (double)f33 != 0.0 ? (float)(1.0 / Math.sqrt(f33)) : 1.0f;
        f37 *= f34;
        f38 *= f34;
        f39 *= f34;
        f33 = f40 * f40 + f41 * f41 + f42 * f42;
        f34 = (double)f33 != 0.0 ? (float)(1.0 / Math.sqrt(f33)) : 1.0f;
        float f43 = f32 * f38 - f31 * f39;
        float f44 = f30 * f39 - f32 * f37;
        float f45 = f31 * f37 - f30 * f38;
        float f46 = (f40 *= f34) * f43 + (f41 *= f34) * f44 + (f42 *= f34) * f45 < 0.0f ? -1.0f : 1.0f;
        int j2 = (int)(f30 * 127.0f) & 0xFF;
        int k2 = (int)(f31 * 127.0f) & 0xFF;
        int l2 = (int)(f32 * 127.0f) & 0xFF;
        int i1 = (l2 << 16) + (k2 << 8) + j2;
        intbuffer.put(baseIndex + 0 * this.vertexSize + this.offsetNormal, i1);
        intbuffer.put(baseIndex + 1 * this.vertexSize + this.offsetNormal, i1);
        intbuffer.put(baseIndex + 2 * this.vertexSize + this.offsetNormal, i1);
        intbuffer.put(baseIndex + 3 * this.vertexSize + this.offsetNormal, i1);
        int j1 = ((int)(f37 * 32767.0f) & 0xFFFF) + (((int)(f38 * 32767.0f) & 0xFFFF) << 16);
        int k1 = ((int)(f39 * 32767.0f) & 0xFFFF) + (((int)(f46 * 32767.0f) & 0xFFFF) << 16);
        intbuffer.put(baseIndex + 0 * this.vertexSize + 10, j1);
        intbuffer.put(baseIndex + 0 * this.vertexSize + 10 + 1, k1);
        intbuffer.put(baseIndex + 1 * this.vertexSize + 10, j1);
        intbuffer.put(baseIndex + 1 * this.vertexSize + 10 + 1, k1);
        intbuffer.put(baseIndex + 2 * this.vertexSize + 10, j1);
        intbuffer.put(baseIndex + 2 * this.vertexSize + 10 + 1, k1);
        intbuffer.put(baseIndex + 3 * this.vertexSize + 10, j1);
        intbuffer.put(baseIndex + 3 * this.vertexSize + 10 + 1, k1);
        float f47 = (f3 + f8 + f13 + f18) / 4.0f;
        float f48 = (f4 + f9 + f14 + f19) / 4.0f;
        floatbuffer.put(baseIndex + 0 * this.vertexSize + 8, f47);
        floatbuffer.put(baseIndex + 0 * this.vertexSize + 8 + 1, f48);
        floatbuffer.put(baseIndex + 1 * this.vertexSize + 8, f47);
        floatbuffer.put(baseIndex + 1 * this.vertexSize + 8 + 1, f48);
        floatbuffer.put(baseIndex + 2 * this.vertexSize + 8, f47);
        floatbuffer.put(baseIndex + 2 * this.vertexSize + 8 + 1, f48);
        floatbuffer.put(baseIndex + 3 * this.vertexSize + 8, f47);
        floatbuffer.put(baseIndex + 3 * this.vertexSize + 8 + 1, f48);
    }

    public static void calcNormalChunkLayer(bfd wrr) {
        if (wrr.g().b() && wrr.i == 7 && wrr.e % 4 == 0) {
            SVertexBuilder svertexbuilder = wrr.sVertexBuilder;
            SVertexBuilder.endSetVertexFormat(wrr);
            int i2 = wrr.e * svertexbuilder.vertexSize;
            for (int j2 = 0; j2 < i2; j2 += svertexbuilder.vertexSize * 4) {
                svertexbuilder.calcNormal(wrr, j2);
            }
        }
    }

    public static void drawArrays(int drawMode, int first, int count, bfd wrr) {
        if (count != 0) {
            bmu vertexformat = wrr.g();
            int i2 = vertexformat.g();
            if (i2 == 56) {
                ByteBuffer bytebuffer = wrr.f();
                bytebuffer.position(32);
                GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)i2, (ByteBuffer)bytebuffer);
                bytebuffer.position(40);
                GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)i2, (ByteBuffer)bytebuffer);
                bytebuffer.position(48);
                GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)i2, (ByteBuffer)bytebuffer);
                bytebuffer.position(0);
                GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
                GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
                GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
                bfl.glDrawArrays(drawMode, first, count);
                GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
                GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
                GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
            } else {
                bfl.glDrawArrays(drawMode, first, count);
            }
        }
    }
}

