/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.optifine.BlockPosM;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.util.EntityUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static aui fogColorNether = null;
    private static aui fogColorEnd = null;
    private static aui skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static int[] potionColors = null;
    private static final alz BLOCK_STATE_DIRT = afi.d.Q();
    private static final alz BLOCK_STATE_WATER = afi.j.Q();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        public int getColor(alz blockState, adq blockAccess, cj blockPos) {
            ady biomegenbase = CustomColors.getColorBiome(blockAccess, blockPos);
            return swampGrassColors != null && biomegenbase == ady.v ? swampGrassColors.getColor(biomegenbase, blockPos) : biomegenbase.b(blockPos);
        }

        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        public int getColor(alz blockState, adq blockAccess, cj blockPos) {
            ady biomegenbase = CustomColors.getColorBiome(blockAccess, blockPos);
            return swampFoliageColors != null && biomegenbase == ady.v ? swampFoliageColors.getColor(biomegenbase, blockPos) : biomegenbase.c(blockPos);
        }

        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        public int getColor(alz blockState, adq blockAccess, cj blockPos) {
            return foliagePineColors != null ? foliagePineColors.getColor(blockAccess, blockPos) : adj.a();
        }

        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        public int getColor(alz blockState, adq blockAccess, cj blockPos) {
            return foliageBirchColors != null ? foliageBirchColors.getColor(blockAccess, blockPos) : adj.b();
        }

        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        public int getColor(alz blockState, adq blockAccess, cj blockPos) {
            ady biomegenbase = CustomColors.getColorBiome(blockAccess, blockPos);
            return waterColors != null ? waterColors.getColor(biomegenbase, blockPos) : (Reflector.ForgeBiome_getWaterColorMultiplier.exists() ? Reflector.callInt(biomegenbase, Reflector.ForgeBiome_getWaterColorMultiplier, new Object[0]) : biomegenbase.ar);
        }

        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty("mcpatcher/color.properties", "palette.format", CustomColormap.FORMAT_STRINGS, "vanilla");
        String s2 = "mcpatcher/colormap/";
        String[] astring = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColors.getCustomColors(s2, astring, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (Config.isCustomColors()) {
            String[] astring1 = new String[]{"pine.png", "pinecolor.png"};
            foliagePineColors = CustomColors.getCustomColors(s2, astring1, 256, 256);
            String[] astring2 = new String[]{"birch.png", "birchcolor.png"};
            foliageBirchColors = CustomColors.getCustomColors(s2, astring2, 256, 256);
            String[] astring3 = new String[]{"swampgrass.png", "swampgrasscolor.png"};
            swampGrassColors = CustomColors.getCustomColors(s2, astring3, 256, 256);
            String[] astring4 = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
            swampFoliageColors = CustomColors.getCustomColors(s2, astring4, 256, 256);
            String[] astring5 = new String[]{"sky0.png", "skycolor0.png"};
            skyColors = CustomColors.getCustomColors(s2, astring5, 256, 256);
            String[] astring6 = new String[]{"fog0.png", "fogcolor0.png"};
            fogColors = CustomColors.getCustomColors(s2, astring6, 256, 256);
            String[] astring7 = new String[]{"underwater.png", "underwatercolor.png"};
            underwaterColors = CustomColors.getCustomColors(s2, astring7, 256, 256);
            String[] astring8 = new String[]{"underlava.png", "underlavacolor.png"};
            underlavaColors = CustomColors.getCustomColors(s2, astring8, 256, 256);
            String[] astring9 = new String[]{"redstone.png", "redstonecolor.png"};
            redstoneColors = CustomColors.getCustomColors(s2, astring9, 16, 1);
            xpOrbColors = CustomColors.getCustomColors(s2 + "xporb.png", -1, -1);
            durabilityColors = CustomColors.getCustomColors(s2 + "durability.png", -1, -1);
            String[] astring10 = new String[]{"stem.png", "stemcolor.png"};
            stemColors = CustomColors.getCustomColors(s2, astring10, 8, 1);
            stemPumpkinColors = CustomColors.getCustomColors(s2 + "pumpkinstem.png", 8, 1);
            stemMelonColors = CustomColors.getCustomColors(s2 + "melonstem.png", 8, 1);
            String[] astring11 = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
            myceliumParticleColors = CustomColors.getCustomColors(s2, astring11, -1, -1);
            Pair<LightMapPack[], Integer> pair = CustomColors.parseLightMapPacks();
            lightMapPacks = (LightMapPack[])pair.getLeft();
            lightmapMinDimensionId = (Integer)pair.getRight();
            CustomColors.readColorProperties("mcpatcher/color.properties");
            blockColormaps = CustomColors.readBlockColormaps(new String[]{s2 + "custom/", s2 + "blocks/"}, colorsBlockColormaps, 256, 256);
            CustomColors.updateUseDefaultGrassFoliageColors();
        }
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            jy resourcelocation = new jy(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return valDef;
            }
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            String s2 = properties.getProperty(key);
            if (s2 == null) {
                return valDef;
            }
            List<String> list = Arrays.asList(validValues);
            if (!list.contains(s2)) {
                CustomColors.warn("Invalid value: " + key + "=" + s2);
                CustomColors.warn("Expected values: " + Config.arrayToString(validValues));
                return valDef;
            }
            CustomColors.dbg("" + key + "=" + s2);
            return s2;
        }
        catch (FileNotFoundException var9) {
            return valDef;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String s2 = "mcpatcher/lightmap/world";
        String s1 = ".png";
        String[] astring = ResUtils.collectFiles(s2, s1);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s22 = astring[i2];
            String s3 = StrUtils.removePrefixSuffix(s22, s2, s1);
            int j2 = Config.parseInt(s3, Integer.MIN_VALUE);
            if (j2 == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + s3 + ", path: " + s22);
                continue;
            }
            map.put(j2, s22);
        }
        Set set = map.keySet();
        Integer[] ainteger = set.toArray(new Integer[set.size()]);
        Arrays.sort((Object[])ainteger);
        if (ainteger.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int j1 = ainteger[0];
        int k1 = ainteger[ainteger.length - 1];
        int k2 = k1 - j1 + 1;
        CustomColormap[] acustomcolormap = new CustomColormap[k2];
        for (int l2 = 0; l2 < ainteger.length; ++l2) {
            Integer integer = ainteger[l2];
            String s4 = (String)map.get(integer);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, -1, -1);
            if (customcolormap == null) continue;
            if (customcolormap.getWidth() < 16) {
                CustomColors.warn("Invalid lightmap width: " + customcolormap.getWidth() + ", path: " + s4);
                continue;
            }
            int i1 = integer - j1;
            acustomcolormap[i1] = customcolormap;
        }
        LightMapPack[] alightmappack = new LightMapPack[acustomcolormap.length];
        for (int l1 = 0; l1 < acustomcolormap.length; ++l1) {
            LightMapPack lightmappack;
            CustomColormap customcolormap3 = acustomcolormap[l1];
            if (customcolormap3 == null) continue;
            String s5 = customcolormap3.name;
            String s6 = customcolormap3.basePath;
            CustomColormap customcolormap1 = CustomColors.getCustomColors(s6 + "/" + s5 + "_rain.png", -1, -1);
            CustomColormap customcolormap2 = CustomColors.getCustomColors(s6 + "/" + s5 + "_thunder.png", -1, -1);
            LightMap lightmap = new LightMap(customcolormap3);
            LightMap lightmap1 = customcolormap1 != null ? new LightMap(customcolormap1) : null;
            LightMap lightmap2 = customcolormap2 != null ? new LightMap(customcolormap2) : null;
            alightmappack[l1] = lightmappack = new LightMapPack(lightmap, lightmap1, lightmap2);
        }
        return new ImmutablePair((Object)alightmappack, (Object)j1);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream inputstream = Config.getResourceStream(new jy(path));
            if (inputstream == null) {
                return defHeight;
            }
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            inputstream.close();
            return bufferedimage == null ? defHeight : bufferedimage.getHeight();
        }
        catch (IOException var4) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            jy resourcelocation = new jy(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            CustomColors.dbg("Loading " + fileName);
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            particleWaterColor = CustomColors.readColor((Properties)properties, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)properties, "particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)properties, "lilypad");
            expBarTextColor = CustomColors.readColor((Properties)properties, "text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)properties, "text.boss");
            signTextColor = CustomColors.readColor((Properties)properties, "text.sign");
            fogColorNether = CustomColors.readColorVec3(properties, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(properties, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(properties, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(properties, fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(properties, fileName, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(properties, fileName, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(properties, fileName, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(properties, fileName, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(properties, fileName, "text.code.", "Text");
            int[] aint = CustomColors.readMapColors(properties, fileName, "map.", "Map");
            if (aint != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(aint);
            }
            potionColors = CustomColors.readPotionColors(properties, fileName, "potion.", "Potion");
            xpOrbTime = Config.parseInt(properties.getProperty("xporb.time"), -1);
        }
        catch (FileNotFoundException var5) {
            return;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String s2 = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o2 : props.keySet()) {
            String s1 = (String)o2;
            String s22 = props.getProperty(s1);
            if (!s1.startsWith(s2)) continue;
            map.put(s1, s22);
        }
        String[] astring = map.keySet().toArray(new String[map.size()]);
        for (int j2 = 0; j2 < astring.length; ++j2) {
            String s6 = astring[j2];
            String s3 = props.getProperty(s6);
            CustomColors.dbg("Block palette: " + s6 + " = " + s3);
            String s4 = s6.substring(s2.length());
            String s5 = TextureUtils.getBasePath(fileName);
            s4 = TextureUtils.fixResourcePath(s4, s5);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, 256, 256);
            if (customcolormap == null) {
                CustomColors.warn("Colormap not found: " + s4);
                continue;
            }
            ConnectedParser connectedparser = new ConnectedParser("CustomColors");
            MatchBlock[] amatchblock = connectedparser.parseMatchBlocks(s3);
            if (amatchblock != null && amatchblock.length > 0) {
                for (int i2 = 0; i2 < amatchblock.length; ++i2) {
                    MatchBlock matchblock = amatchblock[i2];
                    customcolormap.addMatchBlock(matchblock);
                }
                list.add(customcolormap);
                continue;
            }
            CustomColors.warn("Invalid match blocks: " + s3);
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] acustomcolormap = list.toArray(new CustomColormap[list.size()]);
        return acustomcolormap;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        String[] astring = ResUtils.collectFiles(basePaths, new String[]{".properties"});
        Arrays.sort(astring);
        ArrayList list = new ArrayList();
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = astring[i2];
            CustomColors.dbg("Block colormap: " + s2);
            try {
                jy resourcelocation = new jy("minecraft", s2);
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) {
                    CustomColors.warn("File not found: " + s2);
                    continue;
                }
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                CustomColormap customcolormap = new CustomColormap(properties, s2, width, height, paletteFormatDefault);
                if (!customcolormap.isValid(s2) || !customcolormap.isValidMatchBlocks(s2)) continue;
                CustomColors.addToBlockList(customcolormap, list);
                continue;
            }
            catch (FileNotFoundException var12) {
                CustomColors.warn("File not found: " + s2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (int j2 = 0; j2 < basePalettes.length; ++j2) {
                CustomColormap customcolormap1 = basePalettes[j2];
                CustomColors.addToBlockList(customcolormap1, list);
            }
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[][] acustomcolormap = CustomColors.blockListToArray(list);
        return acustomcolormap;
    }

    private static void addToBlockList(CustomColormap cm2, List blockList) {
        int[] aint = cm2.getMatchBlockIds();
        if (aint != null && aint.length > 0) {
            for (int i2 = 0; i2 < aint.length; ++i2) {
                int j2 = aint[i2];
                if (j2 < 0) {
                    CustomColors.warn("Invalid block ID: " + j2);
                    continue;
                }
                CustomColors.addToList(cm2, blockList, j2);
            }
        } else {
            CustomColors.warn("No match blocks: " + Config.arrayToString(aint));
        }
    }

    private static void addToList(CustomColormap cm2, List list, int id2) {
        while (id2 >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> list2 = (ArrayList<CustomColormap>)list.get(id2);
        if (list2 == null) {
            list2 = new ArrayList<CustomColormap>();
            list.set(id2, list2);
        }
        list2.add(cm2);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] acustomcolormap = new CustomColormap[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = (List)list.get(i2);
            if (list2 == null) continue;
            CustomColormap[] acustomcolormap1 = list2.toArray(new CustomColormap[list2.size()]);
            acustomcolormap[i2] = acustomcolormap1;
        }
        return acustomcolormap;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            String s2 = names[i2];
            int j2 = CustomColors.readColor(props, s2);
            if (j2 < 0) continue;
            return j2;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String s2 = props.getProperty(name);
        if (s2 == null) {
            return -1;
        }
        int i2 = CustomColors.parseColor(s2 = s2.trim());
        if (i2 < 0) {
            CustomColors.warn("Invalid color: " + name + " = " + s2);
            return i2;
        }
        CustomColors.dbg(name + " = " + s2);
        return i2;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int i2 = Integer.parseInt(str, 16) & 0xFFFFFF;
            return i2;
        }
        catch (NumberFormatException var2) {
            return -1;
        }
    }

    private static aui readColorVec3(Properties props, String name) {
        int i2 = CustomColors.readColor(props, name);
        if (i2 < 0) {
            return null;
        }
        int j2 = i2 >> 16 & 0xFF;
        int k2 = i2 >> 8 & 0xFF;
        int l2 = i2 & 0xFF;
        float f2 = (float)j2 / 255.0f;
        float f1 = (float)k2 / 255.0f;
        float f22 = (float)l2 / 255.0f;
        return new aui(f2, f1, f22);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String s2 = paths[i2];
            s2 = basePath + s2;
            CustomColormap customcolormap = CustomColors.getCustomColors(s2, width, height);
            if (customcolormap == null) continue;
            return customcolormap;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            jy resourcelocation = new jy(pathImage);
            if (!Config.hasResource(resourcelocation)) {
                return null;
            }
            CustomColors.dbg("Colormap " + pathImage);
            PropertiesOrdered properties = new PropertiesOrdered();
            String s2 = StrUtils.replaceSuffix(pathImage, ".png", ".properties");
            jy resourcelocation1 = new jy(s2);
            if (Config.hasResource(resourcelocation1)) {
                InputStream inputstream = Config.getResourceStream(resourcelocation1);
                properties.load(inputstream);
                inputstream.close();
                CustomColors.dbg("Colormap properties: " + s2);
            } else {
                ((Properties)properties).put("format", paletteFormatDefault);
                ((Properties)properties).put("source", pathImage);
                s2 = pathImage;
            }
            CustomColormap customcolormap = new CustomColormap(properties, s2, width, height, paletteFormatDefault);
            return !customcolormap.isValid(s2) ? null : customcolormap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(bgg quad, alz blockState, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        IColorizer customcolors$icolorizer;
        afh block = blockState.c();
        alz iblockstate = renderEnv.getBlockState();
        if (blockColormaps != null) {
            CustomColormap customcolormap;
            if (!quad.b()) {
                if (block == afi.c) {
                    iblockstate = BLOCK_STATE_DIRT;
                }
                if (block == afi.af) {
                    return -1;
                }
            }
            if (block == afi.cF && renderEnv.getMetadata() >= 8) {
                blockPos = blockPos.b();
                iblockstate = blockAccess.p(blockPos);
            }
            if ((customcolormap = CustomColors.getBlockColormap(iblockstate)) != null) {
                if (Config.isSmoothBiomes() && !customcolormap.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolormap, renderEnv.getColorizerBlockPosM());
                }
                return customcolormap.getColor(blockAccess, blockPos);
            }
        }
        if (!quad.b()) {
            return -1;
        }
        if (block == afi.bx) {
            return CustomColors.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block == afi.af) {
            return CustomColors.getRedstoneColor(renderEnv.getBlockState());
        }
        if (block instanceof ajx) {
            return CustomColors.getStemColorMultiplier(block, blockAccess, blockPos, renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        int i2 = renderEnv.getMetadata();
        if (block != afi.c && block != afi.H && block != afi.cF) {
            if (block == afi.cF) {
                customcolors$icolorizer = COLORIZER_GRASS;
                if (i2 >= 8) {
                    blockPos = blockPos.b();
                }
            } else if (block == afi.t) {
                switch (i2 & 3) {
                    case 0: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE;
                        break;
                    }
                    case 1: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE_PINE;
                        break;
                    }
                    case 2: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE_BIRCH;
                        break;
                    }
                    default: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE;
                        break;
                    }
                }
            } else if (block == afi.u) {
                customcolors$icolorizer = COLORIZER_FOLIAGE;
            } else {
                if (block != afi.bn) {
                    return -1;
                }
                customcolors$icolorizer = COLORIZER_FOLIAGE;
            }
        } else {
            customcolors$icolorizer = COLORIZER_GRASS;
        }
        return Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolors$icolorizer, renderEnv.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(iblockstate, blockAccess, blockPos);
    }

    protected static ady getColorBiome(adq blockAccess, cj blockPos) {
        ady biomegenbase = blockAccess.b(blockPos);
        if (biomegenbase == ady.v && !Config.isSwampColors()) {
            biomegenbase = ady.q;
        }
        return biomegenbase;
    }

    private static CustomColormap getBlockColormap(alz blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof aly)) {
            return null;
        }
        aly blockstatebase = (aly)blockState;
        int i2 = blockstatebase.getBlockId();
        if (i2 >= 0 && i2 < blockColormaps.length) {
            CustomColormap[] acustomcolormap = blockColormaps[i2];
            if (acustomcolormap == null) {
                return null;
            }
            for (int j2 = 0; j2 < acustomcolormap.length; ++j2) {
                CustomColormap customcolormap = acustomcolormap[j2];
                if (!customcolormap.matchesBlock(blockstatebase)) continue;
                return customcolormap;
            }
            return null;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(alz blockState, adq blockAccess, cj blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = blockPos.n();
        int i1 = blockPos.o();
        int j1 = blockPos.p();
        BlockPosM blockposm = blockPosM;
        for (int k1 = l2 - 1; k1 <= l2 + 1; ++k1) {
            for (int l1 = j1 - 1; l1 <= j1 + 1; ++l1) {
                blockposm.setXyz(k1, i1, l1);
                int i22 = colorizer.getColor(blockState, blockAccess, blockposm);
                i2 += i22 >> 16 & 0xFF;
                j2 += i22 >> 8 & 0xFF;
                k2 += i22 & 0xFF;
            }
        }
        int j22 = i2 / 9;
        int k22 = j2 / 9;
        int l22 = k2 / 9;
        return j22 << 16 | k22 << 8 | l22;
    }

    public static int getFluidColor(adq blockAccess, alz blockState, cj blockPos, RenderEnv renderEnv) {
        afh block = blockState.c();
        IColorizer customcolors$icolorizer = CustomColors.getBlockColormap(blockState);
        if (customcolors$icolorizer == null && blockState.c().t() == arm.h) {
            customcolors$icolorizer = COLORIZER_WATER;
        }
        return customcolors$icolorizer == null ? block.a(blockAccess, blockPos, 0) : (Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, customcolors$icolorizer, renderEnv.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(blockState, blockAccess, blockPos));
    }

    public static void updatePortalFX(beb fx2) {
        if (particlePortalColor >= 0) {
            int i2 = particlePortalColor;
            int j2 = i2 >> 16 & 0xFF;
            int k2 = i2 >> 8 & 0xFF;
            int l2 = i2 & 0xFF;
            float f2 = (float)j2 / 255.0f;
            float f1 = (float)k2 / 255.0f;
            float f22 = (float)l2 / 255.0f;
            fx2.b(f2, f1, f22);
        }
    }

    public static void updateMyceliumFX(beb fx2) {
        if (myceliumParticleColors != null) {
            int i2 = myceliumParticleColors.getColorRandom();
            int j2 = i2 >> 16 & 0xFF;
            int k2 = i2 >> 8 & 0xFF;
            int l2 = i2 & 0xFF;
            float f2 = (float)j2 / 255.0f;
            float f1 = (float)k2 / 255.0f;
            float f22 = (float)l2 / 255.0f;
            fx2.b(f2, f1, f22);
        }
    }

    private static int getRedstoneColor(alz blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int i2 = CustomColors.getRedstoneLevel(blockState, 15);
        int j2 = redstoneColors.getColor(i2);
        return j2;
    }

    public static void updateReddustFX(beb fx2, adq blockAccess, double x2, double y2, double z2) {
        if (redstoneColors != null) {
            alz iblockstate = blockAccess.p(new cj(x2, y2, z2));
            int i2 = CustomColors.getRedstoneLevel(iblockstate, 15);
            int j2 = redstoneColors.getColor(i2);
            int k2 = j2 >> 16 & 0xFF;
            int l2 = j2 >> 8 & 0xFF;
            int i1 = j2 & 0xFF;
            float f2 = (float)k2 / 255.0f;
            float f1 = (float)l2 / 255.0f;
            float f22 = (float)i1 / 255.0f;
            fx2.b(f2, f1, f22);
        }
    }

    private static int getRedstoneLevel(alz state, int def) {
        afh block = state.c();
        if (!(block instanceof ajb)) {
            return def;
        }
        Integer object = state.b(ajb.P);
        if (!(object instanceof Integer)) {
            return def;
        }
        Integer integer = object;
        return integer;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float f2 = 628.0f / (float)xpOrbTime;
        return timer * f2;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int i2 = (int)Math.round((double)((ns.a(timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int j2 = xpOrbColors.getColor(i2);
        return j2;
    }

    public static int getDurabilityColor(int dur255) {
        if (durabilityColors == null) {
            return -1;
        }
        int i2 = dur255 * durabilityColors.getLength() / 255;
        int j2 = durabilityColors.getColor(i2);
        return j2;
    }

    public static void updateWaterFX(beb fx2, adq blockAccess, double x2, double y2, double z2, RenderEnv renderEnv) {
        if (waterColors != null || blockColormaps != null || particleWaterColor >= 0) {
            cj blockpos = new cj(x2, y2, z2);
            renderEnv.reset(BLOCK_STATE_WATER, blockpos);
            int i2 = CustomColors.getFluidColor(blockAccess, BLOCK_STATE_WATER, blockpos, renderEnv);
            int j2 = i2 >> 16 & 0xFF;
            int k2 = i2 >> 8 & 0xFF;
            int l2 = i2 & 0xFF;
            float f2 = (float)j2 / 255.0f;
            float f1 = (float)k2 / 255.0f;
            float f22 = (float)l2 / 255.0f;
            if (particleWaterColor >= 0) {
                int i1 = particleWaterColor >> 16 & 0xFF;
                int j1 = particleWaterColor >> 8 & 0xFF;
                int k1 = particleWaterColor & 0xFF;
                f2 *= (float)i1 / 255.0f;
                f1 *= (float)j1 / 255.0f;
                f22 *= (float)k1 / 255.0f;
            }
            fx2.b(f2, f1, f22);
        }
    }

    private static int getLilypadColorMultiplier(adq blockAccess, cj blockPos) {
        return lilyPadColor < 0 ? afi.bx.d(blockAccess, blockPos) : lilyPadColor;
    }

    private static aui getFogColorNether(aui col) {
        return fogColorNether == null ? col : fogColorNether;
    }

    private static aui getFogColorEnd(aui col) {
        return fogColorEnd == null ? col : fogColorEnd;
    }

    private static aui getSkyColorEnd(aui col) {
        return skyColorEnd == null ? col : skyColorEnd;
    }

    public static aui getSkyColor(aui skyColor3d, adq blockAccess, double x2, double y2, double z2) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int i2 = skyColors.getColorSmooth(blockAccess, x2, y2, z2, 3);
        int j2 = i2 >> 16 & 0xFF;
        int k2 = i2 >> 8 & 0xFF;
        int l2 = i2 & 0xFF;
        float f2 = (float)j2 / 255.0f;
        float f1 = (float)k2 / 255.0f;
        float f22 = (float)l2 / 255.0f;
        float f3 = (float)skyColor3d.a / 0.5f;
        float f4 = (float)skyColor3d.b / 0.66275f;
        float f5 = (float)skyColor3d.c;
        aui vec3 = skyColorFader.getColor(f2 *= f3, f1 *= f4, f22 *= f5);
        return vec3;
    }

    private static aui getFogColor(aui fogColor3d, adq blockAccess, double x2, double y2, double z2) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int i2 = fogColors.getColorSmooth(blockAccess, x2, y2, z2, 3);
        int j2 = i2 >> 16 & 0xFF;
        int k2 = i2 >> 8 & 0xFF;
        int l2 = i2 & 0xFF;
        float f2 = (float)j2 / 255.0f;
        float f1 = (float)k2 / 255.0f;
        float f22 = (float)l2 / 255.0f;
        float f3 = (float)fogColor3d.a / 0.753f;
        float f4 = (float)fogColor3d.b / 0.8471f;
        float f5 = (float)fogColor3d.c;
        aui vec3 = fogColorFader.getColor(f2 *= f3, f1 *= f4, f22 *= f5);
        return vec3;
    }

    public static aui getUnderwaterColor(adq blockAccess, double x2, double y2, double z2) {
        return CustomColors.getUnderFluidColor(blockAccess, x2, y2, z2, underwaterColors, underwaterColorFader);
    }

    public static aui getUnderlavaColor(adq blockAccess, double x2, double y2, double z2) {
        return CustomColors.getUnderFluidColor(blockAccess, x2, y2, z2, underlavaColors, underlavaColorFader);
    }

    public static aui getUnderFluidColor(adq blockAccess, double x2, double y2, double z2, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int i2 = underFluidColors.getColorSmooth(blockAccess, x2, y2, z2, 3);
        int j2 = i2 >> 16 & 0xFF;
        int k2 = i2 >> 8 & 0xFF;
        int l2 = i2 & 0xFF;
        float f2 = (float)j2 / 255.0f;
        float f1 = (float)k2 / 255.0f;
        float f22 = (float)l2 / 255.0f;
        aui vec3 = underFluidColorFader.getColor(f2, f1, f22);
        return vec3;
    }

    private static int getStemColorMultiplier(afh blockStem, adq blockAccess, cj blockPos, RenderEnv renderEnv) {
        CustomColormap customcolormap = stemColors;
        if (blockStem == afi.bl && stemPumpkinColors != null) {
            customcolormap = stemPumpkinColors;
        }
        if (blockStem == afi.bm && stemMelonColors != null) {
            customcolormap = stemMelonColors;
        }
        if (customcolormap == null) {
            return -1;
        }
        int i2 = renderEnv.getMetadata();
        return customcolormap.getColor(i2);
    }

    public static boolean updateLightmap(adm world, float torchFlickerX, int[] lmColors, boolean nightvision, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int i2 = world.t.q();
        int j2 = i2 - lightmapMinDimensionId;
        if (j2 >= 0 && j2 < lightMapPacks.length) {
            LightMapPack lightmappack = lightMapPacks[j2];
            return lightmappack == null ? false : lightmappack.updateLightmap(world, torchFlickerX, lmColors, nightvision, partialTicks);
        }
        return false;
    }

    public static aui getWorldFogColor(aui fogVec, adm world, pk renderViewEntity, float partialTicks) {
        int i2 = world.t.q();
        switch (i2) {
            case -1: {
                fogVec = CustomColors.getFogColorNether(fogVec);
                break;
            }
            case 0: {
                ave minecraft = ave.A();
                fogVec = CustomColors.getFogColor(fogVec, minecraft.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                fogVec = CustomColors.getFogColorEnd(fogVec);
            }
        }
        return fogVec;
    }

    public static aui getWorldSkyColor(aui skyVec, adm world, pk renderViewEntity, float partialTicks) {
        int i2 = world.t.q();
        switch (i2) {
            case 0: {
                ave minecraft = ave.A();
                skyVec = CustomColors.getSkyColor(skyVec, minecraft.f, renderViewEntity.s, renderViewEntity.t + 1.0, renderViewEntity.u);
                break;
            }
            case 1: {
                skyVec = CustomColors.getSkyColorEnd(skyVec);
            }
        }
        return skyVec;
    }

    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> set = props.keySet();
        int i2 = 0;
        for (Object o2 : set) {
            String s2 = (String)o2;
            String s1 = props.getProperty(s2);
            if (!s2.startsWith(prefix)) continue;
            String s22 = StrUtils.removePrefix(s2, prefix);
            int j2 = EntityUtils.getEntityIdByName(s22);
            if (j2 < 0) {
                CustomColors.warn("Invalid spawn egg name: " + s2);
                continue;
            }
            int k2 = CustomColors.parseColor(s1);
            if (k2 < 0) {
                CustomColors.warn("Invalid spawn egg color: " + s2 + " = " + s1);
                continue;
            }
            while (list.size() <= j2) {
                list.add(-1);
            }
            list.set(j2, k2);
            ++i2;
        }
        if (i2 <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + i2);
        int[] aint = new int[list.size()];
        for (int l2 = 0; l2 < aint.length; ++l2) {
            aint[l2] = (Integer)list.get(l2);
        }
        return aint;
    }

    private static int getSpawnEggColor(aax item, zx itemStack, int layer, int color) {
        int[] aint;
        int i2 = itemStack.i();
        int[] nArray = aint = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (aint == null) {
            return color;
        }
        if (i2 >= 0 && i2 < aint.length) {
            int j2 = aint[i2];
            return j2 < 0 ? color : j2;
        }
        return color;
    }

    public static int getColorFromItemStack(zx itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        zw item = itemStack.b();
        return item == null ? color : (item instanceof aax ? CustomColors.getSpawnEggColor((aax)item, itemStack, layer, color) : color);
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        zd[] aenumdyecolor = zd.values();
        HashMap<String, zd> map = new HashMap<String, zd>();
        for (int i2 = 0; i2 < aenumdyecolor.length; ++i2) {
            zd enumdyecolor = aenumdyecolor[i2];
            map.put(enumdyecolor.l(), enumdyecolor);
        }
        float[][] afloat1 = new float[aenumdyecolor.length][];
        int k2 = 0;
        for (Object o2 : props.keySet()) {
            String s2 = (String)o2;
            String s1 = props.getProperty(s2);
            if (!s2.startsWith(prefix)) continue;
            String s22 = StrUtils.removePrefix(s2, prefix);
            if (s22.equals("lightBlue")) {
                s22 = "light_blue";
            }
            zd enumdyecolor1 = (zd)map.get(s22);
            int j2 = CustomColors.parseColor(s1);
            if (enumdyecolor1 != null && j2 >= 0) {
                float[] afloat = new float[]{(float)(j2 >> 16 & 0xFF) / 255.0f, (float)(j2 >> 8 & 0xFF) / 255.0f, (float)(j2 & 0xFF) / 255.0f};
                afloat1[enumdyecolor1.ordinal()] = afloat;
                ++k2;
                continue;
            }
            CustomColors.warn("Invalid color: " + s2 + " = " + s1);
        }
        if (k2 <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + k2);
        return afloat1;
    }

    private static float[] getDyeColors(zd dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] afloat = dyeColors[dye.ordinal()];
        return afloat == null ? colors : afloat;
    }

    public static float[] getWolfCollarColors(zd dye, float[] colors) {
        return CustomColors.getDyeColors(dye, wolfCollarColors, colors);
    }

    public static float[] getSheepColors(zd dye, float[] colors) {
        return CustomColors.getDyeColors(dye, sheepColors, colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[32];
        Arrays.fill(aint, -1);
        int i2 = 0;
        for (Object o2 : props.keySet()) {
            String s2 = (String)o2;
            String s1 = props.getProperty(s2);
            if (!s2.startsWith(prefix)) continue;
            String s22 = StrUtils.removePrefix(s2, prefix);
            int j2 = Config.parseInt(s22, -1);
            int k2 = CustomColors.parseColor(s1);
            if (j2 >= 0 && j2 < aint.length && k2 >= 0) {
                aint[j2] = k2;
                ++i2;
                continue;
            }
            CustomColors.warn("Invalid color: " + s2 + " = " + s1);
        }
        if (i2 <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + i2);
        return aint;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index >= 0 && index < textColors.length) {
            int i2 = textColors[index];
            return i2 < 0 ? color : i2;
        }
        return color;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[arn.a.length];
        Arrays.fill(aint, -1);
        int i2 = 0;
        for (Object o2 : props.keySet()) {
            String s2 = (String)o2;
            String s1 = props.getProperty(s2);
            if (!s2.startsWith(prefix)) continue;
            String s22 = StrUtils.removePrefix(s2, prefix);
            int j2 = CustomColors.getMapColorIndex(s22);
            int k2 = CustomColors.parseColor(s1);
            if (j2 >= 0 && j2 < aint.length && k2 >= 0) {
                aint[j2] = k2;
                ++i2;
                continue;
            }
            CustomColors.warn("Invalid color: " + s2 + " = " + s1);
        }
        if (i2 <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + i2);
        return aint;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] aint = new int[pe.a.length];
        Arrays.fill(aint, -1);
        int i2 = 0;
        for (Object o2 : props.keySet()) {
            String s2 = (String)o2;
            String s1 = props.getProperty(s2);
            if (!s2.startsWith(prefix)) continue;
            int j2 = CustomColors.getPotionId(s2);
            int k2 = CustomColors.parseColor(s1);
            if (j2 >= 0 && j2 < aint.length && k2 >= 0) {
                aint[j2] = k2;
                ++i2;
                continue;
            }
            CustomColors.warn("Invalid color: " + s2 + " = " + s1);
        }
        if (i2 <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + i2);
        return aint;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        pe[] apotion = pe.a;
        for (int i2 = 0; i2 < apotion.length; ++i2) {
            pe potion = apotion[i2];
            if (potion == null || !potion.a().equals(name)) continue;
            return potion.d();
        }
        return -1;
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId >= 0 && potionId < potionColors.length) {
            int i2 = potionColors[potionId];
            return i2 < 0 ? color : i2;
        }
        return color;
    }

    private static int getMapColorIndex(String name) {
        return name == null ? -1 : (name.equals("air") ? arn.b.M : (name.equals("grass") ? arn.c.M : (name.equals("sand") ? arn.d.M : (name.equals("cloth") ? arn.e.M : (name.equals("tnt") ? arn.f.M : (name.equals("ice") ? arn.g.M : (name.equals("iron") ? arn.h.M : (name.equals("foliage") ? arn.i.M : (name.equals("clay") ? arn.k.M : (name.equals("dirt") ? arn.l.M : (name.equals("stone") ? arn.m.M : (name.equals("water") ? arn.n.M : (name.equals("wood") ? arn.o.M : (name.equals("quartz") ? arn.p.M : (name.equals("gold") ? arn.F.M : (name.equals("diamond") ? arn.G.M : (name.equals("lapis") ? arn.H.M : (name.equals("emerald") ? arn.I.M : (name.equals("podzol") ? arn.J.M : (name.equals("netherrack") ? arn.K.M : (!name.equals("snow") && !name.equals("white") ? (!name.equals("adobe") && !name.equals("orange") ? (name.equals("magenta") ? arn.r.M : (!name.equals("light_blue") && !name.equals("lightBlue") ? (name.equals("yellow") ? arn.t.M : (name.equals("lime") ? arn.u.M : (name.equals("pink") ? arn.v.M : (name.equals("gray") ? arn.w.M : (name.equals("silver") ? arn.x.M : (name.equals("cyan") ? arn.y.M : (name.equals("purple") ? arn.z.M : (name.equals("blue") ? arn.A.M : (name.equals("brown") ? arn.B.M : (name.equals("green") ? arn.C.M : (name.equals("red") ? arn.D.M : (name.equals("black") ? arn.E.M : -1)))))))))))) : arn.s.M)) : arn.q.M) : arn.j.M)))))))))))))))))))));
    }

    private static int[] getMapColors() {
        arn[] amapcolor = arn.a;
        int[] aint = new int[amapcolor.length];
        Arrays.fill(aint, -1);
        for (int i2 = 0; i2 < amapcolor.length && i2 < aint.length; ++i2) {
            arn mapcolor = amapcolor[i2];
            if (mapcolor == null) continue;
            aint[i2] = mapcolor.L;
        }
        return aint;
    }

    private static void setMapColors(int[] colors) {
        if (colors != null) {
            arn[] amapcolor = arn.a;
            boolean flag = false;
            for (int i2 = 0; i2 < amapcolor.length && i2 < colors.length; ++i2) {
                int j2;
                arn mapcolor = amapcolor[i2];
                if (mapcolor == null || (j2 = colors[i2]) < 0 || mapcolor.L == j2) continue;
                mapcolor.L = j2;
                flag = true;
            }
            if (flag) {
                ave.A().P().reloadBannerTextures();
            }
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    public static int getExpBarTextColor(int color) {
        return expBarTextColor < 0 ? color : expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        return bossTextColor < 0 ? color : bossTextColor;
    }

    public static int getSignTextColor(int color) {
        return signTextColor < 0 ? color : signTextColor;
    }

    public static interface IColorizer {
        public int getColor(alz var1, adq var2, cj var3);

        public boolean isColorConstant();
    }
}

