/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleThreadEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTTING_DOWN = 3;
    private static final int ST_SHUTDOWN = 4;
    private static final int ST_TERMINATED = 5;
    private static final Runnable WAKEUP_TASK = new Runnable(){

        public void run() {
        }
    };
    private final EventExecutorGroup parent;
    private final Queue<Runnable> taskQueue;
    final Queue<ScheduledFutureTask<?>> delayedTaskQueue = new PriorityQueue();
    private final Thread thread;
    private final Object stateLock = new Object();
    private final Semaphore threadLock = new Semaphore(0);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup parent, ThreadFactory threadFactory, boolean addTaskWakesUp) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        this.parent = parent;
        this.addTaskWakesUp = addTaskWakesUp;
        this.thread = threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block35: {
                    block31: {
                        block34: {
                            block29: {
                                block33: {
                                    success = false;
                                    SingleThreadEventExecutor.this.updateLastExecutionTime();
                                    try {
                                        try {
                                            SingleThreadEventExecutor.this.run();
                                            success = true;
                                        }
                                        catch (Throwable t) {
                                            SingleThreadEventExecutor.access$000().warn("Unexpected exception from an event executor: ", t);
                                            var4_3 = null;
                                            if (SingleThreadEventExecutor.access$100(SingleThreadEventExecutor.this) < 3) {
                                                SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 3);
                                            }
                                            if (success && SingleThreadEventExecutor.access$200(SingleThreadEventExecutor.this) == 0L) {
                                                SingleThreadEventExecutor.access$000().error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called " + "before run() implementation terminates.");
                                            }
                                            try {
                                                while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                                                }
                                                v0 = null;
                                            }
                                            catch (Throwable var5_6) {
                                                v0 = null;
                                            }
                                            break block29;
                                        }
                                        var4_2 = null;
                                    }
                                    catch (Throwable var3_21) {
                                        var4_4 = null;
                                        if (SingleThreadEventExecutor.access$100(SingleThreadEventExecutor.this) < 3) {
                                            SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 3);
                                        }
                                        if (success && SingleThreadEventExecutor.access$200(SingleThreadEventExecutor.this) == 0L) {
                                            SingleThreadEventExecutor.access$000().error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called " + "before run() implementation terminates.");
                                        }
                                        ** try [egrp 2[TRYBLOCK] [4 : 142->161)] { 
lbl36:
                                        // 2 sources

                                        while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                                        }
                                        v1 = null;
                                        break block31;
lbl40:
                                        // 1 sources

                                        catch (Throwable var5_7) {
                                            v1 = null;
                                            break block31;
                                        }
                                    }
                                    if (SingleThreadEventExecutor.access$100(SingleThreadEventExecutor.this) < 3) {
                                        SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 3);
                                    }
                                    if (success && SingleThreadEventExecutor.access$200(SingleThreadEventExecutor.this) == 0L) {
                                        SingleThreadEventExecutor.access$000().error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called " + "before run() implementation terminates.");
                                    }
                                    ** try [egrp 2[TRYBLOCK] [4 : 142->161)] { 
lbl50:
                                    // 2 sources

                                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                                    }
                                    v2 = null;
                                    break block33;
lbl54:
                                    // 1 sources

                                    catch (Throwable var5_5) {
                                        v2 = null;
                                    }
                                }
                                var6_8 = v2;
                                try {
                                    SingleThreadEventExecutor.this.cleanup();
                                    v3 = null;
                                }
                                catch (Throwable var7_11) {
                                    v3 = null;
                                }
                                var8_14 = v3;
                                var9_17 = SingleThreadEventExecutor.access$300(SingleThreadEventExecutor.this);
                                synchronized (var9_17) {
                                    SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 5);
                                }
                                SingleThreadEventExecutor.access$400(SingleThreadEventExecutor.this).release();
                                if (!SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).isEmpty()) {
                                    SingleThreadEventExecutor.access$000().warn("An event executor terminated with non-empty task queue (" + SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).size() + ')');
                                }
                                SingleThreadEventExecutor.access$600(SingleThreadEventExecutor.this).setSuccess(null);
                                return;
                            }
                            var6_9 = v0;
                            ** try [egrp 3[TRYBLOCK] [6 : 171->184)] { 
lbl79:
                            // 1 sources

                            SingleThreadEventExecutor.this.cleanup();
                            v4 = null;
                            break block34;
lbl82:
                            // 1 sources

                            catch (Throwable var7_12) {
                                v4 = null;
                            }
                        }
                        var8_15 = v4;
                        var9_18 = SingleThreadEventExecutor.access$300(SingleThreadEventExecutor.this);
                        synchronized (var9_18) {
                            SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 5);
                        }
                        SingleThreadEventExecutor.access$400(SingleThreadEventExecutor.this).release();
                        if (!SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).isEmpty()) {
                            SingleThreadEventExecutor.access$000().warn("An event executor terminated with non-empty task queue (" + SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).size() + ')');
                        }
                        SingleThreadEventExecutor.access$600(SingleThreadEventExecutor.this).setSuccess(null);
                        return;
                    }
                    var6_10 = v1;
                    ** try [egrp 3[TRYBLOCK] [6 : 171->184)] { 
lbl99:
                    // 1 sources

                    SingleThreadEventExecutor.this.cleanup();
                    v5 = null;
                    break block35;
lbl102:
                    // 1 sources

                    catch (Throwable var7_13) {
                        v5 = null;
                    }
                }
                var8_16 = v5;
                var9_19 = SingleThreadEventExecutor.access$300(SingleThreadEventExecutor.this);
                synchronized (var9_19) {
                    SingleThreadEventExecutor.access$102(SingleThreadEventExecutor.this, 5);
                }
                SingleThreadEventExecutor.access$400(SingleThreadEventExecutor.this).release();
                if (!SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).isEmpty()) {
                    SingleThreadEventExecutor.access$000().warn("An event executor terminated with non-empty task queue (" + SingleThreadEventExecutor.access$500(SingleThreadEventExecutor.this).size() + ')');
                }
                SingleThreadEventExecutor.access$600(SingleThreadEventExecutor.this).setSuccess(null);
                throw var3_21;
            }
        });
        this.taskQueue = this.newTaskQueue();
    }

    protected Queue<Runnable> newTaskQueue() {
        return new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public EventExecutorGroup parent() {
        return this.parent;
    }

    protected void interruptThread() {
        this.thread.interrupt();
    }

    protected Runnable pollTask() {
        Runnable task;
        assert (this.inEventLoop());
        while ((task = this.taskQueue.poll()) == WAKEUP_TASK) {
        }
        return task;
    }

    protected Runnable takeTask() {
        Runnable task;
        assert (this.inEventLoop());
        if (!(this.taskQueue instanceof BlockingQueue)) {
            throw new UnsupportedOperationException();
        }
        BlockingQueue taskQueue = (BlockingQueue)this.taskQueue;
        do {
            ScheduledFutureTask<?> delayedTask;
            if ((delayedTask = this.delayedTaskQueue.peek()) == null) {
                Runnable task2 = null;
                try {
                    task2 = (Runnable)taskQueue.take();
                    if (task2 == WAKEUP_TASK) {
                        task2 = null;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return task2;
            }
            long delayNanos = delayedTask.delayNanos();
            task = null;
            if (delayNanos > 0L) {
                try {
                    task = (Runnable)taskQueue.poll(delayNanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            if (task != null) continue;
            this.fetchFromDelayedQueue();
            task = (Runnable)taskQueue.poll();
        } while (task == null);
        return task;
    }

    private void fetchFromDelayedQueue() {
        ScheduledFutureTask<?> delayedTask;
        long nanoTime = 0L;
        while ((delayedTask = this.delayedTaskQueue.peek()) != null) {
            if (nanoTime == 0L) {
                nanoTime = ScheduledFutureTask.nanoTime();
            }
            if (delayedTask.deadlineNanos() > nanoTime) break;
            this.delayedTaskQueue.remove();
            this.taskQueue.add(delayedTask);
        }
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    public final int pendingTasks() {
        return this.taskQueue.size();
    }

    protected void addTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        this.taskQueue.add(task);
    }

    protected boolean removeTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        return this.taskQueue.remove(task);
    }

    protected boolean runAllTasks() {
        this.fetchFromDelayedQueue();
        Runnable task = this.pollTask();
        if (task == null) {
            return false;
        }
        do {
            try {
                task.run();
            }
            catch (Throwable t) {
                logger.warn("A task raised an exception.", t);
            }
        } while ((task = this.pollTask()) != null);
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        return true;
    }

    protected boolean runAllTasks(long timeoutNanos) {
        long lastExecutionTime;
        block4: {
            this.fetchFromDelayedQueue();
            Runnable task = this.pollTask();
            if (task == null) {
                return false;
            }
            long deadline = ScheduledFutureTask.nanoTime() + timeoutNanos;
            long runTasks = 0L;
            do {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    logger.warn("A task raised an exception.", t);
                }
                if ((++runTasks & 0x3FL) == 0L && (lastExecutionTime = ScheduledFutureTask.nanoTime()) >= deadline) break block4;
            } while ((task = this.pollTask()) != null);
            lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        this.lastExecutionTime = lastExecutionTime;
        return true;
    }

    protected long delayNanos(long currentTimeNanos) {
        ScheduledFutureTask<?> delayedTask = this.delayedTaskQueue.peek();
        if (delayedTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return delayedTask.delayNanos(currentTimeNanos);
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop || this.state == 3) {
            this.taskQueue.add(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(task);
        } else {
            this.execute(new Runnable(){

                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.add(task);
                }
            });
        }
    }

    public void removeShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(task);
        } else {
            this.execute(new Runnable(){

                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.remove(task);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> copy = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable task : copy) {
                Object var7_6;
                try {
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        logger.warn("Shutdown hook raised an exception.", t);
                        var7_6 = null;
                        ran = true;
                        continue;
                    }
                    var7_6 = null;
                    ran = true;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    ran = true;
                    throw throwable;
                }
            }
        }
        if (ran) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        return ran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        if (quietPeriod < 0L) {
            throw new IllegalArgumentException("quietPeriod: " + quietPeriod + " (expected >= 0)");
        }
        if (timeout < quietPeriod) {
            throw new IllegalArgumentException("timeout: " + timeout + " (expected >= quietPeriod (" + quietPeriod + "))");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean inEventLoop = this.inEventLoop();
        boolean wakeup = true;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            this.gracefulShutdownQuietPeriod = unit.toNanos(quietPeriod);
            this.gracefulShutdownTimeout = unit.toNanos(timeout);
            if (inEventLoop) {
                assert (this.state == 2);
                this.state = 3;
            } else {
                switch (this.state) {
                    case 1: {
                        this.state = 3;
                        this.thread.start();
                        break;
                    }
                    case 2: {
                        this.state = 3;
                        break;
                    }
                    default: {
                        wakeup = false;
                    }
                }
            }
        }
        if (wakeup) {
            this.wakeup(inEventLoop);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        boolean inEventLoop = this.inEventLoop();
        boolean wakeup = true;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isShutdown()) {
                return;
            }
            if (inEventLoop) {
                assert (this.state == 2 || this.state == 3);
                this.state = 4;
            } else {
                switch (this.state) {
                    case 1: {
                        this.state = 4;
                        this.thread.start();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.state = 4;
                        break;
                    }
                    default: {
                        wakeup = false;
                    }
                }
            }
        }
        if (wakeup) {
            this.wakeup(inEventLoop);
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelDelayedTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = ScheduledFutureTask.nanoTime();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            this.wakeup(true);
            return false;
        }
        long nanoTime = ScheduledFutureTask.nanoTime();
        if (this.isShutdown() || nanoTime - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (nanoTime - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.wakeup(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private void cancelDelayedTasks() {
        ScheduledFutureTask[] delayedTasks;
        if (this.delayedTaskQueue.isEmpty()) {
            return;
        }
        for (ScheduledFutureTask task : delayedTasks = this.delayedTaskQueue.toArray(new ScheduledFutureTask[this.delayedTaskQueue.size()])) {
            task.cancel(false);
        }
        this.delayedTaskQueue.clear();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(timeout, unit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        boolean inEventLoop = this.inEventLoop();
        if (inEventLoop) {
            this.addTask(task);
        } else {
            this.startThread();
            this.addTask(task);
            if (this.isShutdown() && this.removeTask(task)) {
                SingleThreadEventExecutor.reject();
            }
        }
        if (!this.addTaskWakesUp) {
            this.wakeup(inEventLoop);
        }
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>((EventExecutor)this, this.delayedTaskQueue, command, null, ScheduledFutureTask.deadlineNanos(unit.toNanos(delay))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<V>(this, this.delayedTaskQueue, callable, ScheduledFutureTask.deadlineNanos(unit.toNanos(delay))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        return this.schedule(new ScheduledFutureTask<Object>((EventExecutor)this, this.delayedTaskQueue, Executors.callable(command, null), ScheduledFutureTask.deadlineNanos(unit.toNanos(initialDelay)), unit.toNanos(period)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>((EventExecutor)this, this.delayedTaskQueue, Executors.callable(command, null), ScheduledFutureTask.deadlineNanos(unit.toNanos(initialDelay)), -unit.toNanos(delay)));
    }

    private <V> ScheduledFuture<V> schedule(final ScheduledFutureTask<V> task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.inEventLoop()) {
            this.delayedTaskQueue.add(task);
        } else {
            this.execute(new Runnable(){

                public void run() {
                    SingleThreadEventExecutor.this.delayedTaskQueue.add(task);
                }
            });
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 2;
                this.delayedTaskQueue.add(new ScheduledFutureTask<Object>((EventExecutor)this, this.delayedTaskQueue, Executors.callable(new PurgeTask(), null), ScheduledFutureTask.deadlineNanos(SCHEDULE_PURGE_INTERVAL), -SCHEDULE_PURGE_INTERVAL));
                this.thread.start();
            }
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static /* synthetic */ int access$100(SingleThreadEventExecutor x0) {
        return x0.state;
    }

    static /* synthetic */ int access$102(SingleThreadEventExecutor x0, int x1) {
        x0.state = x1;
        return x0.state;
    }

    static /* synthetic */ long access$200(SingleThreadEventExecutor x0) {
        return x0.gracefulShutdownStartTime;
    }

    static /* synthetic */ Object access$300(SingleThreadEventExecutor x0) {
        return x0.stateLock;
    }

    static /* synthetic */ Semaphore access$400(SingleThreadEventExecutor x0) {
        return x0.threadLock;
    }

    static /* synthetic */ Queue access$500(SingleThreadEventExecutor x0) {
        return x0.taskQueue;
    }

    static /* synthetic */ Promise access$600(SingleThreadEventExecutor x0) {
        return x0.terminationFuture;
    }

    private final class PurgeTask
    implements Runnable {
        private PurgeTask() {
        }

        public void run() {
            Iterator i = SingleThreadEventExecutor.this.delayedTaskQueue.iterator();
            while (i.hasNext()) {
                ScheduledFutureTask task = (ScheduledFutureTask)i.next();
                if (!task.isCancelled()) continue;
                i.remove();
            }
        }
    }
}

