/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkPosComparator
implements Comparator<adg> {
    private int chunkPosX;
    private int chunkPosZ;
    private double yawRad;
    private double pitchNorm;

    public ChunkPosComparator(int chunkPosX, int chunkPosZ, double yawRad, double pitchRad) {
        this.chunkPosX = chunkPosX;
        this.chunkPosZ = chunkPosZ;
        this.yawRad = yawRad;
        this.pitchNorm = 1.0 - ns.a(Math.abs(pitchRad) / 1.5707963267948966, 0.0, 1.0);
    }

    @Override
    public int compare(adg cp1, adg cp2) {
        int i2 = this.getDistSq(cp1);
        int j2 = this.getDistSq(cp2);
        return i2 - j2;
    }

    private int getDistSq(adg cp2) {
        int i2 = cp2.a - this.chunkPosX;
        int j2 = cp2.b - this.chunkPosZ;
        int k2 = i2 * i2 + j2 * j2;
        double d0 = ns.b((double)j2, (double)i2);
        double d1 = Math.abs(d0 - this.yawRad);
        if (d1 > Math.PI) {
            d1 = Math.PI * 2 - d1;
        }
        k2 = (int)((double)k2 * 1000.0 * this.pitchNorm * d1 * d1);
        return k2;
    }
}

