/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.LauncherFrame;

public class MinecraftLauncher {
    private static final float MIN_HEAP = 511.0f;
    private static final long RECOMMENDED_HEAP = 1024L;
    private static Object reader;

    public static void main(String[] args) throws Exception {
        float heapSizeMegs = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        if (heapSizeMegs > 511.0f) {
            LauncherFrame.main(args);
        } else {
            ArrayList<String> params = new ArrayList<String>();
            boolean error = false;
            try {
                String pathToJar = MinecraftLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-Dsun.java2d.noddraw=true");
                params.add("-Dsun.java2d.d3d=false");
                params.add("-Dsun.java2d.opengl=false");
                params.add("-Dsun.java2d.pmoffscreen=false");
                params.add("-classpath");
                params.add(pathToJar);
                params.add("net.minecraft.LauncherFrame");
                ProcessBuilder pb = new ProcessBuilder(params);
                Process process = pb.start();
                if (process == null) {
                    throw new Exception("!");
                }
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                params.set(0, "java");
                ProcessBuilder pb = new ProcessBuilder(params);
                final Process process = pb.start();
                final BufferedReader reader1 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                final BufferedReader reader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                if (process == null) {
                    throw new IOException("!");
                }
                if (args.length > 0) {
                    Thread errorViewer = new Thread(){
                        BufferedReader reader;
                        {
                            this.reader = reader1;
                        }

                        public void run() {
                            boolean terminated = false;
                            while (!terminated) {
                                int exitvalue = Integer.MIN_VALUE;
                                try {
                                    exitvalue = process.exitValue();
                                }
                                catch (IllegalThreadStateException ex) {
                                    try {
                                        System.err.println(this.reader.readLine());
                                    }
                                    catch (IOException ex1) {
                                        Logger.getLogger(MinecraftLauncher.class.getName()).log(Level.SEVERE, null, ex1);
                                    }
                                }
                                if (exitvalue == Integer.MIN_VALUE) continue;
                                terminated = true;
                            }
                        }
                    };
                    Thread outViewer = new Thread(){
                        BufferedReader reader;
                        {
                            this.reader = reader2;
                        }

                        public void run() {
                            boolean terminated = false;
                            while (!terminated) {
                                int exitvalue = Integer.MIN_VALUE;
                                try {
                                    exitvalue = process.exitValue();
                                }
                                catch (IllegalThreadStateException ex) {
                                    try {
                                        System.out.println(this.reader.readLine());
                                    }
                                    catch (IOException ex1) {
                                        Logger.getLogger(MinecraftLauncher.class.getName()).log(Level.SEVERE, null, ex1);
                                    }
                                }
                                if (exitvalue == Integer.MIN_VALUE) continue;
                                terminated = true;
                            }
                        }
                    };
                    errorViewer.start();
                    outViewer.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LauncherFrame.main(args);
            }
        }
    }
}

