/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class FloatBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private FloatBigListIterators() {
    }

    public static FloatBigListIterator singleton(float element) {
        return new SingletonBigListIterator(element);
    }

    public static FloatBigListIterator unmodifiable(FloatBigListIterator i) {
        return new UnmodifiableBigListIterator(i);
    }

    public static FloatBigListIterator asBigListIterator(FloatListIterator i) {
        return new BigListIteratorListIterator(i);
    }

    public static class BigListIteratorListIterator
    extends AbstractFloatBigListIterator {
        protected final FloatListIterator i;

        protected BigListIteratorListIterator(FloatListIterator i) {
            this.i = i;
        }

        private int intDisplacement(long n) {
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n;
        }

        public void set(float ok) {
            this.i.set(ok);
        }

        public void add(float ok) {
            this.i.add(ok);
        }

        public int back(int n) {
            return this.i.back(n);
        }

        public long back(long n) {
            return this.i.back(this.intDisplacement(n));
        }

        public void remove() {
            this.i.remove();
        }

        public int skip(int n) {
            return this.i.skip(n);
        }

        public long skip(long n) {
            return this.i.skip(this.intDisplacement(n));
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public float nextFloat() {
            return this.i.nextFloat();
        }

        public float previousFloat() {
            return this.i.previousFloat();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBigListIterator
    extends AbstractFloatBigListIterator {
        protected final FloatBigListIterator i;

        public UnmodifiableBigListIterator(FloatBigListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public float nextFloat() {
            return this.i.nextFloat();
        }

        public float previousFloat() {
            return this.i.previousFloat();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    private static class SingletonBigListIterator
    extends AbstractFloatBigListIterator {
        private final float element;
        private int curr;

        public SingletonBigListIterator(float element) {
            this.element = element;
        }

        public boolean hasNext() {
            return this.curr == 0;
        }

        public boolean hasPrevious() {
            return this.curr == 1;
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        public long nextIndex() {
            return this.curr;
        }

        public long previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyBigListIterator
    extends AbstractFloatBigListIterator
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public float nextFloat() {
            throw new NoSuchElementException();
        }

        public float previousFloat() {
            throw new NoSuchElementException();
        }

        public long nextIndex() {
            return 0L;
        }

        public long previousIndex() {
            return -1L;
        }

        public long skip(long n) {
            return 0L;
        }

        public long back(long n) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }
}

