/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleSets;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class DoubleSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private DoubleSortedSets() {
    }

    public static DoubleSortedSet singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleSortedSet singleton(double element, DoubleComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static DoubleSortedSet singleton(Object element) {
        return new Singleton((double)((Double)element));
    }

    public static DoubleSortedSet singleton(Object element, DoubleComparator comparator) {
        return new Singleton((Double)element, comparator);
    }

    public static DoubleSortedSet synchronize(DoubleSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static DoubleSortedSet synchronize(DoubleSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static DoubleSortedSet unmodifiable(DoubleSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends DoubleSets.UnmodifiableSet
    implements DoubleSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleSortedSet sortedSet;

        protected UnmodifiableSortedSet(DoubleSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public DoubleComparator comparator() {
            return this.sortedSet.comparator();
        }

        public DoubleSortedSet subSet(double from, double to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public DoubleSortedSet headSet(double to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public DoubleSortedSet tailSet(double from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public DoubleBidirectionalIterator iterator() {
            return DoubleIterators.unmodifiable(this.sortedSet.iterator());
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return DoubleIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        @Deprecated
        public DoubleBidirectionalIterator doubleIterator() {
            return this.iterator();
        }

        public double firstDouble() {
            return this.sortedSet.firstDouble();
        }

        public double lastDouble() {
            return this.sortedSet.lastDouble();
        }

        @Deprecated
        public Double first() {
            return this.sortedSet.first();
        }

        @Deprecated
        public Double last() {
            return this.sortedSet.last();
        }

        @Deprecated
        public DoubleSortedSet subSet(Double from, Double to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        @Deprecated
        public DoubleSortedSet headSet(Double to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Deprecated
        public DoubleSortedSet tailSet(Double from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends DoubleSets.SynchronizedSet
    implements DoubleSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleSortedSet sortedSet;

        protected SynchronizedSortedSet(DoubleSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(DoubleSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DoubleComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public DoubleSortedSet subSet(double from, double to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public DoubleSortedSet headSet(double to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public DoubleSortedSet tailSet(double from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public DoubleBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return this.sortedSet.iterator(from);
        }

        @Deprecated
        public DoubleBidirectionalIterator doubleIterator() {
            return this.sortedSet.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double firstDouble() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstDouble();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double lastDouble() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastDouble();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Double first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Double last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        @Deprecated
        public DoubleSortedSet subSet(Double from, Double to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        @Deprecated
        public DoubleSortedSet headSet(Double to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Deprecated
        public DoubleSortedSet tailSet(Double from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends DoubleSets.Singleton
    implements DoubleSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        final DoubleComparator comparator;

        private Singleton(double element, DoubleComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(double element) {
            this(element, (DoubleComparator)null);
        }

        final int compare(double k1, double k2) {
            return this.comparator == null ? Double.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Deprecated
        public DoubleBidirectionalIterator doubleIterator() {
            return this.iterator();
        }

        public DoubleBidirectionalIterator iterator(double from) {
            DoubleBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from) <= 0) {
                i.nextDouble();
            }
            return i;
        }

        public DoubleComparator comparator() {
            return this.comparator;
        }

        public DoubleSortedSet subSet(double from, double to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public DoubleSortedSet headSet(double to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public DoubleSortedSet tailSet(double from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        public double firstDouble() {
            return this.element;
        }

        public double lastDouble() {
            return this.element;
        }

        @Deprecated
        public DoubleSortedSet subSet(Double from, Double to) {
            return this.subSet((double)from, (double)to);
        }

        @Deprecated
        public DoubleSortedSet headSet(Double to) {
            return this.headSet((double)to);
        }

        @Deprecated
        public DoubleSortedSet tailSet(Double from) {
            return this.tailSet((double)from);
        }

        @Deprecated
        public Double first() {
            return this.element;
        }

        @Deprecated
        public Double last() {
            return this.element;
        }
    }

    public static class EmptySet
    extends DoubleSets.EmptySet
    implements DoubleSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        public DoubleBidirectionalIterator iterator(double from) {
            return DoubleIterators.EMPTY_ITERATOR;
        }

        @Deprecated
        public DoubleBidirectionalIterator doubleIterator() {
            return DoubleIterators.EMPTY_ITERATOR;
        }

        public DoubleSortedSet subSet(double from, double to) {
            return EMPTY_SET;
        }

        public DoubleSortedSet headSet(double from) {
            return EMPTY_SET;
        }

        public DoubleSortedSet tailSet(double to) {
            return EMPTY_SET;
        }

        public double firstDouble() {
            throw new NoSuchElementException();
        }

        public double lastDouble() {
            throw new NoSuchElementException();
        }

        public DoubleComparator comparator() {
            return null;
        }

        @Deprecated
        public DoubleSortedSet subSet(Double from, Double to) {
            return EMPTY_SET;
        }

        @Deprecated
        public DoubleSortedSet headSet(Double from) {
            return EMPTY_SET;
        }

        @Deprecated
        public DoubleSortedSet tailSet(Double to) {
            return EMPTY_SET;
        }

        @Deprecated
        public Double first() {
            throw new NoSuchElementException();
        }

        @Deprecated
        public Double last() {
            throw new NoSuchElementException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

