/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class CharBigListIterators {
    public static final EmptyBigListIterator EMPTY_BIG_LIST_ITERATOR = new EmptyBigListIterator();

    private CharBigListIterators() {
    }

    public static CharBigListIterator singleton(char element) {
        return new SingletonBigListIterator(element);
    }

    public static CharBigListIterator unmodifiable(CharBigListIterator i) {
        return new UnmodifiableBigListIterator(i);
    }

    public static CharBigListIterator asBigListIterator(CharListIterator i) {
        return new BigListIteratorListIterator(i);
    }

    public static class BigListIteratorListIterator
    extends AbstractCharBigListIterator {
        protected final CharListIterator i;

        protected BigListIteratorListIterator(CharListIterator i) {
            this.i = i;
        }

        private int intDisplacement(long n) {
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big iterator is restricted to 32-bit displacements");
            }
            return (int)n;
        }

        public void set(char ok) {
            this.i.set(ok);
        }

        public void add(char ok) {
            this.i.add(ok);
        }

        public int back(int n) {
            return this.i.back(n);
        }

        public long back(long n) {
            return this.i.back(this.intDisplacement(n));
        }

        public void remove() {
            this.i.remove();
        }

        public int skip(int n) {
            return this.i.skip(n);
        }

        public long skip(long n) {
            return this.i.skip(this.intDisplacement(n));
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public char nextChar() {
            return this.i.nextChar();
        }

        public char previousChar() {
            return this.i.previousChar();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBigListIterator
    extends AbstractCharBigListIterator {
        protected final CharBigListIterator i;

        public UnmodifiableBigListIterator(CharBigListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public char nextChar() {
            return this.i.nextChar();
        }

        public char previousChar() {
            return this.i.previousChar();
        }

        public long nextIndex() {
            return this.i.nextIndex();
        }

        public long previousIndex() {
            return this.i.previousIndex();
        }
    }

    private static class SingletonBigListIterator
    extends AbstractCharBigListIterator {
        private final char element;
        private int curr;

        public SingletonBigListIterator(char element) {
            this.element = element;
        }

        public boolean hasNext() {
            return this.curr == 0;
        }

        public boolean hasPrevious() {
            return this.curr == 1;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        public char previousChar() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        public long nextIndex() {
            return this.curr;
        }

        public long previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyBigListIterator
    extends AbstractCharBigListIterator
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigListIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public char nextChar() {
            throw new NoSuchElementException();
        }

        public char previousChar() {
            throw new NoSuchElementException();
        }

        public long nextIndex() {
            return 0L;
        }

        public long previousIndex() {
            return -1L;
        }

        public long skip(long n) {
            return 0L;
        }

        public long back(long n) {
            return 0L;
        }

        public Object clone() {
            return EMPTY_BIG_LIST_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST_ITERATOR;
        }
    }
}

