/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextArea;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import net.minecraft.launcher.JarVerifier;

public class MinecraftLauncher
extends Applet
implements Runnable {
    private static final int linux = 0;
    private static final int solaris = 1;
    private static final int windows = 2;
    private static final int macos = 3;
    private static final int unknown = 4;
    private static final long serialVersionUID = 1L;
    private Label label;
    private TextArea text;
    private boolean launchVerified = false;
    private static File workDir = null;
    private boolean started = false;

    public static File getWorkingDirectory() {
        if (workDir == null) {
            workDir = MinecraftLauncher.getWorkingDirectory("minecraft");
        }
        return workDir;
    }

    public static File getWorkingDirectory(String applicationName) {
        File workingDirectory;
        String userHome = System.getProperty("user.home", ".");
        switch (MinecraftLauncher.getPlatform()) {
            case 0: 
            case 1: {
                workingDirectory = new File(userHome, String.valueOf('.') + applicationName + '/');
                break;
            }
            case 2: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + applicationName + '/');
                    break;
                }
                workingDirectory = new File(userHome, String.valueOf('.') + applicationName + '/');
                break;
            }
            case 3: {
                workingDirectory = new File(userHome, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                workingDirectory = new File(userHome, String.valueOf(applicationName) + '/');
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    private static int getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return 2;
        }
        if (osName.contains("mac")) {
            return 3;
        }
        if (osName.contains("solaris")) {
            return 1;
        }
        if (osName.contains("sunos")) {
            return 1;
        }
        if (osName.contains("linux")) {
            return 0;
        }
        if (osName.contains("unix")) {
            return 0;
        }
        return 4;
    }

    private byte[] read(InputStream src) throws IOException {
        ByteArrayOutputStream dest = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int n = 0;
        while (n != -1) {
            dest.write(buffer, 0, n);
            n = src.read(buffer);
        }
        src.close();
        dest.close();
        return dest.toByteArray();
    }

    public void startSecondJVM(File file) throws Exception {
        String separator = System.getProperty("file.separator");
        String path = String.valueOf(System.getProperty("java.home")) + separator + "bin" + separator + "java";
        ProcessBuilder processBuilder = new ProcessBuilder(path, "-Xmx1200m", "-Xms1200m", "-cp", file.getAbsolutePath(), "net.minecraft.launchtest.LaunchTest");
        this.log(path);
        Process process = processBuilder.start();
        OutputStream out = process.getOutputStream();
        this.pipe(process.getErrorStream(), System.err);
        this.pipe(process.getInputStream(), System.out);
    }

    private void pipe(final InputStream src, PrintStream dest) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(src));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        if (!line.equals("launchVerified")) continue;
                        MinecraftLauncher.this.launchVerified = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.label = new Label("Minecraft Launcher 2.0");
        this.text = new TextArea();
        this.text.setEditable(false);
        this.text.setFont(new Font("monospaced", 0, 12));
        this.log("Minecraft Launcher Loader 2.0");
        this.log("-----------------------------");
        this.log("");
        this.log("Running tests..");
        this.log("");
        this.add((Component)this.label, "North");
        this.add((Component)this.text, "Center");
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new Thread(this).start();
    }

    private void download(String url, File file) throws IOException {
        HttpURLConnection huc = (HttpURLConnection)new URL(url).openConnection();
        BufferedInputStream in = new BufferedInputStream(huc.getInputStream());
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file, false);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (n != -1) {
            ((OutputStream)out).write(buffer, 0, n);
            n = ((InputStream)in).read(buffer);
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    private void verify(File file) throws MalformedURLException, IOException, CertificateException {
        new JarVerifier(file.toURL()).verify(this.setupProviderCert());
    }

    private X509Certificate setupProviderCert() throws IOException, CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.read(MinecraftLauncher.class.getResourceAsStream("/mojang.cert")));
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        inStream.close();
        return cert;
    }

    public void run() {
        try {
            this.log("Finding minecraft launcher file..");
            File dir = new File(MinecraftLauncher.getWorkingDirectory(), "launcher");
            dir.mkdirs();
            File file = new File(dir, "launcher.jar");
            this.log(file.toString());
            String url = "https://s3.amazonaws.com/MinecraftLaunchTest/mclaunchtest.jar";
            this.log("Downloading mclaunchtest.jar..");
            this.download(url, file);
            this.log("Downloaded size: " + file.length());
            this.log("Verifying file..");
            this.verify(file);
            this.log("Launching JVM..");
            this.startSecondJVM(file);
            this.log("Waiting for ok..");
            int i = 0;
            while (i < 500 && !this.launchVerified) {
                Thread.sleep(10L);
                ++i;
            }
            if (this.launchVerified) {
                this.log("Verified! All is well!");
            } else {
                this.log("Failed! The new window never appeared");
            }
        }
        catch (Exception e) {
            this.log("FAIL: " + e.toString());
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        this.text.append(String.valueOf(msg) + "\n");
        this.text.setCaretPosition(this.text.getText().length() - 1);
    }
}

