/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class JarVerifier {
    private URL jarURL = null;
    private JarFile jarFile = null;

    JarVerifier(URL jarURL) {
        this.jarURL = jarURL;
    }

    private JarFile retrieveJarFileFromURL(URL url) throws IOException, MalformedURLException {
        this.jarURL = url.getProtocol().equalsIgnoreCase("jar") ? url : new URL("jar:" + url.toString() + "!/");
        JarURLConnection conn = (JarURLConnection)this.jarURL.openConnection();
        conn.setUseCaches(false);
        return conn.getJarFile();
    }

    public void verify(X509Certificate targetCert) throws IOException, CertificateEncodingException {
        try {
            if (this.jarFile == null) {
                this.jarFile = this.retrieveJarFileFromURL(this.jarURL);
            }
        }
        catch (Exception ex) {
            SecurityException se = new SecurityException();
            se.initCause(ex);
            throw se;
        }
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = this.jarFile.getManifest();
        if (man == null) {
            throw new SecurityException("The provider is not signed");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            if (je.isDirectory()) continue;
            entriesVec.addElement(je);
            InputStream is = this.jarFile.getInputStream(je);
            while (is.read(buffer, 0, buffer.length) != -1) {
            }
            is.close();
        }
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            X509Certificate[] certChain;
            JarEntry je = (JarEntry)e.nextElement();
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The provider has unsigned class files.");
            }
            int startIndex = 0;
            boolean signedAsExpected = false;
            while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                if (certChain[0].equals(targetCert)) {
                    signedAsExpected = true;
                    break;
                }
                startIndex += certChain.length;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("The provider is not signed by a trusted signer");
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
        if (startIndex > certs.length - 1) {
            return null;
        }
        int i = startIndex;
        while (i < certs.length - 1) {
            if (!((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) break;
            ++i;
        }
        int certChainSize = i - startIndex + 1;
        X509Certificate[] ret = new X509Certificate[certChainSize];
        int j = 0;
        while (j < certChainSize) {
            ret[j] = (X509Certificate)certs[startIndex + j];
            ++j;
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        this.jarFile.close();
    }
}

