/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.space;

import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.softmed.jops.Particle;
import org.softmed.jops.cloner.StandaloneCloner;
import org.softmed.jops.math.AnglesFastMath;
import org.softmed.jops.random.RandomGenerator;
import org.softmed.jops.space.GeneratorSpace;
import org.softmed.jops.valuelists.ValueListf;

public class SphereGenerator
extends GeneratorSpace
implements StandaloneCloner,
IUnmarshallable,
IMarshallable {
    ValueListf innerRadius = new ValueListf();
    ValueListf outerRadius = new ValueListf();
    float hangle;
    float vangle;
    float radius;
    private float cinnerRadius;
    private float couterRadius;
    public static final String JiBX_bindingList = "|org.softmed.jops.JiBX_bin_org_softmed_jops_fileloading_bindingsFactory|";

    public SphereGenerator() {
        this.innerRadius.addValue(Float.valueOf(0.3f), 0.0f);
        this.outerRadius.addValue(Float.valueOf(0.5f), 0.0f);
    }

    public void generate(Particle particle) {
        this.hangle = this.generator.getFloat(360.0f);
        this.vangle = this.generator.getFloat(360.0f);
        AnglesFastMath.convertSphericalToCartesianRadians(this.hangle, this.vangle, particle.position);
        this.radius = this.couterRadius - this.cinnerRadius;
        this.radius = this.generator.getFloat(this.radius) + this.cinnerRadius;
        particle.position.scale(this.radius);
    }

    public void update(float f) {
        this.cinnerRadius = ((Float)this.innerRadius.getValueAt(f)).floatValue();
        this.couterRadius = ((Float)this.outerRadius.getValueAt(f)).floatValue();
    }

    public void recompile() {
        if (this.generator == null) {
            this.generator = new RandomGenerator();
        }
        this.innerRadius.compileArray();
        this.outerRadius.compileArray();
    }

    public void setResolution(int n) {
        this.innerRadius.setResolution(n);
        this.outerRadius.setResolution(n);
    }

    public ValueListf getInnerRadius() {
        return this.innerRadius;
    }

    public ValueListf getOuterRadius() {
        return this.outerRadius;
    }

    public Object getStandaloneCopy() {
        SphereGenerator sphereGenerator = new SphereGenerator();
        sphereGenerator.innerRadius = this.innerRadius.getStandaloneCopy();
        sphereGenerator.outerRadius = this.outerRadius.getStandaloneCopy();
        return sphereGenerator;
    }

    public void setInnerRadius(ValueListf valueListf) {
        this.innerRadius = valueListf;
    }

    public void setOuterRadius(ValueListf valueListf) {
        this.outerRadius = valueListf;
    }

    public void reset() {
    }

    public static /* synthetic */ SphereGenerator JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_3_0(UnmarshallingContext arg1) throws JiBXException {
        return new SphereGenerator();
    }

    public final /* synthetic */ SphereGenerator JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        SphereGenerator sphereGenerator = this;
        arg1.parsePastStartTag(null, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_1(arg1);
        arg1.parsePastCurrentEndTag(null, "InfoObject");
        arg1.parsePastStartTag(null, "InnerRadius");
        ValueListf valueListf = this.innerRadius;
        if (valueListf == null) {
            valueListf = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.innerRadius = valueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "InnerRadius");
        arg1.parsePastStartTag(null, "OuterRadius");
        ValueListf valueListf2 = this.outerRadius;
        if (valueListf2 == null) {
            valueListf2 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.outerRadius = valueListf2.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "OuterRadius");
        arg1.popObject();
        return this;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(16).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_3_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        arg1.startTag(0, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_1(arg1);
        arg1.endTag(0, "InfoObject");
        arg1.startTag(0, "InnerRadius");
        this.innerRadius.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "InnerRadius");
        arg1.startTag(0, "OuterRadius");
        this.outerRadius.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "OuterRadius");
        arg1.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(16, "org.softmed.jops.space.SphereGenerator").marshal((Object)this, arg1);
    }

    public /* synthetic */ int JiBX_getIndex() {
        return 16;
    }
}

