/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.math;

import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;

public class AnglesFastMath {
    static int resolution;
    static float[] cos;
    static float[] sin;
    static float[] tan;
    static float[] arctan;
    static int maxArcTanValue;

    public static float atan(float f) {
        return AnglesFastMath.atan((int)f);
    }

    public static float tan(float f) {
        return AnglesFastMath.tan((int)f);
    }

    public static float atan(int n) {
        if (n < 0) {
            n = -n;
        }
        return arctan[n %= maxArcTanValue];
    }

    public static float tan(int n) {
        if ((n %= 360) < 0) {
            return -tan[-n];
        }
        return tan[n];
    }

    public static float sin(int n) {
        if ((n %= 360) < 0) {
            return -sin[-n];
        }
        return sin[n];
    }

    public static float cos(int n) {
        if (n < 0) {
            n = -n;
        }
        return cos[n %= 360];
    }

    public static float sin(float f) {
        if ((f %= 360.0f) < 0.0f) {
            return -sin[(int)(-f)];
        }
        return sin[(int)f];
    }

    public static float cos(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f = -f;
        }
        return cos[(int)f];
    }

    protected void write(String string) {
        System.out.println(string);
    }

    public static void convertSphericalToCartesian(float f, float f2, Point3f point3f) {
        point3f.setX(AnglesFastMath.cos(f) * AnglesFastMath.sin(f2));
        point3f.setZ(AnglesFastMath.sin(f) * AnglesFastMath.sin(f2));
        point3f.setY(AnglesFastMath.cos(f2));
    }

    public static void convertSphericalToCartesianRadians(float f, float f2, Vector3f vector3f) {
        vector3f.setX(FastMath.cos((float)f) * FastMath.sin((float)f2));
        vector3f.setY(FastMath.sin((float)f) * FastMath.sin((float)f2));
        vector3f.setZ(FastMath.cos((float)f2));
    }

    public static void convertSphericalToCartesian(float f, float f2, Vector3f vector3f) {
        vector3f.setX(AnglesFastMath.cos(f) * AnglesFastMath.sin(f2));
        vector3f.setZ(AnglesFastMath.sin(f) * AnglesFastMath.sin(f2));
        vector3f.setY(AnglesFastMath.cos(f2));
    }

    public static void convertSphericalToCartesianCorrect(float f, float f2, Vector3f vector3f) {
        vector3f.setX(AnglesFastMath.sin(f) * AnglesFastMath.cos(f2));
        vector3f.setZ(AnglesFastMath.cos(f) * AnglesFastMath.cos(f2));
        vector3f.setY(AnglesFastMath.sin(f2));
    }

    public static void convertSphericalToCartesianCorrectRadians(float f, float f2, Vector3f vector3f) {
        vector3f.setX(FastMath.cos((float)f) * FastMath.sin((float)f2));
        vector3f.setZ(FastMath.sin((float)f) * FastMath.sin((float)f2));
        vector3f.setY(FastMath.cos((float)f2));
    }

    public static void convertSphericalToCartesianRadians(float f, float f2, Point3f point3f) {
        point3f.setX(FastMath.cos((float)f) * FastMath.sin((float)f2));
        point3f.setZ(FastMath.sin((float)f) * FastMath.sin((float)f2));
        point3f.setY(FastMath.cos((float)f2));
    }

    static {
        int n;
        maxArcTanValue = 6283;
        resolution = 392;
        cos = new float[resolution];
        sin = new float[resolution];
        tan = new float[resolution];
        arctan = new float[maxArcTanValue];
        double d = 0.0;
        for (n = 0; n < resolution; ++n) {
            d = n;
            AnglesFastMath.cos[n] = (float)Math.cos(Math.toRadians(d));
            AnglesFastMath.sin[n] = (float)Math.sin(Math.toRadians(d));
            AnglesFastMath.tan[n] = (float)Math.tan(Math.toRadians(d));
        }
        for (n = 0; n < maxArcTanValue; ++n) {
            AnglesFastMath.arctan[n] = (float)Math.atan((float)n / 2000.0f);
        }
    }
}

