/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.fileloading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.softmed.jops.Generator;
import org.softmed.jops.GeneratorBehaviour;
import org.softmed.jops.InfoObject;
import org.softmed.jops.ParticleBehaviour;
import org.softmed.jops.ParticleRender;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.PositionAnimator;
import org.softmed.jops.SpaceAnimator;
import org.softmed.jops.fileloading.DataFormatException;
import org.softmed.jops.fileloading.FileLoaderImplementation;
import org.softmed.jops.fileloading.converters.AngleRadiansConverter;
import org.softmed.jops.modifiers.Modifier;
import org.softmed.jops.modifiers.PointMass;
import org.softmed.jops.space.GeneratorSpace;
import org.softmed.jops.valuelists.SimpleGenericValueList;
import org.softmed.jops.valuelists.ValueListf;
import org.softmed.jops.valuelists.ValueListp3f;
import org.softmed.jops.values.GenericValue;

public class JIBXLoader
implements FileLoaderImplementation {
    IBindingFactory bfact;

    public JIBXLoader() {
        this.setup();
    }

    protected void setup() {
        try {
            this.bfact = BindingDirectory.getFactory(ParticleSystem.class);
        }
        catch (JiBXException jiBXException) {
            jiBXException.printStackTrace();
        }
    }

    public String getName(InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null || zipEntry.isDirectory()) {
            throw new FileNotFoundException("No files found inside the Zip Stream or zip stream is null");
        }
        String string = zipEntry.getName();
        return string;
    }

    public ParticleSystem load(InputStream inputStream) throws IOException, DataFormatException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = JIBXLoader.readFully(bufferedInputStream);
        File file = new File("temp.ops");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
        ParticleSystem particleSystem = this.load(new File("temp.ops"));
        file.delete();
        return particleSystem;
    }

    public String getName(URL uRL) {
        System.out.println("Trying to load : " + uRL);
        String string = uRL.getFile();
        return this.getName(string);
    }

    public static void send(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JIBXLoader.send(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public ParticleSystem load(URL uRL) throws IOException, DataFormatException {
        InputStream inputStream = uRL.openStream();
        ParticleSystem particleSystem = this.load(inputStream);
        inputStream.close();
        return particleSystem;
    }

    public String getName(String string) {
        int n;
        String string2 = null;
        if (string == null) {
            string2 = string;
        }
        string2 = (n = string.lastIndexOf(92)) > 1 ? string.substring(n + 1) : string;
        return string2;
    }

    public ParticleSystem load(File file) throws IOException, DataFormatException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = null;
        zipEntry = enumeration.nextElement();
        if (zipEntry == null || zipEntry.isDirectory()) {
            throw new FileNotFoundException("No JOPS file inside the Zip File");
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            ParticleSystem particleSystem;
            IUnmarshallingContext iUnmarshallingContext = this.bfact.createUnmarshallingContext();
            ParticleSystem particleSystem2 = particleSystem = (ParticleSystem)iUnmarshallingContext.unmarshalDocument(inputStream, null);
            this.setObjectReferences(particleSystem2);
            inputStream.close();
            zipFile.close();
            return particleSystem;
        }
        catch (JiBXException jiBXException) {
            jiBXException.printStackTrace();
            throw new DataFormatException(jiBXException);
        }
    }

    private void convertAnglesToRadians(ParticleSystem particleSystem) {
        List<ParticleBehaviour> list;
        List<PositionAnimator> list3 = particleSystem.getPanimators();
        for (PositionAnimator list22 : list3) {
            this.convertAnglesToRadians(list22.getBiasAngle());
            this.convertAnglesToRadians(list22.getBiasSpin());
        }
        List<SpaceAnimator> list4 = particleSystem.getAnimators();
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            list = (SpaceAnimator)iterator.next();
            this.convertAnglesToRadians(((SpaceAnimator)((Object)list)).getSpaceAngle());
            this.convertAnglesToRadians(((SpaceAnimator)((Object)list)).getSpaceSpin());
        }
        List<GeneratorBehaviour> list2 = particleSystem.getGenBehaviours();
        for (GeneratorBehaviour generatorBehaviour : list2) {
            this.convertAnglesToRadians(generatorBehaviour.getAngle());
            this.convertAnglesToRadians(generatorBehaviour.getAngleH());
            this.convertAnglesToRadians(generatorBehaviour.getAngleV());
            this.convertAnglesToRadians(generatorBehaviour.getAngleSpreadH());
            this.convertAnglesToRadians(generatorBehaviour.getAngleSpreadV());
            this.convertAnglesToRadians(generatorBehaviour.getParticleAngleH());
            this.convertAnglesToRadians(generatorBehaviour.getParticleAngleV());
            this.convertAnglesToRadians(generatorBehaviour.getParticleSpinH());
            this.convertAnglesToRadians(generatorBehaviour.getParticleSpinV());
            this.convertAnglesToRadians(generatorBehaviour.getSpin());
            this.convertAnglesToRadians(generatorBehaviour.getSpinH());
            this.convertAnglesToRadians(generatorBehaviour.getSpinV());
            this.convertAlpha(generatorBehaviour.getAlpha());
        }
        list = particleSystem.getBehaviours();
        for (ParticleBehaviour particleBehaviour : list) {
            this.convertAnglesToRadians(particleBehaviour.getAngle());
            this.convertAnglesToRadians(particleBehaviour.getParticleAngleH());
            this.convertAnglesToRadians(particleBehaviour.getParticleAngleV());
            this.convertAnglesToRadians(particleBehaviour.getParticleSpinH());
            this.convertAnglesToRadians(particleBehaviour.getParticleSpinV());
            this.convertAnglesToRadians(particleBehaviour.getSpin());
            this.convertAlpha(particleBehaviour.getAlpha());
        }
    }

    private void convertAlpha(ValueListf valueListf) {
        this.convertAlpha(valueListf.getMainValueList());
        this.convertAlpha(valueListf.getRandomValueList());
    }

    private void convertAnglesToRadians(ValueListf valueListf) {
        this.convertAnglesToRadians(valueListf.getMainValueList());
        this.convertAnglesToRadians(valueListf.getRandomValueList());
    }

    private void convertAnglesToRadians(ValueListp3f valueListp3f) {
        this.convertAnglesToRadians(valueListp3f.getMainValueList());
        this.convertAnglesToRadians(valueListp3f.getRandomValueList());
    }

    private void convertAnglesToRadians(SimpleGenericValueList simpleGenericValueList) {
        AngleRadiansConverter angleRadiansConverter = new AngleRadiansConverter();
        List<GenericValue> list = simpleGenericValueList.getValues();
        for (GenericValue genericValue : list) {
            genericValue.setValue(angleRadiansConverter.fromExternalToInternal(genericValue.getValue()));
        }
    }

    private void convertAlpha(SimpleGenericValueList simpleGenericValueList) {
        List<GenericValue> list = simpleGenericValueList.getValues();
        for (GenericValue genericValue : list) {
            genericValue.setValue(Float.valueOf(((Float)genericValue.getValue()).floatValue() / 255.0f));
        }
    }

    public void save(File file, ParticleSystem particleSystem) throws IOException, DataFormatException {
        this.prepareParticleSystemForSaving(particleSystem);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        String string = file.getName().substring(0, file.getName().indexOf(46));
        ZipEntry zipEntry = new ZipEntry(string + ".xml");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.setMethod(8);
        try {
            IMarshallingContext iMarshallingContext = this.bfact.createMarshallingContext();
            iMarshallingContext.setIndent(4);
            iMarshallingContext.marshalDocument((Object)particleSystem, "UTF-8", null, (OutputStream)zipOutputStream);
            this.cleanParticleSystemAfterSaving(particleSystem);
        }
        catch (JiBXException jiBXException) {
            jiBXException.printStackTrace();
            throw new DataFormatException(jiBXException);
        }
    }

    protected void cleanParticleSystemAfterSaving(ParticleSystem particleSystem) {
        List<Generator> list = particleSystem.getGenerators();
        for (Generator generator : list) {
            generator.setModifierIndexes(null);
        }
    }

    protected void prepareParticleSystemForSaving(ParticleSystem particleSystem) {
        InfoObject infoObject2;
        List<Modifier> list = particleSystem.getModifiers();
        PointMass pointMass = null;
        int n = -1;
        for (InfoObject infoObject2 : list) {
            if (!(infoObject2 instanceof PointMass)) continue;
            pointMass = (PointMass)infoObject2;
            if (pointMass.getPositionAnimator() != null) {
                n = particleSystem.getPanimators().indexOf(pointMass.getPositionAnimator());
                pointMass.setPositionAnimatorIndex(n);
                continue;
            }
            pointMass.setPositionAnimatorIndex(-1);
        }
        List<Generator> list2 = particleSystem.getGenerators();
        infoObject2 = null;
        ParticleBehaviour particleBehaviour = null;
        GeneratorBehaviour generatorBehaviour = null;
        SpaceAnimator spaceAnimator = null;
        ParticleRender particleRender = null;
        GeneratorSpace generatorSpace = null;
        n = -1;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Generator generator = (Generator)iterator.next();
            particleBehaviour = generator.getPb();
            if (particleBehaviour != null) {
                n = particleSystem.getBehaviours().indexOf(particleBehaviour);
                generator.setParticleBehaviourIndex(n);
            } else {
                generator.setParticleBehaviourIndex(-1);
            }
            generatorBehaviour = generator.getGb();
            if (generatorBehaviour != null) {
                n = particleSystem.getGenBehaviours().indexOf(generatorBehaviour);
                generator.setGeneratorBehaviourIndex(n);
            } else {
                generator.setGeneratorBehaviourIndex(-1);
            }
            particleRender = generator.getRender();
            if (particleRender != null) {
                n = particleSystem.getRenders().indexOf(particleRender);
                generator.setRenderIndex(n);
            } else {
                generator.setRenderIndex(-1);
            }
            generatorSpace = generator.getSpace();
            if (generatorSpace != null) {
                n = particleSystem.getSpaces().indexOf(generatorSpace);
                generator.setSpaceIndex(n);
            } else {
                generator.setSpaceIndex(-1);
            }
            spaceAnimator = generator.getAnimator();
            if (spaceAnimator != null) {
                n = particleSystem.getAnimators().indexOf(spaceAnimator);
                generator.setSpaceAnimatorIndex(n);
            } else {
                generator.setSpaceAnimatorIndex(-1);
            }
            infoObject2 = generator.getPositionAnimator();
            if (infoObject2 != null) {
                n = particleSystem.getPanimators().indexOf(infoObject2);
                generator.setPositionAnimatorIndex(n);
            } else {
                generator.setPositionAnimatorIndex(-1);
            }
            list = generator.getModifiers();
            if (list.size() > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                generator.setModifierIndexes(arrayList);
                for (Modifier modifier : list) {
                    n = particleSystem.getModifiers().indexOf(modifier);
                    arrayList.add(n);
                }
                continue;
            }
            generator.setModifierIndexes(null);
        }
    }

    protected void setObjectReferences(ParticleSystem particleSystem) {
        InfoObject infoObject2;
        List<Modifier> list = particleSystem.getModifiers();
        PointMass pointMass = null;
        PositionAnimator positionAnimator = null;
        int n = -1;
        for (InfoObject infoObject2 : list) {
            if (!(infoObject2 instanceof PointMass) || (n = (pointMass = (PointMass)infoObject2).getPositionAnimatorIndex()) <= -1) continue;
            positionAnimator = particleSystem.getPanimators().get(n);
            pointMass.setPositionAnimator(positionAnimator);
        }
        List<Generator> list2 = particleSystem.getGenerators();
        positionAnimator = null;
        infoObject2 = null;
        GeneratorBehaviour generatorBehaviour = null;
        SpaceAnimator spaceAnimator = null;
        ParticleRender particleRender = null;
        Modifier modifier = null;
        GeneratorSpace generatorSpace = null;
        n = -1;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            List<Integer> list3;
            Generator generator = (Generator)iterator.next();
            n = generator.getParticleBehaviourIndex();
            if (n > -1) {
                infoObject2 = particleSystem.getBehaviours().get(n);
                generator.setPb((ParticleBehaviour)infoObject2);
            } else {
                generator.setPb(null);
            }
            n = generator.getGeneratorBehaviourIndex();
            if (n > -1) {
                generatorBehaviour = particleSystem.getGenBehaviours().get(n);
                generator.setGb(generatorBehaviour);
            } else {
                generator.setGb(null);
            }
            n = generator.getRenderIndex();
            if (n > -1) {
                particleRender = particleSystem.getRenders().get(n);
                generator.setRender(particleRender);
            } else {
                generator.setRender(null);
            }
            n = generator.getSpaceIndex();
            if (n > -1) {
                generatorSpace = particleSystem.getSpaces().get(n);
                generator.setSpace(generatorSpace);
            } else {
                generator.setSpace(null);
            }
            n = generator.getSpaceAnimatorIndex();
            if (n > -1) {
                spaceAnimator = particleSystem.getAnimators().get(n);
                generator.setAnimator(spaceAnimator);
            } else {
                generator.setAnimator(null);
            }
            n = generator.getPositionAnimatorIndex();
            System.out.println("PositionAnimator Index ->" + n);
            if (n > -1) {
                positionAnimator = particleSystem.getPanimators().get(n);
                System.out.println("Setting a PositionAnimator ->" + positionAnimator);
                generator.setPositionAnimator(positionAnimator);
            } else {
                generator.setPositionAnimator(null);
            }
            if ((list3 = generator.getModifierIndexes()) == null) continue;
            for (Integer n2 : list3) {
                modifier = particleSystem.getModifiers().get(n2);
                generator.getModifiers().add(modifier);
            }
            generator.setModifierIndexes(null);
        }
    }
}

