/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.cloner.Cloner;
import org.softmed.jops.cloner.DefaultCloner;
import org.softmed.jops.fileloading.DataFormatException;
import org.softmed.jops.fileloading.FileLoaderImplementation;
import org.softmed.jops.fileloading.JIBXLoader;

public class ParticleLibrary {
    FileLoaderImplementation fileImpl = new JIBXLoader();
    Map<String, ParticleSystem> originals = new HashMap<String, ParticleSystem>();
    Cloner cloner = new DefaultCloner();

    public String setOriginalFromFile(File file) throws IOException, DataFormatException {
        String string = file.getPath();
        String string2 = this.fileImpl.getName(string);
        this.setOriginal(string2, this.fileImpl.load(file));
        return string2;
    }

    public String setOriginalFromFile(String string) throws IOException, DataFormatException {
        File file = new File(string);
        String string2 = this.fileImpl.getName(string);
        this.setOriginal(string2, this.fileImpl.load(file));
        return string2;
    }

    public String setOriginalFromStream(InputStream inputStream) throws IOException, DataFormatException {
        String string = this.fileImpl.getName(inputStream);
        this.setOriginal(string, this.fileImpl.load(inputStream));
        return string;
    }

    public String setOriginalFromURL(URL uRL) throws IOException, DataFormatException {
        String string = this.fileImpl.getName(uRL);
        this.setOriginal(string, this.fileImpl.load(uRL));
        return string;
    }

    public void setOriginal(String string, ParticleSystem particleSystem) {
        if (particleSystem != null && string != null) {
            this.originals.put(string, particleSystem);
        }
    }

    public ParticleSystem getOriginal(String string) {
        return this.originals.get(string);
    }

    public void removeOriginal(String string) {
        this.originals.remove(string);
    }

    public ParticleSystem getStandaloneCopy(String string) {
        ParticleSystem particleSystem = this.originals.get(string);
        if (particleSystem != null) {
            return this.cloner.getStandaloneCopy(particleSystem);
        }
        return null;
    }

    public ParticleSystem getStandaloneCopy(ParticleSystem particleSystem) {
        if (particleSystem != null) {
            return this.cloner.getStandaloneCopy(particleSystem);
        }
        return null;
    }

    public void purgeAll() {
        this.originals.clear();
    }

    protected String getSimpleFileName(String string) {
        int n;
        String string2 = null;
        if (string == null) {
            string2 = string;
        }
        string2 = (n = string.lastIndexOf(92)) > 1 ? string.substring(n + 1) : string;
        return string2;
    }

    public FileLoaderImplementation getFileImpl() {
        return this.fileImpl;
    }

    public void setFileImpl(FileLoaderImplementation fileLoaderImplementation) {
        this.fileImpl = fileLoaderImplementation;
    }

    public Cloner getCloner() {
        return this.cloner;
    }

    public void setCloner(Cloner cloner) {
        this.cloner = cloner;
    }
}

