/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.launcher;

import com.turborilla.msm.launcher.Download;
import de.vxart.zipupdate.ProgressListener;
import de.vxart.zipupdate.UpdateEngine;
import de.vxart.zipupdate.UpdateLocation;
import de.vxart.zipupdate.ui.MultiProgressDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Updater {
    private static Logger logger = Logger.getLogger(Updater.class.getCanonicalName());
    private String remoteDir;
    private String host;

    public Updater(String string, String string2) {
        this.host = string;
        this.remoteDir = string2;
    }

    public void update() throws IOException {
        Object object;
        ZipFile[] zipFileArray;
        File[] fileArray;
        String string = null;
        try {
            fileArray = Updater.class.getClassLoader().getResource("build.txt");
            if (fileArray != null) {
                zipFileArray = new Properties();
                zipFileArray.load(fileArray.openStream());
                string = zipFileArray.getProperty("build.number", "0");
            }
            logger.info("this build number: " + string);
            if (string == null || !this.isNewerBuildNumberOnServer(Integer.parseInt(string), this.getRemoteDir() + "/build.txt")) {
                return;
            }
        }
        catch (Exception exception) {
            logger.severe("Could not compare build numbers due to: " + exception);
        }
        fileArray = this.findAllJars(null);
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        zipFileArray = new ZipFile[fileArray.length];
        UpdateLocation[] updateLocationArray = new UpdateLocation[fileArray.length];
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            object = new URL("http", this.getHost(), this.getRemoteDir() + "/" + fileArray[i].getName());
            logger.info("updateLocation: " + object);
            zipFileArray[i] = this.newZipFile(fileArray[i]);
            updateLocationArray[i] = new UpdateLocation((URL)object);
            stringArray[i] = fileArray[i].getName();
        }
        UpdateEngine updateEngine = new UpdateEngine();
        object = new MultiProgressDialog();
        updateEngine.addProgressListener((ProgressListener)object);
        try {
            updateEngine.update(zipFileArray, updateLocationArray, stringArray);
        }
        catch (IOException iOException) {
            updateEngine.removeProgressListener((ProgressListener)object);
            ((MultiProgressDialog)object).getOverallProgressListener().finish();
            ((MultiProgressDialog)object).finish();
            throw iOException;
        }
        try {
            File file = new File(System.getProperty("user.dir"));
            String string2 = this.getOsName() + "-native.jar";
            File file2 = new File(file, string2);
            if (file2.exists()) {
                Updater.unzip(file, string2, file.getParentFile());
            }
        }
        catch (RuntimeException runtimeException) {
            logger.severe("Could not unzip \"" + this.getOsName() + "-native.jar due to " + runtimeException);
            throw runtimeException;
        }
    }

    protected boolean isNewerBuildNumberOnServer(int n, String string) {
        URL uRL = null;
        int n2 = 0;
        try {
            uRL = new URL("http", this.host, "");
            logger.info("About to download " + new URL(uRL, string));
            Download download = Download.startDownload(uRL, string);
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l < 3000L && download.getState() == 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (download.getState() != 2) {
                logger.severe("Could not download build number due to " + download.getLastException());
                return false;
            }
            byte[] byArray = download.getData();
            Properties properties = new Properties();
            try {
                properties.load(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                logger.severe("Could not download build number due to " + iOException);
                return false;
            }
            n2 = Integer.parseInt(properties.getProperty("build.number", "0"));
            logger.info("build number on server: " + n2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Could not download build.txt due to: " + malformedURLException);
        }
        return n2 > n;
    }

    protected File[] findAllJars(String string) throws IOException {
        return this.findAllJars(string, null);
    }

    /*
     * WARNING - void declaration
     */
    protected File[] findAllJars(String string, String string2) throws IOException {
        File[] fileArray = null;
        try {
            void var13_16;
            File file = string != null ? new File(System.getProperty("user.dir") + File.separator + string) : new File(System.getProperty("user.dir"));
            URL uRL = new URL("http", this.host, "");
            Download download = Download.startDownload(uRL, this.remoteDir + "/jarlist.txt", string2);
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l < 3000L && download.getState() == 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (download.getState() != 2) {
                logger.severe("Could not download jar list due to " + download.getLastException());
                throw new IOException(download.getLastException().getMessage());
            }
            byte[] byArray = download.getData();
            String string3 = new String(byArray);
            logger.info("jarlist (" + byArray.length + " bytes):\n" + string3);
            String[] stringArray = string3.split("\n");
            logger.info("jarlist entries: " + stringArray.length);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string4 : stringArray) {
                string4.trim();
                if (Character.getType(string4.charAt(string4.length() - 1)) == 15) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (!string4.endsWith("jar") || string4.endsWith("jzipupdate-0.9.jar") || string4.endsWith("launcher.jar") || string4.endsWith("linux-native.jar") || string4.endsWith("windows-native.jar") || string4.endsWith("macintosh-native.jar")) continue;
                arrayList.add(new File(file, string4));
            }
            arrayList.add(new File(file, this.getOsName() + "-native.jar"));
            fileArray = arrayList.toArray(new File[0]);
            String string5 = "Found the following jars:\n";
            for (File file2 : fileArray) {
                String string6 = (String)var13_16 + file2 + "\n";
            }
            logger.info((String)var13_16);
        }
        catch (Exception exception) {
            logger.severe("Could not download or parse jar list due to " + exception);
            throw new IOException(exception.getMessage());
        }
        return fileArray;
    }

    protected ZipFile newZipFile(File file) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            logger.warning("Could not open \"" + file + "\" due to " + exception + ". Creating empty one.");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.putNextEntry(new ZipEntry("dummy"));
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
            zipFile = new ZipFile(file);
        }
        return zipFile;
    }

    public String getOsName() {
        String string = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            string = "windows";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            string = "linux";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            string = "macintosh";
        }
        return string;
    }

    public static void unzip(File file, String string, File file2) {
        ZipFile zipFile = null;
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            zipFile = new ZipFile(new File(file, string));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                File file3;
                zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0 || (file3 = new File(file2, zipEntry.getName())).exists()) continue;
                file3.mkdirs();
            }
            enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || zipEntry.getName().indexOf("META-INF") >= 0) continue;
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[2048];
                File file4 = new File(file2, zipEntry.getName());
                if (file4.exists()) {
                    file4.delete();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getRemoteDir() {
        return this.remoteDir;
    }

    public void setRemoteDir(String string) {
        this.remoteDir = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }
}

