/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarListMaker {
    private static Logger logger = Logger.getLogger(JarListMaker.class.getName());

    public static void main(String[] stringArray) {
        File file = new File(stringArray[0]);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (fileArray.length < 1) {
                try {
                    logger.log(Level.WARNING, "No ZIP/JAR files found in " + file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                System.exit(2);
            }
            logger.log(Level.INFO, "Generating jarlist for all files in " + file);
            File file2 = new File(file, stringArray[1]);
            if (file2.exists()) {
                file2.delete();
            }
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (printWriter != null) {
                for (File file3 : fileArray) {
                    JarListMaker.index(file3, printWriter);
                }
            }
            printWriter.flush();
        } else {
            logger.severe("not a directory: " + file.getAbsolutePath());
        }
    }

    private static void index(File file, PrintWriter printWriter) {
        String string = JarListMaker.getHash(file);
        printWriter.println(file.getName() + "," + string);
    }

    public static String getHash(File file) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            byte[] byArray = new byte[8192];
            int n = 0;
            try {
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    messageDigest.update(byArray, 0, n);
                }
                byte[] byArray2 = messageDigest.digest();
                BigInteger bigInteger = new BigInteger(1, byArray2);
                string = bigInteger.toString(16);
                System.out.println("MD5: " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to process file for MD5", iOException);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unable to close input stream for MD5 calculation", iOException);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.severe("Could not compute hash due to " + noSuchAlgorithmException);
        }
        return string;
    }
}

