/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.launcher;

import com.turborilla.msm.launcher.Download;
import com.turborilla.msm.launcher.Updater;
import de.vxart.zipupdate.ProgressListener;
import de.vxart.zipupdate.UpdateEngine;
import de.vxart.zipupdate.UpdateLocation;
import de.vxart.zipupdate.ui.MultiProgressDialog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class DynamicUpdater
extends Updater {
    private static Logger logger = Logger.getLogger(DynamicUpdater.class.getCanonicalName());
    private String getBuildNrFile;
    private String authenticationString;
    private String fromBuild;
    private String toBuild;

    public DynamicUpdater(String string, String string2) {
        super(string, null);
        this.getBuildNrFile = string2;
    }

    public boolean isNewBuildNumber() {
        String string = null;
        try {
            URL uRL = Updater.class.getClassLoader().getResource("build.txt");
            if (uRL != null) {
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                string = properties.getProperty("build.number", "0");
            }
            logger.info("this build number: " + string);
            this.fromBuild = string;
            if (string == null || !this.isNewerBuildNumberOnServer(Integer.parseInt(string), "/" + this.getBuildNrFile)) {
                return false;
            }
        }
        catch (Exception exception) {
            logger.severe("Could not compare build numbers due to: " + exception);
        }
        return true;
    }

    public void tryLoginCredentials(Properties properties) throws IOException {
        this.setHost(properties.getProperty("host"));
        this.setRemoteDir(properties.getProperty("root") + properties.getProperty("dir"));
        this.setAuthenticationString(properties.getProperty("auth"));
        File[] fileArray = this.findAllJars(null, this.getAuthenticationString());
    }

    public void update(Properties properties, ProgressListener progressListener) throws IOException {
        Serializable serializable;
        this.setHost(properties.getProperty("host"));
        this.setRemoteDir(properties.getProperty("root") + properties.getProperty("dir"));
        this.setAuthenticationString(properties.getProperty("auth"));
        File[] fileArray = this.findAllJars(null, this.getAuthenticationString());
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        ZipFile[] zipFileArray = new ZipFile[fileArray.length];
        UpdateLocation[] updateLocationArray = new UpdateLocation[fileArray.length];
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            serializable = new URL("http", this.getHost(), this.getRemoteDir() + "/" + fileArray[i].getName());
            logger.info("updateLocation: " + serializable);
            zipFileArray[i] = this.newZipFile(fileArray[i]);
            updateLocationArray[i] = new UpdateLocation((URL)serializable, this.getAuthenticationString());
            stringArray[i] = fileArray[i].getName();
        }
        UpdateEngine updateEngine = new UpdateEngine();
        if (progressListener != null) {
            updateEngine.addProgressListener(progressListener);
        }
        try {
            updateEngine.update(zipFileArray, updateLocationArray, stringArray);
        }
        catch (IOException iOException) {
            if (progressListener != null) {
                updateEngine.removeProgressListener(progressListener);
                if (progressListener instanceof MultiProgressDialog) {
                    ((MultiProgressDialog)progressListener).getOverallProgressListener().finish();
                }
                progressListener.finish();
            }
            throw iOException;
        }
        try {
            serializable = new File(System.getProperty("user.dir"));
            String string = this.getOsName() + "-native.jar";
            File file = new File((File)serializable, string);
            if (file.exists()) {
                DynamicUpdater.unzip((File)serializable, string, ((File)serializable).getParentFile());
            }
        }
        catch (RuntimeException runtimeException) {
            logger.severe("Could not unzip \"" + this.getOsName() + "-native.jar due to " + runtimeException);
            throw runtimeException;
        }
    }

    public Properties getUpdateInfo(String string) throws IOException {
        Properties properties = null;
        URL uRL = new URL("http", this.getHost(), "");
        logger.info("About to download " + new URL(uRL, string));
        Download download = Download.startDownload(uRL, string);
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 3000L && download.getState() == 1) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (download.getState() != 2) {
            logger.severe("Could not download update info due to " + download.getLastException());
            throw new IOException(download.getLastException().getMessage());
        }
        byte[] byArray = download.getData();
        properties = new Properties();
        properties.load(new ByteArrayInputStream(byArray));
        logger.info("Update info: " + properties.toString());
        return properties;
    }

    public String getGetBuildNrFile() {
        return this.getBuildNrFile;
    }

    public void setGetBuildNrFile(String string) {
        this.getBuildNrFile = string;
    }

    public String getAuthenticationString() {
        return this.authenticationString;
    }

    public void setAuthenticationString(String string) {
        this.authenticationString = string;
    }
}

